function checkXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}


/*
 -----------@@@RIPON@ Start Video Course Part----------------------------------
 */
/*
 * @Function            : otherCategory 
 * @Used IN             : @function-'view/user/video/add_video_course.php' - [95]
 * @Description         : get other category from field if user demand  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-02-2016 10:58 AM
 * @Parameter           : NULL
 * @Return              : NULL     
 * @Status              : available      
 */
function otherCategory() {
    var categoryId = documentID('category_id').value;
    if (categoryId === 'other') {
        var otherCourseCategory = documentID('other_course_category');
        otherCourseCategory.setAttribute("style", 'display:block;');
    } else {
        var otherCourseCategory = documentID('other_course_category');
        otherCourseCategory.setAttribute("style", 'display:none;');
    }
}



/*
 * @Function            : checkCourseCategory 
 * @Used IN             : @function-'view/user/video/add_video_course.php' - [126]
 * @Description         : check course category if user select other category
 * @Developed By        : Ripon Jaherul 
 * @Start DateTime      : 24-02-2016 11:27 AM
 * @Parameter           : categoryName[STRING], url[STRING]
 * @Return              : NULL     
 * @Status              : available      
 */
function checkCourseCategory(categoryName, url) {
    var checkCourseCategoryResponse;
    checkCourseCategoryResponse = checkXMLHTTP(checkCourseCategoryResponse);

    if (categoryName !== '') {
        var categoryName1 = categoryName.replace(/  +/g, ' ');

        var formdata = new FormData();
        formdata.append("category_name", categoryName1);

        checkCourseCategoryResponse.addEventListener("load", function () {

            if (checkCourseCategoryResponse.responseText === '1') {
                documentID('course_category_name_exist').value = '1';                
            } else if (checkCourseCategoryResponse.responseText === '2') {
                documentID('course_category_name_exist').value = '';                
            }

        }, false);
        checkCourseCategoryResponse.open("POST", url);
        checkCourseCategoryResponse.send(formdata);
    }
}

/*
 * @Function            : getVideoFolderName 
 * @Used IN             : @function-'view/user/video/create_video_management'
 * @Description         : check folder name exixtence
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 20-03-2016 08:06 PM     
 * @Status              : available      
 */
function getVideoFolderName(folderName, url, oldFolderName) {
    if (folderName !== oldFolderName) {
        checkVideoFolderName(folderName, url);
    }
}

/*
 * @Function            : checkVideoFolderName 
 * @Used IN             : @function-'view/user/video/add_video_course.php' [231]
 * @Description         : check video folder name exixtence
 * @Developed By        : Ripon Jaherul      
 * @Start DateTime      : 24-02-2016 11:27 AM
 * @Parameter           : folderName[STRING], url[STRING]
 * @Return              : NULL 
 * @Status              : available      
 */
function checkVideoFolderName(folderName, url, personID) {
    var checkVideoFolderNameResponse;
    checkVideoFolderNameResponse = checkXMLHTTP(checkVideoFolderNameResponse);

    if (folderName !== '') {
        var folderName1 = folderName.replace(/  +/g, ' ');

        var formdata = new FormData();
        formdata.append("video_folder_name", folderName1);
        formdata.append("person_id", personID);

        checkVideoFolderNameResponse.addEventListener("load", function () {

            if (checkVideoFolderNameResponse.responseText === '1') {
                documentID('video_name_exixts').value = '1';                
                documentID('video_course_folder_name_error').innerHTML = '';
            } else if (checkVideoFolderNameResponse.responseText === '2') {
                documentID('video_name_exixts').value = '';                
                documentID('video_course_folder_name_error').innerHTML = '';
            }

        }, false);
        checkVideoFolderNameResponse.open("POST", url);
        checkVideoFolderNameResponse.send(formdata);
    }
}


/*
 * @Function            : make_clean_url 
 * @Used IN             : @function-'makeCourseUrl'  this[JS]
 * @Description         : make perfect url for video course
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-03-2016 01:39 AM
 * @Parameter           : url[STRING]
 * @Return              : url[STRING]      
 * @Status              : available      
 */
function make_clean_url(url) {
    for (i = 0; url.length > i; i++) {
        if (url.charAt(i) === ' ') {
            url = url.replace(/ +/g, '-');
        }
        if (url.charAt(i) === '.') {
            url = url.replace(/\./g, '');
        }
        if (url.charAt(i) === '-') {
            url = url.replace(/--/g, '-');
        }

    }
    url = url.replace(/[&\/\\#@!^_=,+()$~%.'":*?<>{}]/g, '');
    if (url.charAt(url.length - 1) === '-') {
        url = setCharAt(url, url.length - 1, '');
    }
    url = url.replace(/--/g, '-');
    url = url.replace(' ', '-');
    return url.toLowerCase();
}


/*
 * @Function            : makeCourseUrl 
 * @Used IN             : @function-'view/user/video/add_video_course.php' [68]
 * @Description         : make course url and send to for url existes checking
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-04-2016 11:47 AM 
 * @Parameter           : courseName[STRING], phpURL[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function makeCourseUrl(courseName, phpURL) {
    if (courseName === '') {
        documentID('video_course_url').value = '';
    } else {
        var url = make_clean_url(courseName);
        documentID('video_course_url').value = url;
        checkCourseUrl(url, phpURL);
    }
}


/*
 * @Function            : getUploadVideoType 
 * @Used IN             : @function-'view/user/video/add_video_course.php' [179]
 * @Description         : get video course upload video type
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-04-2016 11:47 AM      
 * @Status              : available      
 */
function getUrlValue1(urlValue, url, oldUrl) {
    if (urlValue !== oldUrl) {
        checkCourseUrl(urlValue, url);
    }
}


/*
 * @Function            : checkCourseUrl 
 * @Used IN             : @front_end/video_course.js  [210]
 * @Description         : check course url existence
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-04-2016 11:47 AM   
 * @Parameter           : given_text[STRING], phpURL[STRING]
 * @Return              : NULL    
 * @Status              : available      
 */
function checkCourseUrl(given_text, phpURL) {
    var checkCourseUrlResponse;
    checkCourseUrlResponse = checkXMLHTTP(checkCourseUrlResponse);

    if (given_text !== '') {
        documentID('video_course_url_error').innerHTML = '';
        var formdata = new FormData();
        formdata.append("video_course_url", given_text);

        checkCourseUrlResponse.addEventListener("load", function () {

            if (checkCourseUrlResponse.responseText === '1') {
                documentID('video_url_exist').value = '1';                
            } else if (checkCourseUrlResponse.responseText === '2') {
                documentID('video_url_exist').value = '';                
            }

        }, false);
        checkCourseUrlResponse.open("POST", phpURL);
        checkCourseUrlResponse.send(formdata);
    }
}

/*
 * @Function            : getUploadVideoType 
 * @Used IN             : @function-'view/user/video/add_video_course.php' [179]
 * @Description         : get video course upload video type
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-04-2016 11:47 AM   
 * @Parameter           : uploadVideoType[INTEGER]
 * @Return              : NULL    
 * @Status              : available      
 */
function getUploadVideoType(uploadVideoType) {
    if (uploadVideoType === '1') {
        documentID('video_folder_name_area').style.display = 'block';
        documentID('upload_video_type_error').innerHTML = '';
    } else if (uploadVideoType === '2' || uploadVideoType === '3') {
        documentID('video_folder_name_area').style.display = 'none';
        documentID('upload_video_type_error').innerHTML = '';
    }
}

/*
 * @Function            : getVideoCourseType 
 * @Used IN             : @function-'view/user/video/add_video_course'
 * @Description         : check course feature status
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 08-03-2016 01:40 AM      
 * @Status              : available      
 */
function getVideoCourseType(type) {
    if (type === '1') {
        documentID('course_price_view').style.display = 'block';
        documentID('video_course_type_error').innerHTML = '';
    } else if (type === '2') {
        documentID('course_price_view').style.display = 'none';
        documentID('video_course_type_error').innerHTML = '';
    }
}

/*
 * @Function            : getAccessLevel 
 * @Used IN             : @function-'view/user/video/add_video_course.php' [368]
 * @Description         : check course access level if user select group amd special user
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 19-03-2016 11:13 AM
 * @Parameter           : videoAccessLevel[STRING]
 * @Return              : NULL       
 * @Status              : available      
 */
function getAccessLevel(videoAccessLevel) {
    if (videoAccessLevel === '4') {
        documentID('group_div').style.display = 'block';
        documentID('check_checkbox_name_div').innerHTML = '';
        documentID('check_checkbox_name_div').style.display = 'block';
        documentID('special_user_div').style.display = 'none';
    } else if (videoAccessLevel === '5') {
        documentID('group_div').style.display = 'none';
        documentID('check_checkbox_name_div').innerHTML = '';
        documentID('check_checkbox_name_div').style.display = 'block';
        documentID('special_user_div').style.display = 'block';
    } else {
        documentID('group_div').style.display = 'none';
        documentID('check_checkbox_name_div').innerHTML = '';
        documentID('check_checkbox_name_div').style.display = 'none';
        documentID('special_user_div').style.display = 'none';
    }
}


/*
 * @Function            : getSearchGroupName 
 * @Used IN             : @function-'view/user/video/add_video_course.php' - [408]
 * @Description         : get search group name
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 19-03-2016 11:37 AM 
 * @Parameter           : url[STRING], searchGroupName[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function getSearchGroupName(url, searchGroupName) {
    var searchGroupNameResponse;
    searchGroupNameResponse = checkXMLHTTP(searchGroupNameResponse);

    var allGroupName = documentID('hidden_search_group_name').value;
    var searchGroupName1 = searchGroupName.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("seatch_group_name", searchGroupName1);
    formdata.append("selected_group", allGroupName);

    searchGroupNameResponse.addEventListener("load", function () {

        documentID('check_checkbox_name_div').innerHTML = searchGroupNameResponse.responseText;

    }, false);
    searchGroupNameResponse.open("POST", url);
    searchGroupNameResponse.send(formdata);
}

/*
 * @Function            : checkGroupPersonID 
 * @Used IN             : @function-'view/user/video/ajax_page/group_view.php'
 * @Description         : get selected or un selected group ID
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 19-03-2016 12:43 AM 
 * @Parameter           : inputValue[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
var groupList = Array();
function checkGroupPersonID(inputValue) {
    if ($("#group_id" + inputValue).is(":checked")) {
        if (groupList.length < 5) {
            groupList.push(inputValue);
            documentID('hidden_search_group_name').value = groupList;
        } else {
            documentID('search_group_name_error').innerHTML = 'You can not selected more than 5 group';
            documentID('group_id' + inputValue).checked = false;
            documentID('hidden_search_group_name').value = groupList;
        }
    } else {
        var index = groupList.indexOf(inputValue);
        groupList.splice(index, 1);
        documentID('hidden_search_group_name').value = groupList;
        documentID('search_group_name_error').innerHTML = '';
    }
}


/*
 * @Function            : getSearchSpecialUser 
 * @Used IN             : @function-'view/user/video/add_video_course.php'- [428]
 * @Description         : get search special user name name
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 20-03-2016 08:37 AM 
 * @Parameter           : url[STRING], specialUserName[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
function getSearchSpecialUser(url, specialUserName) {
    var specialUserResponse;
    specialUserResponse = checkXMLHTTP(specialUserResponse);

    var allspecialUser = documentID('hidden_special_user_name').value;
    var specialUserName1 = specialUserName.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("search_special_user", specialUserName1);
    formdata.append("selected_user", allspecialUser);

    specialUserResponse.addEventListener("load", function () {

        documentID('check_checkbox_name_div').innerHTML = specialUserResponse.responseText;

    }, false);
    specialUserResponse.open("POST", url);
    specialUserResponse.send(formdata);
}

/*
 * @Function            : checkPersonID 
 * @Used IN             : @function-'view/user/video/ajax_page/special_user.php
 * @Description         : get selected or unselected person ID
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 20-03-2016 09:30 AM 
 * @Parameter           : inputValue[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
var personList = Array();
function checkPersonID(inputValue) {
    if ($("#person_id" + inputValue).is(":checked")) {
        if (personList.length < 10) {
            personList.push(inputValue);
            documentID('hidden_special_user_name').value = personList;
        } else {
            documentID('search_special_user_name_error').innerHTML = 'You can not selected more than 10 person';
            documentID('person_id' + inputValue).checked = false;
            documentID('hidden_special_user_name').value = personList;
        }
    } else {
        var index = personList.indexOf(inputValue);
        personList.splice(index, 1);
        documentID('hidden_special_user_name').value = personList;
        documentID('search_special_user_name_error').innerHTML = '';
    }
}


/*
 * @Function            : checkVideoCourse 
 * @Used IN             : @function-'view/user/video/add_video_course'
 * @Description         : check course feature status
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 19-03-2016 11:12 AM      
 * @Status              : available      
 */
function checkVideoCourse() {
    if (documentID('feature_price_status').value === '') {
        documentID('feature_error_message').innerHTML = 'There is a problem when creating video course, please contact support';
//        documentID('pricing_view').style.display = 'block';
        return false;
    } else {
        documentID('feature_error_message').innerHTML = '';
//        documentID('pricing_view').style.display = 'none';
        return true;
    }
}
/*
 -----------@@@RIPON@ End Video Course Part----------------------------------
 */


/*
 -----------@@@RIPON@ Start Video Course Upload Video Part----------------------------------
 */

/*
 * @Function            : addSingleValue 
 * @Used IN             : @function-'uploadVideoFile -     (@2-times)
 * @Description         : Add single section for uploaded video course
 * @Developed By        : Copied from 'admin/video_course.js'
 * @Start DateTime      : 25-02-2016 11:53 AM      
 * @Status              : available      
 */
function addSingleValue(field, sectionCounter, addID) {
    var allUploadVideoOKcounter = new Array();
    var allUploadVideoOKcounter1 = documentID(field + sectionCounter).value;
    if (allUploadVideoOKcounter1 !== '') {
        allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
    }

    if (allUploadVideoOKcounter.length < 0) {
        allUploadVideoOKcounter.push(addID);
    } else {
        if (allUploadVideoOKcounter.indexOf(addID) < 0) {
            allUploadVideoOKcounter.push(addID);
        }
    }
    documentID(field + sectionCounter).value = allUploadVideoOKcounter;
}

/*
 * @Function            : deleteSingleValue 
 * @Used IN             : @function-'removeSingleVideo -       (@7-times)
 * @                    : @function-'removeUploadWorkFile -    (@3-times)
 * @Description         : remove single section for uploaded video course
 * @Developed By        : Copied from 'admin/video_course.js'
 * @Start DateTime      : 20-02-2016 07:04 PM      
 * @Status              : available      
 */
function deleteSingleValue(field, sectionCounter, removeID) {
    var allUploadVideoCounter = new Array();
    var allUploadVideoCounter1 = documentID(field + sectionCounter).value;
    if (allUploadVideoCounter1 !== '') {
        allUploadVideoCounter = allUploadVideoCounter1.split(',');
    }
    if (allUploadVideoCounter.length > 0) {
        if (allUploadVideoCounter.indexOf(removeID) > -1) {
            var index = allUploadVideoCounter.indexOf(removeID);
            allUploadVideoCounter.splice(index, 1);
        }
        documentID(field + sectionCounter).value = allUploadVideoCounter;
    }
}

/*
 * @Function            : getSectionName 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get Video Name and check exists or others  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 10:07 PM  
 * @Status              : available      
 */
function getSectionName(sectionName, videoCourseID, sectionCounter, url) {
    var videoSectionResponse;
    videoSectionResponse = checkXMLHTTP(videoSectionResponse);
    //var fileRegx = /^[0-9a-zA-Z\- ]+$/;

    if (sectionName !== '') {
        documentID('video_section_name_errror' + sectionCounter).innerHTML = '';

        //if (fileRegx.test(sectionName)) {
        documentID('video_section_validate' + sectionCounter).value = '';
        var formdata = new FormData();
        formdata.append("video_section_name", sectionName);
        formdata.append("video_management_id", videoCourseID);
        formdata.append("all_upload_id", documentID('allUploadVideoID_sec_' + sectionCounter).value);

        videoSectionResponse.addEventListener("load", function () {

            if (videoSectionResponse.responseText === '1') {
                documentID('video_section_validate' + sectionCounter).value = '3';
                documentID('video_section_name_errror' + sectionCounter).innerHTML = 'Video Section Name Already Exists';
            } else if (videoSectionResponse.responseText === '2') {
                documentID('video_section_validate' + sectionCounter).value = '';
                documentID('video_section_name_errror' + sectionCounter).innerHTML = '';
            }

        }, false);
        videoSectionResponse.open("POST", url);
        videoSectionResponse.send(formdata);
        // } 
        /*else {
         documentID('video_section_validate' + sectionCounter).value = '2';
         documentID('video_section_name_errror' + sectionCounter).innerHTML = 'No Special Caracter Allow Accept -';
         }*/
    } else {
        documentID('video_section_validate' + sectionCounter).value = '1';
        documentID('video_section_name_errror' + sectionCounter).innerHTML = 'Please Type Course Secion Name';
    }
}



/*
 * @Function            : getUploadVideoName 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get Video Name and check exists or others  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 10:28 AM  
 * @Status              : available      
 */
function getUploadVideoName(videoName, videoCourseID, sectionCounter, videoCounter, url) {
    documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
    documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

    var videoNameResponse;
    videoNameResponse = checkXMLHTTP(videoNameResponse);

    var sectionNameValidate = documentID('video_section_validate' + sectionCounter).value;

    if (sectionNameValidate === '') {
        //var fileRegx = /^[0-9a-zA-Z\- ]+$/;
        if (videoName !== '') {
            //if (fileRegx.test(videoName)) {
            var uploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
            if (uploadVideoID1 !== '') {
                var uploadVideoID2 = uploadVideoID1.split(',');
                var uploadVideoID = uploadVideoID2[0];
                var videoName1 = videoName.replace(/  +/g, ' ');
                var uploadSingleVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;

                var formdata = new FormData();
                formdata.append("upload_video_name", videoName1);
                formdata.append("video_management_id", videoCourseID);
                formdata.append("upload_video_id", parseInt(uploadVideoID));
                formdata.append("upload_video_id1", parseInt(uploadSingleVideoID));

                videoNameResponse.addEventListener("load", function () {

                    if (videoNameResponse.responseText === '1') {
                        documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '3';
                        documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Video Name Already Exists';
                    } else if (videoNameResponse.responseText === '2') {
                        documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
                        documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                    }

                }, false);
                videoNameResponse.open("POST", url);
                videoNameResponse.send(formdata);
            } else {
                documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
            }
            /* } else {
             documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '2';
             documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'No Special Caracter Allow Accept -';
             }*/
        } else {
            documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '1';
            documentID('video_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please Type Video Name';
        }
    } else {
        documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).placeholder = 'Please complete previous input properly';
    }
}


/*
 * @Function            : getVideoFileSize 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get Video size and total size of user Drive
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 12:23 PM  
 * @Status              : available      
 */
var videoFileSizeResponseURL;
function getVideoFileSize(videoManagementID, videoUploadSize, sectionCounter, videoCounter) {
    var videoFileSizeResponse;
    //alert(videoFileSizeResponse);
    videoFileSizeResponse = checkXMLHTTP(videoFileSizeResponse);

    var formdata = new FormData();
    formdata.append("video_management_id", videoManagementID);
    formdata.append("upload_file_size", videoUploadSize);

    videoFileSizeResponse.addEventListener("load", function () {

        documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = videoFileSizeResponse.responseText;
        addSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);
        documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '1';
        documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).removeAttribute("disabled");
        documentID('video_section_name' + sectionCounter).removeAttribute('readonly', '');
        documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).removeAttribute('readonly', '');

    }, false);
    videoFileSizeResponse.open("POST", videoFileSizeResponseURL);
    videoFileSizeResponse.send(formdata);
}
/*
 * @Function            : uploadVideoFile 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get Video Name and check exists or others  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 10:49 AM  
 * @Status              : available      
 */
function uploadVideoFile(videoFile, videoManagementID, sectionCounter, videoCounter, url) {
    var uploadVideoResponse;
    uploadVideoResponse = checkXMLHTTP(uploadVideoResponse);

    var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
    var allUploadVideoID = new Array();
    if (allUploadVideoID1 !== '') {
        allUploadVideoID = allUploadVideoID1.split(',');
    }

    var videoSectionName = documentID('video_section_name' + sectionCounter).value;
    var videoSectionName1 = videoSectionName.replace(/  +/g, ' ');
    var videoName = documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).value;
    var videoName1 = videoName.replace(/  +/g, ' ');
    var videoTranscript = documentID('upload_video_transcript' + sectionCounter + '_video' + videoCounter).value;
    var videoTranscript1 = videoTranscript.replace(/  +/g, ' ');

    var uploadVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;

    var formdata = new FormData();
    formdata.append("video_file", videoFile);
    formdata.append("video_management_id", videoManagementID);
    formdata.append("upload_video_section_name", videoSectionName1);
    formdata.append("upload_video_name", videoName1);
    formdata.append("upload_video_transcript", videoTranscript1);
//    formdata.append("upload_video_access_level", fileStatus);
    formdata.append("upload_video_id", uploadVideoID);
    formdata.append("all_upload_video_id", allUploadVideoID);

    uploadVideoResponse.upload.addEventListener("progress", function (event) {

        documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'block';
        var percent = (event.loaded / event.total) * 100;
        documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).setAttribute('style', 'width:' + Math.round(percent) + '%');

        if (Math.round(percent) === 100) {
            documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>Upload Completed</span>';
        } else {
            documentID('video_section_name' + sectionCounter).setAttribute('readonly', '');
            documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).setAttribute('readonly', '');
            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).setAttribute('disabled', '');
            documentID('videoProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>' + Math.round(percent) + '% uploading</span>';
        }

    }, false);

    uploadVideoResponse.addEventListener("load", function () {

        if (uploadVideoResponse.responseText === 'no_feature') {
            uploadVideoFileErrorMessage(sectionCounter, videoCounter, 'Feature does not available');
        } else if (uploadVideoResponse.responseText === 'file_not_found') {
            uploadVideoFileErrorMessage(sectionCounter, videoCounter, 'Video File no found');
        } else if (uploadVideoResponse.responseText === 'size_exists') {
            uploadVideoFileErrorMessage(sectionCounter, videoCounter, 'Please Update your storage');
        } else if (uploadVideoResponse.responseText === 'error_loc') {
            uploadVideoFileErrorMessage(sectionCounter, videoCounter, 'File Location not found');
        } else if (uploadVideoResponse.responseText === 'error_zero') {
            uploadVideoFileErrorMessage(sectionCounter, videoCounter, 'Invalid video file');
        } else if (uploadVideoResponse.responseText === 'error_size') {
            uploadVideoFileErrorMessage(sectionCounter, videoCounter, 'Video size must less then 500 Mb');
        } else if (uploadVideoResponse.responseText === 'error_type') {
            uploadVideoFileErrorMessage(sectionCounter, videoCounter, 'Please select work file type: mp4,flv');
        } else {
            var videoUploadRespose = uploadVideoResponse.responseText;
            var videoUploadResposeArray = videoUploadRespose.split("@@@");
            var videoUploadID = videoUploadResposeArray[0];
            var videoUploadSize = videoUploadResposeArray[1];
            if (allUploadVideoID.length < 1) {
                allUploadVideoID.push(videoUploadID);
            } else {
                if (allUploadVideoID.indexOf(videoUploadID) < 0) {
                    allUploadVideoID.push(videoUploadID);
                }
            }

            getVideoFileSize(videoManagementID, videoUploadSize, sectionCounter, videoCounter);
            addSingleValue('allUploadVideoID1_sec_', sectionCounter, videoUploadID);

            documentID('allUploadVideoID_sec_' + sectionCounter).value = allUploadVideoID;
            documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value = videoUploadID;
            documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = videoFile.name;
            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        }

    }, false);
    uploadVideoResponse.open("POST", url);
    uploadVideoResponse.send(formdata);
}

/*
 * @Function            : uploadVideo 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get Video Name and check exists or others  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 10:35 AM  
 * @Status              : available      
 */
function uploadVideo(videoFile, videoCourseID, sectionCounter, videoCounter, url) {
    documentID('submit_error').innerHTML = '';
    documentID('section_error').innerHTML = '';
    documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

    var uploadVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
    if (uploadVideoID) {
        deleteSingleValue('allUploadVideoID_sec_', sectionCounter, uploadVideoID);
    }
    deleteSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);

    var sectionNameValidate = documentID('video_section_validate' + sectionCounter).value;
    var videoNameValidate = documentID('video_name_validate_sec' + sectionCounter + '_video' + videoCounter).value;
//    var fileStatusName = document.getElementsByName('upload_video_access_level[' + sectionCounter + '][' + videoCounter + ']');
//    var fileStatus = '';
//    for (var i = 0; i < fileStatusName.length; i++) {
//        if (fileStatusName[i].checked) {
//            fileStatus = fileStatusName[i].value;
//        }
//    }

    if (sectionNameValidate === '' && videoNameValidate === '') {
        var allowedVedioFileType = "mp4 flv";
        var file = videoFile.files[0];
        var fileName = file.name;
        var fileExtention = fileName.split('.').pop().toLowerCase();
        var n = allowedVedioFileType.search(fileExtention);
        if (n > -1) {
            if (file.size < 524288000) {

                uploadVideoFile(file, videoCourseID, sectionCounter, videoCounter, url);

            } else {
                documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
                documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Video size must less then 500 Mb';
            }
        } else {
            documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please select vedio type: mp4 flv';
        }
    } else {
        documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
        documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please complete previous input properly';
    }
}



/*
 * @Function            : getWorkFileStatus 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get work file status and video course work file  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 04:30 PM  
 * @Status              : available      
 */
function getWorkFileStatus(workFileStatus, videoCourseID, sectionCounter, videoCounter, addUrl, removeUrl) {
    var videoUploadStatus = documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value;

    if (videoUploadStatus === '1') {
        documentID('work_file_status_validate_sec_' + sectionCounter + '_video' + videoCounter).value = '1';
        documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        if (workFileStatus === '1') {

            addWorkFileView(videoCourseID, sectionCounter, videoCounter, addUrl);

        } else if (workFileStatus === '2') {
            var uploadWorkFileID = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;
            if (uploadWorkFileID) {

                removeUploadWorkFile(uploadWorkFileID, sectionCounter, videoCounter);

            } else {
                documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';

                deleteSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);
            }
        }
    } else {
        documentID('work_file_yes' + sectionCounter + '_video' + videoCounter).checked = false;
        documentID('work_file_no' + sectionCounter + '_video' + videoCounter).checked = false;
        documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please complete previous input properly';
    }
}


/*
 * @Function            : addWorkFileView 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : add work file  
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 04:30 PM  
 * @Status              : available      
 */
function addWorkFileView(videoCourseID, sectionCounter, videoCounter, addUrl) {
    documentID('submit_error').innerHTML = '';
    documentID('section_error').innerHTML = '';
    documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

    var getWorkFileStatusResponse;
    getWorkFileStatusResponse = checkXMLHTTP(getWorkFileStatusResponse);

    var formdata = new FormData();
    formdata.append("video_management_id", videoCourseID);
    formdata.append("section_counter", sectionCounter);
    formdata.append("video_counter", videoCounter);

    getWorkFileStatusResponse.addEventListener("load", function () {

        documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).style.display = 'block';
        documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).innerHTML = getWorkFileStatusResponse.responseText;
        addSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);


    }, false);
    getWorkFileStatusResponse.open("POST", addUrl);
    getWorkFileStatusResponse.send(formdata);
}


/*
 * @Function            : removeUploadWorkFile 
 * @Used IN             : @function-'admin/video/add_video_work_file.php'       'front_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : remove upload work file 
 * @Developed By        : Copied from admin/video_course.js
 * @Start DateTime      : 27-02-2016 10:44 AM      
 * @Status              : available      
 */
var removeUploadWorkFileURl;
function removeUploadWorkFile(uploadWorkFileID, sectionCounter, videoCounter) {
    var removeUploadWorkFileResponse;
    removeUploadWorkFileResponse = checkXMLHTTP(removeUploadWorkFileResponse);

    swal({
        title: "",
        text: "Are you sure you want to Delete this Work File?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("work_files_management_id", uploadWorkFileID);

                    removeUploadWorkFileResponse.addEventListener("load", function () {

                        if (removeUploadWorkFileResponse.responseText === 'success') {
                            documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value = '';
                            documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                            documentID('work_file_area_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';

                            deleteSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);
                            deleteSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, uploadWorkFileID);
                            deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);
                        }

                    }, false);
                    removeUploadWorkFileResponse.open("POST", removeUploadWorkFileURl);
                    removeUploadWorkFileResponse.send(formdata);
                }
            });
}




/*
 * @Function            : getWorkFileName 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get work file name and check status 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 05:52 PM  
 * @Status              : available      
 */
function getWorkFileName(workFileName, videoCourseID, sectionCounter, videoCounter, url) {
    documentID('submit_error').innerHTML = '';
    var workFileNameResponse;
    workFileNameResponse = checkXMLHTTP(workFileNameResponse);

    var uploadSingleVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
    if (uploadSingleVideoID) {
        if (workFileName !== '') {
            //var fileRegx = /^[0-9a-zA-Z\- ]+$/;
            // if (fileRegx.test(workFileName)) {
            var workFileName1 = workFileName.replace(/  +/g, ' ');

            var uploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
            if (uploadVideoID1 !== '') {
                var uploadVideoID2 = uploadVideoID1.split(',');
                var uploadVideoID = uploadVideoID2[0];


                var formdata = new FormData();
                formdata.append("upload_video_id", uploadVideoID);
                formdata.append("work_files_name", workFileName1);
                formdata.append("upload_video_id1", parseInt(uploadSingleVideoID));

                workFileNameResponse.addEventListener("load", function () {

                    if (workFileNameResponse.responseText === '1') {
                        documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '3';
                        documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Work FIle Name Already Exists';
                    } else if (workFileNameResponse.responseText === '2') {
                        documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
                        documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                    }

                }, false);
                workFileNameResponse.open("POST", url);
                workFileNameResponse.send(formdata);
            } else {
                documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '';
            }
            /* } else {
             documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '2';
             documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'No Special Caracter Allow Accept -';
             }*/
        } else {
            documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value = '1';
            documentID('work_files_name_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please Type Work FIle Name';
        }
    }
}


/*
 * @Function            : getVideoWorkFile 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get work file  and check validation 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 06:10 PM  
 * @Status              : available      
 */
function getVideoWorkFile(workFile, videoCourseID, sectionCounter, videoCounter, url) {
    documentID('submit_error').innerHTML = '';
    documentID('section_error').innerHTML = '';
    documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

    var uploadVideoWorkID = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;
    if (uploadVideoWorkID) {
        deleteSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, uploadVideoWorkID);
    }

    deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);

    var workFileNameValidate = documentID('work_files_name_validate_sec' + sectionCounter + '_video' + videoCounter).value;

    if (workFileNameValidate === '') {
        documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';

        var file = workFile.files[0];
        var fileName = file.name;
        var fileExtention = fileName.split('.').pop().toLowerCase();
        var allowedFileType = " zip rar txt rtf pdf gif jpeg jpg png psd epub azw3 cbr lit mobi swf \n\
                                            docx xlsx pub pptx one doc vsdx accdb xlsb mso rpmsg asd xls oft thmx mdb \n\
                                            xlsm mpp obi pst snp xsn olm  ost dotx vsd laccdb accdr wbk pptm dot ppt xlam \n\
                                            onepkg xltx mde docm pip ppsx ppsm accde grv xla slk potx iaf xlt crtx xlb vss \n\
                                            xar xlw pps pa oab  dotm  mpd svd ops pot xlm mpt acl xltm mdt ade xl vst accdc mdw \n\
                                            accdt mat vdx xsf xll sldx mda mar ppam accda ppa vsx puz prf maf vtx potm xlc wll accdp \n\
                                            mam sldm maq accdu cnv maw xslb";

        var n = allowedFileType.search(fileExtention);
        if (n > -1) {
            if (file.size < 50485760) {

                uploadVideoWorkFile(file, videoCourseID, sectionCounter, videoCounter, url);

            } else {
                documentID('work_file_upload_status_sec' + +sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_work_file_name' + +sectionCounter + '_video' + videoCounter).value = '';
                documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
                documentID('view_work_file_size_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
                documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
                documentID('upload_work_file_error_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = 'File size must less then 10 Mb';
            }
        } else {
            documentID('work_file_upload_status_sec' + +sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_work_file_name' + +sectionCounter + '_video' + videoCounter).value = '';
            documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
            documentID('view_work_file_size_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
            documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
            documentID('upload_work_file_error_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = 'Please select work file type: zip rar txt rtf pdf gif jpeg jpg png psd epub azw3 cbr lit mobi swf \n\
                                            docx xlsx pub pptx one doc vsdx accdb xlsb mso rpmsg asd xls oft thmx mdb \n\
                                            xlsm mpp obi pst snp xsn olm ost dotx vsd laccdb accdr wbk pptm dot ppt xlam \n\
                                            onepkg xltx mde docm pip ppsx ppsm accde grv xla slk potx iaf xlt crtx xlb vss \n\
                                            xar xlw pps pa oab  dotm  mpd svd ops pot xlm mpt acl xltm mdt ade xl vst accdc mdw \n\
                                            accdt mat vdx xsf xll sldx mda mar ppam accda ppa vsx puz prf maf vtx potm xlc wll accdp \n\
                                            mam sldm maq accdu cnv maw xslb';
        }
    } else {
        documentID('work_file_upload_status_sec' + +sectionCounter + '_video' + videoCounter).value = '';
        documentID('view_work_file_name' + +sectionCounter + '_video' + videoCounter).value = '';
        documentID('view_work_file_size_sec' + +sectionCounter + '_video' + videoCounter).innerHTML = '';
        documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
        documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
        documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
        documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = 'Please complete previous input properly';
    }
}


/*
 * @Function            : uploadVideoWorkFile 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get work file  and upload in to database
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 06:10 PM  
 * @Status              : available      
 */
function uploadVideoWorkFile(workFile, videoCourseID, sectionCounter, videoCounter, url) {
    var workFileResponse;
    workFileResponse = checkXMLHTTP(workFileResponse);

    var uploadVideoID = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
    var workFileName = documentID('work_files_name_sec' + sectionCounter + '_video' + videoCounter).value;
    var workFileName1 = workFileName.replace(/  +/g, ' ');

    var uploadVideoWorkID = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;

    var formdata = new FormData();
    formdata.append("upload_video_id", uploadVideoID);
    formdata.append("video_work_file", workFile);
    formdata.append("work_files_name", workFileName1);
    formdata.append("work_files_management_id", uploadVideoWorkID);
    formdata.append("video_management_id", videoCourseID);

    workFileResponse.upload.addEventListener("progress", function (event) {

        documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'block';
        var percent = (event.loaded / event.total) * 100;
        documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).setAttribute('style', 'width:' + Math.round(percent) + '%');

        if (Math.round(percent) === 100) {
            documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>Upload Completed</span>';


            addSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);

            documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
        } else {
            documentID('work_files_name_sec' + sectionCounter + '_video' + videoCounter).setAttribute('readonly', '');
            documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).setAttribute("disabled", '');
            documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '<span style=color:black;>' + Math.round(percent) + '% uploading</span>';
        }

    }, false);

    workFileResponse.addEventListener("load", function () {

        if (workFileResponse.responseText === 'no_feature') {
            uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, 'Feature does not available');
        } else if (workFileResponse.responseText === 'file_not_found') {
            uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, 'Work File not found');
        } else if (workFileResponse.responseText === 'size_exists') {
            uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, 'Please Update your storage');
        } else if (workFileResponse.responseText === 'error_location') {
            uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, 'Feature does not available');
        } else if (workFileResponse.responseText === 'error_size_zero') {
            uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, 'File size must grather then 0 Mb');
        } else if (workFileResponse.responseText === 'error_max_size') {
            uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, 'File size must less then 10 Mb');
        } else if (workFileResponse.responseText === 'error_type') {
            var typeError = 'Please select work file type: zip rar txt rtf pdf gif jpeg jpg png psd epub azw3 cbr lit mobi swf \n\
                                            docx xlsx pub pptx one doc vsdx accdb xlsb mso rpmsg asd xls oft thmx mdb \n\
                                            xlsm mpp obi pst snp xsn olm ost dotx vsd laccdb accdr wbk pptm dot ppt xlam \n\
                                            onepkg xltx mde docm pip ppsx ppsm accde grv xla slk potx iaf xlt crtx xlb vss \n\
                                            xar xlw pps pa oab  dotm  mpd svd ops pot xlm mpt acl xltm mdt ade xl vst accdc mdw \n\
                                            accdt mat vdx xsf xll sldx mda mar ppam accda ppa vsx puz prf maf vtx potm xlc wll accdp \n\
                                            mam sldm maq accdu cnv maw xslb';
            uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, typeError);
        } else {
            var videoWorkFileUploadRespose = workFileResponse.responseText;
            var videoWorkFileUploadArray = videoWorkFileUploadRespose.split("@@@");
            var workFileUploadID = videoWorkFileUploadArray[0];
            var uploadWorkFileSize = videoWorkFileUploadArray[1];

            addSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, workFileUploadID);

            documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value = workFileUploadID;
            documentID('view_work_file_name' + sectionCounter + '_video' + videoCounter).value = workFile.name;
            documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';

            getWorkFileSize(videoCourseID, uploadWorkFileSize, sectionCounter, videoCounter);
        }

    }, false);
    workFileResponse.addEventListener("error", function () {
    }, false);
    workFileResponse.addEventListener("abort", function () {
        alert("Upload Aborted");
    }, false);
    workFileResponse.open("POST", url);
    workFileResponse.send(formdata);
}


/*
 * @Function            : getWorkFileSize 
 * @Used IN             : @function-'user/video/upload_video.php'   
 * @Description         : get work size  and total size in user disk
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 06:10 PM  
 * @Status              : available      
 */
function getWorkFileSize(videoCourseID, uploadWorkFileSize, sectionCounter, videoCounter) {
    var videoFileSizeResponse;
    videoFileSizeResponse = checkXMLHTTP(videoFileSizeResponse);

    var formdata = new FormData();
    formdata.append("video_management_id", videoCourseID);
    formdata.append("upload_file_size", uploadWorkFileSize);

    videoFileSizeResponse.addEventListener("load", function () {

        documentID('work_file_upload_status_sec' + sectionCounter + '_video' + videoCounter).value = '1';
        documentID('view_work_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = videoFileSizeResponse.responseText;
        documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).removeAttribute("disabled");
        documentID('work_files_name_sec' + sectionCounter + '_video' + videoCounter).removeAttribute('readonly');

    }, false);
    videoFileSizeResponse.open("POST", videoFileSizeResponseURL);
    videoFileSizeResponse.send(formdata);
}


/*
 * @Function            : addMoreVideo 
 * @Used IN             : @function-'admin/video/upload_video.php'    
 * @Description         : add more video file 
 * @Developed By        : Copied from 'admin/video_course.js'
 * @Start DateTime      : 27-02-2016 11:19 AM      
 * @Status              : available      
 */
function addMoreVideo(videoCourseID, sectionCounter, url) {
    documentID('submit_error').innerHTML = '';
    documentID('section_error').innerHTML = '';
    documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

    var addMoreVideoResponse;
    addMoreVideoResponse = checkXMLHTTP(addMoreVideoResponse);

    var uploadVideoCounter = new Array();
    var uploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + sectionCounter).value;
    if (uploadVideoCounter1 !== '') {
        uploadVideoCounter = uploadVideoCounter1.split(',');
    }

    var videoCounter;
    var tempArray = new Array();
    if (uploadVideoCounter.length === 1) {
        videoCounter = uploadVideoCounter[0];
    } else {
        for (var i = 0; i < uploadVideoCounter.length; i++) {
            tempArray.push(uploadVideoCounter[i]);
        }
        videoCounter = Math.max.apply(Math, tempArray);
    }
    var videoCounter1 = parseInt(videoCounter);

    var fileStatusName = document.getElementsByName('work_file_status[' + sectionCounter + '][' + videoCounter1 + ']');
    var fileStatus = '';
    for (var i = 0; i < fileStatusName.length; i++) {
        if (fileStatusName[i].checked) {
            fileStatus = fileStatusName[i].value;
        }
    }

    var allUploadVideoOKcounter = new Array();
    var allUploadVideoID = new Array();
    var allUploadVideoWorkFileCounter = new Array();
    var allUploadVideoWorkFileID = new Array();
    var allUploadVideoWorkFileOKCounter = new Array();


    var allUploadVideoOKcounter1 = documentID('allUploadVideoOKcounter_sec_' + sectionCounter).value;
    if (allUploadVideoOKcounter1 !== '') {
        allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
    }
    var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
    if (allUploadVideoID1 !== '') {
        allUploadVideoID = allUploadVideoID1.split(',');
    }

    var allUploadVideoWorkFileCounter1 = documentID('allUploadVideoWorkFileCounter_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileCounter1 !== '') {
        allUploadVideoWorkFileCounter = allUploadVideoWorkFileCounter1.split(',');
    }
    var allUploadVideoWorkFileID1 = documentID('allUploadVideoWorkFileID_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileID1 !== '') {
        allUploadVideoWorkFileID = allUploadVideoWorkFileID1.split(',');
    }
    var allUploadVideoWorkFileOKCounter1 = documentID('allUploadVideoWorkFileOKCounter_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileOKCounter1 !== '') {
        allUploadVideoWorkFileOKCounter = allUploadVideoWorkFileOKCounter1.split(',');
    }

    if ((uploadVideoCounter.length === allUploadVideoOKcounter.length) && (allUploadVideoOKcounter.length === allUploadVideoID.length)) {
        documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

        if (fileStatus !== '') {
            documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter1).innerHTML = '';

            if ((allUploadVideoWorkFileCounter.length === allUploadVideoWorkFileID.length) && (allUploadVideoWorkFileID.length === allUploadVideoWorkFileOKCounter.length)) {
                documentID('video_course_submit_error' + sectionCounter).innerHTML = '';

                var formdata = new FormData();
                formdata.append("video_counter", videoCounter1);
                formdata.append("section_counter", sectionCounter);
                formdata.append("video_management_id", videoCourseID);
                addMoreVideoResponse.addEventListener("load", function () {

                    var parentDiv = documentID('upload_video_section_view' + sectionCounter);
                    var div1 = document.createElement('div');
                    ++videoCounter1;
                    div1.id = 'upload_video_area' + sectionCounter + '_video' + videoCounter1;
                    div1.setAttribute('class', 'col-sm-12 padding-zero');
                    parentDiv.appendChild(div1);
                    div1.innerHTML = addMoreVideoResponse.responseText;
                    var allCounter = uploadVideoCounter + ',' + videoCounter1;
                    documentID('allUploadVideoCounter_sec_' + sectionCounter).value = allCounter;


                }, false);
                addMoreVideoResponse.open("POST", url);
                addMoreVideoResponse.send(formdata);
            } else {
                documentID('video_course_submit_error' + sectionCounter).innerHTML = 'Please submit form correctly';
            }
        } else {
            documentID('video_work_file_status_error_sec' + sectionCounter + '_video' + videoCounter1).innerHTML = 'Please Select Work FIle Status';
        }
    } else {
        documentID('video_course_submit_error' + sectionCounter).innerHTML = 'Please submit form correctly';
    }
}


/*
 * @Function            : removeSingleVideo 
 * @Used IN             : @function-'user/video/upload_video.php'    
 * @Description         : remove Single upload video
 * @Developed By        : Copied from 'admin/video_course.js'
 * @Start DateTime      : 20-02-2016 03:53 PM      
 * @Status              : available      
 */
function removeSingleVideo(sectionCounter, videoCounter, url) {
    var removeSingleVideoResponse;
    removeSingleVideoResponse = checkXMLHTTP(removeSingleVideoResponse);

    var allUploadVideoID = new Array();
    var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
    if (allUploadVideoID1 !== '') {
        allUploadVideoID = allUploadVideoID1.split(',');
    }

    if (allUploadVideoID.length > 1) {
        swal({
            title: "",
            text: "Are you sure you want to Close?",
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'Yes',
            cancelButtonText: "No",
            closeOnConfirm: true,
            closeOnCancel: true
        },
                function (isConfirm) {
                    if (isConfirm) {
                        var upload_video_id = documentID('upload_video_id_sec' + sectionCounter + '_video' + videoCounter).value;
                        var upload_video_work_file_id = documentID('upload_video_work_file_id_sec' + sectionCounter + '_video' + videoCounter).value;

                        if (upload_video_id !== '') {
                            var formdata = new FormData();
                            formdata.append("upload_video_id", upload_video_id);

                            removeSingleVideoResponse.addEventListener("load", function () {

                                if (removeSingleVideoResponse.responseText === 'success') {

                                    deleteSingleValue('allUploadVideoCounter_sec_', sectionCounter, videoCounter);
                                    deleteSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);
                                    deleteSingleValue('allUploadVideoID_sec_', sectionCounter, upload_video_id);
                                    deleteSingleValue('allUploadVideoID1_sec_', sectionCounter, upload_video_id);
                                    if (upload_video_work_file_id) {
                                        deleteSingleValue('allUploadVideoWorkFileCounter_sec_', sectionCounter, videoCounter);
                                        deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);
                                        deleteSingleValue('allUploadVideoWorkFileID_sec_', sectionCounter, upload_video_work_file_id);
                                    }

                                    var parentDiv = documentID('upload_video_section_view' + sectionCounter);
                                    var childDiv = documentID('upload_video_area' + sectionCounter + '_video' + videoCounter);
                                    parentDiv.removeChild(childDiv);
                                }

                            }, false);
                            removeSingleVideoResponse.open("POST", url);
                            removeSingleVideoResponse.send(formdata);
                        } else {
                            var allUploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + sectionCounter).value;
                            var allUploadVideoCounter = new Array();
                            if (allUploadVideoCounter1 !== '') {
                                allUploadVideoCounter = allUploadVideoCounter1.split(',');
                            }
                            if (allUploadVideoCounter.length > 0) {
                                if (allUploadVideoCounter.indexOf(videoCounter) > -1) {
                                    var index = allUploadVideoCounter.indexOf(videoCounter);
                                    allUploadVideoCounter.splice(index, 1);
                                }
                                documentID('allUploadVideoCounter_sec_' + sectionCounter).value = allUploadVideoCounter;
                            }

                            var parentDiv = documentID('upload_video_section_view' + sectionCounter);
                            var childDiv = documentID('upload_video_area' + sectionCounter + '_video' + videoCounter);
                            parentDiv.removeChild(childDiv);
                        }
                    }
                });
    } else {
        swal({
            title: "",
            text: "You can not delete single Video",
            type: "warning",
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'OK',
            closeOnConfirm: true
        });
    }
}


/*
 * @Function            : addMoreVideoSection 
 * @Used IN             : @function-'user/video/upload_video.php'       'front_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more section
 * @Developed By        : Copied from - admin/video_course.js
 * @Start DateTime      : 27-02-2016 01:30 PM      
 * @Status              : available      
 */
function addMoreVideoSection(videoCourseID, url) {
    documentID('submit_error').innerHTML = '';
    documentID('section_error').innerHTML = '';

    var allsectionCounter = new Array();
    var allsectionCounter1 = documentID('allSectionCounter').value;
    if (allsectionCounter1 !== '') {
        allsectionCounter = allsectionCounter1.split(',');
    }

    var sectionCounter1;
    var tempArray = new Array();
    if (allsectionCounter.length === 1) {
        sectionCounter1 = allsectionCounter[0];
    } else {
        for (var i = 0; i < allsectionCounter.length; i++) {
            tempArray.push(allsectionCounter[i]);
        }
        sectionCounter1 = Math.max.apply(Math, tempArray);
    }
    var sectionCounter = parseInt(sectionCounter1);

    var allUploadVideoCounter = new Array();
    var allUploadVideoOKcounter = new Array();
    var allUploadVideoID = new Array();
    var allUploadVideoWorkFileCounter = new Array();
    var allUploadVideoWorkFileID = new Array();
    var allUploadVideoWorkFileOKCounter = new Array();
    var allUploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + sectionCounter).value;
    if (allUploadVideoCounter1 !== '') {
        allUploadVideoCounter = allUploadVideoCounter1.split(',');
    }
    var allUploadVideoOKcounter1 = documentID('allUploadVideoOKcounter_sec_' + sectionCounter).value;
    if (allUploadVideoOKcounter1 !== '') {
        allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
    }
    var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + sectionCounter).value;
    if (allUploadVideoID1 !== '') {
        allUploadVideoID = allUploadVideoID1.split(',');
    }
    var allUploadVideoWorkFileCounter1 = documentID('allUploadVideoWorkFileCounter_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileCounter1 !== '') {
        allUploadVideoWorkFileCounter = allUploadVideoWorkFileCounter1.split(',');
    }
    var allUploadVideoWorkFileID1 = documentID('allUploadVideoWorkFileID_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileID1 !== '') {
        allUploadVideoWorkFileID = allUploadVideoWorkFileID1.split(',');
    }
    var allUploadVideoWorkFileOKCounter1 = documentID('allUploadVideoWorkFileOKCounter_sec_' + sectionCounter).value;
    if (allUploadVideoWorkFileOKCounter1 !== '') {
        allUploadVideoWorkFileOKCounter = allUploadVideoWorkFileOKCounter1.split(',');
    }

    var videoCounter1;
    var tempArray1 = new Array();
    if (allUploadVideoCounter.length === 1) {
        videoCounter1 = allUploadVideoCounter[0];
    } else {
        for (var i = 0; i < allUploadVideoCounter.length; i++) {
            tempArray1.push(allUploadVideoCounter[i]);
        }
        videoCounter1 = Math.max.apply(Math, tempArray1);
    }
    var videoCounter2 = parseInt(videoCounter1);
    var fileStatusName = document.getElementsByName('work_file_status[' + sectionCounter + '][' + videoCounter2 + ']');
    var fileStatus = '';
    for (var i = 0; i < fileStatusName.length; i++) {
        if (fileStatusName[i].checked) {
            fileStatus = fileStatusName[i].value;
        }
    }

    if ((allUploadVideoCounter.length === allUploadVideoOKcounter.length) && (allUploadVideoOKcounter.length === allUploadVideoID.length)) {
        if (fileStatus !== '') {
            if ((allUploadVideoWorkFileCounter.length === allUploadVideoWorkFileID.length) && (allUploadVideoWorkFileID.length === allUploadVideoWorkFileOKCounter.length)) {
                documentID('section_error').innerHTML = '';
                getSectionArea(videoCourseID, sectionCounter, url);

            } else {
                documentID('section_error').innerHTML = 'Please Submit previous input properly';
            }
        } else {
            documentID('section_error').innerHTML = 'Please Submit previous input properly';
        }
    } else {
        documentID('section_error').innerHTML = 'Please Submit previous input properly';
    }
}


/*
 * @Function            : getSectionArea 
 * @Used IN             : @function-'addMoreVideoSection'       'front_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : add more section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-02-2016 12:54 PM      
 * @Status              : available      
 */
function getSectionArea(videoManagementID, sectionCounter, url) {
    documentID('submit_error').innerHTML = '';
    documentID('section_error').innerHTML = '';

    var getSectionAreaResponse;
    getSectionAreaResponse = checkXMLHTTP(getSectionAreaResponse);

    var formdata = new FormData();
    formdata.append("section_counter", sectionCounter);
    formdata.append("video_management_id", videoManagementID);
    getSectionAreaResponse.addEventListener("load", function () {

        var parentDiv = documentID('video_section_area');
        var div1 = document.createElement('div');
        ++sectionCounter;
        div1.id = 'upload_video_section' + sectionCounter;
        div1.setAttribute('class', 'col-sm-12 section-color');
        parentDiv.appendChild(div1);
        div1.innerHTML = getSectionAreaResponse.responseText;
        var allsectionCounter1 = documentID('allSectionCounter').value;
        var allSecctionCounter = allsectionCounter1 + ',' + sectionCounter;
        documentID('allSectionCounter').value = allSecctionCounter;

    }, false);
    getSectionAreaResponse.open("POST", url);
    getSectionAreaResponse.send(formdata);
}


/*
 * @Function            : removeSingleVideoSection 
 * @Used IN             : @function-'user/video/upload_video.php'       'front_end_resource/video_course/video_course.js'[@JS file],
 * @Description         : remove single section for uploaded video course
 * @Developed By        : Copied from admin/video_course.js
 * @Start DateTime      : 27-02-2016 02:09 PM      
 * @Status              : available      
 */
function removeSingleVideoSection(sectionCounter, url) {
    var removeSingleVideoSectionResponse;
    removeSingleVideoSectionResponse = checkXMLHTTP(removeSingleVideoSectionResponse);

    var allSectionCounter = new Array();
    var allSectionCounter1 = documentID('allSectionCounter').value;
    allSectionCounter = allSectionCounter1.split(',');
    var allUploadVideoID = documentID('allUploadVideoID1_sec_' + sectionCounter).value;

    if (allSectionCounter.length > 1) {
        swal({
            title: "",
            text: "Are you sure you want to Close?",
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'Yes',
            cancelButtonText: "No",
            closeOnConfirm: true,
            closeOnCancel: true
        },
                function (isConfirm) {
                    if (isConfirm) {
                        if (allUploadVideoID !== '') {
                            var formdata = new FormData();
                            formdata.append("all_upload_video_id", allUploadVideoID);

                            removeSingleVideoSectionResponse.addEventListener("load", function () {

                                if (removeSingleVideoSectionResponse.responseText === 'success') {
                                    var parentDiv = documentID('video_section_area');
                                    var childDiv = documentID('upload_video_section' + sectionCounter);
                                    parentDiv.removeChild(childDiv);
                                    deleteSingleValue('allSectionCounter', '', sectionCounter);
                                }

                            }, false);
                            removeSingleVideoSectionResponse.open("POST", url);
                            removeSingleVideoSectionResponse.send(formdata);
                        } else {
                            var parentDiv = documentID('video_section_area');
                            var childDiv = documentID('upload_video_section' + sectionCounter);
                            parentDiv.removeChild(childDiv);
                            deleteSingleValue('allSectionCounter', '', sectionCounter);
                        }
                    }
                });
    } else {
        swal({
            title: "",
            text: "You can not delete single Video Section",
            type: "warning",
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'OK',
            closeOnConfirm: true
        });
    }
}


/*
 * @Function            : checkVideoCourseWorkFIle 
 * @Used IN             : @function-'user/video/upload_video.php
 * @Description         : add more section
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 23-02-2016 04:06 PM      
 * @Status              : available      
 */
function checkVideoCourseWorkFIle() {
    var videoSatus1 = '2';
//    var videoSatus11 = '';
    var workSatusVal = '2';
    var workSatus1 = '2';
    var allsectionCounter = new Array();
    var allsectionCounter1 = documentID('allSectionCounter').value;
    if (allsectionCounter1 !== '') {
        allsectionCounter = allsectionCounter1.split(',');
    }

    for (var i = 0; i < allsectionCounter.length; i++) {
        if (documentID('video_section_validate' + allsectionCounter[i]).value === '1') {
            documentID('video_section_name_errror' + allsectionCounter[i]).innerHTML = 'Please type section name@';
            videoSatus1 = '2';
            break;
        } else if ((documentID('video_section_validate' + allsectionCounter[i]).value === '2')) {
            documentID('video_section_name_errror' + allsectionCounter[i]).innerHTML = 'No Special Caracter Allow Accept -@';
            videoSatus1 = '2';
            break;
        } else if ((documentID('video_section_validate' + allsectionCounter[i]).value === '3')) {
            documentID('video_section_name_errror' + allsectionCounter[i]).innerHTML = 'Section Name Already Exists@';
            videoSatus1 = '2';
            break;
        } else if ((documentID('video_section_validate' + allsectionCounter[i]).value === '')) {
            documentID('video_section_name_errror' + allsectionCounter[i]).innerHTML = '';
            videoSatus1 = '1';
        }

        var allUploadVideoCounter = new Array();
        var allUploadVideoOKcounter = new Array();
        var allUploadVideoID = new Array();
        var allUploadVideoWorkFileCounter = new Array();
        var allUploadVideoWorkFileID = new Array();
        var allUploadVideoWorkFileOKCounter = new Array();
        var allUploadVideoCounter1 = documentID('allUploadVideoCounter_sec_' + allsectionCounter[i]).value;
        if (allUploadVideoCounter1 !== '') {
            allUploadVideoCounter = allUploadVideoCounter1.split(',');
        }
        var allUploadVideoOKcounter1 = documentID('allUploadVideoOKcounter_sec_' + allsectionCounter[i]).value;
        if (allUploadVideoOKcounter1 !== '') {
            allUploadVideoOKcounter = allUploadVideoOKcounter1.split(',');
        }
        var allUploadVideoID1 = documentID('allUploadVideoID_sec_' + allsectionCounter[i]).value;
        if (allUploadVideoID1 !== '') {
            allUploadVideoID = allUploadVideoID1.split(',');
        }
        var allUploadVideoWorkFileCounter1 = documentID('allUploadVideoWorkFileCounter_sec_' + allsectionCounter[i]).value;
        if (allUploadVideoWorkFileCounter1 !== '') {
            allUploadVideoWorkFileCounter = allUploadVideoWorkFileCounter1.split(',');
        }
        var allUploadVideoWorkFileID1 = documentID('allUploadVideoWorkFileID_sec_' + allsectionCounter[i]).value;
        if (allUploadVideoWorkFileID1 !== '') {
            allUploadVideoWorkFileID = allUploadVideoWorkFileID1.split(',');
        }
        var allUploadVideoWorkFileOKCounter1 = documentID('allUploadVideoWorkFileOKCounter_sec_' + allsectionCounter[i]).value;
        if (allUploadVideoWorkFileOKCounter1 !== '') {
            allUploadVideoWorkFileOKCounter = allUploadVideoWorkFileOKCounter1.split(',');
        }


        if ((allUploadVideoCounter.length === allUploadVideoOKcounter.length) && (allUploadVideoOKcounter.length === allUploadVideoID.length)) {
            for (var j = 0; j < allUploadVideoOKcounter.length; j++) {
                if (documentID('video_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).value === '1') {
                    documentID('video_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).innerHTML = 'Please type video name @';
                    videoSatus1 = '2';
                    break;
                } else if (documentID('video_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).value === '2') {
                    documentID('video_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).innerHTML = 'No Special Caracter Allow Accept -@';
                    videoSatus1 = '2';
                    break;
                } else if (documentID('video_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).value === '3') {
                    documentID('video_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).innerHTML = 'Video Name Already Exists @';
                    videoSatus1 = '2';
                    break;
                } else if (documentID('video_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).value === '') {
                    documentID('video_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[j]).innerHTML = '';
                    videoSatus1 = '1';
                }
            }
            for (var k = 0; k < allUploadVideoOKcounter.length; k++) {
                if (documentID('work_file_status_validate_sec_' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[k]).value === '1') {
                    workSatusVal = '1';
                } else {
                    workSatusVal = '2';
                    documentID('video_work_file_status_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoOKcounter[k]).innerHTML = 'Please select work file status@';
                    break;
                }
            }

            if ((allUploadVideoWorkFileCounter.length === allUploadVideoWorkFileID.length) && (allUploadVideoWorkFileID.length === allUploadVideoWorkFileOKCounter.length)) {
                for (var k = 0; k < allUploadVideoWorkFileCounter.length; k++) {
                    if (documentID('work_files_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).value === '1') {
                        documentID('work_files_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).innerHTML = 'Please type work file name@';
                        workSatus1 = '2';
                        break;
                    } else if (documentID('work_files_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).value === '2') {
                        documentID('work_files_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).innerHTML = 'No Special Caracter Allow Accept -@';
                        workSatus1 = '2';
                        break;
                    } else if (documentID('work_files_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).value === '3') {
                        documentID('work_files_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).innerHTML = 'Work File Name Already Exists@';
                        workSatus1 = '2';
                        break;
                    } else if (documentID('work_files_name_validate_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).value === '') {
                        documentID('work_files_name_error_sec' + allsectionCounter[i] + '_video' + allUploadVideoCounter[k]).innerHTML = '';
                        workSatus1 = '1';
                    }
                }
            } else {
                workSatus1 = '2';
                break;
            }
        } else {
            videoSatus1 = '2';
            break;
        }
    }

    if (videoSatus1 === '2') {
        documentID('submit_error').innerHTML = 'Please Submit previous input properly';
        return false;
    } else if (videoSatus1 === '1') {
        documentID('submit_error').innerHTML = '';
//        return false;
    }
    if (workSatusVal === '2') {
        documentID('submit_error').innerHTML = 'Please Submit previous input properly';
        return false;
    } else {
        documentID('submit_error').innerHTML = '';
//        return false;
    }
    if (workSatus1 === '2') {
        documentID('submit_error').innerHTML = 'Please Submit previous input properly';
        return false;
    } else if (workSatus1 === '1') {
        documentID('submit_error').innerHTML = '';
//        return false;
    }
}


/*
 * @Function            : askForSkipVideoCourseWorkFile 
 * @Used IN             : @function-'user/video/upload_video.php
 * @Description         : skip video for upload
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 23-03-2016 03:56 PM      
 * @Status              : available      
 */
function askForSkipVideoCourseWorkFile(videoCourseURL, url, redirectURl) {
    var skipVideoCourseWorkFileResponse;
    skipVideoCourseWorkFileResponse = checkXMLHTTP(skipVideoCourseWorkFileResponse);

    swal({
        title: "",
        text: "Are you sure you want to Skip Course Work File?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {

                    var formdata = new FormData();
                    formdata.append("video_course_url", videoCourseURL);

                    skipVideoCourseWorkFileResponse.addEventListener("load", function () {

                        if (skipVideoCourseWorkFileResponse.responseText === 'success') {
                            window.location.href = redirectURl + '/' + videoCourseURL;
                        }

                    }, false);
                    skipVideoCourseWorkFileResponse.open("POST", url);
                    skipVideoCourseWorkFileResponse.send(formdata);
                }
            });
}



/*
 * @Function            : askForSkipEditVideoCourseWorkFile 
 * @Used IN             : @function-'user/video/edit_uploaded_video.php
 * @Description         : skip edit uploaded video
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 23-03-2016 08:50 PM      
 * @Status              : available      
 */
function askForSkipEditVideoCourseWorkFile(videoCourseURL, url, redirectURl) {
    var skipVideoCourseWorkFileResponse;
    skipVideoCourseWorkFileResponse = checkXMLHTTP(skipVideoCourseWorkFileResponse);

    swal({
        title: "",
        text: "Are you sure you want to Skip Course Work File?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {

                    var formdata = new FormData();
                    formdata.append("video_course_url", videoCourseURL);

                    skipVideoCourseWorkFileResponse.addEventListener("load", function () {

                        if (skipVideoCourseWorkFileResponse.responseText === 'success') {
                            window.location.href = redirectURl + '/' + videoCourseURL;
                        }

                    }, false);
                    skipVideoCourseWorkFileResponse.open("POST", url);
                    skipVideoCourseWorkFileResponse.send(formdata);
                }
            });
}
/*
 -----------@@@RIPON@ End Video Course Upload Video Part----------------------------------
 */


/*
 -----------@@@RIPON@ Start View public Video Course Part----------------------------------
 */


/*
 * @Function            : getCategoryID 
 * @Used IN             : @function-'front_end/video_course.php
 * @Description         : get category ID and view course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-03-2016 12:29 PM      
 * @Status              : available      
 */
function getCategoryID(url, categoryID) {
    var categoryIDResponse;
    categoryIDResponse = checkXMLHTTP(categoryIDResponse);

    var formdata = new FormData();
    formdata.append("category_id", categoryID);

    categoryIDResponse.addEventListener("load", function () {

        documentID('video_course_view').innerHTML = categoryIDResponse.responseText;

    }, false);
    categoryIDResponse.open("POST", url);
    categoryIDResponse.send(formdata);
}

/*
 * @Function            : moreCategory 
 * @Used IN             : @function-'front_end/video_course.php
 * @Description         : view more video course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-03-2016 12:35 PM      
 * @Status              : available      
 */
function moreCategory(url, counter) {
    var moreCategoryResponse;
    moreCategoryResponse = checkXMLHTTP(moreCategoryResponse);

    var formdata = new FormData();
    formdata.append("counter", counter);

    moreCategoryResponse.addEventListener("load", function () {

        documentID('category_view').innerHTML = moreCategoryResponse.responseText;

    }, false);
    moreCategoryResponse.open("POST", url);
    moreCategoryResponse.send(formdata);
}

/*
 * @Function            : getSkillLevel 
 * @Used IN             : @self
 * @Description         : add access_level in array
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-02-2016 12:40 AM  
 * @Status              : available      
 */
var skillLevelArray = new Array();
function getSkillLevel(inputValue, url) {
    if ($("#skill_level" + inputValue).is(":checked")) {
        skillLevelArray.push(inputValue);
        getVideoCourseBYSkillLevel(skillLevelArray, url);
    } else {
        var index = skillLevelArray.indexOf(inputValue);
        skillLevelArray.splice(index, 1);
        getVideoCourseBYSkillLevel(skillLevelArray, url);
    }
}

/*
 * @Function            : getVideoCourseBYSkillLevel 
 * @Used IN             : @getSkillLevel    this[@JS]
 * @Description         : get video course by access level
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-03-2016 12:39 PM  
 * @Status              : available      
 */
function getVideoCourseBYSkillLevel(skillLevelArray, url) {
    var skillLevelResponse;
    skillLevelResponse = checkXMLHTTP(skillLevelResponse);

    var formdata = new FormData();
    formdata.append("all_skill_level", skillLevelArray);

    skillLevelResponse.addEventListener("load", function () {

        documentID('video_course_view').innerHTML = skillLevelResponse.responseText;

    }, false);
    skillLevelResponse.open("POST", url);
    skillLevelResponse.send(formdata);
}


/*
 * @Function            : getTechnologValue 
 * @Used IN             : @fornt_end/video_course.php
 * @Description         : get technology video course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-03-2016 12:48 PM  
 * @Status              : available      
 */
var technologyArray = new Array();
function getTechnologValue(inputValue, url) {
    if ($("#course_technology" + inputValue).is(":checked")) {
        technologyArray.push(inputValue);
        getVideoCourseBYTechnology(technologyArray, url);
    } else {
        var index = technologyArray.indexOf(inputValue);
        technologyArray.splice(index, 1);
        getVideoCourseBYTechnology(technologyArray, url);
    }
}


/*
 * @Function            : getVideoCourseBYTechnology 
 * @Used IN             : @getTechnologValue    this[@JS]
 * @Description         : get video course by technoogy
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-03-2016 06:33 PM  
 * @Status              : available      
 */
function getVideoCourseBYTechnology(technologyArray, url) {
    var technologyResponse;
    technologyResponse = checkXMLHTTP(technologyResponse);

    var formdata = new FormData();
    formdata.append("selected_topic", technologyArray);

    technologyResponse.addEventListener("load", function () {

        documentID('video_course_view').innerHTML = technologyResponse.responseText;

    }, false);
    technologyResponse.open("POST", url);
    technologyResponse.send(formdata);
}


/*
 * @Function            : moreTechnology 
 * @Used IN             : @fornt_end/video_course.php
 * @Description         : get more technoogy
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-03-2016 01:01 PM  
 * @Status              : available      
 */
function moreTechnology(url, counter) {
    var technologyResponse;
    technologyResponse = checkXMLHTTP(technologyResponse);

    var technologyList = 'null';
    if (technologyArray.length > 0) {
        technologyList = technologyArray;
    }

    var formdata = new FormData();
    formdata.append("counter", counter);
    formdata.append("selected_topic", technologyList);

    technologyResponse.addEventListener("load", function () {

        documentID('technology_view').innerHTML = technologyResponse.responseText;

    }, false);
    technologyResponse.open("POST", url);
    technologyResponse.send(formdata);
}



/*
 * @Function            : getPriorityLevel 
 * @Used IN             : @fornt_end/video_course.php
 * @Description         : get video course priorit level
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-03-2016 01:16 PM  
 * @Status              : available      
 */
function getPriorityLevel(inputValue, url) {
    var priorityLevelResponse;
    priorityLevelResponse = checkXMLHTTP(priorityLevelResponse);

    var priorityLevel;
    if (inputValue === '1') {
        documentID("priority_level2").checked = false;
    } else if (inputValue === '2') {
        documentID("priority_level1").checked = false;
    }

    if ($("#priority_level" + inputValue).is(":checked")) {
        priorityLevel = inputValue;
    } else {
        priorityLevel = 'null';
    }

    var formdata = new FormData();
    formdata.append("priority_level", priorityLevel);

    priorityLevelResponse.addEventListener("load", function () {

        documentID('video_course_view').innerHTML = priorityLevelResponse.responseText;

    }, false);
    priorityLevelResponse.open("POST", url);
    priorityLevelResponse.send(formdata);
}


/*
 * @Function            : getFreeVideoCourse 
 * @Used IN             : @fornt_end/video_course.php
 * @Description         : get free video course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 24-03-2016 01:20 PM  
 * @Status              : available      
 */
function getFreeVideoCourse(inputValue, url) {
    var freeVideoCourseResponse;
    freeVideoCourseResponse = checkXMLHTTP(freeVideoCourseResponse);

    var courseType;
    if ($("#course_type").is(":checked")) {
        courseType = inputValue;
    } else {
        courseType = 'null';
    }

    var formdata = new FormData();
    formdata.append("free_course_value", courseType);

    freeVideoCourseResponse.addEventListener("load", function () {

        documentID('video_course_view').innerHTML = freeVideoCourseResponse.responseText;

    }, false);
    freeVideoCourseResponse.open("POST", url);
    freeVideoCourseResponse.send(formdata);
}


/*
 * @Function            : searchVideoCourse 
 * @Used IN             : @fornt_end/video_course.php
 * @Description         : get searched video course
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 25-03-2016 07:00 PM  
 * @Status              : available      
 */
function searchVideoCourse(searchValue, url) {
    var searchVideoCourseResponse;
    searchVideoCourseResponse = checkXMLHTTP(searchVideoCourseResponse);

    var formdata = new FormData();
    formdata.append("search_value", searchValue);

    searchVideoCourseResponse.addEventListener("load", function () {

        documentID('video_course_view').innerHTML = searchVideoCourseResponse.responseText;

    }, false);
    searchVideoCourseResponse.open("POST", url);
    searchVideoCourseResponse.send(formdata);
}
/*
 -----------@@@RIPON@ End View public Video Course Part----------------------------------
 */


/*
 -----------@@@RIPON@ View Organization Video Course Part----------------------------------
 */
function checkForDelete(url, videoCourseUrl) {
    var deleteVideoCourseResponse;
    deleteVideoCourseResponse = checkXMLHTTP(deleteVideoCourseResponse);

    swal({
        title: "",
        text: "Are you sure you want to Delete this Video Course?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("video_course_url", videoCourseUrl);

                    deleteVideoCourseResponse.addEventListener("load", function () {

                        if (deleteVideoCourseResponse.responseText === 'success') {
                            location.reload();
                        }

                    }, false);
                    deleteVideoCourseResponse.open("POST", url);
                    deleteVideoCourseResponse.send(formdata);
                }
            });
}
/*
 -----------@@@RIPON@ View Organization Video Course Part----------------------------------
 */



/*
 -----------@@@RIPON@ View public video course----------------------------------
 */

/*
 * @Function            : downloadWorkFile 
 * @Used IN             : @fornt_end/video_course_details.php
 * @Description         : download video course work file
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 11-04-2016 05:55 PM  
 * @Status              : available      
 */
function downloadWorkFile(url, workFileID) {
    window.location.href = url + workFileID;
}


/*
 * @Function            : searchVideo
 * @Used IN             : @fornt_end/video_course_details.php
 * @Description         : get video by search
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 12-04-2016 04:02 PM  
 * @Status              : available      
 */
function searchVideo(url, videoCourseID, searchValue) {
    var searchVideoResponse;
    searchVideoResponse = checkXMLHTTP(searchVideoResponse);

    var formdata = new FormData();
    formdata.append("video_course_id", videoCourseID);
    formdata.append("search_input", searchValue);

    searchVideoResponse.addEventListener("load", function () {

        documentID('view_video_menu').innerHTML = searchVideoResponse.responseText;

    }, false);
    searchVideoResponse.open("POST", url);
    searchVideoResponse.send(formdata);
}


//$(document).ready(function () {
//    $('a').click(function () {
//        $('#view_video').toggle();
//        return false;
//    });
//
//});
/*
 -----------@@@RIPON@ View public video course----------------------------------
 */


/*
 -----------@@@RIPON@ Start Utility Function----------------------------------
 */
/*
 * @Function            : uploadVideoFileErrorMessage
 * @Used IN             : @function-uploadVideoFile   this[@JS]
 * @Description         : show upload video file error message
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 19-04-2016 05:27 PM  
 * @Status              : available      
 */
function uploadVideoFileErrorMessage(sectionCounter, videoCounter, errorMessage) {
    documentID('view_video_file_name' + sectionCounter + '_video' + videoCounter).value = '';
    documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
    documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
    documentID('view_file_size_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
    documentID('progressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
    documentID('upload_video_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = errorMessage;

    documentID('video_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
    documentID('videoFile_sec' + sectionCounter + '_video' + videoCounter).removeAttribute("disabled");
    documentID('video_section_name' + sectionCounter).removeAttribute('readonly', '');
    documentID('video_name_sec' + sectionCounter + '_video' + videoCounter).removeAttribute('readonly', '');

    deleteSingleValue('allUploadVideoOKcounter_sec_', sectionCounter, videoCounter);
}


/*
 * @Function            : uploadVideoFileErrorMessage
 * @Used IN             : @function-uploadVideoFile   this[@JS]
 * @Description         : show upload video work file error message
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 20-04-2016 10:10 AM  
 * @Status              : available      
 */
function uploadVideoWorkFileErrorMessage(sectionCounter, videoCounter, errorMessage) {
    documentID('view_work_file_name' + sectionCounter + '_video' + videoCounter).value = '';
    documentID('workFile_sec' + sectionCounter + '_video' + videoCounter).value = '';
    documentID('work_file_upload_status_sec' + sectionCounter + '_video' + videoCounter).value = '';
    documentID('workProgressBar_sec' + sectionCounter + '_video' + videoCounter).innerHTML = '';
    documentID('workFileProgressID_sec' + sectionCounter + '_video' + videoCounter).style.display = 'none';
    documentID('upload_work_file_error_sec' + sectionCounter + '_video' + videoCounter).innerHTML = errorMessage;

    deleteSingleValue('allUploadVideoWorkFileOKCounter_sec_', sectionCounter, videoCounter);
}

/*
 -----------@@@RIPON@ End Utility Function----------------------------------
 */


/*
 -----------@@@RIPON@ Start learner video course view Part----------------------------------
 */
function cancelVideoCourseRegistration(url, ID, type) {
    window.location.href = url + '/' + ID + '/' + type;
}

function learnerVideoCoursePagination(url, videoCourseType, pageNumber) {
    var videoCoursePaginationResponse;
    videoCoursePaginationResponse = checkXMLHTTP(videoCoursePaginationResponse);

    var formdata = new FormData();
    formdata.append("video_course_type", videoCourseType);
    formdata.append("page_number", pageNumber);

    videoCoursePaginationResponse.addEventListener("load", function () {

        if (videoCourseType === 'free') {
            documentID('view_learner_free_video_course').innerHTML = videoCoursePaginationResponse.responseText;
        }
        if (videoCourseType === 'register') {
            documentID('view_learner_register_video_course').innerHTML = videoCoursePaginationResponse.responseText;
        }

    }, false);
    videoCoursePaginationResponse.open("POST", url);
    videoCoursePaginationResponse.send(formdata);
}

function videoCoursePagination(url, videoCourseType, pageNumber) {
    var videoCoursePaginationResponse;
    videoCoursePaginationResponse = checkXMLHTTP(videoCoursePaginationResponse);

    var formdata = new FormData();
    formdata.append("video_course_type", videoCourseType);
    formdata.append("page_number", pageNumber);

    videoCoursePaginationResponse.addEventListener("load", function () {

        if (videoCourseType === 'draft') {
            documentID('view_draft_video_course').innerHTML = videoCoursePaginationResponse.responseText;
        }
        if (videoCourseType === 'submit') {
            documentID('view_submit_video_course').innerHTML = videoCoursePaginationResponse.responseText;
        }
        if (videoCourseType === 'active') {
            documentID('view_active_video_course').innerHTML = videoCoursePaginationResponse.responseText;
        }
        $('html, body').animate({scrollTop: 0}, 'slow');

    }, false);
    videoCoursePaginationResponse.open("POST", url);
    videoCoursePaginationResponse.send(formdata);
}

/*
 * @Description         : Displays modal in delete video course
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 27-03-17
 * @Status              : available      
 */
$(document).on('click', 'button[id^="modalNoButtonvc"]', function () {
    var videoCourseUrl = this.id.replace('modalNoButtonvc', '');
    $("#deleteVideoCourseModal" + videoCourseUrl).modal('hide');
}).on('click', 'button[id^="modalYesButtonvc"]', function () {
    var videoCourseUrl = this.id.replace('modalYesButtonvc', '');
    deleteVideoCourse(videoCourseUrl);
});


/*
 * @Description         : Deletes Video Course Via Ajax
 * @Developed By        : Md Mashqur Ul Alam
 * @Start DateTime      : 27-03-17
 * @Status              : available      
 */
function deleteVideoCourse(videoCourseUrl) {
    var url = $('#baseUrl').val() + 'user/delete-video-course';
    $.post(url,
            {
                video_course_url: videoCourseUrl
            },
            function (data) {
                var val = JSON.parse(data);

                if (val === 'ok') {
                    $("#deleteVideoCourseModal" + videoCourseUrl).modal('hide');
                    $('#row' + videoCourseUrl).hide().remove();
                }
            });
}
/*
 -----------@@@RIPON@ End learner video course view Part----------------------------------
 */



/*
 * ----------------- Following Code is For video Player ------------------------
 */



/*
 * @Function            : videoLoad 
 * @Used IN             : @fornt_end/video_course_details.php
 * @Description         : view uploaded video when click video
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 11-04-2016 05:54 PM  
 * @Updated By          : Md Mashqur Ul Alam
 * @Update DateTime     : 29-05-17
 * @Status              : available      
 */
var previousUploadVideoID = '';
function videoLoad(url, uploadVideoID) {    
    $.post(url,
            {
                upload_video_id: uploadVideoID
            },
            function (data) {                
                $('#video-container').empty();
                $('#video-container').html(data);
                plyr.setup();
            });
}

