
/* 
 * @Description         : Displays default selected image in image gallery
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 18-04-2016
 * @Status              : Available
 */
$(document).ready(function () {
    //$('.thumbDiv').slice(0, 6).show();
    var firstImage = $('#thumbImage1').attr('src');
    if (firstImage) {
        $('img#SliderImage').attr('src', firstImage);
    } else {
        var defaultImage = $('#defaultThumb').attr('src');
        $('img#SliderImage').attr('src', defaultImage);
    }
});


/* 
 * @Description         : Displays next thumb image on clicking right arrow
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 18-04-2016
 * @Status              : Available
 */
$('#rightArrow').click(function () {
    if ($('.thumbDiv:visible').last().next().length > 0) {
        $('.thumbDiv:visible').first().hide('slide', {direction: "left"}, function () {
            $('.thumbDiv:visible').last().next().show('slide', {direction: "right"}, 400);
        });
    }
});


/* 
 * @Description         : Displays previous thumb image on clicking left arrow
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 18-04-2016
 * @Status              : Available
 */
$('#leftArrow').click(function () {
    if ($('.thumbDiv:visible').first().prev().length > 0) {
        $('.thumbDiv:visible').last().hide('slide', {direction: 'right'}, function () {
            $('.thumbDiv:visible').first().prev().show('slide', {direction: 'left'}, 400);
        });
    }
});

/* 
 * @Description         : Displays selected thumb image in gallery upon clicking
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 18-04-2016
 * @Status              : Available
 */
$('img[id^=thumbImage]').click(function () {
    $('.thumbDiv').removeClass('currentThumb');
    $(this).parent().addClass('currentThumb');
    var imgSource = $(this).attr('src');    
    $('img#SliderImage').attr('src', imgSource).fadeIn();
    
});


/* 
 * @Description         : Displays alert Upon clicking delete
 * @Developed By        : MD MASHQUR UL ALAM
 * @Start DateTime      : 18-04-2016
 * @Status              : Available
 */
$('#deleteGalleryImage').click(function () {
    swal({
        title: "",
        text: "Do you really want to delete this image ?",
        showCancelButton: true,
        confirmButtonColor: '#8CC73F',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var baseUrl = $('#baseUrl').val();
                    var contentLocation = $('img#SliderImage').attr('src');
                    var contentType = window.location.href.replace(baseUrl, '');
                    var url = baseUrl + 'profile/delete_image_album_content';
                    $.post(url,
                            {
                                content_location: contentLocation,
                                content_type: contentType
                            },
                            function (response) {
                                if (response == 'ok') {
                                    window.location.reload();
                                }
                            });
                }
            });
});
