$(document).ready(function () {
    var baseUrl = $('#baseUrl').val();
    /*
     * @Description         : get payment from
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 11:10 PM   
     */
    $(document).on('click', 'input[id^=paymentMethod]', function () {
        var ID = this.id.replace('paymentMethod', '');
        if (ID === '1') {
            $('#bkashMethodView').slideDown();
            $('#checkMethodView').slideUp();
        }
        if (ID === '2') {
            $('#checkMethodView').slideDown();
            $('#bkashMethodView').slideUp();
        }
        if (ID === '3') {
            $('#paypalMethodView').slideDown();
        }
    });

    /*
     * @Description         : get bank ID for view bank information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 11:51 PM   
     */
    var bankId;
    $(document).on('change', 'select[id=bankId]', function () {
        accountNumberArray = [];
        var output = '<option value="">Select Bank Branch</option>';
        bankId = $('#' + this.id).val();
        if (bankId === 'other') {
            $('#otherBankNameView').fadeIn('slow');
            output += '<option value="other">Other</option>';
            $('#bankBranchId').html(output);
        } else {
            var output1 = getBranchDataView(bankId, output);
            output1 += '<option value="other">Other</option>';
            $('#bankBranchId').html(output1);
            $('#otherBankNameView').fadeOut('slow');
            $('#otherBankBranchNameView').fadeOut('slow');
        }
    });


    /*
     * @Description         : get bank branch ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 12:21 PM   
     */
    var bankBranchId;
    $(document).on('change', 'select[id=bankBranchId]', function () {
        bankBranchId = $('#' + this.id).val();
        if (bankBranchId === 'other') {
            $('#otherBankBranchNameView').fadeIn('slow');
        } else {
            $('#otherBankBranchNameView').fadeOut('slow');
        }
    });



    /*
     * @Description         : check bank name if user seect other bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 02:55 PM   
     */
    var bankNameArray = [];
    $(document).on('keyup', 'input[id="otherBankName"]', function () {
        var bankName = $('#' + this.id).val().replace(/  +/g, ' ').trim();
        if (bankNameArray.length >= 0) {
            if ($.inArray(bankName, bankNameArray) > -1) {
                $('#bank_name_exists').val(1);
            } else {
                $('#bank_name_exists').val('');
            }
        }

        if (bankNameArray.length === 0) {
            getAllBankName();
        }
    });



    /*
     * @Description         : check bank name if user seect other bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 02:55 PM   
     */
    $(document).on('keyup', 'input[id="editOtherBankName"]', function () {
        var bankName = $('#' + this.id).val().replace(/  +/g, ' ').trim();

        if (previousBankName !== bankName) {
            if (bankNameArray.length >= 0) {
                if ($.inArray(bankName, bankNameArray) > -1) {
                    $('#edit_bank_name_exists').val(1);
                } else {
                    $('#edit_bank_name_exists').val('');
                }
            }
        }


        if (bankNameArray.length === 0) {
            getAllBankName();
        }
    });
    /*
     * @Description         : get all bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 05:17 PM   
     */
    function getAllBankName() {
        $.get(baseUrl + 'user/get-all-bank-name', function (data) {
            var bankData = JSON.parse(data);
            var i = 0;
            $.each(bankData, function () {
                bankNameArray[i] = bankData[i].bank_name;
                i++;
            });
        });
    }


    /*
     * @Description         : check bank branch name if user seect other bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 02:55 PM   
     */
    var bankBranchArray = [];
    $(document).on('keyup', 'input[id="otherBankBranchName"]', function () {
        var bankBranchName = $('#' + this.id).val().replace(/  +/g, ' ').trim();
        if (bankId !== 'other') {

            if (bankBranchArray.length >= 0) {
                if ($.inArray(bankBranchName, bankBranchArray) > -1) {
                    $('#bank_branch_name_exists').val(1);
                } else {
                    $('#bank_branch_name_exists').val('');
                }
            }

            if (bankBranchArray.length === 0) {
                var i = 0;
                var bankBranchData = JSON.parse(getBankData(bankId));
                $.each(bankBranchData, function () {
                    bankBranchArray[i] = bankBranchData[i].bank_branch_name;
                    i++;
                });
            }
        }
    });

    /*
     * @Description         : check edit bank branch name if user seect other bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 02:55 PM   
     */
    $(document).on('keyup', 'input[id="edit_OtherBankBranchName"]', function () {
        var bankBranchName = $('#' + this.id).val().replace(/  +/g, ' ').trim();

        if (bankId !== 'other') {
            if (bankBranchArray.length >= 0) {
                if ($.inArray(bankBranchName, bankBranchArray) > -1) {
                    $('#edit_OtherBankBranchName_exists').val(1);
                } else {
                    $('#edit_OtherBankBranchName_exists').val('');
                }
            }

            if (bankBranchArray.length === 0) {
                var i = 0;
                var bankBranchData = JSON.parse(getBankData(bankId));
                $.each(bankBranchData, function () {
                    bankBranchArray[i] = bankBranchData[i].bank_branch_name;
                    i++;
                });
            }
        }
    });


    /*
     * @Description         : check account number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 02:55 PM   
     */
    var accountNumberArray = [];
    $(document).on('keyup', 'input[id="personAccountNumber"]', function () {
        var accountNumber = $('#' + this.id).val();
        if (accountNumberArray.length >= 0) {
            if ($.inArray(accountNumber, accountNumberArray) > -1) {
                $('#accountNumberExists').val(1);
            } else {
                $('#accountNumberExists').val('');
            }
        }

        if (accountNumberArray.length === 0) {
            generateAccountNumberArray();
        }

    });

    /*
     * @Description         : check account number for edit check amount
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 03:03 PM   
     */
    $(document).on('keyup', 'input[id="edit_person_account_number"]', function () {
        var accountNumber = $('#' + this.id).val();

        if (previousAccountNumber !== accountNumber) {
            if (accountNumberArray.length >= 0) {
                if ($.inArray(accountNumber, accountNumberArray) > -1) {
                    $('#edit_AccountNumberExists').val(1);
                } else {
                    $('#edit_AccountNumberExists').val('');
                }
            }
        } else {
            $('#edit_AccountNumberExists').val('');
        }

        if (accountNumberArray.length === 0) {
            generateAccountNumberArray();
        }

    });

    /*
     * @Description         : generate account number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 28-12-2016 10:45 AM   
     */
    function generateAccountNumberArray() {
        var accountNumber = JSON.parse(getAccountNumber(bankId));

        if (accountNumber.length > 0) {
            var i = 0;
            $.each(accountNumber, function () {
                accountNumberArray[i] = accountNumber[i].person_account_number;
                i++;
            });
        }
    }
    /*
     * @Description         : check bank branch name if user seect other bank name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 19-12-2016 02:55 PM   
     */
    var previousPaypalEmail;
    $(document).on('click', 'a[id^="editPaypalPayment"]', function () {
        var paymentMethodId = this.id.replace('editPaypalPayment', '');

        $.post(baseUrl + 'user/get-paypal-payment-info', {payment_method_id: paymentMethodId}, function (data) {
            var paypalPaymentInfo = JSON.parse(data);

            $('#updatePaypalMethodView').slideDown('slow');
            $('#edit_PaypalEmail').val(paypalPaymentInfo.paypal_email);
            previousPaypalEmail = paypalPaymentInfo.paypal_email;
            $('#payPalMethodid').val(paymentMethodId);
        });
    });

    /*
     * @Description         : check paypal email ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 03:36 PM   
     */
    $(document).on('keyup', 'input[id="paypalEmail"]', function () {
        var paypalEmail = $('#' + this.id).val();

        $.post(baseUrl + 'user/check-paypal-email', {paypal_email: paypalEmail}, function (data) {
            if (data === '1') {
                $('#paypalEmailEsists').val(1);
            } else {
                $('#paypalEmailEsists').val('');
            }
        });
    });

    /*
     * @Description         : check paypal email ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 03:36 PM   
     */
    $(document).on('keyup', 'input[id="edit_PaypalEmail"]', function () {
        var paypalEmail = $('#' + this.id).val();

        if (previousPaypalEmail !== paypalEmail) {
            $.post(baseUrl + 'user/check-paypal-email', {paypal_email: paypalEmail}, function (data) {
                if (data === '1') {
                    $('#edit_paypalEmailEsists').val(1);
                } else {
                    $('#edit_paypalEmailEsists').val('');
                }
            });
        } else {
            $('#edit_paypalEmailEsists').val('');
        }
    });


    /*
     * @Description         : update bkash payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 10:07 AM   
     */
    var previousBkashNumber;
    $(document).on('click', 'a[id^="editBkashInfo"]', function () {
        var bKashPaymentID = this.id.replace('editBkashInfo', '');

        $.post(baseUrl + 'user/get-bkash-payment-info', {bkash_payment_id: bKashPaymentID}, function (data) {
            var bkashPaymentData = JSON.parse(data);

            $('#updateBkashMethodView').slideDown('slow');
            $('#bkashPaymentID').val(bKashPaymentID);
            previousBkashNumber = bkashPaymentData.bkash_number;
            $('#edit_bkash_number').val(bkashPaymentData.bkash_number);
            $('input[name=edit_bkash_number_type][value=' + bkashPaymentData.bkash_number_type + ']').attr('checked', true);
        });
    });



    /*
     * @Description         : check bkash number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 10:08 AM   
     */
    var bKashNumberArray = [];
    $(document).on('keyup', 'input[id="bkashNumber"]', function () {
        var bkashNumber = $('#' + this.id).val();

        if (bKashNumberArray.length >= 0) {
            if ($.inArray(bkashNumber, bKashNumberArray) > -1) {
                $('#bkashNumberExistence').val(1);
            } else {
                $('#bkashNumberExistence').val('');
            }
        }

        if (bKashNumberArray.length === 0) {
            getALLbkashNumber();
        }
    });


    /*
     * @Description         : check bkash number for edit
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 02:40 AM   
     */
    $(document).on('keyup', 'input[id="edit_bkash_number"]', function () {
        var bkashNumber = $('#' + this.id).val();

        if (bkashNumber !== previousBkashNumber) {
            if (bKashNumberArray.length >= 0) {
                if ($.inArray(bkashNumber, bKashNumberArray) > -1) {
                    $('#bkashNumberExistence').val(1);
                } else {
                    $('#bkashNumberExistence').val('');
                }
            }
        } else {
            $('#bkashNumberExistence').val('');
        }

        if (bKashNumberArray.length === 0) {
            getALLbkashNumber();
        }
    });

    /*
     * @Description         : get all bkash number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 02:39 PM   
     */
    function getALLbkashNumber() {
        $.get(baseUrl + 'user/check-bkash-number', function (data) {
            var bkashData = JSON.parse(data);

            var i = 0;
            $.each(bkashData, function () {
                bKashNumberArray[i] = bkashData[i].bkash_number;
                i++;
            });
        });
    }

    /*
     * @Description         : delete bkash payment method
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 27-12-2016 03:17 PM   
     */
    $(document).on('click', 'a[id^="deleteBkashInfo"]', function () {
        var bkashPaymentId = this.id.replace('deleteBkashInfo', '');
        $('#viewDeleteBkashPaymentModal' + bkashPaymentId).modal('show');
    }).on('click', 'button[id^="modalNoButtonbKashPayment"]', function () {
        var bkashPaymentId = this.id.replace('modalNoButtonbKashPayment', '');
        $('#viewDeleteBkashPaymentModal' + bkashPaymentId).modal('hide');
    }).on('click', 'button[id^="modalYesButtonbKashPayment"]', function () {
        var bkashPaymentId = this.id.replace('modalYesButtonbKashPayment', '');

        $.post(baseUrl + 'user/delete-bkash-payment-method', {bkash_payment_id: bkashPaymentId}, function () {
            location.reload();
        });
    });

    /*
     * @Description         : update bkash payment information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 10:07 AM   
     */
    var previousBankName, previousAccountNumber;
    $(document).on('click', 'a[id^="editCheckInfo"]', function () {
        var checkPaymentID = this.id.replace('editCheckInfo', '');
        var output = '<option value="">Select Bank Branch</option>';

        $.post(baseUrl + 'user/get-check-payment-info', {check_payment_id: checkPaymentID}, function (data) {
            var checkPaymentData = JSON.parse(data);

            $('#updateCheckMethodView').slideDown('slow');
            if (checkPaymentData.bank_info.bank_status === '2') {
                $('#editBankId').val('other');
                $('#otherEditBankNameView').fadeIn('slow');
                $('#editBankID').val(checkPaymentData.bank_info.bank_id);
                bankId = 'other';
                $('#editOtherBankName').val(checkPaymentData.bank_info.bank_name);
                previousBankName = checkPaymentData.bank_info.bank_name;
            } else {
                bankId = checkPaymentData.bank_info.bank_id;
                $('#editBankId').val(checkPaymentData.bank_info.bank_id);
            }

            var output1 = getBranchDataView(checkPaymentData.bank_info.bank_id, output);
            output1 += '<option value="other">Other</option>';
            $('#edit_BankBranchId').html(output1);
            $('#edit_BankBranchId').val(checkPaymentData.branch_info.bank_branch_id);

            $('#checkPaymentID').val(checkPaymentID);
            previousAccountNumber = checkPaymentData.check_payment_info.person_account_number;
            $('#edit_person_account_number').val(checkPaymentData.check_payment_info.person_account_number);
        });
    });


    /*
     * @Description         : get bank ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-12-2016 03:35 PM   
     */
    $(document).on('change', 'select[id="editBankId"]', function () {
        var output = '<option value="">Select Bank Branch</option>';
        var bankId = $('#' + this.id).val();
        if (bankId === 'other') {
            $('#otherEditBankNameView').fadeIn('slow');
            output += '<option value="other">Other</option>';
            $('#edit_BankBranchId').html(output);
        } else {
            var output1 = getBranchDataView(bankId, output);
            output1 += '<option value="other">Other</option>';
            $('#edit_BankBranchId').html(output1);
            $('#otherEditBankNameView').fadeOut('slow');
            $('#otherEditBankBranchNameView').fadeOut('slow');
        }
    });


    /*
     * @Description         : get bank branch ID
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 26-12-2016 03:40 PM   
     */
    $(document).on('change', 'select[id=edit_BankBranchId]', function () {
        var bankBranchId = $('#' + this.id).val();
        if (bankBranchId === 'other') {
            $('#editBankID').val('');
            $('#otherEditBankBranchNameView').fadeIn('slow');
        } else {
            $('#otherEditBankBranchNameView').fadeOut('slow');
        }
    });

    /*
     * @Description         : delete check payment method
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 28-12-2016 05:01 PM   
     */
    $(document).on('click', 'a[id^=deletecheckInfo]', function () {
        var checkPaymentId = this.id.replace('deletecheckInfo', '');
        $('#viewDeleteCheckPaymentModal' + checkPaymentId).modal('show');
    }).on('click', 'button[id^="modalNoButtoncheckPayment"]', function () {
        var checkPaymentId = this.id.replace('modalNoButtoncheckPayment', '');
        $('#viewDeleteCheckPaymentModal' + checkPaymentId).modal('hide');
    }).on('click', 'button[id^="modalYesButtoncheckPayment"]', function () {
        var checkPaymentId = this.id.replace('modalYesButtoncheckPayment', '');

        $.post(baseUrl + 'user/delete-check-payment-method', {check_payment_id: checkPaymentId}, function () {
            location.reload();
        });
    });
    /*
     * @Description         : get bank branch ID
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 26-12-2016 03:40 PM   
     */
    $(document).on('click', 'a[id^=deletePaypalInfo]', function () {
        var paypalPaymentId = this.id.replace('deletePaypalInfo', '');
        $('#viewDeletePaypalPaymentModal' + paypalPaymentId).modal('show');
    }).on('click', 'button[id^="modalNoButtonpaypalPayment"]', function () {
        var paypalPaymentId = this.id.replace('modalNoButtonpaypalPayment', '');
        $('#viewDeletePaypalPaymentModal' + paypalPaymentId).modal('hide');
    }).on('click', 'button[id^="modalYesButtonpaypalPayment"]', function () {
        var paypalPaymentId = this.id.replace('modalYesButtonpaypalPayment', '');

        $.post(baseUrl + 'user/delete-paypal-payment-method', {paypal_payment_id: paypalPaymentId}, function () {
            location.reload();
        });
    });
});


/*
 * @Description         : get all bank branch name by bank ID
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 26-12-2016 02:55 PM   
 */
function getBankData(bankId) {
    var output;
    var baseUrl = $('#baseUrl').val();
    $.ajax({
        type: 'POST',
        url: baseUrl + 'user/view-bank-branch',
        data: {bank_id: bankId},
        dataType: 'html',
        async: false,
        success: function (data) {
            output = data;
        }
    });
    return output;
}


/*
 * @Description         : get all account number
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 28-12-2016 10:35 AM   
 */
function getAccountNumber(bankId) {
    var output;
    var baseUrl = $('#baseUrl').val();
    $.ajax({
        type: 'POST',
        url: baseUrl + 'user/check-bank-account-number',
        data: {bank_id: bankId},
        dataType: 'html',
        async: false,
        success: function (data) {
            output = data;
        }
    });
    return output;
}



/*
 * @Description         : get all branch data view
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 26-12-2016 02:58 PM   
 */
function getBranchDataView(bankId, output) {
    var bankBranchData = JSON.parse(getBankData(bankId));

    var i = 0;
    $.each(bankBranchData, function () {
        output += '<option value="' + bankBranchData[i].bank_branch_id + '">' + bankBranchData[i].bank_branch_name + '</option>';
        i++;
    });
    return output;
}