function checkXmlHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest !== 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}


/*
 -----------@@@RIPON@ Start Add Course view Part (25-07-16)----------------------------------
 */
(function () {
    var editCourseName = documentID('edit_course_name') ? documentID('edit_course_name').value : '';
    if (editCourseName === '') {
        var courseName;
        var courseURL;
        documentID('course_name').oninput = function () {
            courseName = documentID('course_name').value;

            if (courseURL === undefined || courseURL === '') {
                var makeUrl = makeCleanUrl(courseName);
                makeCourseUrl(makeUrl);
            } else {
                documentID('course_url').value = courseURL;
                checkCourseUrl(courseURL);
            }
        };

        documentID('course_url').oninput = function () {
            courseURL = documentID('course_url').value;
            documentID('course_url').value = courseURL;
            checkCourseUrl(courseURL);
        };
    }
}());
/*
 * @Function            : make_clean_url 
 * @Used IN             : create_course.php
 * @Description         : Make clean URL
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-03-2016 08:33 PM  
 * @Status              : available      
 */
function makeCleanUrl(url) {
    for (var i = 0; url.length > i; i++) {
        if (url.charAt(i) === ' ') {
            url = url.replace(/ +/g, '-');
        }
        if (url.charAt(i) === '.') {
            url = url.replace(/\./g, '');
        }
        if (url.charAt(i) === '-') {
            url = url.replace(/--/g, '-');
        }

    }
    url = url.replace(/[&\/\\#@!^_=,+()$~%.'":*?<>{}]/g, '');
    if (url.charAt(url.length - 1) === '-') {
        url = setCharAt(url, url.length - 1, '');
    }
    url = url.replace(/--/g, '-');
    url = url.replace(' ', '-');
    return url.toLowerCase();
}


/*
 * @Function            : makeCourseUrl 
 * @Used IN             : make course url
 * @Description         : Make coure URL
 * @Developed By        : Md Jaherul Islam
 * @Start DateTime      : 17-07-2016 01:01 PM  
 * @Status              : available      
 */
function makeCourseUrl(course_url) {
    var makeNewCourseUrl = $('#make_course_ajax_url').val();
    var formdata = new FormData();
    formdata.append('course_url', course_url);

    $.ajax({
        url: makeNewCourseUrl,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#course_url').val(data);
        }
    });
}

/*
 * @Function            : otherResourcePerson 
 * @Used IN             : create_course.php
 * @Description         : get other resource form
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-03-2016 08:33 PM  
 * @Status              : available      
 */
function otherResourcePerson(resourcePersonID) {
    if (resourcePersonID === 'other') {
        documentID('other_resource_person').style.display = 'block';
    } else {
        documentID('other_resource_person').style.display = 'none';
    }
}


/*
 * @Function            : checkEditCourseURl 
 * @Used IN             : view/user/course/edit_course.php
 * @Description         : check edit course URL existence
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 11:09 AM  
 * @Parameter           : newURL[STRING], oldURl[STRING]
 * @Return              : NULL
 * @Status              : available      
 */
function checkEditCourseURl(newURL, oldURl) {
    if (newURL !== oldURl) {
        checkCourseUrl(newURL);
    } else {
        documentID('url_exist').value = '';        
    }
}
/*
 * @Function            : checkCourseUrl 
 * @Used IN             : function-'user/course/course_list.php
 * @Description         : check course URL Esists
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-03-2016 08:33 PM  
 * @Status              : available      
 */
function checkCourseUrl(urlValue) {
    var courseUrlResponse;
    courseUrlResponse = checkXmlHTTP(courseUrlResponse);

    var url = documentID('course_ajax_url').value;
    var formdata = new FormData();
    formdata.append("course_url", urlValue);

    courseUrlResponse.addEventListener("load", function () {

        if (courseUrlResponse.responseText === '1') {
            documentID('url_exist').value = '1';            
        } else if (courseUrlResponse.responseText === '2') {
            documentID('url_exist').value = '';           
        }

    }, false);
    courseUrlResponse.open("POST", url);
    courseUrlResponse.send(formdata);
}

/*
 * @Function            : getParentTopic 
 * @Used IN             : @function-'user/course/add_course.php'
 * @Description         : get parent Topic for view child topic
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 23-07-2016 05:23 PM 
 * @Parameter           : topicID[INTEGER], url[STRING], childTopicID[INTEGER]
 * @Return              : NULL      
 * @Status              : available      
 */
var getParentTopic = function (topicID, url, childTopicID, personID) {
    var output = '<option value="">Select Topic</option>';
    if (topicID !== '') {
        var serverUrl = url + '/' + topicID + '/' + personID;
        $.get(serverUrl, function (data, status) {
            if (status === 'success') {
                var topicInfo = JSON.parse(data);

                for (var i = 0; i < topicInfo.length; i++) {
                    output += '<option value="' + topicInfo[i].topic_id + '">' + topicInfo[i].topic_name + '</option>';
                }
                output += '<option value="other">Other Topic</option>';
                $('#topic_id').html(output);
                if (childTopicID !== '') {
                    $('#topic_id').val(childTopicID);
                }
            }
        });
    } else {
        $('#topic_id').html(output);
    }
    $('#other_topic_name').val('');
    $('#otherTopic').hide();
};


/*
 * @Function            : getOtherTopic 
 * @Used IN             : @function-'user/course/add_course.php'
 * @Description         : get other topic input fileld
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 23-07-2016 05:39 PM 
 * @Parameter           : topic[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
var getOtherTopic = function (topic) {
    if (topic === 'other') {
        $('#otherTopic').show();
    } else {
        $('#otherTopic').hide();
    }
};

/*
 * @Function            : checkOtherTopicName 
 * @Used IN             : @function-'user/course/add_course.php'
 * @Description         : check other topic name existence
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 23-07-2016 05:46 PM 
 * @Parameter           : topicName[STRING], url[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
var checkOtherTopicName = function (topicName1, url) {
    var parentTopicId = $('#parent_topic_id').val();
    var topicName = topicName1.replace(/  +/g, '');

    var formdata = new FormData();
    formdata.append('parent_topic_id', parentTopicId);
    formdata.append('topic_name', topicName);

    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#other_topic_name_exist').val(data);            
        }
    });
};

/*
 * @Function            : getSkillLevel 
 * @Used IN             : @self
 * @Description         : view courses using course Access Level
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 08-02-2016 10:51 AM  
 * @Updateded By        : Ripon Jaherul
 * @Update DateTime     : 25-02-2016 01:03 AM  
 * @Status              : available      
 */
function getCourseType(courseType) {
    if (courseType === '1') {
        documentID('course_price_view').style.display = 'block';
    } else if (courseType === '2') {
        documentID('course_price_view').style.display = 'none';
    }
}

/*
 * @Function            : getCurrencyType 
 * @Used IN             : @function-'view/user/course/add_course.php'
 * @Description         : Change Course price icon based on currenty type
 * @Developed By        : Md. Delwar Hossain
 * @Start DateTime      : 16-04-2017 11:30 AM  
 * @Status              : available      
 */
function getCurrencyType(course_price_currency){
    if (course_price_currency === '1') {
        documentID('usd').style.display = 'none';
        documentID('bdt').style.display = 'block';
    } else if (course_price_currency === '2') {
        documentID('usd').style.display = 'block';
        documentID('bdt').style.display = 'none';
    }
}

/*
 * @Function            : viewTotalClassHour 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : view total class hour
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 05:08 PM 
 * @Parameter           : numberOfClasses[STRING], classHourPerDay[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
var viewTotalClassHour = function (numberOfClasses, classHourPerDay) {
    var time = convertDecemaltoTime(numberOfClasses, classHourPerDay);
    documentID('show_total_class_hour').innerHTML = 'Total Class Hour: ' + time;
    documentID('total_class_hour').value = time;
};

/*
 * @Function            : getTotalClassHour 
 * @Used IN             : @self
 * @Description         : get total class hour 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 08-02-2016 10:51 AM  
 * @Status              : available      
 */

function getTotalClassHour() {
    var numberOfClasses1 = documentID('number_of_classes').value;
    if (numberOfClasses1) {        
        documentID('number_of_classes_error').innerHTML = '';
    }
    var classHourPerDay1 = documentID('class_hour_per_day').value;
    if (classHourPerDay1) {      
        documentID('class_hour_per_day_error').innerHTML = '';
    }


    if (classHourPerDay1 !== '' && numberOfClasses1 !== '') {
        var time = convertDecemaltoTime(numberOfClasses1, classHourPerDay1);
        documentID('show_total_class_hour').innerHTML = 'Total Class Hour: ' + time;
        documentID('total_class_hour').value = time;
    }
}


/*
 * @Function            : convertDecemaltoTime 
 * @Used IN             : @self
 * @Description         : convert Desimal to Time
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 08-09-2016 10:51 AM  
 * @Status              : available      
 */
function convertDecemaltoTime(numberOfClasses1, classHourPerDay1) {
    var numberOfClasses = parseInt(numberOfClasses1);
    var classMinutePerDay = parseFloat(classHourPerDay1);
    var classMinuts = numberOfClasses * classMinutePerDay;
    var classMiliSeconds = classMinuts * 60000;
    var timeObject = convertMillisecondsToDigitalClock(classMiliSeconds);
    return timeObject.clock;
}


/*
 * @Function            : convertMillisecondsToDigitalClock 
 * @Used IN             : @self
 * @Description         : convert millisecond to to Digital clock 
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 08-09-2016 10:51 AM  
 * @Status              : available      
 */
function convertMillisecondsToDigitalClock(ms) {
    var hours = Math.floor(ms / 3600000); // 1 Hour = 36000 Milliseconds
    var minutes = Math.floor((ms % 3600000) / 60000); // 1 Minutes = 60000 Milliseconds
    var minutes1; // 1 Minutes = 60000 Milliseconds
    if (minutes.toString().length === 1) {
        minutes1 = minutes + '0';
    } else {
        minutes1 = minutes;
    }
    return {
        hours: hours,
        minutes: minutes,
        clock: hours + ":" + minutes1
    };
}

/*
 * @Function            : getStartDate 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : check start date validation
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 04:35 AM 
 * @Parameter           : courseStartDate[DATE], previousStartDate[DATE]
 * @Return              : NULL      
 * @Status              : available      
 */
var getStartDate = function (courseStartDate, previousStartDate) {
    if (courseStartDate !== previousStartDate) {
        $('#course_start_date').attr('class', 'form-control validate[required, custom[mindate], custom[courseFinishedDate]]');
    } else {
        $('#course_start_date').attr('class', 'form-control validate[required]');
    }
};


/*
 * @Function            : getLastDate 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : check End date validation
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 04:41 AM 
 * @Parameter           : courseEndtDate[DATE], previousEndDate[DATE]
 * @Return              : NULL      
 * @Status              : available      
 */
var getLastDate = function (courseEndtDate, previousEndDate) {
    if (courseEndtDate !== previousEndDate) {
        $('#last_date_of_registration').attr('class', 'form-control validate[required, custom[mindate], custom[compareEndRegDate]]');
    } else {
        $('#last_date_of_registration').attr('class', 'form-control validate[required]');
    }
};

/*
 * @Function            : getFinishDate 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : check Finish date validation
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 04:43 AM 
 * @Parameter           : courseFinishtDate[DATE], previousFinishDate[DATE]
 * @Return              : NULL      
 * @Status              : available      
 */
var getFinishDate = function (courseFinishtDate, previousFinishDate) {
    if (courseFinishtDate !== previousFinishDate) {
        $('#course_finished_date').attr('class', 'form-control validate[required, custom[mindate], custom[courseFinishedDate]]');
    } else {
        $('#course_finished_date').attr('class', 'form-control validate[required]');
    }
};
/*
 -----------@@@RIPON@ End Add Course view Part (25-07-16)----------------------------------
 */


/*
 -----------@@@RIPON@ Start View course (organization and Teacher) Part----------------------------------
 */
/*
 * @Function            : coursePagination 
 * @Used IN             : @function-'user/course/course_list.php, user/course/ajax_page/view_course.php'
 * @Description         : course pagination
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 19-05-2016 09:37 AM  
 * @Parameter           : url[STRING], courseType[INTEGER], pageNumber[INTEGER]
 * @Return              : NULL    
 * @Status              : Available        
 */
function coursePagination(url, courseType, pageNumber) {
    var coursePaginationResponse;
    coursePaginationResponse = checkXmlHTTP(coursePaginationResponse);

    var formdata = new FormData();
    formdata.append("course_type", courseType);
    formdata.append("page_number", pageNumber);

    coursePaginationResponse.addEventListener("load", function () {

        if (courseType === 'draft') {
            documentID('view_draft_course').innerHTML = coursePaginationResponse.responseText;
        }
        if (courseType === 'submit') {
            documentID('view_submit_course').innerHTML = coursePaginationResponse.responseText;
        }
        if (courseType === 'active') {
            documentID('view_active_course').innerHTML = coursePaginationResponse.responseText;
        }
        $('html, body').animate({scrollTop: 0}, 'slow');

    }, false);
    coursePaginationResponse.open("POST", url);
    coursePaginationResponse.send(formdata);
}

/*
 * @Function            : deleteCourse 
 * @Used IN             : @function-'user/course/course_list.php, user/course/ajax_page/view_course.php'
 * @Description         : delete course
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 22-09-2016 10:31 AM  
 * @Parameter           : url[STRING], courseUrl[STRING]
 * @Return              : NULL    
 * @Status              : Available        
 */
function deleteCourse(url, courseUrl) {
    $.post(url, {course_url: courseUrl}, function () {
        location.reload();
    });
}
/*
 -----------@@@RIPON@ Start View course (organization and Teacher) Part----------------------------------
 */





/*
 -----------@@@RIPON@ Start learner course view Part----------------------------------
 */
function cancelCourseRegistration(url, ID, type) {
    window.location.href = url + '/' + ID + '/' + type;
}

function learnerCoursePagination(url, courseType, pageNumber) {
    var coursePaginationResponse;
    coursePaginationResponse = checkXmlHTTP(coursePaginationResponse);

    var formdata = new FormData();
    formdata.append("course_type", courseType);
    formdata.append("page_number", pageNumber);

    coursePaginationResponse.addEventListener("load", function () {

        if (courseType === 'free') {
            documentID('view_learner_free_course').innerHTML = coursePaginationResponse.responseText;
        }
        if (courseType === 'register') {
            documentID('view_learner_register_course').innerHTML = coursePaginationResponse.responseText;
        }


    }, false);
    coursePaginationResponse.open("POST", url);
    coursePaginationResponse.send(formdata);
}

/*
 -----------@@@RIPON@ End learner course view Part----------------------------------
 */
