function checkXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}



/*
 -----------@@@RIPON@ Start Video Course Part----------------------------------
 */
/*
 * @Function            : otherCategory 
 * @Used IN             : @function-'view/user/class/schedule_class'
 * @Description         : check schedult class submit 
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 12-03-2016 12:35 PM
 * @Status              : available      
 */
function cehckSubmit(featureStatus) {
    if (featureStatus === 1) {
        documentID('feature_status_error').style.display = 'none';
        return true;
    } else {
        documentID('feature_status_error').style.display = 'block';
        return true;
    }
}

/*
 * @Function            : checkStartTime 
 * @Used IN             : @function-'view/user/class/schedule_class'
 * @Description         : check schedule classroom 
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 12-03-2016 02:49 PM
 * @Status              : available      
 */
function checkStartTime(classStartTime, url) {
    var checkStartTimeResponse;
    checkStartTimeResponse = checkXMLHTTP(checkStartTimeResponse);

    var classStartDate = documentID('class_date').value;
    if (classStartDate) {
        if (classStartTime !== '') {
            documentID('duration').value = '';
            var classStartDateTime = classStartDate + ' ' + classStartTime;
            var formdata = new FormData();
            formdata.append("class_start_date_time", classStartDateTime);

            checkStartTimeResponse.addEventListener("load", function () {

                if (checkStartTimeResponse.responseText === '1') {
                    documentID('class_start_time_error').innerHTML = '';
                } else if (checkStartTimeResponse.responseText === '2') {
                    documentID('class_start_time_validate').value = '2';
                    documentID('class_start_time_error').innerHTML = 'Start time must grather than today';
                }

            }, false);
            checkStartTimeResponse.open("POST", url);
            checkStartTimeResponse.send(formdata);
        } else {
            documentID('class_start_time_validate').value = '1';
            documentID('class_start_time_error').innerHTML = 'Please select class start date time';
        }
    } else {
        documentID('class_start_date_validate').value = '1';
        documentID('class_start_date_error').innerHTML = 'Please select course start date';
    }
}

/*
 * @Function            : checkDuration 
 * @Used IN             : @function-'view/user/class/schedule_class.php'
 * @Description         : check class duaration 
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 12-03-2016 02:21 PM
 * @Status              : available      
 */
function checkDuration(url, classrommNumber, classroomID) {
    var checkDurationResponse;
    checkDurationResponse = checkXMLHTTP(checkDurationResponse);

    var fileRegx = /^[0-9]+$/;
    var duration = documentID('duration').value;
    var classDate = documentID('class_date').value;
    var startTime = documentID('class_start_time').value;
    if (classDate !== '' && startTime !== '') {
        if (fileRegx.test(duration)) {
            if (duration <= 180 && duration >= 30) {
                var formdata = new FormData();
                formdata.append("class_date", classDate);
                formdata.append("start_time", startTime);
                formdata.append("duration", duration);
                formdata.append("classroom_id", classroomID);

                checkDurationResponse.addEventListener("load", function () {

                    if (checkDurationResponse.responseText >= classrommNumber) {
                        documentID('class_duration').innerHTML = '';
                        documentID('duration_error').innerHTML = 'You have already used maximum classroom';
                    } else {
                        var convertTime = ConvertTimeformat(startTime);
                        var m = moment(classDate + ' ' + convertTime);
                        m.add(duration, 'minute');
                        documentID('class_duration').innerHTML = "<b>Class End Time</b> : " + m.format("h:mm:ss a");
                        documentID('duration_error').innerHTML = '';
                    }

                }, false);
                checkDurationResponse.open("POST", url);
                checkDurationResponse.send(formdata);

            } else {
                documentID('class_duration').innerHTML = '';
                documentID('duration_error').innerHTML = 'Duration must less than 180 and Grether than 30 minuts';
            }
        } else {
            documentID('class_duration').innerHTML = '';
            documentID('duration_error').innerHTML = 'Please input valid duaration';
        }
    } else {
        documentID('class_duration').innerHTML = '';
        documentID('duration_error').innerHTML = 'Please input Date and start time';
    }
}

/*
 * @Function            : ConvertTimeformat 
 * @Used IN             : @function-'checkDuration'  this[@JS]
 * @Description         : convert time 
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 12-03-2016 02:20 PM
 * @Status              : available      
 */
function ConvertTimeformat(time) {
    var hours = Number(time.match(/^(\d+)/)[1]);
    var minutes = Number(time.match(/:(\d+)/)[1]);
    var AMPM = time.match(/\s(.*)$/)[1];
    if (AMPM === "PM" && hours < 12)
        hours = hours + 12;
    if (AMPM === "AM" && hours === 12)
        hours = hours - 12;
    var sHours = hours.toString();
    var sMinutes = minutes.toString();
    if (hours < 10)
        sHours = "0" + sHours;
    if (minutes < 10)
        sMinutes = "0" + sMinutes;

    return sHours + ":" + sMinutes;
}


/*
 * @Function            : selectCategoryCourse 
 * @Used IN             : @function-'add_course(MODAL)'  this[@JS]
 * @Description         : select category and get course
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 12-03-2016 04:13 PM
 * @Status              : available      
 */
function selectCategoryCourse(categoryID, url) {
    var selectCategoryCourseResponse;
    selectCategoryCourseResponse = checkXMLHTTP(selectCategoryCourseResponse);

    var formdata = new FormData();
    formdata.append("course_category_id", categoryID);

    selectCategoryCourseResponse.addEventListener("load", function () {

        documentID('category_course').innerHTML = selectCategoryCourseResponse.responseText;

    }, false);
    selectCategoryCourseResponse.open("POST", url);
    selectCategoryCourseResponse.send(formdata);
}


/*
 * @Function            : setCourse 
 * @Used IN             : @function-'add_course(MODAL)'  this[@JS]
 * @Description         : set course name in sehedule class
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 12-03-2016 06:08 PM
 * @Status              : available      
 */
function setCourse() {
    var courseID = document.forms['selectCourseForm'].elements['course_id'].value;
    var courseName = documentID('course_name' + courseID).value;
    documentID('submitted_course_name').innerHTML = '<b>Course Name : </b>' + courseName;
    documentID('hidden_course_id').value = courseID;
    documentID('hidden_course_name').value = courseName;
    documentID('course_id_error').innerHTML = '';
}

/*
 * @Function            : getClassroomTitle 
 * @Used IN             : @function-'schedule_class'  this[@JS]
 * @Description         : check class room title validation
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 01:59 AM
 * @Status              : available      
 */
function getClassroomTitle(classroomTitle) {
    if (classroomTitle !== '') {
        documentID('classroom_title_error').innerHTML = '';
    } else {
        documentID('classroom_title_error').innerHTML = 'Please Select Classroom Title';
    }
}
/*
 * @Function            : getClassroomTitle 
 * @Used IN             : @function-'schedule_class.php'  this[@JS]
 * @Description         : check class room title validation
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 01:59 AM
 * @Status              : available      
 */
function checkDate(startDate, url, classroomPerDay, classroomID) {
    if (startDate !== '') {
        documentID('class_start_date_error').innerHTML = '';
        documentID('duration').value = '';

        var checkDateResponse;
        checkDateResponse = checkXMLHTTP(checkDateResponse);

        var formdata = new FormData();
        formdata.append("start_date", startDate);
        formdata.append("classroom_id", classroomID);

        checkDateResponse.addEventListener("load", function () {

            if (checkDateResponse.responseText >= classroomPerDay) {
                documentID('class_start_date_validate').value = '2';
                documentID('class_start_date_error').innerHTML = 'You have already used maximum classroom in this day';
            } else {
                documentID('class_start_date_validate').value = '';
                documentID('class_start_date_error').innerHTML = '';
            }

        }, false);
        checkDateResponse.open("POST", url);
        checkDateResponse.send(formdata);
    } else {
        documentID('class_start_date_validate').value = '1';
        documentID('class_start_date_error').innerHTML = 'Please Select Classroom Title';
    }
}


/*
 * @Function            : updateUrlForm 
 * @Used IN             : @function-'review_publish.php'  this[@JS]
 * @Description         : get update URl form
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 03:09 AM
 * @Status              : available      
 */
function updateUrlForm(url, classRoomID) {
    var updateUrlFormResponse;
    updateUrlFormResponse = checkXMLHTTP(updateUrlFormResponse);

    var formdata = new FormData();
    formdata.append("classroom_id", classRoomID);

    updateUrlFormResponse.addEventListener("load", function () {

        documentID('edit_url_button').style.display = 'none';
        documentID('save_url_button').style.display = 'block';
        documentID('view_url_form').innerHTML = updateUrlFormResponse.responseText;

    }, false);
    updateUrlFormResponse.open("POST", url);
    updateUrlFormResponse.send(formdata);
}


/*
 * @Function            : checkClassRoomURL 
 * @Used IN             : @function-'review_publish.php'(ajax_page[add_classroom_url_form])
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 03:09 AM
 * @Status              : available      
 */
function checkClassRoomURL(inputURl, url, oldurl) {
    var updateUrlFormResponse;
    updateUrlFormResponse = checkXMLHTTP(updateUrlFormResponse);

    var urlRegx = /^[0-9a-z\-]+$/;
    var hypenRegex = /--/g;

    if (inputURl !== '') {
        if (inputURl !== oldurl) {
            if (inputURl.charAt(0) === '-') {
                documentID('classroom_url_error').innerHTML = 'No hypen allow at the first';
                documentID('class_url_validate').value = '2';
            } else if (inputURl.charAt(inputURl.length - 1) === '-') {
                documentID('classroom_url_error').innerHTML = 'No hypen allow at the last';
                documentID('class_url_validate').value = '3';
            } else if (hypenRegex.test(inputURl)) {
                documentID('classroom_url_error').innerHTML = 'Multiple hypen does not allow';
                documentID('class_url_validate').value = '4';
            } else if (urlRegx.test(inputURl)) {
                var formdata = new FormData();
                formdata.append("new_classroom_url", inputURl);

                updateUrlFormResponse.addEventListener("load", function () {

                    if (updateUrlFormResponse.responseText === '1') {
                        documentID('classroom_url_error').innerHTML = 'Url Already Exixts';
                        documentID('class_url_validate').value = '6';
                    } else if (updateUrlFormResponse.responseText === '2') {
                        documentID('classroom_url_error').innerHTML = '';
                        documentID('class_url_validate').value = '';
                    }

                }, false);
                updateUrlFormResponse.open("POST", url);
                updateUrlFormResponse.send(formdata);

            } else {
                documentID('classroom_url_error').innerHTML = 'No Capital Letter or Special Caracter Allow Accept -';
                documentID('class_url_validate').value = '5';
            }
        }
    } else {
        documentID('classroom_url_error').innerHTML = 'Please Type Classsroom URL';
        documentID('class_url_validate').value = '1';
    }
}


/*
 * @Function            : saveUpdateURL 
 * @Used IN             : @function-'review_publish.php'(ajax_page[add_classroom_url_form])
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 09:29 AM
 * @Status              : available      
 */
function saveUpdateURL(url, classroomID, redirectURL) {
    var updateUrlFormResponse;
    updateUrlFormResponse = checkXMLHTTP(updateUrlFormResponse);

    var urlValidate = documentID('class_url_validate').value;
    if (urlValidate === '1') {
        documentID('classroom_url_error').innerHTML = 'Please Type Classsroom URL';
        return false;
    } else if (urlValidate === '2') {
        documentID('classroom_url_error').innerHTML = 'No hypen allow at the first';
        return false;
    } else if (urlValidate === '3') {
        documentID('classroom_url_error').innerHTML = 'No hypen allow at the last';
        return false;
    } else if (urlValidate === '4') {
        documentID('classroom_url_error').innerHTML = 'Multiple hypen does not allow';
        return false;
    } else if (urlValidate === '5') {
        documentID('classroom_url_error').innerHTML = 'No Capital Letter or Special Caracter Allow Accept -';
        return false;
    } else if (urlValidate === '6') {
        documentID('classroom_url_error').innerHTML = 'Url Already Exixts';
        return false;
    } else {
        var newURL = documentID('classroom_url').value;

        var formdata = new FormData();
        formdata.append("new_classroom_url", newURL);
        formdata.append("classroom_id", classroomID);

        updateUrlFormResponse.addEventListener("load", function () {

            window.location.href = redirectURL + '/' + updateUrlFormResponse.responseText;

        }, false);
        updateUrlFormResponse.open("POST", url);
        updateUrlFormResponse.send(formdata);
    }
}


/*
 * @Function            : checkClassroomAction 
 * @Used IN             : @function-'myclass.php'
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 14-03-2016 12:07 PM
 * @Status              : available      
 */
function checkClassroomAction(url, status, classroomID) {
    var checkClassroomActionResponse;
    checkClassroomActionResponse = checkXMLHTTP(checkClassroomActionResponse);

    swal({
        title: "",
        text: "Are you sure you want to " + status + " this Class?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("status", status);
                    formdata.append("classroom_id", classroomID);

                    checkClassroomActionResponse.addEventListener("load", function () {

                        if (checkClassroomActionResponse.responseText === 'success') {
                            location.reload();
                        }

                    }, false);
                    checkClassroomActionResponse.open("POST", url);
                    checkClassroomActionResponse.send(formdata);
                }
            });
}


/*
 * @Function            : changeStudentPermission 
 * @Used IN             : @function-'course_registered_student.php'
 * @Description         : change student permission
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 16-03-2016 06:53 PM
 * @Status              : available      
 */
function changeStudentPermission(url, studentID, classroomID, type) {
    var studentPermissionResponse;
    studentPermissionResponse = checkXMLHTTP(studentPermissionResponse);

    swal({
        title: "",
        text: "Are you sure you want to " + type + " this Student?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("type", type);
                    formdata.append("student_id", studentID);
                    formdata.append("classroom_id", classroomID);

                    studentPermissionResponse.addEventListener("load", function () {

                        if (studentPermissionResponse.responseText === '2') {
                            showError();
                        } else if (studentPermissionResponse.responseText === '3') {
                            showError1();
                        } else {
                            documentID('sActions' + studentID).innerHTML = studentPermissionResponse.responseText;
                        }

                    }, false);
                    studentPermissionResponse.open("POST", url);
                    studentPermissionResponse.send(formdata);
                }
            });
}

function showError() {
    swal({
        title: "",
        text: "This student allready assigned in this class time",
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'OK',
        closeOnConfirm: true
    });
}
function showError1() {
    swal({
        title: "",
        text: "Maximun number of student assigned this class",
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'OK',
        closeOnConfirm: true
    });
}


/*
 * @Function            : checkStudentxClassroomAction 
 * @Used IN             : @function-'my_class_as_larner.php'
 * @Description         : check assigned student action
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 19-03-2016 12:26 PM
 * @Status              : available      
 */
function checkStudentClassroomAction(url, status, classroomStudentID) {
    var studentClassroomResponse;
    studentClassroomResponse = checkXMLHTTP(studentClassroomResponse);

    swal({
        title: "",
        text: "Are you sure you want to " + status + " this Student?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("classroom_student_id", classroomStudentID);

                    studentClassroomResponse.addEventListener("load", function () {

                        if (studentClassroomResponse.responseText === 'success') {
                            location.reload();
                        }

                    }, false);
                    studentClassroomResponse.open("POST", url);
                    studentClassroomResponse.send(formdata);
                }
            });
}