$(document).ready(function () {
    $('#topic_name').keyup(function () {
        validateName();
    });

    $('#parent_topic_id').change(function () {
        validateName();
    });
});


/*
 * @Function            : validateName 
 * @Used IN             : @function-'view/admin/add_topic_from.php
 * @Description         : validate topic name
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-07-2016 04:18 PM 
 * @Parameter           : NULL
 * @Return              : NULL      
 * @Status              : available      
 */
var validateName = function () {
    var topicID1 = $('#topicID').val();
    var topicName = $('#topic_name').val();
    var parentTopicID1 = $('#parent_topic_id').val();
    var topicID = topicID1 === undefined ? 0 : topicID1;
    var parentTopicID = parentTopicID1 === '' ? 0 : parentTopicID1;

    var checkTopicNameUrl = $('#checkTopicNameUrl').val();
    var serverURL = checkTopicNameUrl + '/' + topicID + '/' + parentTopicID + '/' + topicName;

    $.get(serverURL, function (data, status) {
        if (status === 'success') {
            $('#topic_name_exists').val(data);            
        }
    });
};


/*
 * @Function            : changeTopicStatus 
 * @Used IN             : @function-'view/admin/manage_topic.php
 * @Description         : change topic status
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-07-2016 11:57 AM 
 * @Parameter           : url[STRING], topicID[INTEGER], status[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
var changeTopicStatus = function (url, topicID, status) {
    var serverUrl = url + '/' + topicID + '/' + status;
    $.get(serverUrl, function (data, status) {
        if (status === 'success') {
            if (data !== 'Delete') {
                var topicData = JSON.parse(data);
                viewTopicAction(topicData);
            } else {
                location.reload();
            }
        }
    });
};


/*
 * @Function            : viewTopicAction  
 * @Used IN             : @function-'changeTopicStatus'   this[@JS]
 * @Description         : view topic action
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-07-2016 01:26 PM 
 * @Parameter           : topicData[ARRAY]
 * @Return              : NULL      
 * @Status              : available      
 */
var viewTopicAction = function (topicData) {
    var output = '';
    var editURL = $('#editURL').val();
    switch (topicData.topic_status) {
        case '1':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#InactiveTopic' + topicData.topic_id + '"><i class="fa fa-user-plus" title="Active"></i></a>&nbsp;';
            break;
        case '2':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#PendingTopic' + topicData.topic_id + '"><i class="fa fa-user-times" title="Inactive"></i></a>&nbsp;';
            break;
        case '3':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#ActiveTopic' + topicData.topic_id + '"><i class="fa fa-refresh fa-spin" title="Pending"></i></a>&nbsp;';
            break;
        case '4':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#ActiveTopic' + topicData.topic_id + '"><i class="fa fa-refresh fa-spin" title="Pending"></i></a>&nbsp;';
            break;
        case '5':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#PendingTopic' + topicData.topic_id + '"><i class="glyphicon glyphicon-ok" title="Approved"></i></a>&nbsp;';
            break;
    }
    output += '<a href="' + editURL + '/' + topicData.topic_id + '"><i class="fa fa-edit" title="Edit"></i></a>&nbsp;';
    output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#deleteTopic' + topicData.topic_id + '"><i class="fa fa-trash-o" title="Delete"></i></a>&nbsp;';

    $('#topicAction' + topicData.topic_id).html(output);
};
