$(document).ready(function () {
    
    /*
     * @Description         : View payment request details
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 30-04-17    
     */
    $(document).on('click', 'a[id^=paymentRequestDetail]', function () {
        var courseUrl = this.id.replace('paymentRequestDetail', '');
        var baseUrl = $('#baseUrl').val();
        var status = $('#status' + courseUrl).val();

        if (status !== '') {
            $('#displayPaymentRequest' + courseUrl).slideUp('slow');
            $('#status' + courseUrl).val('');
        } else {
            $.ajax({
                type: 'post',
                url: baseUrl + 'admin/view-all-payment-request',
                data: {course_url: courseUrl},
                beforeSend: function () {
                    $('#loadingImage' + courseUrl).slideDown('slow');
                },
                complete: function (jqXHR, textStatus) {
                    $('#loadingImage' + courseUrl).slideUp('slow');
                },
                success: function (data, status) {
                    if (status === 'success') {
                        var viewPage = JSON.parse(data);
                        $('#displayPaymentRequest' + courseUrl).html(viewPage).slideDown('slow');
                        $('#status' + courseUrl).val(1);
                    }
                }
            });
        }

    });

    /*
     * @Description         : Confirm pyment request alert
     * @Developed By        : MD Mashqur Ul Alam
     * @Start DateTime      : 30-04-17    
     */
    $(document).on('click', 'a[id^=confirmPayment]', function () {
        var courseUrl = this.id.replace('confirmPayment', '');
        var baseUrl = $('#baseUrl').val();

        swal({
            title: "",
            text: "Are you sure to confirm payment ?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: '#8CC73F',
            confirmButtonText: 'Yes',
            cancelButtonText: "No",
            closeOnConfirm: true,
            closeOnCancel: true
        },
            function (isConfirm) {
                    if (isConfirm) {
                        $.post(
                                baseUrl + 'admin/confirm-payment-request',
                                {
                                    course_url: courseUrl
                                },
                                function (data) {
                                    var response = JSON.parse(data);
                                    if(response === 'payment confirmed'){
                                        $('#confirmPayment'+courseUrl).html('<i class="fa fa-check" title="Payment Confirmed">');
                                    }

                                });
                    }
                });


    });
});