$(document).ready(function () //ready() is used to make a function available after the document is loaded
{
    var bankIDArray = [];
    var bankNameArray = [];
    var bankStatusArray = [];
    var searchInput = '';
    var pageNumber = 1;
    var baseUrl = $('#baseUrl').val();


    $("#addBankForm").click(function ()
    {
        $("#addBankFormView").slideDown('slow'); //slideDown() used to hidden elements
        return false;
    });

    $("#cancelBankForm").click(function ()
    {
        $("#addBankFormView").slideUp('slow'); //slideUp() method slides-up (hides) the selected elements.
        $('#bank_name').val('');
        $('input[name=bank_status]').attr('checked', false);
        return false;
    });


    /*
     * @Description         : check bank name existence
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 03:32 PM      
     */
    $(document).on('keyup', 'input[id="bank_name"]', function () {
        var inputBankName = $('#' + this.id).val().replace(/  +/g, ' ').trim();

        if ($.inArray(inputBankName, bankNameArray) > -1) {
            $('#bank_name_exists').val(1);
        } else {
            $('#bank_name_exists').val('');
        }
    });

    /*
     * @Description         : get bank information
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 02:50 PM      
     */
    $.get(
            baseUrl + 'admin/get-bank-info',
            function (data) {
                var bankData = JSON.parse(data);

                var i = 0;
                $.each(bankData, function () {
                    bankIDArray[i] = bankData[i].bank_id;
                    bankNameArray[i] = bankData[i].bank_name;
                    bankStatusArray[i] = bankData[i].bank_status;
                    i++;
                });
            });


    /*
     * @Description         : bank pagination
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 04:57 PM      
     */
    $(document).on('keyup', 'input[id="search_bank_name"]', function () {
        pageNumber = 1;
        searchInput = $('#' + this.id).val().replace(/  +/g, ' ').trim();

        viewBankName();
    });

    /*
     * @Description         : bank pagination
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 04:57 PM      
     */
    $(document).on('click', 'a[id^="bankPagination"]', function () {
        pageNumber = this.id.replace('bankPagination', '');

        viewBankName();
    });


    /*
     * @Description         : Active bank status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 11:50 AM      
     */
    $(document).on('click', 'a[id^="activeBankName"]', function () {
        var bankID = this.id.replace('activeBankName', '');
        $('#viewActiveBankModal' + bankID).modal('show');
    }).on('click', 'button[id^="modalNoButtonActive"]', function () {
        var bankID = this.id.replace('modalNoButtonActive', '');
        $('#viewActiveBankModal' + bankID).modal('hide');
    }).on('click', 'button[id^="modalYesButtonActive"]', function () {
        var bankID = this.id.replace('modalYesButtonActive', '');
        $.post(
                baseUrl + 'admin/update-bank-status',
                {bank_id: bankID, bank_status: 1},
                function (data) {
                    var bankData = JSON.parse(data);
                    if (bankData.total_modify_bank !== null) {
                        $('#message').html('<span><strong>' + bankData.total_modify_bank + '</strong> <span style="color: #000">bank and </span><strong>' + bankData.total_modify_branch + '</strong> <span style="color: #000">branch affected</span></span>');
                    }
                    viewBankName();
                });
    });


    /*
     * @Description         : Pending bank status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 11:50 AM      
     */
    $(document).on('click', 'a[id^="pendingBankName"]', function () {
        var bankID = this.id.replace('pendingBankName', '');
        $('#viewPendingBankModal' + bankID).modal('show');
    }).on('click', 'button[id^="modalNoButtonPending"]', function () {
        var bankID = this.id.replace('modalNoButtonPending', '');
        $('#viewPendingBankModal' + bankID).modal('hide');
    }).on('click', 'button[id^="modalYesButtonPending"]', function () {
        var bankID = this.id.replace('modalYesButtonPending', '');
        $.post(
                baseUrl + 'admin/update-bank-status',
                {bank_id: bankID, bank_status: 2},
                function () {
                    viewBankName();
                });
    });


    /*
     * @Description         : delete bank status modalYesButton
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 12:21 PM      
     */
    $(document).on('click', 'a[id^="deleteBankName"]', function () {
        var bankID = this.id.replace('deleteBankName', '');
        $('#viewDeleteBankModal' + bankID).modal('show');
    }).on('click', 'button[id^="modalNoButtonDelete"]', function () {
        var bankID = this.id.replace('modalNoButtonDelete', '');
        $('#viewDeleteBankModal' + bankID).modal('hide');
    }).on('click', 'button[id^="modalYesButtonDelete"]', function () {
        var bankID = this.id.replace('modalYesButtonDelete', '');

        $.post(
                baseUrl + 'admin/delete-bank-name',
                {bank_id: bankID},
                function () {
                    viewBankName();
                });
    });


    /*
     * @Description         : edit bank name
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 02:39 PM      
     */
    $(document).on('click', 'a[id^="editBankName"]', function () {
        var bankID = this.id.replace('editBankName', '');

        $('#header_name').html('Edit Bank Form');
        $('#EditBankForm').slideDown('slow');
        $('#singleBankView' + bankID).hide('slow');

        var index = $.inArray(bankID, bankIDArray);
        $('#edit_bank_name').val(bankNameArray[index]);
        $('#editBankID').val(bankID);
        $('input[name=edit_bank_status][value=' + bankStatusArray[index] + ']').attr('checked', true);
        $('a[id^="editBankName"]').attr('style', 'pointer-events: none');
    });


    /*
     * @Description         : cancel edit bank form
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 03:50 PM      
     */
    $(document).on('click', 'a[id^="canceleditBankForm"]', function () {
        viewBankName();
    });


    /*
     * @Description         : check edit bank name
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-12-2016 10:11 AM      
     */
    $(document).on('keyup', 'input[id="edit_bank_name"]', function () {
        var bankID = $('#editBankID').val();
        var inputBankName = $('#' + this.id).val().replace(/  +/g, ' ').trim();

        var index = $.inArray(bankID, bankIDArray);
        var bankNameindex = $.inArray(inputBankName, bankNameArray);

        if (index === bankNameindex) {
            $('#edit_bank_name_exists').val('');
        } else if (bankNameindex > -1) {
            $('#edit_bank_name_exists').val(1);
        } else {
            $('#edit_bank_name_exists').val('');
        }
    });

    /*
     * @Description         : view bank name
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 06:42 PM      
     */
    function viewBankName() {
        $.ajax({
            type: 'post',
            url: baseUrl + 'admin/view-bank-name',
            data: {search_input: searchInput, page_number: pageNumber},
            beforeSend: function () {
                $('#manageBankView').slideUp('slow');
            },
            success: function (data, status) {
                if (status === 'success') {
                    $('#manageBankView').html(JSON.parse(data)).slideDown('slow');
                    $('#header_name').html('Add Bank Form');
                    $('#EditBankForm').slideUp('slow');
                }
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    }
});



/*
 * 
 * 
 * @Description         : view bank branch manage code
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 15-12-2016 02:25 PM      
 */
$(document).ready(function () {
    var pageNumber = 1;
    var bankID = '';
    var baseUrl = $('#baseUrl').val();
    /*
     * @Description         : add bank branch form
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-12-2016 02:26 PM      
     */
    $('#addBankBranchForm').click(function () {
        $('#viewBankBranchForm').slideDown('slow');
    });

    /*
     * @Description         : close bank branch form
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-12-2016 02:46 PM      
     */
    $('#cancelBankBranchForm').click(function () {
        $('#viewBankBranchForm').slideUp('slow');
        $('#bank_id').val('');
        $('#bank_branch_name').val('');
        $('input[name=bank_branch_status]').attr('checked', false);
    });


    /*
     * @Description         : bank branch pagination
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-12-2016 04:53 PM      
     */
    $(document).on('click', 'a[id^="bankBranchPagination"]', function () {
        pageNumber = this.id.replace('bankBranchPagination', '');

        viewBankBranchName();
    });


    /*
     * @Description         : get single bank branch
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-12-2016 05:46 PM      
     */
    $(document).on('click', 'div[id^="bankName"]', function () {
        pageNumber = 1;
        bankID = this.id.replace('bankName', '');

        viewBankBranchName();
    });

    /*
     * @Description         : check bank name validation
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-12-2016 02:18 PM      
     */
    $(document).on('change', 'select[id="bank_id"]', function () {
        var bankID = $('#bank_id').val();
        if (bankID !== '') {
            $('#bank_name_error').html('').fadeOut('slow');
        } else {
            $('#bank_name_error').fadeIn('slow').html('Please select bank name!');
        }
    });

    /*
     * @Description         : check branch name validation
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-12-2016 02:11 PM      
     */
    $(document).on('keyup', 'input[id="bank_branch_name"]', function () {
        var bankID = $('#bank_id').val();
        if (bankID !== '') {
            $('#bank_name_error').html('').fadeOut('slow');

            var branchName = $('#' + this.id).val().replace(/  +/g, ' ').trim();
            checkBranchName(bankID, branchName, '');
        } else {
            $('#bank_name_error').fadeIn('slow').html('Please select bank name!');
        }
    });


    /*
     * @Description         : check edit branch name validation
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-12-2016 02:31 PM      
     */
    $(document).on('keyup', 'input[id="edit_bank_branch_name"]', function () {
        var bankID = $('#edit_bank_id').val();
        if (bankID !== '') {
            $('#bank_name_error').html('').fadeOut('slow');

            var bankBranchId = $('#bankBranchId').val();
            var branchName = $('#' + this.id).val().replace(/  +/g, ' ').trim();

            // check bank branch name
            checkBranchName(bankID, branchName, bankBranchId);
        } else {
            $('#bank_name_error').fadeIn('slow').html('Please select bank name!');
        }
    });


    /*
     * @Description         : check branch name validation
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-12-2016 02:29 PM      
     */
    function checkBranchName(bankID, branchName, bankBranchId) {
        $.post(baseUrl + 'admin/check-bank-name',
                {bank_id: bankID, baranch_name: branchName, bank_branch_id: bankBranchId},
                function (data) {
                    if (bankBranchId === '') {
                        $('#bank_branch_name_exists').val(data);
                    } else {
                        $('#edit_bank_branch_name_exists').val(data);
                    }
                });
    }

    /*
     * @Description         : Active bank Branch status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-12-2016 03:24 PM      
     */
    $(document).on('click', 'a[id^="activeBankBranchName"]', function () {
        var bankBranchID = this.id.replace('activeBankBranchName', '');
        $('#viewActiveBankBranchModal' + bankBranchID).modal('show');
    }).on('click', 'button[id^="modalNoButtonbranchActive"]', function () {
        var bankBranchID = this.id.replace('modalNoButtonbranchActive', '');
        $('#viewActiveBankBranchModal' + bankBranchID).modal('hide');
    }).on('click', 'button[id^="modalYesButtonbranchActive"]', function () {
        var bankBranchID = this.id.replace('modalYesButtonbranchActive', '');
        $.post(
                baseUrl + 'admin/update-bank-branch-status',
                {bank_branch_id: bankBranchID, bank_branch_status: 1},
                function (data) {
                    var branchData = JSON.parse(data);
                    if (branchData.total_deleted_branch !== null) {
                        $('#message').html('<span><strong>' + branchData.total_deleted_branch + '</strong> <span style="color: #000"> branch affected! </span></span>');
                    }
                    viewBankBranchName();
                });
    });


    /*
     * @Description         : Pending bank Branchstatus
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-12-2016 03:24 PM      
     */
    $(document).on('click', 'a[id^="pendingBankBranchName"]', function () {
        var bankBranchID = this.id.replace('pendingBankBranchName', '');
        $('#viewPendingBankBranchModal' + bankBranchID).modal('show');
    }).on('click', 'button[id^="modalNoButtonbranchPending"]', function () {
        var bankBranchID = this.id.replace('modalNoButtonbranchPending', '');
        $('#viewPendingBankBranchModal' + bankBranchID).modal('hide');
    }).on('click', 'button[id^="modalYesButtonbranchPending"]', function () {
        var bankBranchID = this.id.replace('modalYesButtonbranchPending', '');
        $.post(
                baseUrl + 'admin/update-bank-branch-status',
                {bank_branch_id: bankBranchID, bank_branch_status: 2},
                function () {
                    viewBankBranchName();
                });
    });


    /*
     * @Description         : edit bank Branchstatus
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 18-12-2016 12:08 PM      
     */
    $(document).on('click', 'a[id^="editBankBranceName"]', function () {
        var bankBranchID = this.id.replace('editBankBranceName', '');
        $('#branchHeaderName').html('Edit Bank Branch Form');
        $('#updateBankBranchForm').slideDown('slow');
        $('#singleBankBranchView' + bankBranchID).hide('slow');

        $.post(baseUrl + 'admin/get-bank-branch-info', {branch_bank_id: bankBranchID}, function (data) {
            var bankBranchData = JSON.parse(data);

            $('#bankBranchId').val(bankBranchID);
            $('#edit_bank_id').val(bankBranchData.branch_bank_info.bank_id);
            $('#edit_bank_branch_name').val(bankBranchData.branch_bank_info.bank_branch_name);
            $('input[name=edit_bank_branch_status][value=' + bankBranchData.branch_bank_info.bank_branch_status + ']').attr('checked', true);
            $('a[id^="editBankBranceName"]').attr('style', 'pointer-events: none');
            $('a[id^="bankBranchPagination"]').attr('style', 'pointer-events: none');
            $('a[id^="deleteBankBranchName"]').attr('style', 'pointer-events: none');
            $('div[id^="bankName"]').attr('style', 'color: #80c12c;pointer-events: none');
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    });

    /*
     * @Description         : delete bank status modalYesButton
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 15-12-2016 04:25 PM      
     */
    $(document).on('click', 'a[id^="deleteBankBranchName"]', function () {
        var bankBranchID = this.id.replace('deleteBankBranchName', '');
        $('#viewDeleteBankBranchModal' + bankBranchID).modal('show');
    }).on('click', 'button[id^="modalNoButtonbranchDelete"]', function () {
        var bankBranchID = this.id.replace('modalNoButtonbranchDelete', '');
        $('#viewDeleteBankBranchModal' + bankBranchID).modal('hide');
    }).on('click', 'button[id^="modalYesButtonbranchDelete"]', function () {
        var bankBranchID = this.id.replace('modalYesButtonbranchDelete', '');

        $.post(
                baseUrl + 'admin/delete-bank-branch',
                {bank_branch_id: bankBranchID},
                function () {
                    viewBankBranchName();
                });
    });



    /*
     * @Description         : cancel bank form
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 15-12-2016 04:25 PM      
     */
    $(document).on('click', 'a[id^="cancelBankBranchForm"]', function () {
        viewBankBranchName();

        $('#branchHeaderName').html('Add Bank Branch Form');
        $('#updateBankBranchForm').slideUp('slow');
    });


    /*
     * @Description         : view bank name
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 14-12-2016 06:42 PM      
     */
    function viewBankBranchName() {
        $.ajax({
            type: 'post',
            url: baseUrl + 'admin/view-bank-branch',
            data: {page_number: pageNumber, bank_id: bankID},
            beforeSend: function () {
                $('#manageBankBranchView').slideUp('slow');
            },
            success: function (data, status) {
                if (status === 'success') {
                    $('#manageBankBranchView').html(JSON.parse(data)).slideDown('slow');
                }
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    }
});



/*
 * @Description         : update bank branch status
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 15-12-2016 03:35 PM      
 */
function updateBankBranchStatus(bankBranchID, status) {
    var output;
    var baseUrl = $('#baseUrl').val();
    $.post(
            baseUrl + 'admin/update-bank-branch-status',
            {bank_branch_id: bankBranchID, bank_branch_status: status},
            function () {
                if (status === '1') {
                    output = ' <a href="javascript:void(0)"  id="pendingBankBranchName' + bankBranchID + '" ><i class="fa fa-user-times" title="Pending"></i></a><span>&nbsp;&nbsp;</span>';
                }
                if (status === '2') {
                    output = ' <a href="javascript:void(0)"  id="activeBankBranchName' + bankBranchID + '" ><i class="fa fa-user-plus" title="Active"></i></a><span>&nbsp;&nbsp;</span>';
                }
                $('#statusBranchAction' + bankBranchID).html(output);
            });
}