"use strict";

$(document).ready(function () {

    var limit = 1;
    var notificationType = $('#notificationType').val();
    loadNotification(limit, notificationType);
    /*
     * @Description         : view notification mousehove and click
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-09-2016 11:21 AM 
     * @Status              : Available       
     */
    $(document).on('mousemove', 'div[id^="viewSinglenotification"]', function () {
        $('#' + this.id).addClass('light_green');
    }).on('mouseout', 'div[id^="viewSinglenotification"]', function () {
        $('#' + this.id).removeClass('light_green');
    }).on('click', 'div[id^="viewSinglenotification"]', function () {
        var notificationID = this.id.replace('viewSinglenotification', '');
        var baseUrl = $('#baseUrl').val();
        var viewNotificationUrl = baseUrl + 'admin/update-view-notification';

        $.post(viewNotificationUrl, {notification_id: notificationID,
            notification_type: notificationType},
                function (data) {
                    var urlData = JSON.parse(data);
                    if (urlData === 'error') {
                        $('#viewDeleteWorkFile').modal('show');
                        $(document).on('click', 'button[id="modalOkButtonnotification"]', function () {
                            location.reload();
                        });
                    } else {
                        window.location.href = urlData;
                    }
                });
    });

    /*
     * @Description         : load data after scroll
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-09-2016 11:21 AM 
     * @Status              : Available       
     */
    $(window).scroll(function () {
        var scrollTop = $(window).scrollTop();
        var docValue = $(document).height() - ($(window).height() + 300);
        if (((scrollTop + 50) > docValue) && ((scrollTop - 50) < docValue)) {
            limit += 1;
            loadNotification(limit, notificationType);
        }
    });
});


/*
 * @Description         : load notification information
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 24-09-2016 12:56 PM 
 * @Status              : Available       
 */
var loadNotification = function (limit, notificationType) {
    var baseUrl = $('#baseUrl').val();
    $.ajax({
        type: 'post',
        url: baseUrl + 'admin/view-notification',
        data: {limit: limit, notification_type: notificationType},
        traditional: true,
        success: function (ajaxData) {
            var notificationData = JSON.parse(ajaxData);
            $('#viewNotification').append(notificationData);
            $('#viewNotification').fadeIn('slow');
        }
    });
};
