/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 12-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Admin add video form show in view page
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : videoCounter is pass the value of video form open count
* @Return              :        
* @value               : base_url is used to get base url, url is used to set the route where ajax data send
                         formdata is used to send input->post value by ajax
                         parentDiv is used to select the parent div where child div append
                         newDiv is used to create new div element
* @Status              : Available
* @version             : v2.1       
* */
function addVideoForm(videoCounter){
    var base_url = $('#baseUrl').val(); 
    var url = base_url + 'add-admin-video-form'; 
    var formdata = new FormData(); 
    formdata.append("video_counter", videoCounter);
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            var parentDiv = documentID('add_video_area');
            var newDiv = document.createElement('div');
            newDiv.id = 'upload_video_counter' + videoCounter;
            newDiv.setAttribute('class', 'col-sm-12 form-group');
            parentDiv.appendChild(newDiv);
            newDiv.innerHTML = data;
        }
    });
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 12-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Admin add single video form show by click on add more video button
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : url is pass the value url where ajax data send
* @Return              :        
* @value               : allVideoFormCounter is used to kepp all Video Form Counter data, 
                         allVideoFormCounterValue is used to get counter value from view page
                         videoCounterValue is used to keep counter value
                         tempArray is used to keep calculated allVideoFormCounter value in this array
                         videoCounter is used to keep final video form counter value
                         formdata is used to send input->post value by ajax
                         parentDiv is used to select the parent div where child div append
                         newDiv is used to create new div element
* @Status              : Available
* @version             : v2.1       
* */
function addMoreVideo(url){  
    var allVideoFormCounter = new Array(); 
    var allVideoFormCounterValue = $('#allVideoFormCounter').val(); 
    if (allVideoFormCounterValue !== '') {
        allVideoFormCounter = allVideoFormCounterValue.split(',');
    }

    var videoCounterValue; 
                        
    var tempArray = new Array(); 
    if (allVideoFormCounter.length === 1) {
        videoCounterValue = allVideoFormCounter[0];
    } else {
        for (var i = 0; i < allVideoFormCounter.length; i++) {
            tempArray.push(allVideoFormCounter[i]);
        }
        videoCounterValue = Math.max.apply(Math, tempArray);
    }
    var videoCounter = parseInt(videoCounterValue);    
    
    var formdata = new FormData(); 
    formdata.append("video_counter", videoCounter);
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            var parentDiv = documentID('add_video_area'); 
            var newDiv = document.createElement('div'); 
            ++videoCounter;
            newDiv.id = 'upload_video_counter' + videoCounter;
            newDiv.setAttribute('class', 'col-sm-12 form-group');
            parentDiv.appendChild(newDiv);
            newDiv.innerHTML = data;
            
            var allVideoFormCounterValue = $('#allVideoFormCounter').val();
            var allVideoFormCounter = allVideoFormCounterValue + ',' + videoCounter;
            $('#allVideoFormCounter').val(allVideoFormCounter);
        }
    });
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 12-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Admin add video form show in view page
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : value is pass the value of manage_video_work_file
                         counter is pass the value of video_counter
* @Return              :        
* @value               : 
* @Status              : Available
* @version             : v2.1       
* */
function getWorkFileStatus(value, videoCounter){
    if(value == 1){
        $('#work_file_video_' + videoCounter).show();
    }
    else if(value == 2){
        $('#work_file_video_' + videoCounter).hide();
        var work_file_id = $('#work_file_id' + videoCounter).val();
        
        if(work_file_id != ''){
            var base_url = $('#baseUrl').val();
            var url = base_url + 'delete-admin-video-workfile';
            var work_file_type_id = $('#manage_video_id' + videoCounter).val();
            //deleteVideoWorkfile(url, work_file_type_id);
            var formdata = new FormData(); 
            formdata.append("work_file_type_id", work_file_type_id);
            $.ajax({
                url: url,
                type: "POST",
                data: formdata,
                contentType: false,
                cache: false,
                processData: false,
                success: function ()
                {
                    $('#work_file_id'+ videoCounter).val('');
                    $('#work_file_name'+ videoCounter).val('');
                    $('#view_work_file_name'+ videoCounter).val('');
                    $('#progressID_work_file'+ videoCounter).hide();
                    $("input[name='work_file_payment_type["+ videoCounter +"]']").prop('checked', false);
                }
            });
        }
    }
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 12-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Admin add video form show in view page
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Function            : uploadVideoFile()
* @Parameter           : videoFile is pass the value of upload video information
                         videoCounter is pass the value of video_counter
                         url is pass the value of route where ajax data send
* @Return              :        
* @value               : allowedVedioFileType is used to set all video format which formate type video is allowed to upload, 
                         file is used to keep video file information
                         fileName is used to keep video file name
                         fileExtention is used to keep video file format type
                         fileExtentionSearch is used to search video file format which gives on allowedVedioFileType                         
* @Status              : Available
* @version             : v2.1       
* */
function getVideoFile(videoFile, videoCounter, url) {
    var allowedVideoFileType = "mp4 flv 3gp webm avi wmv"; 
    var file = videoFile.files[0]; 
    var fileName = file.name; 
    var fileExtention = fileName.split('.').pop().toLowerCase(); 
    var fileExtentionSearch = allowedVideoFileType.search(fileExtention); 
    
    $('#view_video_file_name' + videoCounter).val(fileName);
    if (fileExtentionSearch > -1) {
        if (file.size < 524288000) {

            uploadVideoFile(file, videoCounter, url);

        }else{
            $('#manage_upload_video_error' + videoCounter).html('File size must less then 500 Mb');
        }
    }else{
        $('#manage_upload_video_error' + videoCounter).html('Please select video file type: mp4 flv 3gp webm avi wmv');
    }    
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 12-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Admin add video form show in view page
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Used in             : getVideoFile()
* @Parameter           : videoFile is pass the value of upload video information
                         videoCounter is pass the value of video_counter
                         url is pass the value of route where ajax data send
* @Return              :        
* @value               : org_manage_video_title is used to get the value of input field id manage_video_title
                         manage_video_title is used to replace the value of org_manage_video_title if there was used any special character to space
                         manage_video_work_file is used to get the value of radio button id manage_video_work_file
                         manage_video_payment_type is used to get the value of radio button id manage_video_payment_type
                         manage_video_status is used to get the value of radio button id manage_video_status
                         formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
function uploadVideoFile(videoFile, videoCounter, url) {
    $('#uploadVideoFileName' + videoCounter).hide();
    var org_manage_video_title = $('#manage_video_title' + videoCounter).val(); 
    var manage_video_title = org_manage_video_title.replace(/  +/g, ' '); 
    
    var manage_video_work_file = $("input[name='manage_video_work_file["+ videoCounter +"]']:checked").val(); 
    var manage_video_payment_type = $("input[name='manage_video_payment_type["+ videoCounter +"]']:checked").val(); 
    var manage_video_status = $("input[name='manage_video_status["+ videoCounter +"]']:checked").val(); 
     
    var manage_video_id_value = $('#manage_video_id' + videoCounter).val();
    
    var formdata = new FormData(); 
    formdata.append("video_file", videoFile);
    formdata.append("manage_video_id", manage_video_id_value);
    formdata.append("manage_video_title", manage_video_title);
    formdata.append("manage_video_work_file", manage_video_work_file);
    formdata.append("manage_video_payment_type", manage_video_payment_type);
    formdata.append("manage_video_status", manage_video_status);
        
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        xhr: function(){
            var xhr = new window.XMLHttpRequest();
            xhr.upload.addEventListener("progress", function(event){
                if (event.lengthComputable) {
                    $('#progressID_video' + videoCounter).show();
                    var percent = (event.loaded / event.total) * 100;
                    $('#videoProgressBar_video' + videoCounter).attr('style', 'width:' + Math.round(percent) + '%');
                    
                    if (Math.round(percent) === 100) {
                        $('#videoProgressBar_video' + videoCounter).html('<span style=color:black;>Upload Completed</span>');
                        
                        $('#videoFile_video' + videoCounter).removeAttr("disabled");
                        $('#progressID_video' + videoCounter).hide();
                        $('#processing_image' + videoCounter).show();

                    } else {
                        $('#videoFile_video' + videoCounter).attr('disabled', '');
                        $('#videoProgressBar_video' + videoCounter).html('<span style=color:black;>' + Math.round(percent) + '% uploading</span>');
                    }
                }
            }, false);
            return xhr;
        },
        complete: function () {
            $('#processing_image' + videoCounter).hide();
            $('#progressID_video' + videoCounter).show();
        },
        success: function (data) 
        {
            $('#manage_video_id' + videoCounter).val(data);   
            
            var allManageVideoIdValue = $('#all_manage_video_id').val();
            if(allManageVideoIdValue == ''){
                var allManageVideoId = data;
            }else{
                var allManageVideoId = allManageVideoIdValue + ',' + data;
            }
            $('#all_manage_video_id').val(allManageVideoId);            
        }
    });        
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 27-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Admin workfile type check and upload
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Function            : uploadAdminWorkFile()
* @Parameter           : workFile is pass the value of upload workFile information
                         videoCounter is pass the value of video_counter
                         url is pass the value of route where ajax data send
* @Return              :        
* @value               : allowedVedioFileType is used to set all workFile format which formate type workFile is allowed to upload, 
                         file is used to keep video file information
                         fileName is used to keep video file name
                         fileExtention is used to keep video file format type
                         fileExtentionSearch is used to search video file format which gives on allowedVedioFileType                         
* @Status              : Available
* @version             : v2.1       
* */
function getAdminVideoWorkFile(workFile, videoCounter, url) {
    var allowedWorkFileType = "zip rar txt rtf pdf gif jpeg jpg png psd epub azw3 cbr lit mobi swf \n\
                                    docx xlsx pub pptx one doc vsdx accdb xlsb mso rpmsg asd xls oft thmx mdb \n\
                                    xlsm mpp obi pst snp xsn olm  ost dotx vsd laccdb accdr wbk pptm dot ppt xlam \n\
                                    onepkg xltx mde docm pip ppsx ppsm accde grv xla slk potx iaf xlt crtx xlb vss \n\
                                    xar xlw pps pa oab  dotm  mpd svd ops pot xlm mpt acl xltm mdt ade xl vst accdc mdw \n\
                                    accdt mat vdx xsf xll sldx mda mar ppam accda ppa vsx puz prf maf vtx potm xlc wll accdp \n\
                                    mam sldm maq accdu cnv maw xslb"; 
    var file = workFile.files[0]; 
    var fileName = file.name; 
    var fileExtention = fileName.split('.').pop().toLowerCase(); 
    var fileExtentionSearch = allowedWorkFileType.search(fileExtention); 

    var manage_video_id = $('#manage_video_id' + videoCounter).val();
    if(manage_video_id == ''){
        $('#manage_upload_video_error' + videoCounter).html('Please Upload video');
    }else{
        $('#view_work_file_name' + videoCounter).val(fileName);
        if (fileExtentionSearch > -1) {
            if (file.size < 524288000) {

                uploadAdminWorkFile(file, manage_video_id, videoCounter, url);

            }else{
                $('#manage_upload_video_work_file_error' + videoCounter).html('File size must less then 500 Mb');
            }
        }else{
            $('#manage_upload_video_work_file_error' + videoCounter).html('Please select work file type: zip rar txt rtf pdf gif jpeg jpg png psd epub azw3 cbr lit mobi swf \n\
                                                                                                    docx xlsx pub pptx one doc vsdx accdb xlsb mso rpmsg asd xls oft thmx mdb \n\
                                                                                                    xlsm mpp obi pst snp xsn olm  ost dotx vsd laccdb accdr wbk pptm dot ppt xlam \n\
                                                                                                    onepkg xltx mde docm pip ppsx ppsm accde grv xla slk potx iaf xlt crtx xlb vss \n\
                                                                                                    xar xlw pps pa oab  dotm  mpd svd ops pot xlm mpt acl xltm mdt ade xl vst accdc mdw \n\
                                                                                                    accdt mat vdx xsf xll sldx mda mar ppam accda ppa vsx puz prf maf vtx potm xlc wll accdp \n\
                                                                                                    mam sldm maq accdu cnv maw xslb');
        } 
    }
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 27-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Admin add video form show in view page
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Used in             : getAdminVideoWorkFile()
* @Parameter           : workFile is pass the value of upload workFile information
                         videoCounter is pass the value of video_counter
                         url is pass the value of route where ajax data send
* @Return              :        
* @value               : org_work_file_name is used to get the value of input field id work_file_name
                         work_file_name is used to replace the value of org_work_file_name if there was used any special character to space
                         work_file_payment_type is used to get the value of radio button id work_file_payment_type
                         work_file_id_value is used to get the value of id work_file_id_value
                         formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
function uploadAdminWorkFile(workFile, manage_video_id, videoCounter, url){
    $('#uploadWorkfileName' + videoCounter).hide();
    var org_work_file_name = $('#work_file_name' + videoCounter).val(); 
    var work_file_name = org_work_file_name.replace(/  +/g, ' '); 
    var work_file_id_value = $('#work_file_id' + videoCounter).val();
    //var work_file_payment_type = $('#work_file_payment_type' + videoCounter + ':checked').val();
    
    var work_file_payment_type = $("input[name='work_file_payment_type["+ videoCounter +"]']:checked").val(); 

    var formdata = new FormData(); 
    formdata.append("work_file", workFile);
    formdata.append("work_file_id", work_file_id_value);
    formdata.append("work_file_type_id", manage_video_id);
    formdata.append("work_file_name", work_file_name);
    formdata.append("work_file_payment_type", work_file_payment_type);
       
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        xhr: function(){
            var xhr = new window.XMLHttpRequest();
            xhr.upload.addEventListener("progress", function(event){
                if (event.lengthComputable) {
                    $('#progressID_work_file' + videoCounter).show();
                    var percent = (event.loaded / event.total) * 100;
                    $('#progressBar_work_file' + videoCounter).attr('style', 'width:' + Math.round(percent) + '%');
                    
                    if (Math.round(percent) === 100) {
                        $('#progressBar_work_file' + videoCounter).html('<span style=color:black;>Upload Completed</span>');
                        


                        $('#work_file' + videoCounter).removeAttr("disabled");
                        $('#progressID_work_file' + videoCounter).hide();
                        $('#processing_image_work_file' + videoCounter).show();

                    } else {
                        $('#work_file' + videoCounter).attr('disabled', '');
                        $('#progressBar_work_file' + videoCounter).html('<span style=color:black;>' + Math.round(percent) + '% uploading</span>');
                    }
                }
            }, false);
            return xhr;
        },
        success: function (data) 
        {
            $('#processing_image_work_file' + videoCounter).hide();
            $('#progressID_work_file' + videoCounter).show();

            $('#work_file_id' + videoCounter).val(data);   
            
            var allWorkFileIdValue = $('#all_work_file_id').val();
            if(allWorkFileIdValue == ''){
                var allWorkFileId = data;
            }else{
                var allWorkFileId = allWorkFileIdValue + ',' + data;
            }
            $('#all_work_file_id').val(allWorkFileId);
        }
    }); 
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 27-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Delete admin video all information
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : manage_video_id is pass the value of manage_video_id
                         url is pass the value of route where ajax data send
* @Return              :        
* @value               : formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
function deleteAdminVideo(url, manage_video_id){
    var formdata = new FormData(); 
    formdata.append("manage_video_id", manage_video_id);
    swal({
        title: "",
        text: "Are you sure, you want to Delete this video?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
        function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function ()
                    {
                        location.reload();
                    }
                });
            }
        });
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 27-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Delete admin single resolution video location information
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : manage_video_location_id is pass the value of manage_video_location_id
                         url is pass the value of route where ajax data send
* @Return              :        
* @value               : formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
function deleteSingleResolutionVideo(url, manage_video_location_id){
    var formdata = new FormData(); 
    formdata.append("manage_video_location_id", manage_video_location_id);
    swal({
        title: "",
        text: "Are you sure, you want to Delete this resolution video file?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
        function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function ()
                    {
                        location.reload();
                    }
                });
            }
        });
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 29-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Delete admin workfile information
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : work_file_type_id is pass the value of work_file_type_id
                         url is pass the value of route where ajax data send
* @Return              :        
* @value               : formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
function deleteVideoWorkfile(url, work_file_type_id){
    var formdata = new FormData(); 
    formdata.append("work_file_type_id", work_file_type_id);
    swal({
        title: "",
        text: "Are you sure, you want to Delete this work file?",
        showCancelButton: true,
        confirmButtonColor: '#73AE28',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
        function (isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function ()
                    {
                        location.reload();
                    }
                });
            }
        });
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 29-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : download admin workfile
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : workFileID is pass the value of workFileID
                         url is pass the value of route where ajax data send
* @Return              : null   
* @value               : null
* @Status              : Available
* @version             : v2.1       
* */
function downloadWorkFile(url, workFileID) {
    window.location.href = url + workFileID;
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 29-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Check input filed error against [if status: active]
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : id is pass the field id
                         videoCounter is pass the value of videoCounter
* @Return              : null   
* @value               : manage_video_title is used to keep manage_video_title value
                         work_file_name is used to keep work_file_name value
                         manage_video_status is used to keep manage_video_status value
* @Status              : Available
* @version             : v2.1       
* */
function checkError(id, videoCounter){
    var manage_video_title = $('#manage_video_title'+ videoCounter).val();
    var work_file_name = $('#work_file_name'+ videoCounter).val(); 
    var manage_video_status = $("input[name='manage_video_status["+ videoCounter +"]']:checked").val();
    if(id == 'manage_video_title'+videoCounter){
        if(manage_video_status == '1'){
            if(manage_video_title == ''){
                $('#manage_video_title_error'+ videoCounter).show();
                $('#manage_video_status_error'+ videoCounter).show();
                
                $('#manage_video_title_error'+ videoCounter).html('Video Title Required');
                $('#manage_video_status_error'+ videoCounter).html('If you want active this video, you must type video title');
            }else{
                $('#manage_video_title_error'+ videoCounter).hide();
                $('#manage_video_status_error'+ videoCounter).hide();
            }
        }
    }
    if(id == 'work_file_name'+videoCounter){
        if(manage_video_status == '1'){
            if(work_file_name != ''){
                if(manage_video_title == ''){
                    $('#manage_video_title_error'+ videoCounter).show();
                    $('#manage_video_title_error'+ videoCounter).html('Video Title Required');
                }else{
                    $('#manage_video_title_error'+ videoCounter).hide();
                }
            }
        }
    }
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 29-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Check manage_video_title if status: active
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : manage_video_status is pass the manage_video_status value
                         videoCounter is pass the value of videoCounter
* @Return              : null   
* @value               : manage_video_title is used to keep manage_video_title value
* @Status              : Available
* @version             : v2.1       
* */
function checkManageVideoName(manage_video_status , videoCounter){
    var manage_video_title = $('#manage_video_title'+ videoCounter).val();
    if(manage_video_status == '1'){
        if(manage_video_title == ''){
            $('#manage_video_status_error'+ videoCounter).show();
            $('#manage_video_title_error'+ videoCounter).show();
            
            $('#manage_video_title_error'+ videoCounter).html('Video Title Required');
            $('#manage_video_status_error'+ videoCounter).html('If you want active this video, you must type video title');
        }
    }else if(manage_video_status == '2'){
        $('#work_file_name_error'+ videoCounter).hide();
        $('#manage_video_title_error'+ videoCounter).hide();
        $('#manage_video_status_error'+ videoCounter).hide();
    }    
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 30-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Search manage admin video
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : search_value is pass the search_value value
                         url is pass the value of url
* @Return              : null   
* @value               : searchInput is used to keep searchInput value
*                        manage_admin_video_status is used to keep manage_admin_video_status value
*                        manage_video_status is used to keep manage_video_status value
*                        formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
function searchManageAdminVideo(search_value, url){
    var searchInput = (search_value.replace(/  +/g, ' ')).trim();
    var manage_admin_video_status = $('#manage_admin_video_status').val();
    var manage_video_status = (manage_admin_video_status === '') ? 0 : manage_admin_video_status;
    
    var formdata = new FormData(); 
    formdata.append("search_value", searchInput);
    formdata.append("manage_admin_video_status", manage_video_status);
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#view_manage_admin_video').html(data);
        }
    });
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 30-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Search manage admin video by status
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : manage_admin_video_status is pass the manage_admin_video_status value
                         url is pass the value of url
* @Return              : null   
* @value               : searchInput is used to keep searchInput value
*                        manage_admin_video_status is used to keep manage_admin_video_status value
*                        manage_video_status is used to keep manage_video_status value
*                        formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
function searchByManageAdminVideoStatus(manage_admin_video_status, url){
    var manage_video_status = (manage_admin_video_status === '') ? 0 : manage_admin_video_status;
    var search_value = $('#manage_admin_video_search').val();
    var searchInput = (search_value.replace(/  +/g, ' ')).trim();
    
    var formdata = new FormData(); 
    formdata.append("manage_admin_video_status", manage_video_status);
    formdata.append("search_value", searchInput);
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#view_manage_admin_video').html(data);
        }
    });
}

/**
* @Author              : Md. Delwar Hossain    
* @CreatedDate         : 30-07-17   
* @ModifiedDate        : Null
* @ModifiedBy          : Null
* @Route               : Null
* @Description         : Pagination for manage video, Search, by status search
* @view                : Null
* @redirect            : Null
* @deprecated          : No
* @exception           : 
* @inheritDoc          : 
* @Parameter           : null
* @Return              : null   
* @value               : page_number is used to keep page_number value
*                        search_value is used to keep search_value value
*                        manage_admin_video_status is used to keep manage_admin_video_status value
*                        manage_video_status is used to keep manage_video_status value
*                        formdata is used to send input->post value by ajax
* @Status              : Available
* @version             : v2.1       
* */
$(document).on('click', "a[id^=manage_admin_video_pagination]", function () {
    var page_number = this.id.replace('manage_admin_video_pagination', '');
    var baseUrl = $('#baseUrl').val();
    
    var search_value = $('#manage_admin_video_search').val();
    var manage_admin_video_status = $('#manage_admin_video_status').val();
    var manage_video_status = (manage_admin_video_status === '') ? 0 : manage_admin_video_status;
    
    if(search_value != '' || (search_value == '' && manage_video_status != '0')){
        var searchInput = (search_value.replace(/  +/g, ' ')).trim();
        var url = baseUrl + 'search-admin-video';
        var formdata = new FormData(); 
        formdata.append("search_value", searchInput);
        formdata.append("manage_admin_video_status", manage_video_status);
        formdata.append('page_number', page_number);
    }
    else{
        var url = baseUrl + 'pagination-admin-video';
        var formdata = new FormData(); 
        formdata.append('page_number', page_number);
    }
    
    $.ajax({
        url: url,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#view_manage_admin_video').html(data);
        }
    });    
});
