/*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : add language form upon clicking the add btn
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function add_language_form(){
    $('#add_language').show();
    $('#edit_language').hide();
}
/*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/add-language
 * @Description         : add language using javascript without reloading the page
 * @view                : language/language_ajax_page/view_manage_language_ajax
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function add_language() {
    var addLanguage = $("#add_language_name").val();
    var baseUrl = $("#baseUrl").val();
    $.post(baseUrl + 'language/add-language',
            {
                add_language_name: addLanguage
            },
            function (data) {
                //var languageDetails = JSON.parse(data);
                //console.log(data);
                if(data === 'empty'){
                    $("#add_language_name").val();
                    $("#add_language_name_error").html('Enter Language ');
                }else{
                    if(data === 'length_error'){
                        $("#add_language_name").val();
                        $("#add_language_name_error").html('Enter Language between 3 to 20 characters');
                        $("#add_language_name").val('');
                    }else{
                        if(data === 'no_table'){
                            $("#add_language_name").val();
                            $("#add_language_name_error").html('Table may not exits');
                        }else{
                            if(data === 'no'){
                                $("#add_language_name").val();
                                $("#add_language_name_error").html('Language Already Exit');
                                $("#add_language_name").val('');
                            }else{
                                $('#view_language').html(data);
                                $("#add_language_name").val('');
                                $("#add_language_name_error").html('');
                                }
                            }
                        }
                }
            }
    );

}

/*   
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/edit-language
 * @Description         : edit language using javascript without reloading the page
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function edit_language(id) {
    $("#edit_language").slideDown('slow');
    $('#add_language').hide();
    var base_url = $("#baseUrl").val();
    $.post(base_url + 'language/edit-language',
            {
                language_ID: id
            },
            function (data) {
                var languageDetails = JSON.parse(data);
                console.log(languageDetails);
                var languageName = languageDetails.language_name;
                $("#language_ID").val(languageDetails.language_id);
                $("#language_name").val(languageName);


            });
}

/*
 
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/delete-language
 * @Description         : delete language using javascript without reloading the page
 * @view                : language/language_ajax_page/view_manage_language_ajax
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1          
 */
function deleteLanguage(id) {
    var baseUrl = $("#baseUrl").val();
    var page_number = $('#page_number').val();
    swal({
            title: "",
            text: "Are you sure you want to delete this Language?",
            showCancelButton: true,
            confirmButtonColor: '#8CC73F',
            confirmButtonText: 'Yes',
            cancelButtonText: "No",
            closeOnConfirm: true,
            closeOnCancel: true
        },function(){
            $.post(baseUrl + 'language/delete-language',
                    {
                        language_id: id,
                        page_number: page_number
                    },
                    function (data) {

                        $('#view_language').html(data);
                    }
            );
        });
}
/* 
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/update-language
 * @Description         : update language using javascript without reloading the page
 * @view                : language/language_ajax_page/view_manage_language_ajax
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1        
 */
function update_language() {
    var baseUrl = $('#baseUrl').val();
    var languageID = $('#language_ID').val();
    var languageName = $('#language_name').val();
    var page_number = $('#page_number').val();
    //console.log(page_number);
    $.post(baseUrl + 'language/update-language',
            {
                language_id: languageID,
                language_name: languageName,
                page_number: page_number
            },
            function (data) {
                    if(data === 'empty'){
                    $("#language_name").val();
                    $("#edit_language_name_error").html('Enter Language ');
                }else{
                    if(data==='length_error'){
                        $("#language_name").val();
                        $("#edit_language_name_error").html('Enter Language between 3 to 20 characters ');
                        $("#language_name").val('');
                    }else{
                        if(data === 'no_table'){
                            $("#add_language_name").val();
                            $("#edit_language_name_error").html('Table may not exits');
                        }else{
                            if(data === 'no'){
                                $("#language_name").val();
                                $("#edit_language_name_error").html('Language Already Exit');
                                //$("#language_name").val('');
                            }else{
                                $('#view_language').html(data);
                                $("#language_name").val('');
                                $("#edit_language_name_error").html('');
                                $("#edit_language").hide();
                               }
                           }
                       }
                }
            }
    );
}
/* 
 * @Author              : Kazol 
 * @CreatedDate         : 11-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/manage-language-ajax
 * @Description         : loading an ajax view when load the page for the first time
 * @view                : language/language_ajax_page/view_manage_language_ajax
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1        
 */
function manage_language_by_ajax() {
    var baseUrl = $('#baseUrl').val();
    $.post(baseUrl + 'language/manage-language-ajax',
            function (data) {
                $('#view_language').html(data);
            }

    );
}

/*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : Hide add language form upon clicking the cancel btn
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1        
 *      
 */
function cancel_add_language() {
    $('#add_language').hide();
}

/*
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : Hide edit language form upon clicking the cancel btn
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
function cancel_edit_language() {
    $('#edit_language').hide();
}


$(document).ready(function () {
    
   /*
     * @Author              : Kazol 
     * @CreatedDate         : 10-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : language/view-all-language
     * @Description         : calling function by taking input value from the search text box 
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1  
     */
    $(document).on('keyup', "#SearchLanguage", function () {
        viewLanguage();
    });
    /* 
     * @Author              : Kazol 
     * @CreatedDate         : 11-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : language-page
     * @Description         : this function is used for language pagination
     * @view                : language/language_ajax_page/view_language_ajax_page
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    $(document).on('click', "a[id^=language_pagination]", function () {
        var page_number = this.id.replace('language_pagination', '');
        var url = $('#baseUrl').val() + 'language-page';
        $.post(url,
                {
                    page_number: page_number
                },
                function (data) {
                    $('#view_language').html(data);
                    $('#language_pagination').val();
                });
    });
    
    /* 
     * @Author              : Kazol 
     * @CreatedDate         : 12-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : search-language-page
     * @Description         : this function is used for search language pagination
     * @view                : language/ajax_view/language_search_ajax
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    $(document).on('click', "a[id^=search_language_pagination]", function () {
        var page_number = this.id.replace('search_language_pagination', '');
        var url = $('#baseUrl').val() + 'search-language-page';
        $.post(url,
                {
                    page_number: page_number
                },
                function (data) {
                    $('#view_language').html(data);
                    $('#language_pagination').val();
                });
    });


});
/* 
 * @Author              : Kazol 
 * @CreatedDate         : 10-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : language/view-all-language
 * @Description         : this function is used for ajax search
 * @view                : language/language_ajax_page/view_language_search_page
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1        
 */
function viewLanguage() {
    var languageName = $("#SearchLanguage").val().trim();
    var baseUrl = $("#baseUrl").val();
    $.post(baseUrl + 'language/view-all-language',
            {
                language_name: languageName
            },
            function (data) {
                //var outPut = JSON.parse(data);              
                $("#view_language").html(data);
            });
    $("html, body").animate({scrollTop: 0}, "slow");
}



