/**
 * Js of education institute of admin 
 *
 * @author Md Mashqur Ul Alam
 */



$(document).ready(function(){   
    /*
     * @Used IN             : @view- 'education_institute_view.php'
     * @Description         : Updates education institute status to approved
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 10-01-2017 
     * @Status              : Available        
     */
    
    $(document).on('click', 'a[id^=approveEduIns]', function(){
        var eduInsId = this.id.replace('approveEduIns', '');
        var iconId = this.id;
        var url = $("#baseUrl").val()+'admin/approve-edu-ins';
        $.post(url,{edu_ins_id: eduInsId}, function(data){
            var result = JSON.parse(data);
            if(result === '1'){
                $('#'+iconId).hide();
            }
        });
    });

    /*
     * @Description         : populates the forms with country and city on page load
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-12-2016 2:54 PM      
     */
    
    populateCountries("eduInsCountry", "eduInsCity");
    populateCountries("editEduInsCountry", "editEduInsCity");
    populateCountries("searchEduInsCountry", "searchEduInsCity");
    
    /*
     * @Description         : Displays the add edu ins form upon clicking the btn
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-12-2016 2:54 PM      
     */
    
    $("#add_edu_ins_btn").click(function(){
        $("#add_edu_form").slideDown('slow');
        $("#add_edu_ins_btn").hide();
    });
    
    /*
     * @Description         : Hides the add new edu ins form upon clicking cancel
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-12-2016 2:54 PM      
     */
    
    $("#edu_ins_cancel").click(function(){
        $("#add_new_education_form")[0].reset();
        $("#add_edu_form").slideUp('slow');
        $("#add_edu_ins_btn").show();
    });
    
    /*
     * @Description         : displays edit edu ins form upon clicking edit btn
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-12-2016 2:54 PM      
     */
    
    $("#edit_edu_ins_cancel").click(function(){
        $("#edit_edu_form").slideUp('slow', function(){
            location.reload();
        }); 
    });
    
    /*
     * @Description         : Display Modal Upon clicking Delete education institute
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-12-2016 2:54 PM      
     */
    
    $(document).on('click','a[id^="deleteEduIns"]', function(){
        var eduInsId = this.id.replace('deleteEduIns', '');
        $("#deleteEduInsModal"+eduInsId).modal('show');
    }).on('click', 'button[id^="modalNoButton"]', function(){
        var eduInsId = this.id.replace('modalNoButton', '');
        $("#deleteEduInsModal"+eduInsId).modal('hide');
    }).on('click', 'button[id^="modalYesButton"]', function(){
        var id = this.id.replace('modalYesButton','');
        deleteEduIns(id);
    });
    
    /*
     * @Description         : search events for education institute search
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-12-2016 2:54 PM      
     */
    $(document).on('change', "#SearchEduInsPubStatus", function(){
        viewEduInsName();
    }).on('change', "#SearchEduInstype", function(){
        viewEduInsName();
    }).on('keyup', "#SearchEduInsName", function(){
        viewEduInsName();
    }).on('change', "#searchEduInsCountry", function(){
        viewEduInsName();
    }).on('change', "#searchEduInsCity", function(){
        viewEduInsName();
    });
    
    /*
     * @Description         : events on clicking pagination link
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 22-12-2016 2:54 PM      
     */
    $(document).on('click','a[id^="eduInsPagination"]', function(){
        var currentPage = this.id.replace('eduInsPagination', '');
        viewEduInsName(currentPage);        
    });
    
});


/**
     * @Function            : editEduIns 
     * @Used IN             : @view- 'education_institute_view.php'
     * @Description         : Displays the edit edu ins form anb populates
     *                        the form with data
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 17-12-2016 03:00 PM  
     * @Parameter           : base_url, id[id of the education institute}
     * @View                : Null
     * @Redirect            : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */ 
function editEduIns(id){
    $("#edit_edu_form").slideDown('slow');
    var base_url = $("#baseUrl").val();
    $.post(base_url+'admin/get-education-institute',
            {
                education_institute_id: id
            },
            function(data){
                var eduInsDetail = JSON.parse(data);
                console.log(eduInsDetail);
                var eduInsType = eduInsDetail.education_institute_type;
                $("#eduInsId").val(eduInsDetail.education_institute_id);
                $("input[name=education_institute_type][value=" + eduInsType + "]").attr('checked','true');
                $("#editEduInsCountry").val(eduInsDetail.education_institute_country);
                //alert(eduInsDetail.education_institute_city);
                populateStates("editEduInsCountry", "editEduInsCity");
                $("#editEduInsCity").val(eduInsDetail.education_institute_city);                
                $("#editEduInsName").val(eduInsDetail.education_institute_name);
                $("input[name=education_institute_status][value=" + eduInsDetail.education_institute_status + "]").attr('checked','true');
                
            });            
            $('.EditBtn').attr('style', 'pointer-events: none');
    
}


/*
     * @Function            : deleteEduIns 
     * @Used IN             : @view- 'education_institute_view.php'
     * @Description         : Deletes a education institute
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 18-12-2016 03:47 PM  
     * @Parameter           : id[id of the education institute}
     * @View                : Null
     * @Redirect            : Null
     * @Return              : NULL    
     * @Status              : Available        
     */ 
function deleteEduIns(id){
    var baseUrl = $("#baseUrl").val();
    $.post(baseUrl+'admin/delete-education-institute',
            {
                eduIns_id: id
            },
            function(){
                $("#eduIns_row"+id).fadeOut();
            }
          );
}

/*
     * @Function            : viewEduInsName 
     * @Used IN             : @view- 'education_institute_view.php'
     * @Description         : Updates Education Institute Name List Based on Search
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 20-12-2016 05:23 PM  
     * @Parameter           : currentPage [pagination page number]   
     * @Status              : Available        
     */
function viewEduInsName(currentPage){
    var pubStatus = $("#SearchEduInsPubStatus").val().trim();
    var insType = $("#SearchEduInstype").val().trim();
    var insName = $("#SearchEduInsName").val().trim();
    var country = $("#searchEduInsCountry").val().trim();
    var city = $("#searchEduInsCity").val().trim();
    var baseUrl = $("#baseUrl").val();
    $.post(baseUrl+'admin/view-eduIns-name',
          {
              pubStatus: pubStatus,
              insType: insType,
              insName: insName,
              country: country,
              city: city,
              currentPage: currentPage
          },
          function(data){
              //var outPut = JSON.parse(data);              
              $("#manageEduInsView").html(data);
              var idCount = $('input[id^="eduInsCountryCode"]').length;
              for(i=0; i<=idCount; i++){
                  var countryName = getCountryName($('#eduInsCountryCode'+i).val());
                  $('#eduInsCountryCode'+i).parent().append().text(countryName);
              }
          });
          $("html, body").animate({scrollTop: 0}, "slow");
}