
/*
 * @Description         : View Course work file
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 08-11-2016 09:32 AM
 * @Status              : Available        
 */
$(document).ready(function () {
    var divID;
    var baseUrl = $('#baseUrl').val();


    /*
     * @Description         : search course work file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-11-2016 04:51 PM
     * @Status              : Available        
     */
    $('#search_input').keyup(function () {
        var searchInput = $('#search_input').val().replace(/  +/g, ' ');

        $.post(
                baseUrl + 'admin/course/search-work-file',
                {search_input: searchInput},
                function (data) {
                    $('#view_work_file_courses').html(data);
                });
    });


    /*
     * @Description         : delete work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 09:36 AM
     * @Status              : Available        
     */
    $(document).on('click', 'a[id^="deleteWorkFile"]', function () {
        var courseUrl = this.id.replace('deleteWorkFile', '');
        $('#viewDeleteWorkFileModal' + courseUrl).modal('show');
    }).on('click', 'button[id^="modalNoButton"]', function () {
        var courseUrl = this.id.replace('modalNoButton', '');
        $('#viewDeleteWorkFileModal' + courseUrl).modal('hide');
    }).on('click', 'button[id^="modalYesButton"]', function () {
        var courseUrl = this.id.replace('modalYesButton', '');

        $.post(
                baseUrl + 'admin/course/delete-all-work-file',
                {course_url: courseUrl},
                function (data) {
                    if (data !== 'error') {
                        location.reload();
                    }
                }
        );
    });



    /*
     * @Description         : Move Course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 09:36 AM
     * @Status              : Available        
     */
    $(document).on('click', 'a[id^="btnMove"]', function () {
        $('#viewFileOrder').fadeIn('slow');
        var output = '<option value="">Select Order</option>';
        var ID = divID = this.id.replace('btnMove', '');
        var totalDiv = Number($('#viewWOrkFile').children('div[id=singleWorkFile]').length);
        var incValue = Number($('#incValue' + ID).val());
        $('#random_number').val(ID);

        if (incValue === 1) {
            output += '<option value="2">After</option><option value="3">Bottom</option>';
        } else if (incValue === totalDiv) {
            output += '<option value="1">Top</option><option value="2">After</option>';
        } else {
            output += '<option value="1">Top</option><option value="2">After</option><option value="3">Bottom</option>';
        }
        $('#order').html(output);
    });


    /*
     * @Description         : select file order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 11:35 AM 
     * @Status              : Available        
     */
    $(document).on('change', 'select[id="order"]', function () {
        $('#order_error').html('').fadeOut('slow');
        var order = Number($('#' + this.id).val());
        var output = '<option value="">Select File Name</option>';

        if (order === 2) {
            $('#fileNameView').fadeIn('slow');
            var serverUrl = baseUrl + 'admin/course/get-work-file/' + divID;

            $.get(serverUrl, function (data) {
                var workFile = JSON.parse(data);

                for (var i = 0; i < workFile.id.length; i++) {
                    output += '<option value="' + workFile.id[i] + '">' + workFile.file_name[i] + '</option>';
                }

                $('#selected_file').html(output);
            });
        } else {
            $('#fileNameView').fadeOut('slow');
        }
    });

    /*
     * @Description         : select file order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 11:35 AM 
     * @Status              : Available        
     */
    $(document).on('change', 'select[id="selected_file"]', function () {
        if ($('#selected_file').val() !== '') {
            $('#selected_file_error').fadeIn('slow').html('');
        } else {
            $('#selected_file_error').fadeIn('slow').html('Please select file name');
        }
    });
    /*
     * @Description         : calcel work file process
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 12:29 PM
     * @Status              : Available        
     */
    $(document).on('click', 'button[id="CancelBtn"]', function () {
        $('#order').val('');
        $('#selected_file').val('');
        $('#fileNameView').fadeOut('slow');
        $('#viewFileOrder').fadeOut('slow');
    });
    /*
     * @Description         : update work file process
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 12:34 PM
     * @Status              : Available        
     */

    $('form').submit(function (e) {
        var order = Number($('#order').val());
        if (order === 0) {
            $('#order_error').fadeIn('slow').html('Please select order');
            e.preventDefault();
        } else {
            if (order === 2) {
                var selectedFile = $('#selected_file').val();
                if (selectedFile === '') {
                    $('#selected_file_error').fadeIn('slow').html('Please select file name');
                    e.preventDefault();
                }
            }
        }
    });
    /*
     * @Description         : Delete Course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 09:37 AM
     * @Status              : Available        
     */
    $(document).on('click', 'a[id^="btnDelete"]', function () {
        var ID = this.id.replace('btnDelete', '');
        $('#viewDeleteWorkFile' + ID).modal('show');
    }).on('click', 'button[id^="modalNoButton"]', function () {
        var ID = this.id.replace('modalNoButton', '');
        $('#viewDeleteWorkFile' + ID).modal('hide');
    }).on('click', 'button[id^="modalYesButton"]', function () {
        var ID = this.id.replace('modalYesButton', '');
        var serverUrl = baseUrl + 'admin/course/delete-view-work-file';

        $.post(serverUrl, {id: ID}, function () {
            location.reload();
        });
    });
});