
/*
 -----------@@@RIPON@ Add Course From part(14-07-16)----------------------------------
 */
/*
 * @Description         : create url when add course
 * @Developed By        : MD Jaherul ISlam
 * @Start DateTime      : 12-07-2016 09:06 AM  
 * @Status              : available      
 */
$(document).ready(function () {
    var editCourseName = ($('#edit_course_name').val() !== undefined) ? $('#edit_course_name').val() : '';
    if (editCourseName === '') {
        var courseName;
        var courseURL;
        $('#course_name').keyup(function () {
            courseName = $('#course_name').val();

            if (courseURL === undefined || courseURL === '') {
                var newUrl = makeCleanUrl(courseName);
                makeNewURl(newUrl);
            } else {
                $('#course_url').val(courseURL);
                checkURL(courseURL);
            }
        });

        $('#course_url').keyup(function () {
            courseURL = $('#course_url').val();
            $('#course_url').val(courseURL);
            checkURL(courseURL);
        });
    }
});

/*
 * @Function            : makeNewURl 
 * @Description         : make new url and check database if new url are exists
 * @Developed By        : MD Jaherul ISlam
 * @Start DateTime      : 14-07-2016 11:06 AM  
 * @Parameter           : url[STRING]
 * @Return              : NULL  
 * @Status              : available      
 */
var makeNewURl = function (url) {
    var makeNewCourseUrl = $('#makeNewCourseUrl').val();
    var formdata = new FormData();
    formdata.append('course_url', url);

    $.ajax({
        url: makeNewCourseUrl,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            $('#course_url').val(data);
        }
    });
};
/*
 * @Function            : checkURL 
 * @Description         : check course URL in databse if exists
 * @Developed By        : MD Jaherul ISlam
 * @Start DateTime      : 14-07-2016 01:06 PM  
 * @Parameter           : url[STRING]
 * @Return              : NULL  
 * @Status              : available      
 */
var checkURL = function (url) {
    var checkCourseUrl = $('#checkCourseUrl').val();
    var formdata = new FormData();
    formdata.append('course_url', url);

    $.ajax({
        url: checkCourseUrl,
        type: "POST",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        success: function (data)
        {
            if (data === '1') {
                $('#url_exist').val(1);
            }
            if (data === '2') {
                $('#url_exist').val(2);
            }
        }
    });
};

/*
 * @Function            : checkEditCourseUrl 
 * @Description         : check course URL for eit course 
 * @Developed By        : MD Jaherul ISlam
 * @Start DateTime      : 07-08-2016 11:19 AM  
 * @Parameter           : newUrl[STRING], oldUrl[STRING]
 * @Return              : NULL  
 * @Status              : available      
 */
var checkEditCourseUrl = function (newUrl, oldUrl) {
    if (newUrl !== oldUrl) {
        checkURL(newUrl);
    } else {
    }
};

/*
 * @Function            : make_clean_url 
 * @Used IN             : create_course.php
 * @Description         : Make clean URL
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 21-03-2016 08:33 PM  
 * @Parameter           : url[STRING]
 * @Return              : NULL    
 * @Status              : available      
 */
function makeCleanUrl(url) {
    for (var i = 0; url.length > i; i++) {
        if (url.charAt(i) === ' ') {
            url = url.replace(/ +/g, '-');
        }
        if (url.charAt(i) === '.') {
            url = url.replace(/\./g, '');
        }
        if (url.charAt(i) === '-') {
            url = url.replace(/--/g, '-');
        }
    }
    url = url.replace(/[&\/\\#@!^_=,+()$~%.'":*?<>{}]/g, '');
    if (url.charAt(url.length - 1) === '-') {
        url = setCharAt(url, url.length - 1, '');
    }
    url = url.replace(/--/g, '-');
    url = url.replace(' ', '-');
    return url.toLowerCase();
}


/*
 * @Function            : getParentTopic 
 * @Used IN             : @function-'admin/course/add-course-from.php'
 * @Description         : get parent Topic for view child topic
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 21-04-2016 05:47 PM 
 * @Parameter           : topicID[INTEGER], url[STRING],childTopicID[INTEGRE]
 * @Return              : NULL      
 * @Status              : available      
 */
var getParentTopic = function (topicID, url, childTopicID, personID1) {
    var personID = (personID1 === '') ? '' : personID1;
    var output = '<option value="">Select Topic</option>';
    var serverUrl = url + '/' + topicID + '/' + personID;
    $.get(serverUrl, function (data, status) {
        if (status === 'success') {
            var topicInfo = JSON.parse(data);

            for (var i = 0; i < topicInfo.length; i++) {
                output += '<option value="' + topicInfo[i].topic_id + '">' + topicInfo[i].topic_name + '</option>';
            }
            $('#topic_id').html(output);

            if (childTopicID !== '') {
                $('#topic_id').val(childTopicID);
            }
        }
    });
};

/*
 * @Function            : getTotalClassHour 
 * @Description         : get total class hour
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 12-07-2016 10:56 AM  
 * @Parameter           : Null
 * @Return              : NULL     
 * @Status              : available      
 */
function getTotalClassHour() {
    var numberOfClasses1 = $('#number_of_classes').val();
    if (numberOfClasses1) {
        $('#number_of_classes_error').val('');
    }
    var classHourPerDay1 = $('#class_hour_per_day').val();
    if (classHourPerDay1) {
        $('#class_hour_per_day_error').val('');
    }


    if (classHourPerDay1 !== '' && numberOfClasses1 !== '') {
        var time = convertDecemaltoTime(numberOfClasses1, classHourPerDay1);
        $('#total_class_hour').html(time);
        $('#total_class_hour_value').val(time);
    }
}

/*
 * @Function            : viewTotalClassHour 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : view total class hour
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 05:08 PM 
 * @Parameter           : numberOfClasses[STRING], classHourPerDay[STRING]
 * @Return              : NULL      
 * @Status              : available      
 */
var viewTotalClassHour = function (numberOfClasses, classHourPerDay) {
    var time = convertDecemaltoTime(numberOfClasses, classHourPerDay);
    $('#total_class_hour').html(time);
    $('#total_class_hour_value').val(time);
};

/*
 * @Function            : convertDecemaltoTime 
 * @Description         : convert time to decimal
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 12-07-2016 10:55 AM  
 * @Parameter           : numberOfClasses1[STRING], classHourPerDay1[STRING]
 * @Return              : time[datetime]   
 * @Status              : available      
 */
function convertDecemaltoTime(numberOfClasses1, classHourPerDay1) {
    var numberOfClasses = parseInt(numberOfClasses1);
    var classMinutePerDay = parseFloat(classHourPerDay1);
    var classMinuts = numberOfClasses * classMinutePerDay;
    var classMiliSeconds = classMinuts * 60000;
    var timeObject = convertMillisecondsToDigitalClock(classMiliSeconds);
    return timeObject.clock;
}


/*
 * @Function            : convertMillisecondsToDigitalClock 
 * @Description         : convert milisecond to digital clock
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 12-07-2016 10:55 AM  
 * @Parameter           : time[milisecond]
 * @Return              : time[datetime] 
 * @Status              : available      
 */
function convertMillisecondsToDigitalClock(ms) {
    var hours = Math.floor(ms / 3600000); // 1 Hour = 36000 Milliseconds
    var minutes = Math.floor((ms % 3600000) / 60000); // 1 Minutes = 60000 Milliseconds
    var minutes1; // 1 Minutes = 60000 Milliseconds
    if (minutes.toString().length === 1) {
        minutes1 = minutes + '0';
    } else {
        minutes1 = minutes;
    }
    return {
        hours: hours,
        minutes: minutes,
        clock: hours + ":" + minutes1
    };
}


/*
 * @Function            : CoursePrice 
 * @Description         : view course currency
 * @Developed By        : Md Jaherul Islam
 * @Start DateTime      : 12-07-2016 11:10 AM  
 * @Parameter           : courseType[INTEGER]
 * @Return              : Null
 * @Status              : available      
 */
function CoursePrice(courseType) {
    if (courseType === '1') {
        $('#Course_Price').show('slow');
    } else {
        $('#Course_Price').hide('slow');
    }
}

/*
 -----------@@@RIPON@ END Add Course From part(14-07-16)----------------------------------
 */

/*
 -----------@@@RIPON@ Start Edit Course From part(07-08-16)----------------------------------
 */
/*
 * @Function            : getStartDate 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : check start date validation
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 04:35 AM 
 * @Parameter           : courseStartDate[DATE], previousStartDate[DATE]
 * @Return              : NULL      
 * @Status              : available      
 */
var getStartDate = function (courseStartDate, previousStartDate) {
    if (courseStartDate !== previousStartDate) {
        $('#course_start_date').attr('class', 'form-control validate[custom[mindate], custom[courseFinishedDate]]');
    } else {
        $('#course_start_date').attr('class', 'form-control');
    }
};


/*
 * @Function            : getLastDate 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : check End date validation
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 04:41 AM 
 * @Parameter           : courseEndtDate[DATE], previousEndDate[DATE]
 * @Return              : NULL      
 * @Status              : available      
 */
var getLastDate = function (courseEndtDate, previousEndDate) {
    if (courseEndtDate !== previousEndDate) {
        $('#last_date_of_registration').attr('class', 'form-control validate[custom[mindate], custom[compareStartRegDate]]');
    } else {
        $('#last_date_of_registration').attr('class', 'form-control');
    }
};

/*
 * @Function            : getFinishDate 
 * @Used IN             : @function-'view/user/course/edit_course.php' 
 * @Description         : check Finish date validation
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 25-07-2016 04:43 AM 
 * @Parameter           : courseFinishtDate[DATE], previousFinishDate[DATE]
 * @Return              : NULL      
 * @Status              : available      
 */
var getFinishDate = function (courseFinishtDate, previousFinishDate) {
    if (courseFinishtDate !== previousFinishDate) {
        $('#course_finished_date').attr('class', 'form-control validate[custom[courseFinishedDate], custom[compareStartRegDate]]');
    } else {
        $('#course_finished_date').attr('class', 'form-control');
    }
};
/*
 -----------@@@RIPON@ End Edit Course From part(07-08-16)----------------------------------
 */


/*
 -----------@@@RIPON@ Start Course Register Student View part(01-09-16)----------------------------------
 */
var removeStudent = function (url, rollNumber) {
    $.post(url, {roll_number: rollNumber}, function () {
        location.reload();
    });
};


$(document).ready(function () {
    $(document).on('click', 'a[id^="registerCourseStudentPagination"]', function () {
        var courseID = $('#courseID').val();
        var paginationUrl = $('#paginationUrl').val();
        var pageNumber = this.id.replace('registerCourseStudentPagination', '');

        $.ajax({
            type: 'post',
            url: paginationUrl,
            data: {course_id: courseID, page_number: pageNumber},
            beforeSend: function () {
                $('#loading_image').show();
                $('#view_register_student').attr('style', 'opacity:0.2');
            },
            complete: function () {
                $('#loading_image').hide();
                $('#view_register_student').attr('style', 'opacity:1');
            },
            success: function (data) {
                $('#view_register_student').html(data);
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    });
});

/*
 * @Function            : viewRegisteredStudentBYDate 
 * @Description         : View register student by datewise
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 04:40 PM  
 * @Parameter           : StartData,endDate
 * @Return              : NULL    
 * @Status              : Available        
 */
var viewRegisteredStudentBYDate = function (startDate, endDate) {
    var todaysData = getTodaysDate();

    if (startDate <= endDate) {
        if (todaysData >= endDate) {
            viewRegisterCourse(startDate, endDate);
            $('#errorMessage').html('');
        } else {
            $('#errorMessage').html('<span style="color:red;">Your can not select date after today!</span>');
        }
    } else {
        $('#errorMessage').html('<span style="color:red;">Please select date between to range!</span>');
    }
};

/*
 * @Description         : get current date
 * @Developed By        : MD Jaherul Islam
 * @Start DateTime      : 18-09-2016 04:38 PM 
 * @Status              : Available        
 */
var getTodaysDate = function () {
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1; //January is 0!

    var yyyy = today.getFullYear();
    if (dd < 10) {
        dd = '0' + dd;
    }
    if (mm < 10) {
        mm = '0' + mm;
    }
    return yyyy + '-' + mm + '-' + dd;
};
var viewRegisterCourse = function (startDate, endDate) {
    var courseUrl = $('#courseUrl').val();
    var registerStudentUrl = $('#registerStudentUrl').val();

    $.ajax({
        type: 'post',
        url: registerStudentUrl,
        data: {start_date: startDate, end_date: endDate, course_url: courseUrl},
        beforeSend: function () {
            $('#loading_image').show();
            $('#view_register_student').attr('style', 'opacity:0.2');
        },
        complete: function () {
            $('#loading_image').hide();
            $('#view_register_student').attr('style', 'opacity:1');
        },
        success: function (data) {
            $('#view_register_student').html(data);
        }
    });
    $("html, body").animate({scrollTop: 0}, "slow");
};
/*
 -----------@@@RIPON@ End Course Register Student View part(01-09-16)----------------------------------
 */
/*
 -----------@@@RIPON@ Start Manage Course From part(04-08-16)----------------------------------
 */

/*
 * @Function            : changeCoursePermission 
 * @Description         : change Course PErmission
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 04-08-2016 11:10 AM
 * @Parameter           : url, courseID, status
 * @Return              : NULL  
 * @Status              : available      
 */
function changeCoursePermission(url, courseID, status) {
    var output = '';
    var serverUrl = url + '/' + courseID + '/' + status;

    $.get(serverUrl, function (data) {
        var courseInfo = JSON.parse(data);
        if (courseInfo.course_resource_person_edit === '1') {
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#rPersonEditNotPermitted' + courseInfo.course_id + '"><i class="fa fa-times" title="NO"></i></a>';
        }
        if (courseInfo.course_resource_person_edit === '2') {
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#rPersonEditPermitted' + courseInfo.course_id + '"><i class="fa fa-check-circle" title="Yes"></i></a>';
        }
        $('#resourcePeronEdit' + courseID).html(output);
    });
}

/*
 * @Function            : changeCoursePermission 
 * @Description         : change Course Upcoming status
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 04-08-2016 07:07 PM
 * @Parameter           : url, courseID, status
 * @Return              : NULL  
 * @Status              : available      
 */
var changeCourseUpcomming = function (url, courseID, status) {
    var output = '';
    var serverUrl = url + '/' + courseID + '/' + status;

    $.get(serverUrl, function (data) {
        var courseInfo = JSON.parse(data);
        if (courseInfo.upcoming_course === '1') {
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#upcommingNotPermitted' + courseInfo.course_id + '"><i class="fa fa-times" title="NO"></i></a>';
        }
        if (courseInfo.upcoming_course === '2') {
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#upcommingPermitted' + courseInfo.course_id + '"><i class="fa fa-check-circle" title="Yes"></i></a>';
        }
        $('#upcommingViewStatus' + courseID).html(output);
    });
};


/*
 * @Function            : changeCourseStatus 
 * @Description         : change Course Status
 * @Developed By        : Md Jaherul Islam
 * @Start DateTime      : 04-07-2016 11:07 AM
 * @Parameter           : url, courseID, status
 * @Return              : NULL  
 * @Status              : available      
 */
function changeCourseStatus(url, courseID, status) {
    var serverUrl = url + '/' + courseID + '/' + status;

    $.get(serverUrl, function (data) {
        if (status === 'delete') {
            location.reload();
        } else {
            var courseInfo = JSON.parse(data);
            viewCourseAction(courseID, courseInfo);
        }
    });
}

/*
 * @Function            : viewCourseAction 
 * @Description         : View Course ALl Action
 * @Developed By        : Md Jaherul Islam
 * @Start DateTime      : 04-07-2016 12:58 PM
 * @Parameter           : courseID, courseInfo[ARRAY object]
 * @Return              : NULL  
 * @Status              : available      
 */
var viewCourseAction = function (courseID, courseInfo) {
    var output = '';
    switch (courseInfo.course_status) {
        case '1':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseInactive' + courseID + '"><i class="fa fa-user-times" title="Inactive"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseArchive' + courseID + '"><i class="fa fa-archive" title="Archive"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#coursePending' + courseID + '"><i class="fa fa-refresh fa-spin" title="Pending"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDraft' + courseID + '"><i class="fa fa-dropbox" title="Draft"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDelete' + courseID + '"><i class="fa fa-trash-o" title="Delete"></i></a>&nbsp;';
            break;

        case '6':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseActive' + courseID + '"><i class="fa fa-user-plus" title="Acitve"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseArchive' + courseID + '"><i class="fa fa-archive" title="Archive"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#coursePending' + courseID + '"><i class="fa fa-refresh fa-spin" title="Pending"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDraft' + courseID + '"><i class="fa fa-dropbox" title="Draft"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDelete' + courseID + '"><i class="fa fa-trash-o" title="Delete"></i></a>&nbsp;';
            break;

        case '2':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseActive' + courseID + '"><i class="fa fa-user-plus" title="Acitve"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDelete' + courseID + '"><i class="fa fa-trash-o" title="Delete"></i></a>&nbsp;';
            break;

        case '3':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseApproved' + courseID + '"><i class="glyphicon glyphicon-ok" title="Approved"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDraft' + courseID + '"><i class="fa fa-dropbox" title="Draft"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDelete' + courseID + '"><i class="fa fa-trash-o" title="Delete"></i></a>&nbsp;';
            break;

        case '4':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseActive' + courseID + '"><i class="fa fa-user-plus" title="Acitve"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseArchive' + courseID + '"><i class="fa fa-archive" title="Archive"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#coursePending' + courseID + '"><i class="fa fa-refresh fa-spin" title="Pending"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDraft' + courseID + '"><i class="fa fa-dropbox" title="Draft"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDelete' + courseID + '"><i class="fa fa-trash-o" title="Delete"></i></a>&nbsp;';
            break;

        case '5':
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseActive' + courseID + '"><i class="fa fa-user-plus" title="Acitve"></i></a>&nbsp;';
            output += '<a href="javascript:void(0)" data-toggle="modal" data-target="#courseDelete' + courseID + '"><i class="fa fa-trash-o" title="Delete"></i></a>&nbsp;';
            break;
    }
    $('#courseStatus' + courseID).html(output);
};


/*
 * @Function            : getCourseStatus 
 * @Description         : View Course info by status
 * @Developed By        : Md Jaherul Islam
 * @Start DateTime      : 06-08-2016 10:27 AM
 * @Parameter           : courseStatus, Url
 * @Return              : NULL  
 * @Status              : available      
 */
var getCourseStatus = function (courseStatus1, url) {
    var courseStatus = (courseStatus1 === '') ? 0 : courseStatus1;
    var serverUrl = url + '/' + courseStatus;

    $.get(serverUrl, function (data) {
        $('#view_course').html(data);
    });
};

/*
 * @Function            : getCourseStatus 
 * @Description         : Search Course by name
 * @Developed By        : Md Jaherul Islam
 * @Start DateTime      : 06-08-2016 12:05 PM
 * @Parameter           : searchInput, Url
 * @Return              : NULL  
 * @Status              : available      
 */
var getCourseSearchValue = function (searchInput1, url) {
    var searchInput = (searchInput1.replace(/  +/g, ' ')).trim();

    $.post(url, {search_input: searchInput}, function (data) {
        $('#view_course').html(data);
    });
};


/*
 * @Description         : View more Course name if course name exists 15 character 
 * @Developed By        : Md Jaherul Islam  
 * @Start DateTime      : 24-08-2016 05:01 PM
 * @Status              : available      
 */
$(document).on("click", 'span[id^="moreCourseName"]', function () {
    var divID = this.id;
    var courseUrl = divID.replace('moreCourseName', '');
    if ($('#' + divID).text() === '>>>') {
        $('#courseNameView' + courseUrl).text($('#hiddenCourseName' + courseUrl).val());
        $('#' + divID).text('<<<');
    } else {
        $('#courseNameView' + courseUrl).text($('#hiddenCourseName' + courseUrl).val().substr(0, 10) + '...');
        $('#' + divID).text('>>>');
    }
});
/*
 -----------@@@RIPON@ End Manage Course From part(04-08-16)----------------------------------
 */
