function checkXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}



/*
 -----------@@@RIPON@ Start Coupon Part----------------------------------
 */
/*
 * @Function            : getCouponType 
 * @Used IN             : @function-'admin/coupon/add-coupon.php'    
 * @Description         : get coupon type and view different block
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 10:38 AM
 * @Status              : available      
 */
function getCouponType(couponType) {
    if (couponType === '1') {
        documentID('use_coupon_date_view').style.display = 'none';
        documentID('use_coupon_number_view').style.display = 'block';
    } else if (couponType === '2') {
        documentID('use_coupon_date_view').style.display = 'block';
        documentID('use_coupon_number_view').style.display = 'none';
    }
}


/*
 * @Function            : getCouponPriceType 
 * @Used IN             : @function-'admin/coupon/add-coupon.php'    
 * @Description         : get coupon price type and view different block
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 10:53 AM
 * @Status              : available      
 */
function getCouponPriceType(couponPriceType) {
    if (couponPriceType === '2') {
        documentID('coupon_amount_discount_view').style.display = 'none';
        documentID('coupon_amount_view').style.display = 'block';
    } else if (couponPriceType === '1') {
        documentID('coupon_amount_discount_view').style.display = 'block';
        documentID('coupon_amount_view').style.display = 'none';
    }
}


/*
 * @Function            : getCouponName 
 * @Used IN             : @function-'admin/coupon/add-coupon.php'    
 * @Description         : get coupon Name and check existence
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 10:53 AM
 * @Status              : available      
 */
function getCouponName(couponName1, url) {
    var couponNameResponse;
    couponNameResponse = checkXMLHTTP(couponNameResponse);    

    var couponName = couponName1.replace(/  +/g, ' ');
    var formdata = new FormData();
    formdata.append("coupon_name", couponName);

    couponNameResponse.addEventListener("load", function () {

        if (couponNameResponse.responseText === '1') {
            documentID('coupon_name_existence').value = '1';            
        } else if (couponNameResponse.responseText === '2') {
            documentID('coupon_name_existence').value = '';            
        }

    }, false);
    couponNameResponse.open("POST", url);
    couponNameResponse.send(formdata);
}


/*
 * @Function            : getCouponNameEdit 
 * @Used IN             : @function-'admin/coupon/edit-coupon.php'    
 * @Description         : get coupon Name and check existence
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 06:40 PM
 * @Status              : available      
 */
function getCouponNameEdit(couponName1, oldCuponName, url) {
    var couponName = couponName1.replace(/  +/g, ' ');
    if (couponName !== oldCuponName) {
        getCouponName(couponName, url);
    }
}


/*
 * @Function            : getCouponNameEdit 
 * @Used IN             : @function-'admin/coupon/edit-coupon.php'    
 * @Description         : get coupon Name and check existence
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 06:40 PM
 * @Status              : available      
 */
function getCouponCodeEdit(couponCode, oldCouponCode, url) {
    if (couponCode !== oldCouponCode) {
        getCouponCode(couponCode, url);
    }
}


/*
 * @Function            : getCouponCode 
 * @Used IN             : @function-'admin/coupon/add-coupon.php'    
 * @Description         : get coupon Code and check existence
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 10:25 AM
 * @Status              : available      
 */
function getCouponCode(couponCode, url) {
    var couponCodeResponse;
    couponCodeResponse = checkXMLHTTP(couponCodeResponse);    

    var formdata = new FormData();
    formdata.append("coupon_code", couponCode);

    couponCodeResponse.addEventListener("load", function () {

        if (couponCodeResponse.responseText === '1') {
            documentID('coupon_code_existence').value = '1';            
        } else if (couponCodeResponse.responseText === '2') {
            documentID('coupon_code_existence').value = '';            
        }

    }, false);
    couponCodeResponse.open("POST", url);
    couponCodeResponse.send(formdata);
}

/*
 * @Function            : checkStatus 
 * @Used IN             : @function-'admin/coupon/manage-coupon.php'    
 * @Description         : change coupon status and delete
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 01:56 AM
 * @Status              : available      
 */
function checkStatus(url, status, ID) {
    var checkStatusResponse;
    checkStatusResponse = checkXMLHTTP(checkStatusResponse);

    swal({
        title: "",
        text: "Are you sure you want to " + status + " this Video?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("coupon_id", ID);
                    formdata.append("coupon_status", status);

                    checkStatusResponse.addEventListener("load", function () {

                        if (checkStatusResponse.responseText === 'Delete') {
                            location.reload();
                        } else {
                            documentID('coupon_status_view' + ID).innerHTML = checkStatusResponse.responseText;
                        }

                    }, false);
                    checkStatusResponse.open("POST", url);
                    checkStatusResponse.send(formdata);
                }
            });
}


/*
 * @Function            : searchCoupon 
 * @Used IN             : @function-'admin/coupon/manage-coupon.php'    
 * @Description         : search Coupon
 * @Developed By        : Ripon Jaherul
 * @Start DateTime      : 29-02-2016 05:05 PM
 * @Status              : available      
 */
function searchCoupon(searchValue1, url) {
    var searchCouponResponse;
    searchCouponResponse = checkXMLHTTP(searchCouponResponse);
    var searchValue = searchValue1.replace(/  +/g, ' ');

    var formdata = new FormData();
    formdata.append("search_value", searchValue);

    searchCouponResponse.addEventListener("load", function () {

        documentID('coupon_view').innerHTML = searchCouponResponse.responseText;

    }, false);
    searchCouponResponse.open("POST", url);
    searchCouponResponse.send(formdata);

}