function checkXMLHTTP(xmlhttp) {
    xmlhttp = false;
    try {
        return xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            return xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
    if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
        return xmlhttp = new XMLHttpRequest();
    }
}

function documentID(el) {
    return document.getElementById(el);
}



/*
 -----------@@@RIPON@ Start scedule classromm Part----------------------------------
 */
/*
 * @Function            : selectCategoryCourse 
 * @Used IN             : @function-'view/admin/classroom/ajax_page/view_course[@Modal]'
 * @Description         : select course category
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 15-03-2016 01:53 PM
 * @Status              : available      
 */
function selectCategoryCourse(url, categoryID) {
    var selectCategoryCourseResponse;
    selectCategoryCourseResponse = checkXMLHTTP(selectCategoryCourseResponse);

    var formdata = new FormData();
    formdata.append("course_category_id", categoryID);

    selectCategoryCourseResponse.addEventListener("load", function () {

        documentID('category_course').innerHTML = selectCategoryCourseResponse.responseText;

    }, false);
    selectCategoryCourseResponse.open("POST", url);
    selectCategoryCourseResponse.send(formdata);
}

/*
 * @Function            : checkFeatureStatus 
 * @Used IN             : @function-'view/admin/classroom/ajax_page/view_course[@Modal]'
 * @Description         : check course resource person feature status
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 15-03-2016 01:53 PM
 * @Status              : available      
 */
function checkFeatureStatus(coursID, url) {
    var checkFeatureStatusResponse;
    checkFeatureStatusResponse = checkXMLHTTP(checkFeatureStatusResponse);

    var formdata = new FormData();
    formdata.append("course_id", coursID);

    checkFeatureStatusResponse.addEventListener("load", function () {

        if (checkFeatureStatusResponse.responseText === '1') {
            documentID('course_feature_error').innerHTML = '';
            documentID('course_id_validate').value = '';
        } else if (checkFeatureStatusResponse.responseText === '2') {
            documentID('course_id' + coursID).checked = false;
            documentID('course_id_validate').value = '1';
            documentID('course_feature_error').innerHTML = 'No feature is assigned in this course resource person';
        }

    }, false);
    checkFeatureStatusResponse.open("POST", url);
    checkFeatureStatusResponse.send(formdata);
}

/*
 * @Function            : setCourse 
 * @Used IN             : @function-'add_course(MODAL)'  this[@JS]
 * @Description         : set course name in sehedule class
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 15-03-2016 06:08 PM
 * @Status              : available      
 */
function setCourse(url) {
    if (documentID('course_id_validate').value === '') {
        var courseID = document.forms['selectCourseForm'].elements['course_id'].value;
        var courseName = documentID('course_name' + courseID).value;
        documentID('submitted_course_name').innerHTML = '<b>Course Name : </b>' + courseName;
        documentID('hidden_course_id').value = courseID;
        documentID('hidden_course_name').value = courseName;
        documentID('course_id_error').innerHTML = '';
        getCourseFeatureInfo(courseID, url);
        return true;
    } else {
        documentID('course_feature_error').innerHTML = 'No feature is assigned in this course resource person';
        return false;
    }
}


/*
 * @Function            : getCourseFeatureInfo 
 * @Used IN             : @function-'view_course(MODAL)'  this[@JS]
 * @Description         : get feature information using course id
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 15-03-2016 12:18 AM
 * @Status              : available      
 */
function getCourseFeatureInfo(courseID, url) {
    var courseFeatureInfoResponse;
    courseFeatureInfoResponse = checkXMLHTTP(courseFeatureInfoResponse);

    var formdata = new FormData();
    formdata.append("course_id", courseID);

    courseFeatureInfoResponse.addEventListener("load", function () {

        var featureInfo1 = courseFeatureInfoResponse.responseText;
        var featureInfo = featureInfo1.split(",");
        documentID('attendees_number').innerHTML = featureInfo[0];
        documentID('virtual_classroom_type').innerHTML = featureInfo[1];

    }, false);
    courseFeatureInfoResponse.open("POST", url);
    courseFeatureInfoResponse.send(formdata);
}


/*
 * @Function            : checkClassStartDate 
 * @Used IN             : @function-'schedulr_classs.php
 * @Description         : check classroom start date
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 15-03-2016 05:16 PM
 * @Status              : available      
 */
function checkClassStartDate(startDate, url, classroomID) {
    var checkClassStartDateResponse;
    checkClassStartDateResponse = checkXMLHTTP(checkClassStartDateResponse);

    var courseID = documentID('hidden_course_id').value;
    if (courseID !== '') {
        documentID('class_start_date_error').innerHTML = '';
        documentID('class_duration').value = '';

        var formdata = new FormData();
        formdata.append("course_id", courseID);
        formdata.append("class_start_date", startDate);
        formdata.append("classroom_id", classroomID);

        checkClassStartDateResponse.addEventListener("load", function () {

            if (checkClassStartDateResponse.responseText === '1') {
                documentID('class_start_date_error').innerHTML = '';
            } else if (checkClassStartDateResponse.responseText === '2') {
                documentID('class_start_date_error').innerHTML = 'Class Start date must grather than todays date';
            } else if (checkClassStartDateResponse.responseText === '3') {
                documentID('class_start_date_error').innerHTML = 'Maximun class take in this day';
            }

        }, false);
        checkClassStartDateResponse.open("POST", url);
        checkClassStartDateResponse.send(formdata);
    } else {
        documentID('course_id_error').innerHTML = 'Please Select Course';
    }
}


/*
 * @Function            : checkClassStartTime 
 * @Used IN             : @function-'schedulr_classs.php
 * @Description         : check classroom start time
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 15-03-2016 05:40 PM
 * @Status              : available      
 */
function checkClassStartTime(startTime, url) {
    var classStartTimeResponse;
    classStartTimeResponse = checkXMLHTTP(classStartTimeResponse);

    var courseID = documentID('hidden_course_id').value;
    var classStartDate = documentID('class_start_date').value;
    if (classStartDate !== '') {
        documentID('class_start_time_error').innerHTML = '';
        documentID('class_duration').value = '';

        var formdata = new FormData();
        formdata.append("course_id", courseID);
        formdata.append("class_start_date", classStartDate);
        formdata.append("class_start_time", startTime);

        classStartTimeResponse.addEventListener("load", function () {

            if (classStartTimeResponse.responseText === '1') {
                documentID('class_start_time_error').innerHTML = '';
            } else if (classStartTimeResponse.responseText === '2') {
                documentID('class_start_time_error').innerHTML = 'Class Start date must grather todays date';
            }

        }, false);
        classStartTimeResponse.open("POST", url);
        classStartTimeResponse.send(formdata);
    } else {
        documentID('class_start_date_error').innerHTML = 'Please select Class start date';
    }
}

/*
 * @Function            : checkClassDuration 
 * @Used IN             : @function-'schedulr_classs.php
 * @Description         : check classroom Duration
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 15-03-2016 06:31 PM
 * @Status              : available      
 */
function checkClassDuration(duration, url, classroomID) {
    var classDurationResponse;
    classDurationResponse = checkXMLHTTP(classDurationResponse);

    var courseID = documentID('hidden_course_id').value;
    var classStartDate = documentID('class_start_date').value;
    var classStartTime = documentID('class_start_time').value;
    var fileRegx = /^[0-9]+$/;
    if (classStartTime !== '' && classStartDate !== '') {
        if (fileRegx.test(duration)) {
            if (duration <= 180 && duration >= 30) {
                var formdata = new FormData();
                formdata.append("course_id", courseID);
                formdata.append("class_start_date", classStartDate);
                formdata.append("class_start_time", classStartTime);
                formdata.append("class_duration", duration);
                formdata.append("classroom_id", classroomID);

                classDurationResponse.addEventListener("load", function () {

                    if (classDurationResponse.responseText === '1') {
                        var convertTime = ConvertTimeformat(classStartTime);
                        var m = moment(classStartDate + ' ' + convertTime);
                        m.add(duration, 'minute');
                        documentID('view_class_duration').innerHTML = "<b>Class End Time</b> : " + m.format("h:mm:ss a");
                        documentID('class_duration_error').innerHTML = '';
                    } else if (classDurationResponse.responseText === '2') {
                        documentID('view_class_duration').innerHTML = '';
                        documentID('class_duration_error').innerHTML = 'Already running class in this time';
                    }

                }, false);
                classDurationResponse.open("POST", url);
                classDurationResponse.send(formdata);

            } else {
                documentID('view_class_duration').innerHTML = '';
                documentID('class_duration_error').innerHTML = 'Please input valid duaration';
            }
        } else {
            documentID('class_duration').placeholder = 'Please complete upper input';
            documentID('class_duration').value = '';
            documentID('view_class_duration').innerHTML = '';
            documentID('class_duration_error').innerHTML = 'Please input valid duaration';
        }
    } else {
        documentID('class_duration').placeholder = 'Please complete upper input';
        documentID('class_duration').value = '';
        documentID('view_class_duration').innerHTML = '';
        documentID('class_start_time_error').innerHTML = 'Please select course start date time';
    }
}

/*
 * @Function            : ConvertTimeformat 
 * @Used IN             : @function-'checkDuration'  this[@JS]
 * @Description         : convert time 
 * @Developed By        : Copied form - 'front_end/classroom.js'
 * @Start DateTime      : 15-03-2016 07:10 PM
 * @Status              : available      
 */
function ConvertTimeformat(time) {
    var hours = Number(time.match(/^(\d+)/)[1]);
    var minutes = Number(time.match(/:(\d+)/)[1]);
    var AMPM = time.match(/\s(.*)$/)[1];
    if (AMPM === "PM" && hours < 12)
        hours = hours + 12;
    if (AMPM === "AM" && hours === 12)
        hours = hours - 12;
    var sHours = hours.toString();
    var sMinutes = minutes.toString();
    if (hours < 10)
        sHours = "0" + sHours;
    if (minutes < 10)
        sMinutes = "0" + sMinutes;

    return sHours + ":" + sMinutes;
}
/*
 -----------@@@RIPON@ End scedule classromm Part----------------------------------
 */


/*
 -----------@@@RIPON@ Start view scedule classromm Part----------------------------------
 */

/*
 * @Function            : checkClassroomAction 
 * @Used IN             : @function-'myclass.php'
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 14-03-2016 12:07 PM
 * @Status              : available      
 */
function checkClassroomAction(url, status, classroomID) {
    var checkClassroomActionResponse;
    checkClassroomActionResponse = checkXMLHTTP(checkClassroomActionResponse);

    swal({
        title: "",
        text: "Are you sure you want to " + status + " this Class?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("status", status);
                    formdata.append("classroom_id", classroomID);

                    checkClassroomActionResponse.addEventListener("load", function () {

                        if (checkClassroomActionResponse.responseText === 'success') {
                            location.reload();
                        }

                    }, false);
                    checkClassroomActionResponse.open("POST", url);
                    checkClassroomActionResponse.send(formdata);
                }
            });
}


/*
 * @Function            : changeStudentPermission 
 * @Used IN             : @function-'course_registered_student.php'
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 19-03-2016 03:53 PM
 * @Status              : available      
 */
function checkStudentPermission(url, courseID, studentID, classroomID, type, url1) {
    var studentPermissionResponse;
    studentPermissionResponse = checkXMLHTTP(studentPermissionResponse);

    if (type === 'Assign') {
        var formdata = new FormData();
        formdata.append("type", type);
        formdata.append("course_id", courseID);
        formdata.append("student_id", studentID);
        formdata.append("classroom_id", classroomID);

        studentPermissionResponse.addEventListener("load", function () {

            if (studentPermissionResponse.responseText === '2') {
                showError();
            } else if (studentPermissionResponse.responseText === '3') {
                showError1();
            } else if (studentPermissionResponse.responseText === '1') {
                changeStudentPermission(url1, courseID, studentID, classroomID, type);
            }

        }, false);
        studentPermissionResponse.open("POST", url);
        studentPermissionResponse.send(formdata);
    }
}
function showError() {
    swal({
        title: "",
        text: "This student allready assigned in this class time",
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'OK',
        closeOnConfirm: true
    });
}
function showError1() {
    swal({
        title: "",
        text: "Maximun number of student assigned this class",
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'OK',
        closeOnConfirm: true
    });
}


/*
 * @Function            : changeStudentPermission 
 * @Used IN             : @function-'course_registered_student.php'
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 19-03-2016 03:53 PM
 * @Status              : available      
 */
function changeStudentPermission(url, courseID, studentID, classroomID, type) {
    var studentPermissionResponse1;
    studentPermissionResponse1 = checkXMLHTTP(studentPermissionResponse1);

    swal({
        title: "",
        text: "Are you sure you want to " + type + " this Class?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("type", type);
                    formdata.append("course_id", courseID);
                    formdata.append("student_id", studentID);
                    formdata.append("classroom_id", classroomID);

                    studentPermissionResponse1.addEventListener("load", function () {

                        documentID('sActions' + studentID).innerHTML = studentPermissionResponse1.responseText;

                    }, false);
                    studentPermissionResponse1.open("POST", url);
                    studentPermissionResponse1.send(formdata);
                }
            });
}

/*
 * @Function            : changeStudentPermission 
 * @Used IN             : @function-'course_registered_student.php'
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 19-03-2016 03:53 PM
 * @Status              : available      
 */
function changeStudentPermission1(url, courseID, studentID, classroomID, type) {
    var studentPermissionResponse1;
    studentPermissionResponse1 = checkXMLHTTP(studentPermissionResponse1);

    swal({
        title: "",
        text: "Are you sure you want to " + type + " this Class?",
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes',
        cancelButtonText: "No",
        closeOnConfirm: true,
        closeOnCancel: true
    },
            function (isConfirm) {
                if (isConfirm) {
                    var formdata = new FormData();
                    formdata.append("type", type);
                    formdata.append("course_id", courseID);
                    formdata.append("student_id", studentID);
                    formdata.append("classroom_id", classroomID);

                    studentPermissionResponse1.addEventListener("load", function () {

                        location.reload();

                    }, false);
                    studentPermissionResponse1.open("POST", url);
                    studentPermissionResponse1.send(formdata);
                }
            });
}

/*
 -----------@@@RIPON@ End view scedule classromm Part----------------------------------
 */



/*
 -----------@@@RIPON@ Start scedule classromm review and published Part----------------------------------
 */

/*
 * @Function            : updateUrlForm 
 * @Used IN             : @function-'review_publish.php'  this[@JS]
 * @Description         : get update URl form
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 03:09 AM
 * @Status              : available      
 */
function updateUrlForm(url, classRoomID) {
    var updateUrlFormResponse;
    updateUrlFormResponse = checkXMLHTTP(updateUrlFormResponse);

    var formdata = new FormData();
    formdata.append("classroom_id", classRoomID);

    updateUrlFormResponse.addEventListener("load", function () {

        documentID('edit_url_button').style.display = 'none';
        documentID('save_url_button').style.display = 'block';
        documentID('view_url_form').innerHTML = updateUrlFormResponse.responseText;

    }, false);
    updateUrlFormResponse.open("POST", url);
    updateUrlFormResponse.send(formdata);
}


/*
 * @Function            : checkClassRoomURL 
 * @Used IN             : @function-'review_publish.php'(ajax_page[add_classroom_url_form])
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 03:09 AM
 * @Status              : available      
 */
function checkClassRoomURL(inputURl, url, oldurl) {
    var updateUrlFormResponse;
    updateUrlFormResponse = checkXMLHTTP(updateUrlFormResponse);

    var urlRegx = /^[0-9a-z\-]+$/;
    var hypenRegex = /--/g;
    if (inputURl !== '') {
        if (inputURl !== oldurl) {
            if (inputURl.charAt(0) === '-') {
                documentID('classroom_url_error').innerHTML = 'No hypen allow at the first';
                documentID('class_url_validate').value = '2';
            } else if (inputURl.charAt(inputURl.length - 1) === '-') {
                documentID('classroom_url_error').innerHTML = 'No hypen allow at the last';
                documentID('class_url_validate').value = '3';
            } else if (hypenRegex.test(inputURl)) {
                documentID('classroom_url_error').innerHTML = 'Multiple hypen does not allow';
                documentID('class_url_validate').value = '4';
            } else if (urlRegx.test(inputURl)) {
                var formdata = new FormData();
                formdata.append("new_classroom_url", inputURl);

                updateUrlFormResponse.addEventListener("load", function () {

                    if (updateUrlFormResponse.responseText === '1') {
                        documentID('classroom_url_error').innerHTML = 'Url Already Exixts';
                        documentID('class_url_validate').value = '6';
                    } else if (updateUrlFormResponse.responseText === '2') {
                        documentID('classroom_url_error').innerHTML = '';
                        documentID('class_url_validate').value = '';
                    }

                }, false);
                updateUrlFormResponse.open("POST", url);
                updateUrlFormResponse.send(formdata);

            } else {
                documentID('classroom_url_error').innerHTML = 'No Capital Letter or Special Caracter Allow Accept -';
                documentID('class_url_validate').value = '5';
            }
        }
    } else {
        documentID('classroom_url_error').innerHTML = 'Please Type Classsroom URL';
        documentID('class_url_validate').value = '1';
    }
}


/*
 * @Function            : saveUpdateURL 
 * @Used IN             : @function-'review_publish.php'(ajax_page[add_classroom_url_form])
 * @Description         : check classroom URL
 * @Developed By        : Ripon Jaherul  
 * @Start DateTime      : 13-03-2016 09:29 AM
 * @Status              : available      
 */
function saveUpdateURL(url, classroomID, redirectURL) {
    var updateUrlFormResponse;
    updateUrlFormResponse = checkXMLHTTP(updateUrlFormResponse);

    var urlValidate = documentID('class_url_validate').value;
    if (urlValidate === '1') {
        documentID('classroom_url_error').innerHTML = 'Please Type Classsroom URL';
        return false;
    } else if (urlValidate === '2') {
        documentID('classroom_url_error').innerHTML = 'No hypen allow at the first';
        return false;
    } else if (urlValidate === '3') {
        documentID('classroom_url_error').innerHTML = 'No hypen allow at the last';
        return false;
    } else if (urlValidate === '4') {
        documentID('classroom_url_error').innerHTML = 'Multiple hypen does not allow';
        return false;
    } else if (urlValidate === '5') {
        documentID('classroom_url_error').innerHTML = 'No Capital Letter or Special Caracter Allow Accept -';
        return false;
    } else if (urlValidate === '6') {
        documentID('classroom_url_error').innerHTML = 'Url Already Exixts';
        return false;
    } else {
        var newURL = documentID('classroom_url').value;

        var formdata = new FormData();
        formdata.append("new_classroom_url", newURL);
        formdata.append("classroom_id", classroomID);

        updateUrlFormResponse.addEventListener("load", function () {

            window.location.href = redirectURL + '/' + updateUrlFormResponse.responseText;

        }, false);
        updateUrlFormResponse.open("POST", url);
        updateUrlFormResponse.send(formdata);
    }
}

/*
 -----------@@@RIPON@ End scedule classromm review and published Part----------------------------------
 */