$(document).ready(function () {

    var all_course;
    $('#allCourse').click(function () {
        if ($('#allCourse').is(":checked")) {
            all_course = 1;
            $('.course_checkbox').attr('checked', false);
        }
        viewAllVideoCourses();
    });
    /*
     * @Author              : Kazol
     * @CreatedDate         : 30-08-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : view-all-video-course
     * @Description         : This function is used for get video course by select resource person checkbox
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : viewAllVideoCourses
     * @Parameter           : 
     * @Return              : 
     * @value               : resourcePersonID
     * @Status              : active
     * @version             : v2.1        
     */
    var resourcePersonArray = new Array();
    $(document).on("click", 'input[id^="resource_person"]', function () {
        var divID = this.id;
        var resourcePersonID = divID.replace('resource_person', '');
        console.log(resourcePersonID);
        if ($('#' + divID).is(":checked")) {
            resourcePersonArray.push(resourcePersonID);
        } else {
            if ($.inArray(resourcePersonID, resourcePersonArray) > -1) {
                resourcePersonArray.splice($.inArray(resourcePersonID, resourcePersonArray), 1);
            }
        }
        all_course = '';
        //pageNumber = 1;
        viewAllVideoCourses();
        $('#allCourse').attr('checked', false);
    });
    
    var childTopicArray = new Array();
    $(document).on("click", 'input[id^="VideoCourseChildTopic"]', function () {
        var divID = this.id;
        var topicID = divID.replace('VideoCourseChildTopic', '');
        if ($('#' + divID).is(":checked")) {
            childTopicArray.push(topicID);
        } else {
            if ($.inArray(topicID, childTopicArray) > -1) {
                childTopicArray.splice($.inArray(topicID, childTopicArray), 1);
            }
        }
        all_course = '';
        //pageNumber = 1;
        viewAllVideoCourses();
        $('#allCourse').attr('checked', false);
    });
    
    var otherParentTopic;
    $(document).on('click', 'input[id="other_parent_topic"]', function () {
        if ($('#' + this.id).is(":checked")) {
            otherParentTopic = 1;
        } else {
            otherParentTopic = '';
        }
        all_course = '';
        //pageNumber = 1;
        viewAllVideoCourses();
        $('#allCourse').attr('checked', false);
    });
    
    var skillLevelArray = new Array();
    $('input[id^="skillLevel"]').click(function () {
        var divID = this.id;
        var skillLevel = divID.replace('skillLevel', '');
        if ($('#' + divID).is(':checked')) {
            skillLevelArray.push(skillLevel);
        } else {
            if ($.inArray(skillLevel, skillLevelArray) > -1) {
                skillLevelArray.splice(($.inArray(skillLevel, skillLevelArray)), 1);
            }
        }
        all_course = '';
        //pageNumber = 1;
        viewAllVideoCourses();
        $('#allCourse').attr('checked', false);
    });
    
    var courseType;
    $('#courseType').click(function () {
        if ($('#courseType').is(':checked')) {
            courseType = 1;
        } else {
            courseType = '';
        }
        all_course = '';
        //pageNumber = 1;
        viewAllVideoCourses();
        $('#allCourse').attr('checked', false);
    });
    /*
     * @Author              : Kazol
     * @CreatedDate         : 31-08-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : view-all-video-course
     * @Description         : This function is used for get the video course when we click in the new/popular checkbox
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : allCourse,other_parent_topic,course_type,page_number, url
     * @Status              : active
     * @version             : v2.1        
     */
    var videoCoursePriority;
    $('input[id^="otherPriorityLevel"]').click(function () {
        var divID = this.id;

        if ($('#' + divID).is(':checked')) {
            //courseRating = '';
            var coursePriorityID = divID.replace('otherPriorityLevel', '');
            if (coursePriorityID === '1') {
                videoCoursePriority = 1;
                $('#otherPriorityLevel2').attr('checked', false);
            }
            if (coursePriorityID === '2') {
                videoCoursePriority = 2;
                $('#otherPriorityLevel1').attr('checked', false);
            }
            //$('#rated_course').attr('checked', false);
        } else {
            videoCoursePriority = '';
        }
        all_course = '';
        //pageNumber = 1;
        viewAllVideoCourses();
        $('#allCourse').attr('checked', false);
    });
    /*
     * @Author              : Kazol
     * @CreatedDate         : 30-08-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for pagination video course when all video coursed are clicked in the 
                              checkbox
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : viewAllVideoCourses
     * @Parameter           : 
     * @Return              : 
     * @value               : pageNumber
     * @Status              : active
     * @version             : v2.1        
     */
    var pageNumber;
    $(document).on("click", 'a[id^="all_video_course_checkbox_pagination"]', function () {
        var divID = this.id;
        pageNumber = divID.replace('all_video_course_checkbox_pagination', '');

        viewAllVideoCourses();
    });
    /*
     * @Author              : delwar Sumon
     * @CreatedDate         : unkhown
     * @ModifiedDate        : 30-08-2017
     * @ModifiedBy          : Kazol
     * @Route               : view-all-video-course
     * @Description         : This function is used for get the video course when we click in the checkbox in the left side menu
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : allCourse,other_parent_topic,course_type,page_number, url
     * @Status              : active
     * @version             : v2.1        
     */
    function viewAllVideoCourses () {
//        var searchInput = $('#search-input').val();
//        var search_value = searchInput.replace(/  +/g, ' ').trim();
        
        var allCourse = (all_course === undefined) ? 1 : all_course;
        var other_parent_topic = (otherParentTopic === undefined) ? '' : otherParentTopic;
        var course_type = (courseType === undefined) ? '' : courseType;
        var video_course_priority = (videoCoursePriority === undefined) ? '' : videoCoursePriority;
        var page_number = (pageNumber === undefined) ? 1 : pageNumber;
        var url = $('#viewCoursesUrl').val();
        
        var viewCourseData = {
            //search_value: search_value,
            all_course: allCourse,
            child_topic_id: childTopicArray,
            other_parent_topic: other_parent_topic,
            skill_level_id: skillLevelArray,
            course_type: course_type,
            resource_person: resourcePersonArray,
            video_course_priority_level: video_course_priority,
            page_number: page_number
        };
        $.ajax({
            url: url,
            type: "POST",
            data: JSON.stringify(viewCourseData),
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $('#loading_image').show();
                $('#view_without_paginzation').attr('style', 'opacity:0.2');
            },
            complete: function () {
                $('#loading_image').hide();
                $('#view_without_paginzation').attr('style', 'opacity:1');
            },
            success: function (data, status) {
                if (status === 'success') {
                    $('#video_course_view').html(data);
                }
            }
        });
        $("html, body").animate({scrollTop: 0}, "slow");
    };

      
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 28-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : search-all-video-course, pagination-all-video-course
 * @Description         : This function is used for search video course along with search video course pagination
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              :     
 * @value               : search_video_course, page_number
 * @Status              : active
 * @version             : v2.1         
 */
    
    $(document).on('click',"a[id^=all_video_course_pagination]",function(){
         //var video_course_id = $('#all_video_course_pagination').val();
         var search_video_course = $('#search-input').val();
         var page_number = this.id.replace('all_video_course_pagination', '');
         var baseUrl = $('#baseUrl').val();
         console.log(page_number);
         
        if(search_video_course != ''){
            var url = baseUrl+'search-all-video-course';
            
            var formdata = new FormData(); 
            
            formdata.append("search_input", search_video_course);
            formdata.append("page_number", page_number);
        }else{
            var url = baseUrl+'pagination-all-video-course';
            var formdata = new FormData(); 
            //formdata.append("video_course_id", video_course_id);
            formdata.append("page_number", page_number);
        }
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data)
            {
                $('#video_course_view').html(data);
            }
        });
    });
    
    
    
});
/*
 * @Author              : Delwar Sumon
 * @CreatedDate         : Unknown
 * @ModifiedDate        : 10-09-2017 
 * @ModifiedBy          : Kazol 
 * @Route               : more-video-course-child-topic
 * @Description         : This function is used for getting more child topic video course
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : parentTopicID
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    function moreChildTopic (parentTopicID) {
        var totalChildTopic = $('#childTopic'+parentTopicID).children().length;
        var base_url = $('#baseUrl').val();
        var url = base_url + 'more-video-course-child-topic';
        
        var formdata = new FormData(); 
        formdata.append("parent_topic_id", parentTopicID);
        formdata.append("total_child_topic", totalChildTopic);
        
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data) {
                $('#viewMoreChildTopic'+parentTopicID).html(data);
            }
        });
    };
    /*
     * @Author              : 09-09-2017
     * @CreatedDate         : Kazol
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : more-video-course-resource-person
     * @Description         : This function is used for get the more resource person
     * @view                : all_video_course/ajax_view/more_resource_person
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    function moreResourcePerson () {
        var countResourcePerson = $('#count_resource_person').children().length;
        var totalResourcePerson = countResourcePerson;
        var base_url = $('#baseUrl').val();
        var url = base_url + 'more-video-course-resource-person';
        
        var formdata = new FormData(); 
        formdata.append("count_resource_person", totalResourcePerson);
        
        $.ajax({
            url: url,
            type: "POST",
            data: formdata,
            contentType: false,
            cache: false,
            processData: false,
            success: function (data) {
                $('#more_resource_person').html(data);
            }
        });
    };
    
    function searchALLVideoCourse (searchInput, url) {
        var search_value = searchInput.replace(/  +/g, ' ').trim();
        var searchData = {
            search_value: search_value
        };
        
        $.ajax({
            type: 'post',
            url: url,
            data: JSON.stringify(searchData),
            contentType: false,
            traditional: true,
            beforeSend: function () {
                $('#loading_image').show();
                $('#view_without_paginzation').attr('style', 'opacity:0.2');
            },
            complete: function () {
                $('#loading_image').hide();
                $('#view_without_paginzation').attr('style', 'opacity:1');
            },
            success: function (data, status) {
                if (status === 'success') {
                    //$('#video_course_view').html(data);
                }
            }
        });
    };
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 28-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : search-all-video-course
 * @Description         : This function is used for search video course 
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : search_value, url
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    function search_all_video_course(search_value, url){
        var search_input = (search_value.replace(/  +/g, ' ')).trim();
        $.post(url,{
            search_input : search_input
            
        },function(data){
            $('#video_course_view').html(data);
        });
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 12-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : download-manage-admin-video-workfile
     * @Description         : This function is used for download work files of a single video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : url, workFileID
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    function downloadWorkFile(url, workFileID) {
        window.location.href = url + workFileID;
    }