<?php

function format_interval(DateInterval $interval) {
    $result = "";
    if ($interval->y) {
        $result .= $interval->format("%y years ");
    }
    if ($interval->m) {
        $result .= $interval->format("%m months ");
    }
    if ($interval->d) {
        $result .= $interval->format("%d days ");
    }
    if ($interval->h) {
        $result .= $interval->format("%h hours ");
    }
    if ($interval->i) {
        $result .= $interval->format("%i minutes ");
    }
    if ($interval->s) {
        $result .= $interval->format("%s seconds ");
    }

    return $result;
}
?>

<?php if ($show_data) { ?>
    <div class="col-xs-7  col-sm-9 text-left" >
        <address>
            <div></div>
            <span class="row col-sm-12" >   
                <span class="col-sm-4" style="padding:0">Course Name</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0"><?php echo $classroom_info->course_name; ?></span>
            </span>

            <span class="row col-sm-12">   
                <span class="col-sm-4" style="padding:0">Classroom Title</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0"><?php echo $classroom_info->classroom_title; ?></span>
            </span>


            <?php
            $offset = $this->session->userdata('time_offset');
            $required_time = (strtotime("$classroom_info->class_start_time") + $offset);

            $now = date('Y-M-d H:i:s', strtotime(gmdate('Y-M-d H:i:s')) - $offset);
            $now = new DateTime($now, new DateTimeZone($person_info->person_time_zone));

            $class_start_time = date('Y-M-d H:i:s', (strtotime($classroom_info->class_start_time)));
            $class_start_time = new DateTime($class_start_time, new DateTimeZone($person_info->person_time_zone));
            $interval = $class_start_time->diff($now);

            $class_start_time = date('Y-M-d H:i:s', (strtotime($classroom_info->class_start_time) + $offset));
            $now = date('Y-M-d H:i:s', (strtotime(gmdate('Y-M-d H:i:s'))));
            $total_duration = strtotime($classroom_info->class_end_time) - strtotime($classroom_info->class_start_time);
            ?>

            <span class="row col-sm-12" >   
                <span class="col-sm-4" style="padding:0">Class Status</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0">
                    <?php
                    if ($classroom_info->classroom_status == 0) {
                        echo 'Start In ' . format_interval($interval);
//                                            }
                    } else
                    if ($classroom_info->classroom_status == 1) {
                        echo 'Running';
                    } else if ($classroom_info->classroom_status == 2) {
                        echo 'Finished';
                    } else if ($classroom_info->classroom_status == 4) {
                        echo 'Not Held';
                    } else if ($classroom_info->classroom_status == 5) {
                        echo 'Canceled';
                    } else if ($classroom_info->classroom_status == 6) {
                        echo 'Archived';
                    } else if ($classroom_info->classroom_status == 7) {
                        echo 'Draft';
                    } else {
                        echo 'Not Held';
                    }
                    ?>
                </span>
            </span>

            <span class="row col-sm-12" >
                <span class="col-sm-4" style="padding:0">Presented by</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0">
                    <a href="<?php echo base_url() . $resource_person_info->url . 'profile/'; ?>"><?php echo $resource_person_info->person_first_name . ' ' . $resource_person_info->person_last_name; ?></a>
                </span>
            </span>

            <span class="row col-sm-12" >   
                <span class="col-sm-4" style="padding:0">Duration</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0"><?php echo $classroom_info->class_duration; ?> Minutes</span>
            </span>
            <?php ?>
        </address>
    </div>
    <div class="col-xs-5  col-sm-3 text-left" style="padding: 20px 0 0 0" >
        <?php if ($classroom_info->student_id) { ?>

            <a href="<?php echo base_url() . 'start-class/' . $classroom_info->classroom_id ?>"><i class="fa  fa-play-circle-o" title="J Class"></i></a>&nbsp;&nbsp;&nbsp;

        <?php } else { ?>

            <?php if ($classroom_info->classroom_status == 0) { // Class Not Started = 0  ?>

                <a href="<?php echo base_url() . 'edit-scheduled-class/' . $classroom_info->url; ?>"><i class="fa fa-edit" title="Edit"></i></a>&nbsp;&nbsp;&nbsp;
                <span>&nbsp;&nbsp;</span>

                <a href="#" onclick="return checkForAction('<?php echo base_url() . 'delete-schedule-class/' . $classroom_info->classroom_id; ?>', 'Delete', <?php echo $classroom_info->classroom_id; ?>)">
                    <i class="fa fa-trash-o" title="Delete"></i>
                </a>&nbsp;&nbsp;&nbsp;

                <span>&nbsp;&nbsp;</span>
                <a href="#" onclick="return checkForAction('<?php echo base_url() . 'cancel-schedule-class/' . $classroom_info->classroom_id; ?>', 'Cancel', <?php echo $classroom_info->classroom_id; ?>)">
                    <i class="fa  fa-user-times" title="Cancel Class"></i>
                </a>&nbsp;&nbsp;&nbsp;

                <span>&nbsp;&nbsp;</span>
                <a href="<?php echo base_url() . 'start-class/' . $classroom_info->url; ?>" target="blank"><i class="fa  fa-play-circle-o" title="Launch Class"></i></a>&nbsp;&nbsp;&nbsp;

            <?php } else if ($classroom_info->classroom_status == 1) { // Class Running = 1  ?>

                <a href="<?php echo base_url() . 'start-class/' . $classroom_info->url; ?>" target="blank">
                    <i class="fa  fa-play-circle-o" title="Launch Class"></i>
                </a>&nbsp;&nbsp;&nbsp;

            <?php } else if ($classroom_info->classroom_status == 2) { // Class End = 2  ?>

                <a href="<?php echo base_url() . 'attended-student/' . $classroom_info->url; ?>">
                    <i class="fa  fa-group" title="Number of Attended Student"></i>
                </a>&nbsp;&nbsp;&nbsp;

                <a href="<?php echo base_url() . 'download-class-video/' . $classroom_info->url; ?>">
                    <i class="fa  fa-download" title="Download Class Video"></i>
                </a>&nbsp;&nbsp;&nbsp;

                <a href="#" onclick="return checkForAction('<?php echo base_url() . 'delete-schedule-class/' . $classroom_info->classroom_id; ?>', 'Delete', <?php echo $classroom_info->classroom_id; ?>)">
                    <i class="fa fa-trash-o" title="Delete"></i> 
                </a>&nbsp;&nbsp;&nbsp;

            <?php } else if ($classroom_info->classroom_status == 3) { // Class Unexpectedly END = 3  ?>

                <a href="<?php echo base_url() . 'start-class/' . $classroom_info->url; ?>" target="blank">
                    <i class="fa  fa-play-circle-o" title="Launch Class"></i>
                </a>&nbsp;&nbsp;&nbsp;

            <?php } else if ($classroom_info->classroom_status == 4) { // Class Running = 4  ?>

                <a href="#" onclick="return checkForAction('<?php echo base_url() . 'delete-schedule-class/' . $classroom_info->classroom_id; ?>', 'Delete', <?php echo $classroom_info->classroom_id; ?>)">
                    <i class="fa fa-trash-o" title="Delete"></i> 
                </a>&nbsp;&nbsp;&nbsp;

            <?php } else if ($classroom_info->classroom_status == 5) { // Class Canceled = 5  ?>

                <a href="#" onclick="return checkForAction('<?php echo base_url() . 'delete-schedule-class/' . $classroom_info->classroom_id; ?>', 'Delete', <?php echo $classroom_info->classroom_id; ?>)">
                    <i class="fa fa-trash-o" title="Delete"></i> 
                </a>&nbsp;&nbsp;&nbsp;

            <?php } ?>

        <?php } ?>
    </div>
    <?php
} else {
    echo '';
}
?>
