<!DOCTYPE html>
<html>
    <head>
        <title>Student Course Certificate</title>
        <style type="text/css">
            *{
                margin: 0px;
                padding: 0px;                
            }
            .wrapper{            
                width: 980px;
                height: 500px;
                border: 8px solid #8CC73F; 
                background-color: #F2F9EA;
                font-family: 'Roboto', Roboto Light, Roboto Bold, sans-serif;
            }

            .header{
                width: 100%;
                height: 120px;
                border-bottom: 4px solid #8CC73F;
                margin: 0px;
                padding: 0px;

            }

            .logo {
                width: 180px;
                /*height: 100px;*/
                padding: 0px;
                float: left;
                text-align: center;
                margin-top: 15px;
            }

            .logo-img{
                width: 50px;
                height: 50px;
            }

            .main-content{           
                text-align: center;
            }
            
            p{
                margin: 0px;
                padding: 2px;
            }
            
            .content-header{
                font-family: certificate;            
                font-size: 55px;           
            }

            .content-body{
                margin-top: 35px;
            }

            .certificate_owner_name{
                margin: 15px;
                font-family: courgette;
                font-size: 30px;
            }

            .content-footer{
                margin-top: 55px;
                float: right;               
            }

            .space-fixer{
                width: 80%;
                float: left;
            }

            .instructor{
                width: 20%;         
                float: right;
                margin-bottom: 10px;

            }
            
            .verification-link{
                font-size: 10px;
                text-align: left;
                margin-left: 10px;
                margin-bottom: 7px;
            }
        </style>
    </head>
    <body>
        <div class="wrapper">
            <div class="header">
                <div class="logo">
                    <?php if (isset($certificate_data->certificate_logo)) { ?>                                    
                        <img class="logo-img" src="<?php echo base_url($certificate_data->certificate_logo) ?>" title="logo">
                        <p>
                            <?php echo $certificate_data->course_by ?>
                        </p>
                    <?php } else { ?>
                        <img class="logo-img" src="<?php echo base_url('images/logo-50.png') ?>" title="logo">
                        <p>
                            Talha Training
                        </p>
                    <?php } ?>
                </div>            
            </div>

            <div class="main-content">
                <div class="content-header">
                    <span>Certificate of Completion</span>
                </div>

                <div class="content-body">
                    <p>  This is to acknowledge that</p>
                    <p class="certificate_owner_name"> <?php echo $certificate_data->student_name; ?></p>
                    <p>has Completed</p>
                    <p>A Training Course on : <?php echo $certificate_data->course_name; ?></p>
                    <p>With a Roll Number : <?php echo $certificate_data->student_roll_number; ?></p>
                    <p>Given this day of <?php echo $certificate_data->course_completion_date; ?></p>
                </div>

                <div class="content-footer">
                    <div class="space-fixer">                      
                    </div>
                    <div class="instructor">
                        <p><?php echo $certificate_data->course_resource_person; ?></p>
                        <p>Instructor</p>
                    </div>                    
                </div>
                <div>
                    <p class="verification-link">Verification Link:&nbsp;&nbsp;<strong><?php echo base_url().'verifiy_certificate/'.$certificate_data->student_roll_number; ?></strong></p>
                </div>
            </div>       
        </div>
    </body>
</html>