<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="author" content="">
        <meta http-equiv="content-type" content="text/html; charset=utf-8">
        <title>New customer Registration - bind 2.0 | Paperman</title>


    </head>
    <body onload="initialize_map()">

        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css">
        <script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
        <script type="text/javascript">

        function initialize_map() {
            geocoder = new google.maps.Geocoder();
            var myOptions = {
                zoom: 2,
                center: new google.maps.LatLng(13.288828765662416, 80.945261001586914),
                mapTypeControl: true,
                mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU},
                navigationControl: true,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };




            map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

            // initialize marker

            var marker = new google.maps.Marker({
                position: map.getCenter(),
                draggable: true,
                map: map
            });

            // intercept map and marker movements
            google.maps.event.addListener(map, "idle", function () {
                marker.setPosition(map.getCenter());

                var latitude = map.getCenter().lat().toFixed(6);
                var longitude = map.getCenter().lng().toFixed(6);
                document.getElementById("latitude").value = latitude;
                document.getElementById("longitude").value = longitude;
                google.maps.event.trigger(map, "resize");
            });
            google.maps.event.addListener(marker, "dragend", function (mapEvent) {
                map.panTo(mapEvent.latLng);
            });


            findAddress("New York");
        }

        function findAddress(address) {
            if ((address != '') && geocoder) {
                geocoder.geocode({'address': address}, function (results, status) {
                    if (status == google.maps.GeocoderStatus.OK) {
                        if (status != google.maps.GeocoderStatus.ZERO_RESULTS) {
                            if (results && results[0]
                                    && results[0].geometry && results[0].geometry.viewport)
                                map.fitBounds(results[0].geometry.viewport);
                        } else {
                            alert("No results found");
                        }
                    } else {
                        alert("Geocode was not successful for the following reason: " + status);
                    }
                });
            }
        }

        </script>
        <div class="col-md-12">
            <div class="col-md-6">

                <h1 class="text-center" >Enter your Location</h1>
                <?php echo validation_errors(); //id="formID2" ?>
                <form class="form-horizontal" action="<?php echo base_url() . 'travels/add_to_geo_location' ?>" method="POST">
                    <div class="form-group">
                        <div class="col-sm-10">
                            <?php
                            $message = $this->session->userdata('message');
                            $this->session->unset_userdata('message');
                            if ($message) {
                                echo $message;
                            }
                            ?>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="country_name" class="col-sm-2 control-label">Country</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="country_name" name="country_name"  placeholder="Country">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="city" class="col-sm-2 control-label">City</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="city" name="city" placeholder="City">
                        </div>
                    </div>				



                    <div class="form-group" >
                        <div class="col-sm-2"></div>
                        <div class="col-sm-10">
                            <!-- Text boxes to show lat long values -->
                            <div class="input-group col-md-6 pull-left">
                                <span class="input-group-addon">Latitude</span>
                                <input type="text" id="latitude" name="latitude" class="form-control">
                            </div>
                            <div class="input-group col-md-6 pull-left">
                                <span class="input-group-addon" >Longitude</span>
                                <input type="text" class="form-control" id="longitude" name="longitude">
                            </div>
                        </div>
                    </div>
                    <div class="form-group" >
                        <div class="col-sm-2"></div>
                        <div class="col-sm-10">
                            <input type="submit" class="btn btn-success"name="btn" id="btn" value=" Add your Location ">
                        </div>
                    </div>



                </form>
            </div>
            <div class="col-md-6">
                <h1 class="text-center">Mark your Location</h1>
                <div id="map_canvas" style="width:100%;height:70%;">
                </div>

            </div>		
        </div>
        <!--<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>-->
        <!--<script src="https://maxcdn.bootstrapcdn.com/bootstrap/2.3.2/js/bootstrap.min.js"></script>-->
        <script type="text/javascript">
        $(document).ready(function () {
            $("#country_name").blur(function () {
                var address = $("#country_name").val();
                findAddress(address);
            });
            $("#state").blur(function () {
                var address = $("#country_name").val() + ' ' + $("#state").val();
                findAddress(address);
            });

            $("#city").blur(function () {
                var address = $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });

            $("#area").blur(function () {
                var address = $("#area").val() + ' ' + $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });

            $("#street_name").blur(function () {
                var address = $("#street_name").val() + ' ' + $("#area").val() + ' ' + $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });


        });
        </script>
    </body>
</html>