
<script type="text/javascript">
    $(document).ready(function () {
        $("body").on("load", function () {
            initialize_map();
        });
    });
    function initialize_map() {
        geocoder = new google.maps.Geocoder();
        var myOptions = {
            zoom: 2,
            center: new google.maps.LatLng(13.288828765662416, 80.945261001586914),
            mapTypeControl: true,
            mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU},
            navigationControl: true,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        };




        map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

        // initialize marker

        var marker = new google.maps.Marker({
            position: map.getCenter(),
            draggable: true,
            map: map
        });

        // intercept map and marker movements
        google.maps.event.addListener(map, "idle", function () {
            marker.setPosition(map.getCenter());
//            alert(map.getCenter());
            var latitude = map.getCenter().lat().toFixed(6);
            var longitude = map.getCenter().lng().toFixed(6);
            document.getElementById("latitude").value = latitude;
            document.getElementById("longitude").value = longitude;
            google.maps.event.trigger(map, "resize");
        });
        google.maps.event.addListener(marker, "dragend", function (mapEvent) {
            map.panTo(mapEvent.latLng);
        });


        findAddress("Bangladesh");
    }

    function findAddress(address) {
        if ((address != '') && geocoder) {
            geocoder.geocode({'address': address}, function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    if (status != google.maps.GeocoderStatus.ZERO_RESULTS) {
                        if (results && results[0]
                                && results[0].geometry && results[0].geometry.viewport)
                            map.fitBounds(results[0].geometry.viewport);
                    } else {
                        alert("No results found");
                    }
                } else {
                    alert("Geocode was not successful for the following reason: " + status);
                }
            });
        }
    }

</script>
<body onload="initialize_map()">
    <div class="col-md-12">
        <div class="col-md-6">
            <h1 class="text-center" >Enter your Address</h1>
            <form class="form-horizontal">
                <div class="form-group">
                    <label for="country_name" class="col-sm-2 control-label">Country</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="country_name" placeholder="Country">
                    </div>
                </div>

                <div class="form-group">
                    <label for="state" class="col-sm-2 control-label">State</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="state" placeholder="State">
                    </div>
                </div>

                <div class="form-group">
                    <label for="city" class="col-sm-2 control-label">City</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="city" placeholder="City">
                    </div>
                </div>

                <div class="form-group">
                    <label for="area" class="col-sm-2 control-label">Area</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="area" placeholder="Area">
                    </div>
                </div>

                <div class="form-group">
                    <label for="street_name" class="col-sm-2 control-label">Street Name</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="street_name" placeholder="Street Name">
                    </div>
                </div>



            </form>
        </div>
        <div class="col-md-6">
            <h1 class="text-center">Mark your Location</h1>
            <div id="map_canvas" style="width:100%;height:70%;">
            </div>
            <!-- Text boxes to show lat long values -->
            <div class="input-group col-md-6 pull-left">
                <span class="input-group-addon">Latitude</span>
                <input type="text" id="latitude" class="form-control">
            </div>
            <div class="input-group col-md-6 pull-left">
                <span class="input-group-addon" >Longitude</span>
                <input type="text" class="form-control" id="longitude">
            </div>



        </div>		
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#country_name").blur(function () {
                var address = $("#street_name").val() + ' ' + $("#area").val() + ' ' + $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });
            $("#state").blur(function () {
                var address = $("#street_name").val() + ' ' + $("#area").val() + ' ' + $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });

            $("#city").blur(function () {
                var address = $("#street_name").val() + ' ' + $("#area").val() + ' ' + $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });

            $("#area").blur(function () {
                var address = $("#street_name").val() + ' ' + $("#area").val() + ' ' + $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });

            $("#street_name").blur(function () {
                var address = $("#street_name").val() + ' ' + $("#area").val() + ' ' + $("#city").val() + ' ' + $("#state").val() + ' ' + $("#country_name").val();
                findAddress(address);
            });


        });
    </script>
</body>