<?php

function format_interval(DateInterval $interval) {
    $result = "";
    if ($interval->y) {
        $result .= $interval->format("%y years ");
    }
    if ($interval->m) {
        $result .= $interval->format("%m months ");
    }
    if ($interval->d) {
        $result .= $interval->format("%d days ");
    }
    if ($interval->h) {
        $result .= $interval->format("%h hours ");
    }
    if ($interval->i) {
        $result .= $interval->format("%i minutes ");
    }
    if ($interval->s) {
        $result .= $interval->format("%s seconds ");
    }

    return $result;
}

$person_id = $this->session->userdata('person_id');
$person_role = $this->session->userdata('person_role');
?>
<div class="col-sm-12 white" >
    <div class="col-sm-7 text-left" style="padding-top: 20px ">
        <address>
            <span class="row col-sm-12" >   
                <span class="col-sm-4" style="padding:0">Course Name</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0">
                    <a href="<?php echo base_url() . $course_info->url; ?>" target="blank">
                        <?php echo $course_info->course_name; ?>
                    </a>
                </span>
            </span>
            <span class="row col-sm-12">
                <span class="col-sm-4" style="padding:0">Classroom Title</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0"><?php echo $classroom_info->classroom_title; ?></span>
            </span>
            <?php
            $offset = $this->session->userdata('time_offset');
            $required_time = (strtotime("$classroom_info->class_start_time") + $offset);

            $now = date('Y-M-d H:i:s', strtotime(gmdate('Y-M-d H:i:s')) - $offset);
            $now = new DateTime($now, new DateTimeZone($person_info->person_time_zone));

            $class_start_time = date('Y-M-d H:i:s', (strtotime($classroom_info->class_start_time)));
            $class_start_time = new DateTime($class_start_time, new DateTimeZone($person_info->person_time_zone));
            $interval = $class_start_time->diff($now);
            $class_start_time = date('Y-M-d H:i:s', (strtotime($classroom_info->class_start_time) + $offset));
            $now = date('Y-M-d H:i:s', (strtotime(gmdate('Y-M-d H:i:s'))));
            $total_duration = strtotime($classroom_info->class_end_time) - strtotime($classroom_info->class_start_time);
            ?>

            <span class="row col-sm-12">
                <span class="col-sm-4" style="padding:0">Class Status</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0">
                    <?php
                    $running = FALSE;
                    if ($classroom_info->classroom_status == 0) {
                        if ($class_start_time < $now) {
                            $running = TRUE;
                            echo 'Running';
                        } else {
                            echo 'Start In ' . format_interval($interval);
                        }
                    } else {
                        $classroom_status = array('', 'Running', 'Finished', 'Unexpected_End', 'Not Held', 'Canceled', 'Archived', 'Draft', 'Not Held');
                        echo $classroom_status[$classroom_info->classroom_status];
                    }
                    ?>
                </span>
            </span>

            <span class="row col-sm-12" >
                <span class="col-sm-3" style="font-weight: bold;margin-right: 45px; padding: 0px;">Presented by</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0">
                    <a href="<?php echo base_url() . $resource_person_info->url . '/profile'; ?>"><?php echo $resource_person_info->person_first_name . ' ' . $resource_person_info->person_last_name; ?></a>
                </span>
            </span>
            <br>

            <span class="row col-sm-12" >   
                <span class="col-sm-3" style="font-weight: bold;margin-right: 45px; padding:0">Duration</span>
                <span class="col-sm-1" style="padding:0">: </span>
                <span class="col-sm-6" style="padding:0"><?php echo $classroom_info->class_duration; ?> Minutes</span>
            </span>

        </address>
    </div>

    <div class="col-sm-5 text-left" style="padding: 20px 0 0 0">

        <?php if ($person_role == 1) { // Admin?>

        <?php } else if ($person_role == 2) {  // Account officer?>


        <?php } else if ($person_role == 6) { // Super Admin?>

            <a href="<?php echo base_url() . 'super-admin/edit-classroom-schedule/' . $classroom_info->url; ?>"><i class="fa fa-edit" title="Edit"></i></a>&nbsp;
            <span>&nbsp;&nbsp;</span>

            <a href="javascript:void(0)" 
               onclick="return checkForAction('<?php echo base_url() . 'super-admin/delete-schedule-class/' . $classroom_info->classroom_id; ?>', 'Delete', <?php echo $classroom_info->classroom_id; ?>)">
                <i class="fa fa-trash-o" title="Delete"></i> 
            </a>&nbsp;&nbsp;&nbsp;

            <?php if ($classroom_info->classroom_status != 5) { ?>
                <a href="javascript:;" 
                   onclick="return checkForAction('<?php echo base_url() . 'super-admin/cancel-schedule-class/' . $classroom_info->classroom_id; ?>', 'Cancel', <?php echo $classroom_info->classroom_id; ?>)">
                    <i class="fa  fa-remove" title="Cancel Class"></i></a>&nbsp;
                <span>&nbsp;&nbsp;</span>
            <?php } ?>

            <a href="javascript:;" >
                <i class="fa fa-laptop" title="Join Class"></i>
            </a>&nbsp;
            <span>&nbsp;&nbsp;</span>

                                    <!--<a href="#"><i class="fa  fa-play-circle-o" title="Launch Class"></i></a>&nbsp;-->


        <?php } ?>




    </div>
</div>

<div class="col-sm-12"><br></div> 