<?php

/**
 * Description of Work_file_model
 *
 * @author Md Jaherul Islam
 */
class Work_file_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Description         : set Course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-11-2016 04:44 PM
     * @Parameter           : $course_id
     * @Return              : Null 
     * @Status              : Available        
     * */
    private $course_id;

    function set_course_id($course_id) {
        $this->course_id = $course_id;
        return $this;
    }

    /**
     * @Description         : set work file data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-11-2016 10:05 AM       
     * */
    private $arr_data;

    function set_data($data) {
        $this->arr_data = $data;
        return $this;
    }

    /**
     * @Function            : get_work_file_information 
     * @Description         : get work file information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-10-2016 05:26 PM
     * @Parameter           : $field_name=>which file will be printed
     *                        $work_file_type=>Course, Video_course
     *                        $work_file_type_id=> COurse / Video COurse ID
     * @Return              : $work_file_info    
     * @Status              : Available        
     * */
    function get_work_file_information($field_name, $work_file_type, $work_file_type_id) {
        return $this->db->select($field_name)->from('tbl_work_files')
                        ->where('work_file_type', $work_file_type)
                        ->where('work_file_type_id', $work_file_type_id)->get()->row();
    }

    /**
     * @Function            : get_work_file_information 
     * @Description         : get work file information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 24-10-2016 05:26 PM
     * @Parameter           : $work_file_type=>Course, Video_course
     *                        $work_file_type_id=> COurse / Video COurse ID
     * @Return              : $total_work_file 
     * @Status              : Available        
     * */
    function get_total_work_file($work_file_type, $work_file_type_id) {
        return $this->db->where(Array('work_file_type' => $work_file_type, 'work_file_type_id' => $work_file_type_id))->from('tbl_work_files')->count_all_results();
    }

    /**
     * @Function            : get_work_file_info_by_type_id 
     * @Description         : get work file information by Course_id/vide course ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-11-2016 10:29 AM
     * @Parameter           : $field_name, $type[Course Type/Video Course Type], 
     *                        $id[Course ID/ VIdeo COurse ID], $work_file_id
     * @Return              : Null 
     * @Status              : Available        
     * */
    function get_work_file_info_by_type_id($field_name, $type, $id, $work_file_id) {
        return $this->db->select($field_name)->from('tbl_work_files AS wf')
                        ->join('tbl_random AS r', 'wf.work_file_id = r.random_type_id')
                        ->where('wf.work_file_type', $type)
                        ->where('wf.work_file_type_id', $id)
                        ->where_not_in('wf.work_file_id', $work_file_id)
                        ->where('r.random_type', 3)->get()->result();
    }

    /**
     * @Function            : get_all_table_data 
     * @Description         : get all table information 
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-11-2016 12:07 PM
     * @Parameter           : $field=>[* OR other ind field], $table_name=>[table name]
     * @Return              : $table_info 
     * @Status              : available      
     * */
    function get_order_work_file_data($field, $condition) {
        return $this->db->select($field)->from('tbl_work_files')->where($condition)->order_by('work_file_order', 'asc')->get()->result();
    }

    /**
     * @Function            : get_last_ordered_id 
     * @Description         : get work file by DESC order
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-11-2016 10:56 AM
     * @Parameter           : $field=>[* OR other ind field], $table_name=>[table name]
     * @Return              : $table_info 
     * @Status              : available      
     * */
    function get_last_ordered_id($field_name, $condition, $order) {
        return $this->db->select($field_name)->from('tbl_work_files')
                        ->where($condition)->order_by('work_file_order', $order)->limit(1)->get()->row();
    }

    /**
     * @Function            : get_folder_info 
     * @Description         : get work folder name with work file infomation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-11-2016 10:29 AM
     * @Parameter           : $filed_name
     * @Return              : Null 
     * @Status              : Available        
     * */
    function get_folder_info($field_name) {
        return $this->db->select($field_name)->from('tbl_work_file_folder AS wff')
                        ->join('tbl_work_files AS wf', 'wff.work_file_folder_id = wf.work_file_folder_id')
                        ->group_by('wf.work_file_folder_id')->get()->result();
    }

    /**
     * @Function            : get_work_file_folder_name 
     * @Description         : get work folder name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-11-2016 10:22 AM
     * @Parameter           : Null
     * @Return              : Null 
     * @Status              : Available        
     * */
    function get_work_file_folder_name() {
        $folder_array = [];
        $folder_info = $this->get_folder_info('wf.work_file_type_id,wff.work_file_folder_name');

        foreach ($folder_info as $value) {
            if ($this->session->work_file_course_id != $value->work_file_type_id) {
                $folder_array[] = $value->work_file_folder_name;
            }
        }
        return $folder_array;
    }

    /**
     * @Function            : set_edit_work_file_data 
     * @Description         : set work file data into session
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-10-2016 10:50 AM
     * @Parameter           : $work_file_info=>work file data
     *                        $session_data=> session data
     * @Return              : $total_work_file 
     * @Status              : Available        
     * */
    function set_edit_work_file_data($work_file_info, $session_data) {
        $i = 1;
        foreach ($work_file_info as $work_file_value) {
            $session_data['sess_work_file']['counter'][] = $i;
            $condition_1 = ['random_type' => 3, 'random_type_id' => $work_file_value->work_file_id];
            $random_number = $this->utility_model->get_table_information('random_number', 'tbl_random', $condition_1)->random_number;
            $session_data['sess_work_file']['work_file_random_id'][] = $this->tt_random_number
                            ->set_random_number($random_number)->filter_number('45')->get_filter_number();
            $i++;
        }
        set_session($session_data);
    }

    /**
     * @Description         : set course url
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 04:24 PM    
     * @Parameter           : $course_url   
     * */
    private $course_url;

    function set_course_url($url) {
        $this->course_url = $url;
        return $this;
    }

    /**
     * @Description         : get course ID from url and set to session
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 04:27 PM    
     * @Parameter           : $course_url   
     * */
    function set_course_id_into_session() {
        $session_data = [];
        $session_data['work_file_course_id'] = $this->course_model->course_info_by_url('course_id', $this->course_url)->course_id;
        $session_data['sess_work_file'] = Array('counter' => [1], 'work_file_random_id' => []);
        set_session($session_data);
        return $this;
    }

    /**
     * @Function            : save_folder_information 
     * @Description         : save work file folder information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-10-2016 02:33 PM
     * @Parameter           : Null
     * @Return              : $total_work_file 
     * @Status              : Available        
     * */
    private $folder_name;
    private $work_file_folder_id;

    function save_folder_information() {
        $work_folder_info = $this->get_work_file_information('work_file_folder_id', 1, $this->session->work_file_course_id);
        if (!$work_folder_info) { // if any work file folder does not create from this course
            $work_folder_id = $this->save_work_file_folder_name();
            $this->tt_random_number->set_random_data(2, $work_folder_id)->save_random_value();
        }

        $this->work_file_folder_id = ($work_folder_info) ? $work_folder_info->work_file_folder_id : $work_folder_id;
        $condition = Array(
            'random_type' => 2, // for work file folder
            'random_type_id' => $this->work_file_folder_id
        );
        $this->folder_name = $this->utility_model->get_table_information('random_number', 'tbl_random', $condition)->random_number;
        return $this;
    }

    /**
     * @Function            : get_folder_name 
     * @Description         : get folder name;
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 11:08 AM
     * @Parameter           : Null
     * @Return              : $folder_name 
     * @Status              : Available        
     * */
    function get_folder_name() {
        return $this->folder_name;
    }

    /**
     * @Function            : get_work_file_folder_id 
     * @Description         : get work file folder ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-10-2016 04:05 PM
     * @Parameter           : Null
     * @Return              : $work_file_folder_id 
     * @Status              : Available        
     * */
    function get_work_file_folder_id() {
        return $this->work_file_folder_id;
    }

    /**
     * @Function            : save_work_file_folder_name 
     * @Description         : get work file folder name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 11:42 AM
     * @Parameter           : Null
     * @Return              : $work_file_folder_id    
     * @Status              : Available        
     * */
    function save_work_file_folder_name() {
        $data = Array();
        $data['work_file_folder_name'] = htmlspecialchars($this->input->post('work_file_folder_name', TRUE));
        return $this->utility_model->save_information_in_database('tbl_work_file_folder', $data);
    }

    /**
     * @Function            : get_file_name 
     * @Description         : get work file name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 03:38 PM
     * @Parameter           : Null
     * @Return              : $work_file_name
     * @Status              : Available        
     * */
    function get_file_name() {
        return $this->file_name;
    }

    /**
     * @Function            : set_work_file_data 
     * @Description         : set work file post data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 11:12 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $file_name;
    public $file_data = [];

    function set_work_file_data() {
        $this->file_name = htmlspecialchars($this->input->post('work_file_name', TRUE));
        $this->file_data['work_file_type'] = 1;
        $this->file_data['work_file_type_id'] = $this->session->work_file_course_id;
        $this->file_data['work_file_folder_id'] = $this->work_file_folder_id;
        $this->file_data['work_file_name'] = $this->file_name . '.' . $this->tt_files->get_file_extension();
        $this->file_data['work_file_upload_date'] = date('Y-m-d h:i:s', (time() - $this->session->time_offset));
        $this->file_data['work_file_size'] = $this->tt_files->get_file_size();
        $this->file_data['work_file_access_level'] = $this->input->post('work_file_access_level', TRUE);
        if (empty($this->work_file_model->check_work_file_id())) {
            $this->file_data['work_file_order'] = $this->get_order_id($this->session->work_file_course_id);
        }
        $this->file_data['work_file_status'] = 3;
        return $this;
    }

    /**
     * @Function            : get_order_id 
     * @Description         : get order ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-11-2016 10:52 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_order_id($course_id) {
        $condition = ['work_file_type' => 1, 'work_file_type_id' => $course_id];
        $file_info = $this->get_last_ordered_id('work_file_order', $condition, 'desc');

        return ($file_info) ? ++$file_info->work_file_order : 1;
    }

    /**
     * @Function            : get_work_file_data 
     * @Description         : get work file post data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 02:23 AM
     * @Parameter           : Null
     * @Return              : $work_file_data    
     * @Status              : Available        
     * */
    function get_work_file_data() {
        return $this->file_data;
    }

    /*
     * @Function            : make_work_file_upload_dir 
     * @Description         : make upload work file directory
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-10-2016 02:15 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     */

    private $upload_dir;

    function make_work_file_upload_dir() {
        $this->upload_dir = 'content-library/' . $this->url_model->course_creator_url($this->session->work_file_course_id) . '/my-work-file/' . $this->folder_name . '/';
        if (!is_dir($this->upload_dir)) {
            mkdir($this->upload_dir, 0777, TRUE);
        }
        return $this;
    }

    /*
     * @Function            : get_upload_dir 
     * @Description         : get upload dir
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-10-2016 12:00 AM
     * @Parameter           : Null
     * @Return              : $upload_dir    
     * @Status              : Available        
     */

    function get_upload_dir() {
        return $this->upload_dir;
    }

    /**
     * @Function            : get_work_file_size
     * @Description         : get uploaded work file size 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 12:19 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_work_file_size() {
        $directory = 'content-library/' . $this->session->person_url;
        $file_size = $this->tt_storage->set_size($this->tt_files->get_file_size())->calculate_disk_storage()->get_designed_file_size();
        $total_storage = $this->tt_storage->set_directory($directory)->set_storage()->calculate_disk_storage()->get_designed_storage();

        if ($this->session->person_role == 4) {
            return $file_size . ' and ' . $total_storage;
        } else {
            $resource_person_type = $this->utility_model->get_single_table_information('resource_person_type', 'tbl_resource_person', 'person_id', $this->session->person_id)->resource_person_type;
            if ($resource_person_type == 2) {
                return $file_size . ' and ' . $total_storage;
            } else {
                return $file_size;
            }
        }
    }

    /**
     * @Description         : get work file size if super admin create course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-11-2016 10:03 AM       
     * */
    function get_work_file_size_for_admin() {
        $directory = 'content-library/' . $this->session->person_url;
        $file_size = $this->tt_storage->set_size($this->tt_files->get_file_size())->calculate_disk_storage()->get_designed_file_size();
        $total_storage = $this->tt_storage->set_directory($directory)->set_storage()->calculate_disk_storage()->get_designed_storage();
        return $file_size . ' and ' . $total_storage;
    }

    /**
     * @Function            : update_work_file_data 
     * @Description         : update work file data if user second time upload work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 05:00 PM
     * @Parameter           : $work_file_data
     * @Return              : Null    
     * @Status              : Available        
     * */
    function update_work_file_data() {
        $work_file_random_id = $this->tt_random_number
                        ->set_random_number($this->check_work_file_id())
                        ->filter_number('TT')->get_filter_number();
        $work_file_id = $this->utility_model->get_single_table_information('random_type_id', 'tbl_random', 'random_number', $work_file_random_id)->random_type_id;
        $work_file_name = $this->utility_model->get_single_table_information('work_file_name', 'tbl_work_files', 'work_file_id', $work_file_id)->work_file_name;
        $upload_dir = $this->tt_files->get_upload_directory();

        $file_path = $upload_dir . $work_file_random_id . '.' . pathinfo($work_file_name, PATHINFO_EXTENSION);
        if (file_exists($file_path)) {
            unlink($file_path);
        }

        $this->utility_model->update_information_in_database('tbl_work_files', 'work_file_id', $work_file_id, $this->work_file_model->get_work_file_data());
    }

    /**
     * @Function            : check_work_file_id 
     * @Description         : get work file ID from session
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 03:33 PM
     * @Parameter           : Null
     * @Return              : $work_file_id    
     * @Status              : Available        
     * */
    function check_work_file_id($counter_arg = '') {
        $counter = ($counter_arg === '') ? $this->input->post('counter', TRUE) : $counter_arg;
        if (in_array($counter, $this->session->sess_work_file['counter'])) {
            $key = array_search($counter, $this->session->sess_work_file['counter']);

            if (isset($this->session->sess_work_file['work_file_random_id'][$key])) {
                return $this->session->sess_work_file['work_file_random_id'][$key];
            } else {
                return '';
            }
        } else {
            return '';
        }
    }

    /**
     * @Function            : remove_course_work_file
     * @Description         : remove course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-10-2016 03:44 PM
     * @Parameter           : $counter, $sess_work_file
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function remove_course_work_file($counter, $sess_work_file) {
        // get key of deleted counter
        $key = array_search($counter, $sess_work_file['counter']);
        // if file donot uploaded
        if ($this->check_work_file_id($counter) != '') {
            // get file random ID to replace 'TT'
            $work_file_random_id = $this->tt_random_number->set_random_number($this->check_work_file_id($counter))
                            ->filter_number('TT')->get_filter_number();
            // get work file ID by random ID
            $work_file_id = $this->utility_model->get_single_table_information('random_type_id', 'tbl_random', 'random_number', $work_file_random_id)->random_type_id;
            // get course ID by work file ID
            $course_id = $this->utility_model->get_single_table_information('work_file_type_id', 'tbl_work_files', 'work_file_id', $work_file_id)->work_file_type_id;
            // delete Course work file
            $this->delete_course_work_file($work_file_id);
            // Reset work file order 
            $this->reset_order($course_id);
            // unset work file id by session
            unset($sess_work_file['work_file_random_id'][$key]);
        }
        unset($sess_work_file['counter'][$key]);
        return $sess_work_file;
    }

    /**
     * @Function            : delete_course_work_file
     * @Description         : delete course work file
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-11-2016 10:12 AM
     * @Parameter           : $work_file_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function delete_course_work_file($work_file_id) {
        // get work file info by work file ID
        $work_file_info = $this->utility_model->get_single_table_information('work_file_type_id,work_file_folder_id,work_file_name', 'tbl_work_files', 'work_file_id', $work_file_id);
        // get folder name which is created as random number
        $condition = ['random_type' => 2, 'random_type_id' => $work_file_info->work_file_folder_id];
        $folder_name = $this->utility_model->get_table_information('random_number', 'tbl_random', $condition)->random_number;

        // get file name which is created as random number
        $condition1 = ['random_type' => 3, 'random_type_id' => $work_file_id];
        $file_name = $this->utility_model->get_table_information('random_number', 'tbl_random', $condition1)->random_number;

        // remaining file directory to unlink file
        $file_dir = 'content-library/' . $this->url_model->course_creator_url($work_file_info->work_file_type_id) . '/my-work-file/' . $folder_name . '/' . $file_name . '.' . pathinfo($work_file_info->work_file_name, PATHINFO_EXTENSION);
        if (file_exists($file_dir)) {
            unlink($file_dir);
        }
        // delete course work file
        $this->utility_model->delete_information_in_database('tbl_work_files', 'work_file_id', $work_file_id);
        // delete random number according to course work file
        $this->utility_model->delete_information_in_database('tbl_random', 'random_number', $file_name);
    }

    /**
     * @Function            : reset_order
     * @Description         : reset course work file order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-11-2016 10:33 AM
     * @Parameter           : $work_file_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function reset_order($course_id) {
        //get all work file ID by course ID
        $condition = ['work_file_type' => 1, 'work_file_type_id' => $course_id];
        $all_work_file_id = $this->get_order_work_file_data('work_file_id', $condition);
        // reset all course work file order
        if ($all_work_file_id) {
            $i = 1;
            foreach ($all_work_file_id as $value) {
                $this->db->set('work_file_order', $i)->where('work_file_id', $value->work_file_id)->update('tbl_work_files');
                $i++;
            }
        }
    }

    /**
     * @Function            : set_work_file_post_data
     * @Description         : set course work file post data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-10-2016 05:17 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $file_name_array = [];
    private $file_access_level_array = [];

    function set_work_file_post_data() {
        $this->folder_name = trim($this->input->post('work_file_folder_name', TRUE));
        $this->file_name_array = $this->input->post('work_file_name', TRUE);
        $this->file_access_level_array = $this->input->post('work_file_access_level', TRUE);
        return $this;
    }

    /**
     * @Function            : update_folder_name
     * @Description         : update folder name
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-11-2016 06:24 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function update_folder_name() {
        // get single work file ID
        $work_file_random_id = '';
        for ($i = 0; $i < count($this->session->sess_work_file['work_file_random_id']); $i++) {
            if (isset($this->session->sess_work_file['work_file_random_id'][$i])) {
                $work_file_random_id = $this->session->sess_work_file['work_file_random_id'][$i];
                break;
            }
        }
        // get work file ID by session random number
        $work_file_id = $this->work_file_id_by_sess_random_number($work_file_random_id);
        $work_file_folder_id = $this->utility_model->
                        get_single_table_information('work_file_folder_id', 'tbl_work_files', 'work_file_id', $work_file_id)->work_file_folder_id;
        $data['work_file_folder_name'] = $this->folder_name;
        $this->db->where('work_file_folder_id', $work_file_folder_id)->update('tbl_work_file_folder', $data);
        return $this;
    }

    /**
     * @Function            : update_work_file
     * @Description         : update work file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-11-2016 10:42 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function update_work_file() {
        $sess_work_file = $this->session->sess_work_file;
        foreach ($sess_work_file['work_file_random_id'] as $key => $value) {
            // get file random number from session
            $work_file_id = $this->work_file_id_by_sess_random_number($value);
            $work_file_name = $this->utility_model->get_single_table_information('work_file_name', 'tbl_work_files', 'work_file_id', $work_file_id)->work_file_name;
            $file_extension = pathinfo($work_file_name, PATHINFO_EXTENSION);

            $data['work_file_name'] = $this->file_name_array[$sess_work_file['counter'][$key]] . '.' . $file_extension;
            $data['work_file_upload_date'] = date('Y-m-d h:i:s', (time() - $this->session->time_offset));
            $data['work_file_access_level'] = $this->file_access_level_array[$sess_work_file['counter'][$key]];
            $data['work_file_status'] = 1;
            $this->db->where('work_file_id', $work_file_id)->update('tbl_work_files', $data);
        }
    }

    /**
     * @Function            : work_file_id_by_sess_random_number
     * @Description         : get work file id by session random number
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-11-2016 11:23 AM
     * @Parameter           : $sess_random_number
     * @Return              : $work_file_id    
     * @Status              : Available        
     * */
    function work_file_id_by_sess_random_number($sess_random_number) {
        // Replace salted string from file number
        $file_random_number = $this->tt_random_number
                        ->set_random_number($sess_random_number)
                        ->filter_number('TT')->get_filter_number();
        // get work file ID by random number
        return $this->random_number_model->set_value(3, '', $file_random_number)->get_type_id();
    }

    /**
     * @Function            : set_status
     * @Description         : set work file status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-11-2016 04:04 PM
     * @Parameter           : $status[INTEGER]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $status;

    function set_status($status) {
        $this->status = $status;
        return $this;
    }

    /**
     * @Function            : set_type
     * @Description         : set work file type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-11-2016 04:22 PM
     * @Parameter           : $status[INTEGER]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $file_type;

    function set_type($file_type) {
        $this->file_type = $file_type;
        return $this;
    }

    /**
     * @Function            : update_status
     * @Description         : update work file status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-11-2016 04:47 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function update_status() {
        $condition = ['work_file_type' => $this->file_type, 'work_file_type_id' => $this->course_id];
        $work_file = $this->utility_model->get_all_table_data('work_file_id,work_file_status', 'tbl_work_files', $condition);

        if ($work_file) {
            foreach ($work_file AS $value) {
                if ($value->work_file_status == 1) {
                    $this->db->set('work_file_status', $this->status)->where('work_file_id', $value->work_file_id)->update('tbl_work_files');
                }
            }
        }
    }

    /**
     * @Function            : update_work_file_order
     * @Description         : update course work file order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 03:16 PM
     * @Parameter           : $course_url
     * @Return              : NULL    
     * @Status              : Available        
     * */
    private $selected_work_file_id;

    function update_work_file_order($course_url) {
        // get selected work file ID
        $this->get_target_work_file_id();
        // Course information by URl
        $course_info = $this->user_course_model->get_course_information_with_url_by_course_url($course_url);
        $order = $this->input->post('file_order', TRUE);
        switch ($order) {
            case 1:
                // old Course work file information
                $old_work_file_info = $this->work_file_info_by_order('work_file_id,work_file_order', $course_info->course_id, 'ASC');
                break;
            case 2:
                // swap order in two input field
                $this->swap_order();
                break;

            case 3:
                // old Course work file information
                $old_work_file_info = $this->work_file_info_by_order('work_file_id,work_file_order', $course_info->course_id, 'DESC');
                break;
        }

        if ($order == 1 || $order == 3) {
            // selected data set into top order data
            $top_data['work_file_order'] = $this->utility_model->get_table_information('work_file_order', 'tbl_work_files', ['work_file_id' => $this->selected_work_file_id])->work_file_order;
            $this->db->where('work_file_id', $old_work_file_info->work_file_id)->update('tbl_work_files', $top_data);
            // set top order in selected order
            $selected_data['work_file_order'] = $old_work_file_info->work_file_order;
            $this->db->where('work_file_id', $this->selected_work_file_id)->update('tbl_work_files', $selected_data);
        }
    }

    /**
     * @Function            : swap_order
     * @Description         : swap order 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 06:56 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function swap_order() {
        $target_random_number = $this->input->post('selected_file', TRUE);
        $filter_random_number = $this->tt_random_number->set_random_number($target_random_number)->filter_number('TT')->get_filter_number();
        $target_work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();

        $drop_down_file_info = $this->utility_model->get_table_information('work_file_type_id,work_file_order', 'tbl_work_files', ['work_file_id' => $target_work_file_id]);
        $drop_down_order = ++$drop_down_file_info->work_file_order; // increment drop down order if select after file name
        // if select after filename to increment work file order
        $condition = ['work_file_type' => 1, 'work_file_type_id' => $drop_down_file_info->work_file_type_id, 'work_file_order' => $drop_down_order];
        $after_work_file_id = $this->utility_model->get_table_information('work_file_id', 'tbl_work_files', $condition);
        if(isset($after_work_file_id)){
            $after_work_file_id = $after_work_file_id->work_file_id;
            // selected data set into top order data
            $top_data['work_file_order'] = $this->utility_model->get_table_information('work_file_order', 'tbl_work_files', ['work_file_id' => $this->selected_work_file_id])->work_file_order;
            $this->db->where('work_file_id', $after_work_file_id)->update('tbl_work_files', $top_data);
        }
        // set top order in selected order
        $selected_data['work_file_order'] = $drop_down_order;
        $this->db->where('work_file_id', $this->selected_work_file_id)->update('tbl_work_files', $selected_data);
    }

    /**
     * @Function            : get_target_work_file_id
     * @Description         : get work file ID which will be changed
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 04:42 PM
     * @Parameter           : Null
     * @Return              : Null    
     * @Status              : Available        
     * */
    function get_target_work_file_id() {
        $random_number = $this->input->post('random_number', TRUE);
        $filter_random_number = $this->tt_random_number->set_random_number($random_number)->filter_number('TT')->get_filter_number();
        $this->selected_work_file_id = $this->random_number_model->set_value(3, '', $filter_random_number)->get_type_id();
        return $this;
    }

    /**
     * @Function            : work_file_info_by_order
     * @Description         : get work file ID by order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-11-2016 04:59 PM
     * @Parameter           : $fld_name[selected field name], 
     *                        $type_id=>course ID/ Video COurse ID,
     *                        $order=>ASC/DESC
     * @Return              : Null    
     * @Status              : Available        
     * */
    function work_file_info_by_order($fld_name, $type_id, $order) {
        return $this->db->select($fld_name)->from('tbl_work_files')->where('work_file_type', 1)
                        ->where('work_file_type_id', $type_id)->order_by('work_file_order', $order)->get()->row();
    }

    /**
     * @Description         : get all work file for manage work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-11-2016 11:43 AM      
     * @Parameter           : $type[INTEGER]=>Course, VIdeo COurse
     *                        $field_name => selected field name
     *                        $limit=> work file limit 
     * */
    function get_all_work_file($field_name, $type, $limit, $search_input = '') {
        return $this->db->select($field_name)
                        ->from('tbl_work_files AS w')
                        ->join('tbl_course AS c', 'w.work_file_type_id = c.course_id')
                        ->where('w.work_file_type', $type)
                        ->like('c.course_name', $search_input)
                        ->group_by('work_file_type_id')->limit(10, $limit)->get()->result();
    }

    /**
     * @Description         : get total work file for manage work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 12-11-2016 11:43 AM      
     * @Parameter           : $type[INTEGER]=>Course, VIdeo COurse
     *                        $field_name => selected field name
     *                        $limit=> work file limit 
     * */
    function get_total_course_work_file($field_name, $type, $search_input = '') {
        return $this->db->select($field_name)
                        ->from('tbl_work_files AS w')
                        ->join('tbl_course AS c', 'w.work_file_type_id = c.course_id')
                        ->where('w.work_file_type', $type)
                        ->like('c.course_name', $search_input)
                        ->group_by('work_file_type_id')->count_all_results();
    }

    /**
     * @Description         : get course ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 15-11-2016 06:10 PM      
     * */
    function get_work_file_course_id() {
        $sql = "SELECT GROUP_CONCAT(DISTINCT(wf.work_file_type_id)) AS course_id
                FROM tbl_work_files AS wf WHERE wf.work_file_type = '1'";
        return $this->db->query($sql)->row()->course_id;
    }

    /**
     * @Description         : work file details for course details
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-11-2016 09:49 AM      
     * */
    function work_file_for_course_details() {
        $this->arr_data['work_files'] = $this->get_order_work_file_data('work_file_id,work_file_name,work_file_access_level,work_file_status', ['work_file_type' => 1, 'work_file_type_id' => $this->course_id]);
        if ($this->arr_data['work_files']) {
            foreach ($this->arr_data['work_files'] as $value) {
                $random_number = $this->utility_model
                                ->get_table_information('random_number', 'tbl_random', ['random_type' => 3, 'random_type_id' => $value->work_file_id])->random_number;
                $this->arr_data['file_random_id'][$value->work_file_id] = $this->tt_random_number
                                ->set_random_number($random_number)->filter_number('23')->get_filter_number();
            }
        }

        return $this->arr_data;
    }

    /**
     * @Function            : __destruct
     * @Description         : destroy all value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-10-2016 04:02 PM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available        
     * */
    public function __destruct() {
        if (!empty($this->work_file_folder_id)) {
            unset($this->work_file_folder_id);
        }
    }

}
