<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Video_Model extends CI_Model {
    /*
     * Save Video Management Information 
     * @Author          : Mahabub-A-Mawla
     * @function Name   : save_video_management_information
     * @paremeter       : none
     * @return          : none
     */

    public function save_video_management_information() {
        $sdata = array();
        $sdata['resource_person_id'] = $this->session->userdata('user_id');
        $sdata['video_folder_name'] = $this->input->post('video_folder_name', TRUE);
        $sdata['video_title'] = $this->input->post('video_title', TRUE);
        $sdata['video_url'] = $this->input->post('video_url', TRUE);
        $sdata['video_price'] = $this->input->post('video_price', TRUE);
        $sdata['video_work_files'] = $this->input->post('video_work_files', TRUE);
        $sdata['video_training_objectives'] = $this->input->post('video_training_objectives', TRUE);
        $sdata['video_training_outline'] = $this->input->post('video_training_outline', TRUE);
        $sdata['video_management_meta_description'] = $this->input->post('video_management_meta_description', TRUE);
//        $sdata['video_management_meta_keywords'] = $this->input->post('video_management_meta_keywords', TRUE);
        $sdata['video_management_author'] = $this->input->post('video_management_author', TRUE);
        $sdata['video_management_status'] = $this->input->post('video_status', TRUE);
        $sdata['video_permissions'] = $this->input->post('video_permissions', TRUE);
        $sdata['video_access_level'] = $this->input->post('video_access_level', TRUE);
        $sdata['video_language'] = $this->input->post('video_language', TRUE);


        /*
         * Manage Category or Other Category
         */
        $course_category = $this->input->post('group_type', TRUE);
        if ($course_category == 'other') {
            $ndata = array();
            $ndata['course_category_name'] = $this->input->post('group_other_type', TRUE);
            $this->db->insert('tbl_course_category', $ndata);
            $sdata['course_category_id'] = $this->db->insert_id();
        } else {
            $sdata['course_category_id'] = $this->input->post('group_type', TRUE);
        }

        $this->session->set_userdata($sdata);
        redirect('video/video_keyword');
    }

    public function save_video_keyword() {

        $selected_ans = '';
        foreach ($_POST['key_answer'] as $v_ans) {
            $selected_ans = $selected_ans . $v_ans . ' ';
        }

        $data = array();
        $data['person_id'] = $this->session->userdata('user_id');
        $data['video_folder_name'] = $this->session->userdata('video_folder_name');
        $data['video_title'] = $this->session->userdata('video_title');
        $data['url_id'] = $this->session->userdata('video_url');
        $data['video_price'] = $this->session->userdata('video_price');
        $data['video_work_files'] = $this->session->userdata('video_work_files');
        $data['video_training_objectives'] = $this->session->userdata('video_training_objectives');
        $data['video_training_outline'] = $this->session->userdata('video_training_outline');
        $data['video_management_meta_description'] = $this->session->userdata('video_management_meta_description');
        $data['video_management_keyword'] = $selected_ans;
        $data['video_management_author'] = $this->session->userdata('video_management_author');
        $data['video_management_status'] = $this->session->userdata('video_status');
//        $data['video_permissions'] = $this->session->userdata('video_permissions');
        $data['video_access_level'] = $this->session->userdata('video_access_level');
        $data['video_language'] = $this->session->userdata('video_language');
        $data['course_category_id'] = $this->session->userdata('course_category_id');
        mkdir('video_upload_folder/talhatraining_video' . '/' . $data['video_folder_name'], 0777, true);
//        echo '<pre>';
//        print_r($data);
//        exit();
        $this->db->insert('tbl_video_management', $data);

        $this->session->unset_userdata('video_folder_name');
        $this->session->unset_userdata('video_title');
        $this->session->unset_userdata('video_url');
        $this->session->unset_userdata('video_price');
        $this->session->unset_userdata('video_work_files');
        $this->session->unset_userdata('video_training_objectives');
        $this->session->unset_userdata('video_training_outline');
        $this->session->unset_userdata('video_management_meta_description');
        $this->session->unset_userdata('video_management_author');
        $this->session->unset_userdata('video_status');
        $this->session->unset_userdata('video_permissions');
        $this->session->unset_userdata('video_access_level');
        $this->session->unset_userdata('video_language');
        $this->session->unset_userdata('course_category_id');

        redirect('video/view_video');
    }

    public function save_upload_video_information($data) {
        $this->db->insert('tbl_upload_video', $data);
        $upload_video_id = $this->db->insert_id();
        return $upload_video_id;
    }

    public function save_upload_file_information($wdata) {
        $this->db->insert('tbl_work_files_management', $wdata);
    }

//    public function select_video_category($person_id) {
//        $sql = "SELECT * "
//                . " FROM "
//                . "     tbl_video_management as vm,"
//                . "     tbl_course_category as cc"
//                . " WHERE "
//                . "     vm.resource_person_id = $person_id"
//                . "    AND vm.course_category_id = cc.course_category_id";
//        $result = $this->db->query($sql)->result();
//        return $result;
//    }
    public function select_video_category($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_video_management');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_all_video_category() {
        $this->db->select('*');
        $this->db->from('tbl_video_management');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

//    public function select_video_access_info($video_id) {
//        $this->db->select('*');
//        $this->db->from('tbl_upload_video');
//        $this->db->where('upload_video_id', $video_id);
//        $this->db->where('upload_video_access_level', 1);
//        $query_result = $this->db->get();
//        $result = $query_result->row();
//        return $result;
//    }

    public function select_video_training_list($category_id = NULL) {
        $this->db->select('*');
        $this->db->from('tbl_video_management');
        if ($category_id) {
            $this->db->where('course_category_id', $category_id);
        }
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function select_all_video_item($category = null, $start, $limit, $status = null, $short = null) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_upload_video as uv, "
                . "     tbl_video_management as vm"
                . " WHERE "
                . "         uv.video_management_id = vm.video_management_id "
                . "     AND vm.course_category_id = cc.course_category_id";

        if ($limit != '' && $limit != 'all' && $start >= 0) {
            $sql .= " LIMIT $start, $limit ";
        }

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_video_management_info($video_management_id) {
        $this->db->select('*');
        $this->db->from('tbl_video_management');
        $this->db->where('video_management_id', $video_management_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function video_view_times($video_id) {
//        $this->db->set('upload_video_view', upload_video_view + 1);
//        $this->db->where('upload_video_id', $video_id);
//        $this->db->update('tbl_upload_video');
        $this->db->where('upload_video_id', $video_id);
        $this->db->set('upload_video_view', 'upload_video_view+1', FALSE);
        $this->db->update('tbl_upload_video');
    }

    public function select_video_by_id($video_id) {
        $this->db->select('*');
        $this->db->from('tbl_upload_video');
        $this->db->where('upload_video_id', $video_id);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_video_item_by_management_id($video_management_id) {
//        $sql = "SELECT * FROM tbl_upload_video as uv WHERE uv.video_management_id = $video_management_id";
//        $result = $this->db->query($sql)->result();
//        return $result;

        $this->db->select('*');
        $this->db->from('tbl_upload_video as uv');
        $this->db->where('uv.video_management_id', $video_management_id);
        $this->db->join('tbl_video_management as vm', 'vm.video_management_id = uv.video_management_id');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

//    public function select_video_item($video_management_id = null, $video_id) {
////        $sql = "SELECT * FROM tbl_upload_video as uv WHERE uv.video_management_id = $video_management_id AND uv.upload_video_id != $video_id";
////        $result = $this->db->query($sql)->result();
//          $this->db->select('*');
//        $this->db->from('tbl_upload_video as uv');
//        $this->db->where('uv.video_management_id', $video_management_id);
//        $this->db->join('tbl_video_management as vm', 'vm.video_management_id = uv.video_management_id');
//        $query_result = $this->db->get();
//        $result = $query_result->result();
//        
//        echo '<pre>';
//        print_r($result);
//        exit();
//        return $result;
//    }

    /*
     * Video Active, Inactive, Archive 
     */


    public function make_video_active($upload_video_id) {
        $this->db->set('upload_video_status', '1');
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    public function make_video_inactive($upload_video_id) {
        $this->db->set('upload_video_status', '0');
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    public function archive_video($upload_video_id) {
        $this->db->set('upload_video_status', '2');
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    /*
     * END Video Active, Inactive, Archive
     */

    public function select_all_video_management_item($category = null, $start, $limit, $status = null, $short = null) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_course_category as cc, "
                . "     tbl_upload_video as uv, "
                . "     tbl_video_management as vm,"
                . "     tbl_person as p"
                . " WHERE "
                . "         uv.video_management_id = vm.video_management_id "
                . "     AND p.person_id = vm.person_id "
                . "     AND vm.course_category_id = cc.course_category_id ";
        $sql .= " GROUP BY vm.video_management_id";
        if ($limit != '' && $limit != 'all' && $start >= 0) {
            $sql .= " LIMIT $start, $limit ";
        }

        $result = $this->db->query($sql)->result();
        return $result;
    }

    /*
     * Start Video Management Active, Inactive, Archive
     */

    public function make_video_management_active($video_management_id) {
        $this->db->set('video_management_status', '1');
        $this->db->where('video_management_id', $video_management_id);
        $this->db->update('tbl_video_management');
    }

    public function make_video_management_inactive($video_management_id) {
        $this->db->set('video_management_status', '0');
        $this->db->where('video_management_id', $video_management_id);
        $this->db->update('tbl_video_management');
    }

    public function archive_video_management($video_management_id) {
        $this->db->set('video_management_status', '2');
        $this->db->where('video_management_id', $video_management_id);
        $this->db->update('tbl_video_management');
    }

    /*
     * END Video Management Active, Inactive, Archive
     */

    public function member_comment_save($data) {
        $this->db->insert('tbl_comment', $data);
        $insert_id = $this->db->insert_id();
        return $insert_id;
    }

    public function select_post_comment_info_by_comment_id($post_comment_id) {
//        $sql = "SELECT c.*, pi.* FROM tbl_comment as c, tbl_post as p, tbl_person as pi WHERE c.post_comment_id = $post_comment_id AND c.post_id = p.post_id AND c.post_comment_by = pi.person_id ";
//        $query_result = $this->db->query($sql);
//        $result = $query_result->row();
////        echo $sql;
////        exit();
//        return $result;


        $this->db->select('*');
        $this->db->from('tbl_comment as c');
        $this->db->where('c.post_comment_id', $post_comment_id);
        $this->db->join('tbl_person as p', 'p.person_id = c.post_comment_by');
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function select_video_comment_info_by_video_id($video_id) {

        $this->db->select('*');
        $this->db->from('tbl_comment as c');
        $this->db->where('c.upload_video_id', $video_id);
        $this->db->join('tbl_person as p', 'p.person_id = c.post_comment_by');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function student_link_person_info($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm,"
                . "     tbl_course_category as cc"
                . " WHERE "
                . "     vm.person_id = $person_id"
                . "    AND vm.course_category_id = cc.course_category_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function comment_replay_save($data) {
        $this->db->insert('tbl_comment_replay', $data);
        $insert_id = $this->db->insert_id();
        return $insert_id;
    }

    public function select_reply_comment_info_by_id($comment_replay_id) {

        $this->db->select('*');
        $this->db->from('tbl_comment_replay as cr');
        $this->db->where('cr.comment_replay_id', $comment_replay_id);
        $this->db->join('tbl_person as p', 'p.person_id = cr.comment_replay_by');
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

//        public function select_video_comment_reply_info_by_video_id($video_id) {
//
//        $this->db->select('*');
//        $this->db->from('tbl_comment_replay as cr');
//        $this->db->where('cr.upload_video_id', $video_id);
//        $this->db->join('tbl_person as p', 'p.person_id = cr.comment_replay_by');
//        $query_result = $this->db->get();
//        $result = $query_result->result();
//        return $result;
//    }
    public function select_video_comment_reply_info($post_comment_id) {

        $this->db->select('*');
        $this->db->from('tbl_comment_replay as cr');
        $this->db->where('cr.post_comment_id', $post_comment_id);
        $this->db->join('tbl_person as p', 'p.person_id = cr.comment_replay_by');
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    public function save_discuss_message($data) {
        $this->db->insert('tbl_message', $data);
    }

    public function select_free_video() {

        $this->db->select('*');
        $this->db->from('tbl_upload_video');
        $this->db->where('upload_video_access_level', 1);
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function selected_video_resource_person_info($video_id) {

        $this->db->select('*');
        $this->db->from('tbl_upload_video as uv');
        $this->db->where('uv.upload_video_id', $video_id);
        $this->db->join('tbl_video_management as vm', 'uv.video_management_id = vm.video_management_id');
        $this->db->join('tbl_person as p', 'p.person_id = vm.person_id');
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function selected_related_video_info($video_keyword) {

        $tdata['video_title_key'] = (explode(" ", $video_keyword));
        $video_key = $tdata['video_title_key'];

        foreach ($video_key as $v_video_key) {
            $this->db->select('*');
            $this->db->from('tbl_video_management');
            $this->db->like('video_management_keyword', $v_video_key);
            $query_result = $this->db->get();
            $result = $query_result->result();
        }

        return $result;
    }

    public function all_related_video_info($video_management_id) {

        $this->db->select('*');
        $this->db->from('tbl_upload_video as uv');
        $this->db->where('uv.video_management_id', $video_management_id);
        $this->db->join('tbl_video_management as vm', 'uv.video_management_id = vm.video_management_id');
        $this->db->join('tbl_person as p', 'p.person_id = vm.person_id');
        $query_result = $this->db->get();
        $result = $query_result->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }
    
    function get_video_course_category_id($category_id){
        $category_id_array = Array();
        $result = $this->get_video_category_id($category_id);
        
        foreach($result as $value){
            $category_id_array[] = $value->course_category_id;
        }
        return $category_id_array;
    }
    
    function get_video_category_id($category_id){
        $this->db->select('course_category_id')
                ->from('tbl_video_management')
                ->where('course_category_id', $category_id);
        return $this->db->get()->result();
    }

}
