<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of user_video_model
 *
 * @author User
 */
class User_video_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

//
//    /**
//     * @Function            : get_video_course_side_content 
//     * @Used IN             : @function-'add_video_course'      user_video[@Controller] - [41]
//     * @Description         : get side content in video course
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 23-04-2016 06:03 PM  
//     * @Parameter           : $data[ARRAY], $side_status1[INTEGER], $side_status2[INTEGER]
//     * @Return              : $data[ARRAY]    
//     * @Status              : Available        
//     * */
//    function get_video_course_side_content($data, $side_status1, $side_status2) {
//        $data['active_menu'] = $this->session->userdata('active_menu');
//        $data['active_sub_menu'] = $this->session->userdata('active_sub_menu');
//        $data['left_side_menu_view'] = $side_status1;
//        $data['left_side'] = $side_status2;
//        return $data;
//    }
//
//    /**
//     * @Function            : get_information_for_add_video_course 
//     * @Used IN             : @function-'add_video_course'      user_video[@Controller] - [46]
//     * @Description         : get required information for add video course
//     * @Developed By        : MD Jaherul Islam
//     * @Start DateTime      : 24-04-2016 06:03 PM  
//     * @Parameter           : $pdata[ARRAY]
//     * @Return              : $pdata[ARRAY]    
//     * @Status              : Available        
//     * */
//    function get_information_for_add_video_course($pdata) {
//        $pdata['resource_person_info'] = $this->person_model->select_resource_person_information_by_person_id($pdata['person_info']->person_id);
//        $pdata['feature_info'] = $this->super_admin_feature_model->check_course_feature_information($pdata['person_info']->person_id);
//        if ($pdata['feature_info']) {
//            $pdata['feature_price_status'] = $pdata['feature_info']->feature_price_status;
//        } else {
//            $pdata['feature_price_status'] = '';
//        }
//        return $pdata;
//    }

    /**
     * @Function            : get_information_for_video_course 
     * @Used IN             : @function-'organization_video'     user_video[@controller]
     * @Description         : get all available course using category ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 09:52 AM
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_information_for_video_course($data) {
        if ($data['person_info']->person_role == 3) {
            $data['resource_person_info'] = $this->resource_person_model->select_resource_person_information_by_person_id($data['person_info']->person_id);
            if ($data['resource_person_info']->resource_person_type == 1) {
                $data['person_info'] = $this->person_model->get_single_person_information_by_person_id(1);
                return $data;
            } else if ($data['resource_person_info']->resource_person_type == 2) {
                 return $data;
            } else if ($data['resource_person_info']->resource_person_type == 3) {
                $data['person_info'] = $this->person_model->select_person_information_by_organization_id($data['resource_person_info']->organization_id);
                 return $data;
            }
        } else if ($data['person_info']->person_role == 4) {
            $data['resource_person_info'] = $this->resource_person_model->select_resource_person_information_by_person_id($data['person_info']->person_id);
             return $data;
        }
    }

    /**
     * @Function            : get_feature_information_for_course 
     * @Used IN             : @function-'get_information_for_course'           this[@Model]
     * @Description         : get feature information for course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-05-2016 10:42 AM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_feature_information_for_course($data) {
        $data['feature_info'] = $this->super_admin_feature_model->check_course_feature_information($data['person_info']->person_id);
        if ($data['feature_info']) {
            $data['feature_price_status'] = $data['feature_info']->feature_price_status;
            $data['feature_storage'] = $data['feature_info']->feature_price_storage * 1024 * 1024 * 1024;
            $data['used_storage'] = $this->person_model->get_person_used_storage($data['person_info']->person_id);
        } else {
            $data['feature_price_status'] = '';
            $data['feature_storage'] = '';
            $data['used_storage'] = $this->person_model->get_person_used_storage($data['person_info']->person_id);
        }
        return $data;
    }

    /*
      -----------@@@RIPON@ Start Add Video Course Part----------------------------------
     */

    /**
     * @Function            : save_video_course_information 
     * @Used IN             : @function-'add_video_course'     user_video[@controller] - [56]
     * @Description         : save video course information  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-04-2016 03:54 PM
     * @Parameter           : $person_info[STRING]
     * @Return              : $video_course_id[INTEGER]    
     * @Status              : Available       
     * */
    public function save_video_course_information($data) {
        $video_data['person_id'] = $data['person_info']->person_id;
        $video_data['video_course_title'] = $this->input->post('video_course_title', TRUE);
        $video_data['video_management_level'] = $this->input->post('video_course_level', TRUE);
        $video_data['video_course_upload_video_type'] = $this->input->post('video_course_upload_video_type', TRUE);
        $video_data['video_access_level'] = $this->input->post('video_course_access_level', TRUE);
        $video_data['video_language'] = $this->input->post('video_course_language', TRUE);
        $video_data['menu_id'] = 0;
        if ($data['resource_person_info']->person_special_permission == 1) {
            $video_data['video_management_status'] = 4;
        } else {
            $video_data['video_management_status'] = 5;
        }
        $video_data_info = $this->get_video_course_information($video_data, $data);
        
        return $this->utility_model->save_information_in_database('tbl_video_management', $video_data_info);
    }

    /**
     * @Function            : get_video_course_information 
     * @Used IN             : @function-'save_video_course_information'     this[@Model] - [77]
     * @Description         : save video course information which have multiple function 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-04-2016 03:54 PM
     * @Parameter           : $video_data[ARRAY],$person_info[STRING]
     * @Return              : $video_data[ARRAY]  
     * @Status              : Available       
     * */
    function get_video_course_information($video_data, $data) {
        $video_data['course_category_id'] = $this->category_model->save_category($data['person_info']->person_id, $this->input->post('category_id', TRUE));
        $video_data['url_id'] = $this->url_model->save_vedio_url($this->input->post('video_course_url', TRUE));
        $video_data['resource_person_id'] = $this->person_model->save_resource_person_id_for_video_course($data, $this->input->post('resource_person_id', TRUE));
        
        $video_data['video_folder_name'] = $this->create_video_course_folder($data['person_info']->url, $this->input->post('video_course_folder_name', TRUE));
        
        if ($this->input->post('video_course_objectives', FALSE) != '') {
            $video_data['video_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($this->input->post('video_course_objectives', FALSE));
        }
        if ($this->input->post('video_course_outline', FALSE) != '') {
            $video_data['video_training_outline'] = $this->tinymce_model->changed_special_character_to_text($this->input->post('video_course_outline', FALSE));
        }
        $video_data_info = $this->get_video_course_type_information($video_data);
        return $video_data_info;
    }

    function get_video_course_type_information($video_data) {
        if ($this->input->post('video_course_type', TRUE) != '') {
            $video_data['video_course_type'] = $this->input->post('video_course_type', TRUE);
            if ($video_data['video_course_type'] == 1) {
                $video_data['video_course_price_currency'] = $this->input->post('video_course_price_currency', TRUE);
                $video_data['video_course_price'] = $this->input->post('video_course_price', TRUE);
            }
        } else {
            $video_data['video_course_type'] = 2;
        }
        return $video_data;
    }

    /**
     * @Function            : save_video_access_permission 
     * @Used IN             : @function-'save_video_course_information'    this[@Model] - [82]
     * @Description         : save video permisssion if user select group or special user
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-03-2016 10:03 PM
     * @Parameter           : $video_course_id[INTEGER], $vdata{ARRAY}
     * @Return              : NULL    
     * @Status              : available      
     * */
    function save_video_access_permission($video_course_id, $vdata) {
        if ($vdata['video_access_level'] == 4) {
            $gData['course_id'] = $video_course_id;
            $gData['group_id'] = $this->input->post('hidden_search_group_name', TRUE);
            $gData['course_group_type'] = 2;
            $this->db->insert('tbl_course_group_permission', $gData);
        } else if ($vdata['video_access_level'] == 5) {
            $pData['course_id'] = $video_course_id;
            $pData['person_id'] = $this->input->post('hidden_special_user_name', TRUE);
            $pData['course_person_type'] = 2;
            $this->db->insert('tbl_course_person_permission', $pData);
        }
    }

    /**
     * @Function            : create_video_course_folder 
     * @Used IN             : @function-'save_video_course_information1'    this[@Model] - [102]
     * @Description         : create video course folder
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-03-2016 10:03 PM
     * @Parameter           : $person_url[STRING], $video_folder_name[STRING]
     * @Return              : $video_folder_name[STRING]    
     * @Status              : available      
     * */
    function create_video_course_folder($person_url, $video_folder_name) {
        $folder = 'content-library/' . $person_url . '/my-video/' . $video_folder_name . '/';
        if (!file_exists($folder)) {
            mkdir($folder, 0777, true);
        }
        return $video_folder_name;
    }

    /**
     * @Function            : check_video_folder_name 
     * @Used IN             : @function-'get_course_value'         super_admin_course[@controller]
     * @                    : @function-'check_video_folder_name'  user_video[@controller] - [211]
     * @Description         : validate video course folder existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-04-2016 03:36 PM  
     * @Parameter           : $video_folder_name[STRING]
     * @Return              : video_course_info    
     * @Status              : Available        
     * */
    public function check_video_folder_name($video_folder_name, $person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_video_management AS vm
                WHERE 
                    vm.person_id = '$person_id'
                AND vm.video_folder_name = '$video_folder_name'";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@ End Add Video Course Part----------------------------------
     */







    /*
      -----------@@@RIPON@ Start Video Course View Part (organization & Teacher)----------------------------------
     */

    /**
     * @Function            : get_all_video_course_value 
     * @Used IN             : @function-'organization_video'   user_video[@controller]
     * @Description         : get all video course value if video course as Draft,Pending, Active or Apporved
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 12:24 PM  
     * @Parameter           : $data[ARRAY], $person_role[INTEGER], $limit[INTEGER]
     * @Return              : $active_course_data[ARRAY]    
     * @Status              : Available        
     * */
    function get_all_video_course_value($data, $person_role, $limit) {
        $active_course_status = '1,4';
        if ($person_role == 4) {
            $draft_course_data = $this->select_all_draft_video_courses($data, $data['person_info']->person_id, 5, $limit, '');
            $submit_course_data = $this->select_all_submit_video_courses($draft_course_data, $data['person_info']->person_id, 3, $limit, '');
            $active_course_data = $this->select_all_active_video_courses($submit_course_data, $data['person_info']->person_id, $active_course_status, $limit, '');
        } else {
            $draft_course_data = $this->select_all_draft_video_courses($data, $data['person_info']->person_id, 5, $limit, $data['resource_person_info']->resource_person_id);
            $submit_course_data = $this->select_all_submit_video_courses($draft_course_data, $data['person_info']->person_id, 3, $limit, $data['resource_person_info']->resource_person_id);
            $active_course_data = $this->select_all_active_video_courses($submit_course_data, $data['person_info']->person_id, $active_course_status, $limit, $data['resource_person_info']->resource_person_id);
        }
        return $active_course_data;
    }

    /**
     * @Function            : select_all_draft_video_courses 
     * @Used IN             : @function-'get_all_video_course_value'              this[@Model] (2)
     * @                    : @function-'view_draft_course_for_ajax_view'   user_course[@Controller] (2)
     * @Description         : Select all draft video coursea
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 12:46 AM  
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_draft_course[ARRAY]    
     * @Status              : Available        
     * */
    function select_all_draft_video_courses($data, $person_id, $status, $limit, $resource_person_id) {
        $data['draft_video_courses'] = $this->select_all_video_courses($person_id, $status, $limit, $resource_person_id);
        $data['total_draft_video_courses'] = $this->get_total_video_course($person_id, $status, $resource_person_id);
        return $data;
    }

    /**
     * @Function            : select_all_submit_video_courses 
     * @Used IN             : @function-'get_all_video_course_value'                   this[@Model] (2)
     *                      : @function-'view_submission_course_for_ajax_view'   user_course[@Controller] (2)
     * @Description         : Select all pending video coursea
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 12:53 PM  
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_pending_course[ARRAY]    
     * @Status              : Available        
     * */
    function select_all_submit_video_courses($data, $person_id, $status, $limit, $resource_person_id) {
        $data['submit_video_courses'] = $this->select_all_video_courses($person_id, $status, $limit, $resource_person_id);
        $data['total_submit_video_courses'] = $this->get_total_video_course($person_id, $status, $resource_person_id);
        return $data;
    }

    /**
     * @Function            : select_all_active_video_courses 
     * @Used IN             : @function-'get_all_video_course_value'            this[@Model] (2)
     *                      : @function-'view_active_course_for_ajax_view'   user_course[@Controller] (2)
     * @Description         : Select all pending video coursea
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 12:56 PM  
     * @Parameter           : $data[ARRAY], $person_id[INTEGER], $status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_active_or_apporved_course[ARRAY]    
     * @Status              : Available        
     * */
    function select_all_active_video_courses($data, $person_id, $status, $limit, $resource_person_id) {
        $data['active_video_courses'] = $this->select_all_video_courses($person_id, $status, $limit, $resource_person_id);
        $data['total_active_video_courses'] = $this->get_total_video_course($person_id, $status, $resource_person_id);
        return $data;
    }

    /**
     * @Function            : select_all_video_courses 
     * @Used IN             : @function-'select_all_draft_video_courses'    this[@Model]
     * @                    : @function-'select_all_submit_courses'   this[@Model]
     * @                    : @function-'select_all_active_courses'   this[@Model]
     * @Description         : Select all video courses with some condition
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 12:33 PM  
     * @Parameter           : $person_id[INTEGER], $course_status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $all_course[ARRAY]    
     * @Status              : Available        
     * */
    function select_all_video_courses($person_id, $course_status, $limit, $resource_person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_video_management AS vm,
                    tbl_url AS u
                WHERE 
                    vm.person_id = '$person_id'";
        if ($resource_person_id != '') {
            $sql.=" AND vm.resource_person_id = '$resource_person_id'";
        }
        $sql.=" AND vm.video_management_status IN ($course_status)
                AND vm.url_id = u.url_id
                AND u.url_type = '8'
                LIMIT $limit,10;";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_video_course 
     * @Used IN             : @function-'select_all_draft_video_courses'    this[@Model]
     * @                    : @function-'select_all_submit_courses'   this[@Model]
     * @                    : @function-'select_all_active_courses'   this[@Model]
     * @Description         : Select total video courses with some condition
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-05-2016 11:43 AM  
     * @Parameter           : $person_id[INTEGER], $course_status[INTEGER],$limit[INTEGER],$resource_person_id[INTEGER]
     * @Return              : $total_course[INTEGER]    
     * @Status              : Available        
     * */
    function get_total_video_course($person_id, $course_status, $resource_person_id) {
        $sql = "SELECT count(*) AS total 
                FROM 
                    tbl_video_management AS vm
                WHERE 
                    vm.person_id = '$person_id'";
        if ($resource_person_id != '') {
            $sql.=" AND vm.resource_person_id = '$resource_person_id'";
        }
        $sql.=" AND vm.video_management_status IN ($course_status)";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@ Start Video Course View Part (organization & Teacher)----------------------------------
     */







    /*
      -----------@@@RIPON@ Start Learner Video Course View Part----------------------------------
     */

    /**
     * @Function            : get_free_video_course_value 
     * @Used IN             : @function-'learner_video'       user_video[@Controller]
     * @Description         : select free video course value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 11:13 AM
     * @Parameter           : $data[ARRAY],$person_id[INTEGER],$limit[INTEGER]
     * @Return              : free_video_course_list  
     * @Status              : available      
     * */
    function get_free_video_course_value($data, $person_id, $limit) {
        $data['free_courses'] = $this->select_learner_free_video_course_list($person_id, $limit);
        $data['total_free_courses'] = $this->select_learner_total_free_video_course_list($person_id);
        return $data;
    }

    /**
     * @Function            : select_learner_free_video_course_list 
     * @Used IN             : @function-'get_free_video_course_value'       this[@Model]
     * @Description         : select free video course list by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-05-2016 01:05 PM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : free_video_course_list  
     * @Status              : available      
     * */
    function select_learner_free_video_course_list($person_id, $limit) {
        $sql = "SELECT *, vm.person_id AS course_creator_id
                FROM 
                    tbl_student AS s,
                    tbl_video_management AS vm,
                    tbl_url AS u,
                    tbl_person AS p
                WHERE 
                    s.person_id = '$person_id'
                AND s.student_course_type = '2'
                AND s.course_id = vm.video_management_id
                AND vm.url_id = u.url_id
                AND u.url_type = '8'
                AND vm.person_id = p.person_id 
                LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_learner_total_free_video_course_list 
     * @Used IN             : @function-'get_free_video_course_value'       this[@Model]
     * @Description         : select total free video course list by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 11:11 AM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : total_free_video_course  
     * @Status              : available      
     * */
    function select_learner_total_free_video_course_list($person_id) {
        $sql = "SELECT count(*) AS total
                FROM 
                    tbl_student AS s
                WHERE 
                    s.person_id = '$person_id'
                AND s.student_course_type = '2'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_register_video_course_value 
     * @Used IN             : @function-'learner_video'       user_video[@Controller]
     * @Description         : select register video course value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 11:18 AM
     * @Parameter           : $data[ARRAY],$person_id[INTEGER],$limit[INTEGER]
     * @Return              : free_video_course_list  
     * @Status              : available      
     * */
    function get_register_video_course_value($data, $person_id, $limit) {
        $data['registered_courses'] = $this->select_learner_register_video_course_list($person_id, $limit);
        $data['total_registered_course'] = $this->select_learner_total_register_video_course_list($person_id);
        return $data;
    }

    /**
     * @Function            : select_learner_register_video_course_list 
     * @Used IN             : @function-'get_register_video_course_value'       this[@Model]
     * @Description         : select register video course list by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-05-2016 01:51 PM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : register_video_course_list  
     * @Status              : available      
     * */
    function select_learner_register_video_course_list($person_id, $limit) {
        $sql = "SELECT *,vm.person_id AS course_creator_id
                FROM 
                    tbl_payment AS py,
                    tbl_video_management AS vm,
                    tbl_url AS u,
                    tbl_person AS p
                WHERE 
                    py.person_id = '$person_id'
                AND py.payment_type = '2'
                AND py.payment_status IN (3,6)
                AND py.payment_type_id = vm.video_management_id
                AND vm.url_id = u.url_id
                AND py.person_id = p.person_id 
                LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_learner_total_register_video_course_list 
     * @Used IN             : @function-'get_register_video_course_value'       this[@Model]
     * @Description         : select total register video course list by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 11:22 AM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : register_video_course_list  
     * @Status              : available      
     * */
    function select_learner_total_register_video_course_list($person_id) {
        $sql = "SELECT count(*) AS total
                FROM 
                    tbl_payment AS py
                WHERE 
                    py.person_id = '$person_id'
                AND py.payment_type = '2'
                AND py.payment_status IN (3,6)";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@ End Learner Video Course View Part----------------------------------
     */

//    @@@@@@@@ it must be deleted after complete all function video course@@@@@@@@@@@@@@@@
    //put your code here
    /**
     * @Function            : select_category_course
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 14-07-2015 05:00 PM   | 
     * @Updated Date Time   : dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Name                  |
     * @parameter           : $category_id
     * @return              : $result array
     * @redirect            : no
     * */
    public function select_video_course_by_id($video_management_id) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u "
                . "WHERE "
                . "         vm.video_management_id = '$video_management_id'"
                . "     AND vm.video_management_status = 1 "
                . "     AND u.url_id = vm.url_id"
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    /**
     * @Function            : select_category_course
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 14-07-2015 05:00 PM   | 
     * @Updated Date Time   : dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Name                  |
     * @parameter           : $category_id
     * @return              : $result array
     * @redirect            : no
     * */
    public function select_video_course_by_url($video_course_url) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u, "
                . "     (SELECT p.*, ur.url as p_url FROM tbl_person as p, tbl_url as ur WHERE ur.url_id = p.url_id ) as p_info "
                . " WHERE "
                . "         u.url = '$video_course_url' "
                . "     AND u.url_id = vm.url_id "
                . "     AND p_info.person_id = vm.person_id "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_active_video_course_by_url($video_course_url) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u, "
                . "     (SELECT p.*, ur.url as p_url FROM tbl_person as p, tbl_url as ur WHERE ur.url_id = p.url_id ) as p_info "
                . " WHERE "
                . "         u.url = '$video_course_url' "
                . "     AND u.url_id = vm.url_id "
                . "     AND (vm.video_management_status = 1 OR vm.video_management_status = 4)"
                . "     AND p_info.person_id = vm.person_id "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($sql);
//        exit();
        return $result;
    }

    public function select_active_video_course_by_id($video_management_id) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u"
                . " WHERE "
                . "         vm.video_management_id = '$video_management_id' "
                . "     AND u.url_id = vm.url_id "
                . "     AND (vm.video_management_status = 1 OR vm.video_management_status = 4)"
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($sql);
//        exit();
        return $result;
    }

    /**
     * @Function            : select_category_course
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 14-07-2015 05:00 PM   | 
     * @Updated Date Time   : dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Name                  |
     * @parameter           : $category_id
     * @return              : $result array
     * @redirect            : no
     * */
    public function select_releted_video_course($video_course_title, $video_name, $video_management_id) {
        $clean_title = $this->cf->make_word_array($video_course_title);
        $keywords[] = explode('-', $clean_title);
        $clean_video_name = $this->cf->make_word_array($video_name);
        $keywords[] = explode('-', $clean_video_name);
        $keywords = array_merge($keywords[0], $keywords[1]);
//        echo '<pre>';
//        print_r($keywords);
//        exit();

        $sql = "SELECT *, u.url as vm_url
                FROM 
                    tbl_video_management as vm,
                    tbl_url as u,
                    tbl_upload_video as uv 
                WHERE 
                    ( vm.course_category_id = '' "
        ;

        for ($i = 0; $i < count($keywords); $i++) {
            $sql .=" OR vm.video_course_title LIKE '%" . $keywords[$i] . "%' ";
            $sql .=" OR vm.video_folder_name LIKE '%" . $keywords[$i] . "%' ";
            $sql .=" OR uv.upload_video_name LIKE '%" . $keywords[$i] . "%' ";
        }

        $sql .= " ) AND u.url_id = vm.url_id "
                . " AND vm.video_management_id = uv.video_management_id "
                . " AND vm.video_management_id NOT IN ('$video_management_id')";

//        echo '<pre>';
//        print_r($sql);
//        exit();

        $result = $this->db->query($sql)->result();

//        $sql2 = "  SELECT * "
//                . " FROM tbl_upload_video as uv, "
//                . "      $sql "
//                . " WHERE "
//                . "          uv.video_management_id = new_table.video_management_id "
//                . " ORDER BY uv.upload_video_view DESC";
//        echo '<pre>';
//        print_r($result);
//        exit();

        return $result;
    }

    public function select_video_management_section($video_management_id) {
        $sql = "SELECT DISTINCT uv.upload_video_section_name  "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_status = 1 "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($video_management_id);
//        exit();
        return $result;
    }

    public function check_section_name_exist($section_name, $video_management_id) {
        $sql = "SELECT DISTINCT uv.upload_video_section_name  "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_section_name = '$section_name'"
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($sql);
//        print_r($result);
//        exit();
        return $result;
    }

    public function check_section_name_exist_for_all_video_in_a_section($section_name, $video_management_id, $upload_video_id) {
        $sql = "SELECT *  "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_section_name = '$section_name'"
                . "     AND uv.upload_video_id = '$upload_video_id'"
        ;
//        echo '<pre>';
//        print_r($sql);
//        exit();
        $result = $this->db->query($sql)->result();
        if (!$result) {
            $sql = "SELECT DISTINCT uv.upload_video_section_name  "
                    . " FROM tbl_upload_video as uv "
                    . " WHERE "
                    . "         uv.video_management_id = '$video_management_id' "
                    . "     AND uv.upload_video_section_name = '$section_name'"
            ;
            $result = $this->db->query($sql)->result();
            return $result;
        } else {
            return false;
        }
    }

    public function check_video_file_name_exist($upload_video_name, $video_management_id, $upload_video_section_name) {
        $sql = "SELECT DISTINCT uv.upload_video_section_name  "
                . " FROM "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_name = '$upload_video_name'"
                . "     AND uv.upload_video_section_name = '$upload_video_section_name'"
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($video_management_id);
//        print_r($upload_video_section_name);
//        print_r($upload_video_name);
//        print_r($result);
//        exit();
        return $result;
    }

    public function check_video_file_name_with_upload_video_id($upload_video_name, $video_management_id, $upload_video_id) {
        $sql = "SELECT DISTINCT uv.upload_video_section_name  "
                . " FROM "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_id != '$upload_video_id' "
                . "     AND uv.upload_video_name = '$upload_video_name'"
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function check_video_work_file_name_exist($work_files_name, $video_management_id, $upload_video_id) {

        $sql = "SELECT *  "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
        ;
        $video_management_info = $this->db->query($sql)->result();

        $all_upload_video_id = '';
        foreach ($video_management_info as $value) {
            $all_upload_video_id .= $value->upload_video_id . ', ';
        }
//        echo '<pre>';
//        print_r($sql);
        $sql = "SELECT * "
                . " FROM tbl_work_files_management as wfm "
                . " WHERE "
                . "         wfm.work_files_name = '$work_files_name'"
                . "     AND wfm.upload_video_id != '$upload_video_id'"
                . "     AND wfm.upload_video_id IN ($all_upload_video_id 0)"
        ;
        $result = $this->db->query($sql)->result();
//        print_r($sql);
//        exit();
        return $result;
    }

    public function check_video_work_file_name_exist_under_section($work_files_name, $video_management_id, $upload_video_id, $section_name) {

        $sql = "SELECT *  "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_section_name = '$section_name'"
        ;
        $video_management_info = $this->db->query($sql)->result();

        $all_upload_video_id = '';
        foreach ($video_management_info as $value) {
            $all_upload_video_id .= $value->upload_video_id . ', ';
        }
//        echo '<pre>';
//        print_r($sql);
        $sql = "SELECT * "
                . " FROM tbl_work_files_management as wfm "
                . " WHERE "
                . "         wfm.work_files_name = '$work_files_name'"
                . "     AND wfm.upload_video_id != '$upload_video_id'"
                . "     AND wfm.upload_video_id IN ($all_upload_video_id 0)"
        ;
        $result = $this->db->query($sql)->result();
//        print_r($sql);
//        exit();
        return $result;
    }

    public function select_draft_and_active_video_management_section($video_management_id) {
        $sql = "SELECT DISTINCT uv.upload_video_section_name  "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND (uv.upload_video_status = 1 "
                . "     OR uv.upload_video_status = 5) "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($sql);
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_course_videos($video_management_id, $video_section_name) {
        $sql = "SELECT * "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_section_name = '$video_section_name'"
                . "     AND uv.upload_video_status = 1 "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_course_draft_and_active_videos($video_management_id, $video_section_name) {
        $sql = "SELECT * "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_section_name = '$video_section_name'"
                . "     AND (uv.upload_video_status = 1 "
                . "     OR uv.upload_video_status = 5) "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_by_id($upload_video_id) {
        $sql = "SELECT * "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.upload_video_id = '$upload_video_id' "
                . "     AND uv.upload_video_status = 1 "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_by_management_id_and_video_id($upload_video_id, $video_management_id) {
        $sql = "SELECT * "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.upload_video_id = '$upload_video_id' "
                . "     AND uv.video_management_id = '$video_management_id' "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video($upload_video_id) {
        $sql = "SELECT * "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.upload_video_id = '$upload_video_id' "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_work_file_by_id($work_files_management_id) {
        $sql = "SELECT * "
                . " FROM tbl_work_files_management as wfm "
                . " WHERE "
                . "         wfm.work_files_management_id = '$work_files_management_id' "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_draft_and_active_video_by_id($upload_video_id) {
        $sql = "SELECT * "
                . " FROM tbl_upload_video as uv "
                . " WHERE "
                . "         uv.upload_video_id = '$upload_video_id' "
                . "     AND (uv.upload_video_status = 1 "
                . "     OR  uv.upload_video_status = 5 )"
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_draft_and_active_video_work_file_by_id($work_files_management_id) {
        $sql = "SELECT * "
                . " FROM tbl_work_files_management as wfm "
                . " WHERE "
                . "         wfm.work_files_management_id = '$work_files_management_id' "
                . "     AND (wfm.work_files_status = 1 "
                . "     OR  wfm.work_files_status = 3 )"
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_by_name_and_course_id($upload_video_id, $video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_upload_video as uv, "
                . "     tbl_video_management as vm "
                . " WHERE "
                . "         uv.upload_video_id = '$upload_video_id' "
                . "     AND uv.video_management_id = vm.video_management_id "
                . "     AND uv.upload_video_status = 1 "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_course_all_video_by_url($url) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_management as vm, "
                . "     tbl_url as u,"
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         u.url = '$url' "
                . "     AND vm.url_id = u.url_id "
                . "     AND vm.video_management_id = uv.video_management_id"
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_upload_video_work_files($upload_video_id) {
        $sql = "SELECT * "
                . "FROM tbl_work_files_management as wf "
                . " WHERE "
                . "         wf.upload_video_id = '$upload_video_id' "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    /**
     * @Function            : select_person_all_video_management
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 2016-01-19 08:02 PM   | 
     * @Updated Date Time   : dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Name                  |
     * @parameter           : $work_files_management_id
     * @return              : ROW
     * @redirect            : no
     * */
    public function select_video_work_file_info($work_files_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_work_files_management as wfm "
                . " WHERE "
                . "     wfm.work_files_management_id = '$work_files_management_id' "
        ;
        $result = $this->db->query($sql)->row();

//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    /**
     * @Function            : select_person_all_video_management
     * @Developed By        : Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> | 
     * @DevelopeDateTime    : 14-07-2015 05:00 PM   | 
     * @Updated Date Time   : dd-mm-yyyy hh:mm AM   |
     * @Updated By          : Name                  |
     * @parameter           : $category_id
     * @return              : $result array
     * @redirect            : no
     * */
    public function select_person_all_video_management($person_id) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u "
                . "WHERE "
                . "         vm.person_id = '$person_id' "
                . "     AND (vm.video_management_status = 1 OR vm.video_management_status = 0) "
                . "     AND u.url_id = vm.url_id "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_inactive_video_management($person_id) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u "
                . "WHERE "
                . "         vm.person_id = '$person_id' "
                . "     AND vm.video_management_status = 0"
                . "     AND u.url_id = vm.url_id "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_active_video_management($person_id) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u "
                . "WHERE "
                . "         vm.person_id = '$person_id' "
                . "     AND vm.video_management_status = 1"
                . "     AND u.url_id = vm.url_id "
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_person_pending_video_management($person_id, $resource_person_id = NULL) {
        $sql = "SELECT * 
                FROM tbl_video_management as vm, 
		tbl_url as u            
                 WHERE 
                    (vm.person_id = '$person_id' OR vm.resource_person_id = '$resource_person_id')
		AND vm.video_management_status = '3'
		AND u.url_id = vm.url_id ";
        return $this->db->query($sql)->result();
    }

    public function select_person_approved_video_management($person_id, $resource_person_id = NULL) {
        $sql = "SELECT * 
                FROM tbl_video_management as vm, 
		tbl_url as u            
                 WHERE 
                    (vm.person_id = '$person_id' OR vm.resource_person_id = '$resource_person_id')
		AND vm.video_management_status IN (1,4)
		AND u.url_id = vm.url_id ";
        return $this->db->query($sql)->result();
    }

    public function select_person_draft_video_management($person_id, $resource_person_id = NULL) {
        $sql = "SELECT * 
                FROM tbl_video_management as vm, 
		tbl_url as u            
                 WHERE 
                    (vm.person_id = '$person_id' OR vm.resource_person_id = '$resource_person_id')
		AND vm.video_management_status = '5'
		AND u.url_id = vm.url_id ";
        return $this->db->query($sql)->result();
    }

    public function select_video_management_by_url($video_url) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u "
                . "WHERE "
                . "         u.url = '$video_url' "
//                . "     AND (vm.video_management_status = 1 OR vm.video_management_status = 0)"
                . "     AND u.url_id = vm.url_id "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_management_by_id($video_management_id) {
        $sql = "SELECT * "
                . "FROM tbl_video_management as vm, tbl_url as u "
                . "WHERE "
                . "         vm.video_management_id = '$video_management_id' "
                . "     AND u.url_id = vm.url_id "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

// START PERMISSION
    public function select_video_course_access_user($video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_person_permission as cpp, "
                . "     tbl_person as p "
                . " WHERE "
                . "         cpp.video_management_id = '$video_management_id' "
                . "     AND p.person_email = cpp.video_course_person_permission_email"
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_video_course_access_group($video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_group_permission as cgp, "
                . "     tbl_group as g "
                . " WHERE "
                . "         cgp.video_management_id = '$video_management_id' "
                . "     AND g.group_id = cgp.group_id"
        ;
        $result = $this->db->query($sql)->result();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function check_person_video_course_group_permission($video_management_id, $group_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_group_permission as cgp"
                . " WHERE "
                . "         cgp.group_id = $group_id "
                . "     AND cgp.video_management_id = '$video_management_id' "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
//        echo '<pre>';
//        print_r($result);
//        exit();
    }

    public function select_user_information_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p,"
                . "     tbl_url as u"
                . " WHERE "
                . "         p.person_id = '$person_id'"
                . "     AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function select_user_information_by_email($person_email) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p,"
                . "     tbl_url as u"
                . " WHERE "
                . "         p.person_email = '$person_email'"
                . "     AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function set_video_course_permission($video_management_id, $person_email) {
        $permission_data = array();
        $permission_data['video_management_id'] = $video_management_id;
        $permission_data['video_course_person_permission_email'] = $person_email;
        $permission_data['video_course_person_permission_invitation_status'] = 1;
        $this->db->insert('tbl_video_course_person_permission', $permission_data);
        return $this->db->insert_id();
//        echo '<pre>';
//        print_r($permission_data);
//        exit();
    }

    public function update_video_course_permission($permission_id) {
//        echo '<pre>';
//        print_r($permission_data);
//        exit();
        $this->db->set('video_course_person_permission_invitation_status', 1);
        $this->db->where('video_course_person_permission_id', $permission_id);
        $this->db->update('tbl_video_course_person_permission');
    }

    public function delete_video_course_permission($permission_email) {
//        echo '<pre>';
//        print_r($permission_email);
//        exit();
        $this->db->where('video_course_person_permission_email', $permission_email);
        $this->db->delete('tbl_video_course_person_permission');
    }

    public function delete_all_video_course_permisions($video_management_id) {
//        echo '<pre>';
//        print_r($permission_email);
//        exit();
        $this->db->where('video_management_id', $video_management_id);
        $this->db->delete('tbl_video_course_group_permission');

        $this->db->where('video_management_id', $video_management_id);
        $this->db->delete('tbl_video_course_person_permission');
    }

    public function set_video_course_group_permission($video_management_id, $group_id) {
//        echo '<pre>';
//        print_r($permission_data);
//        exit();

        $permission_data = array();
        $permission_data['video_management_id'] = $video_management_id;
        $permission_data['group_id'] = $group_id;
        $permission_data['video_course_group_permission_invitation_status'] = 1;
        $this->db->insert('tbl_video_course_group_permission', $permission_data);
        return $this->db->insert_id();
    }

    public function update_video_course_group_permission($video_course_group_permission_id) {
//        echo '<pre>';
//        print_r($permission_data);
//        exit();
        $this->db->set('video_course_group_permission_invitation_status', 1);
        $this->db->where('video_course_group_permission_id', $video_course_group_permission_id);
        $this->db->update('tbl_video_course_group_permission');
    }

    public function delete_video_course_group_permission($video_course_group_permission_id) {
//        echo '<pre>';
//        print_r($permission_data);
//        exit();
        $this->db->where('video_course_group_permission_id', $video_course_group_permission_id);
        $this->db->delete('tbl_video_course_group_permission');
    }

    public function check_person_video_course_permission($video_management_id, $person_email) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_person_permission as cpp "
                . " WHERE "
                . "         cpp.video_course_person_permission_email = '$person_email' "
                . "     AND cpp.video_management_id = '$video_management_id' "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    public function check_user_have_video_permission_by_group($user_id, $video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_video_course_group_permission as cpp, "
                . "     tbl_group as g, "
                . "     tbl_group_member as gm, "
                . "     tbl_person as p "
                . " WHERE "
                . "         cpp.video_management_id = '$video_management_id' "
                . "     AND cpp.group_id = g.group_id "
                . "     AND gm.person_id = '$user_id' "
                . "     AND gm.group_id = g.group_id "
        ;
        $result = $this->db->query($sql)->row();
//        echo '<pre>';
//        print_r($result);
//        exit();
        return $result;
    }

    //END PERMISSION



    public function save_video_information($data) {
        $this->db->insert('tbl_upload_video', $data);
        return $this->db->insert_id();
    }

    public function update_video_information($data, $upload_video_id) {
//        echo '<pre>';
//        print_r($data);
//        exit();
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video', $data);
    }

    public function save_video_file_information($data) {
        $this->db->insert('tbl_upload_video', $data);
        return $this->db->insert_id();
    }

    public function update_video_file_information($data, $upload_video_id) {
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video', $data);
    }

//    public function save_video_work_file_information($data) {
//        $this->db->insert('tbl_work_files_management', $data);
//        return $this->db->insert_id();
//    }

    public function update_video_work_file_status($upload_video_id) {
        $this->db->set('video_work_files', 1);
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    public function update_video_work_file_status_no($upload_video_id) {
        $this->db->set('video_work_files', 2);
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    public function update_video_work_file_information($data, $work_files_management_id) {
        $this->db->where('work_files_management_id', $work_files_management_id);
        $this->db->update('tbl_work_files_management', $data);
    }

    public function delete_drafted_video_and_work_file($video_management_id) {
        $video_management_info = $this->user_video_model->select_video_management_by_id($video_management_id);
        $course_creator_info = $this->profile_model->person_info_by_person_id($video_management_info->person_id);

        $sql = "SELECT * "
                . "FROM "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id'"
                . "     AND uv.upload_video_status = 5 "
        ;
        $uploded_video = $this->db->query($sql)->result();
        if ($uploded_video) {
            foreach ($uploded_video as $value) {
                if ($value->upload_video_location) {
                    $video_file = 'content-library/' . $course_creator_info->url . '/' . $value->upload_video_location;
                    if (is_file($video_file)) {
                        unlink($video_file);
                    }
                }
                $this->db->where('upload_video_id', $value->upload_video_id)->delete('tbl_upload_video');

                $sql = "SELECT * "
                        . "FROM "
                        . "     tbl_work_files_management as wfm "
                        . " WHERE "
                        . "         wfm.upload_video_id = '$value->upload_video_id'"
                        . "     AND wfm.work_files_status = 3 "
                ;
                $uploded_video_work_file = $this->db->query($sql)->row();
                if ($uploded_video_work_file) {
                    $this->db->where('work_files_management_id', $uploded_video_work_file->work_files_management_id)->delete('tbl_work_files_management');
                    if ($uploded_video_work_file->work_files_url) {
                        $work_files_url = 'content-library/' . $course_creator_info->url . '/' . $uploded_video_work_file->work_files_url;
                        if (is_file($work_files_url)) {
                            unlink($work_files_url);
                        }
                    }
                }
                if ($value->upload_video_location) {
                    $folder = explode('/', $value->upload_video_location);
                    $section_folder = $video_file = 'content-library/' . $course_creator_info->url . '/' . $folder[0] . '/' . $folder[1] . '/' . $folder[2];
                    if (is_dir($section_folder)) {
                        $files = array_diff(scandir($section_folder), array('.', '..'));
                        if (!$files) {
                            rmdir($section_folder);
                        }
                    }
                }
            }
        }
    }

    public function convert_file_folder_name($string) {
        //Lower case everything
        $string = strtolower($string);
        //Make alphanumeric (removes all other characters)
        $string = preg_replace("/[^a-z0-9_\s-]/", "", $string);
        //Clean up multiple dashes or whitespaces
//        $string = preg_replace("/[\s-]+/", " ", $string);
        //Convert whitespaces and underscore to dash
        $string = preg_replace("/[\s_]/", "-", $string);
        return $string;
    }

    public function update_section_video_location($creator_info, $video_management_info, $video_management_id, $section_previous_name, $upload_video_section_name) {

        $sql = "SELECT * "
                . "FROM "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id'"
                . "     AND uv.upload_video_section_name = '$section_previous_name'"
        ;
        $section_video = $this->db->query($sql)->result();

        $previous_folder_path = 'content-library/'
                . $creator_info->url
                . '/my-video/'
                . $video_management_info->video_folder_name . '/'
                . $section_previous_name . '/';

        $new_folder_path = 'content-library/'
                . $creator_info->url
                . '/my-video/'
                . $video_management_info->video_folder_name . '/'
                . $upload_video_section_name . '/';
        if (is_dir($previous_folder_path)) {
            rename("$previous_folder_path", "$new_folder_path");
        }

        foreach ($section_video as $value) {
            $upload_video_location = $value->upload_video_location;
            $upload_video_location = explode('/', $upload_video_location);
            $upload_video_location[2] = $upload_video_section_name;
            $video_location = implode('/', $upload_video_location);
            $this->db->set('upload_video_location', $video_location);
            $this->db->set('upload_video_section_name', $upload_video_section_name);
            $this->db->where('upload_video_id', $value->upload_video_id);
            $this->db->update('tbl_upload_video');

            $sql = "SELECT * "
                    . "FROM "
                    . "     tbl_work_files_management as wfm "
                    . " WHERE "
                    . "         wfm.upload_video_id = '$value->upload_video_id'"
            ;
            $uploded_video_work_file = $this->db->query($sql)->row();

            if ($uploded_video_work_file) {
                $work_files_url = $uploded_video_work_file->work_files_url;
                $work_files_url = explode('/', $work_files_url);
                $work_files_url[2] = $upload_video_section_name;
                $work_file_location = implode('/', $work_files_url);
                $this->db->set('work_files_url', $work_file_location);
                $this->db->where('work_files_management_id', $uploded_video_work_file->work_files_management_id);
                $this->db->update('tbl_work_files_management');
            }
        }
    }

    public function update_video_file_name($creator_info, $upload_video_id, $previous_video_file_name, $upload_video_name) {
//        echo '<pre>';
//        print_r($upload_video_name);
//        exit();
        $sql = "SELECT * "
                . "FROM "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         uv.upload_video_id = '$upload_video_id'"
        ;
        $video = $this->db->query($sql)->row();

        $video_management_info = $this->user_video_model->select_video_management_by_id($video->video_management_id);
        $course_creator_info = $this->profile_model->person_info_by_person_id($video_management_info->person_id);

        if ($video) {
            if ($video->upload_video_location) {
                $previous_video_location = 'content-library' . '/' . $creator_info->url . '/' . $video->upload_video_location;
                $upload_video_location = explode('/', $video->upload_video_location);
                $extension = explode('.', $upload_video_location[count($upload_video_location) - 1]);
                $extension = $extension[count($extension) - 1];

                $upload_video_new_location = 'content-library' . '/'
                        . $creator_info->url . '/'
                        . $upload_video_location[0] . '/' // my-video
                        . $upload_video_location[1] . '/' // video-course-folder-name
                        . $upload_video_location[2] . '/' // section-name
                        . $upload_video_name . '.' . $extension;
                if (is_file($previous_video_location)) {
                    rename($previous_video_location, $upload_video_new_location);
                    $upload_video_location[3] = $upload_video_name . '.' . $extension; // 3 position is video file name with extention
                    $video_location = implode('/', $upload_video_location);
                    $this->db->set('upload_video_location', $video_location);
                    $this->db->where('upload_video_id', $upload_video_id);
                    $this->db->update('tbl_upload_video');
                }
            }
        }
    }

    public function update_work_file_name($creator_info, $upload_video_id, $previous_work_file_name, $work_files_name) {

        $sql = "SELECT * "
                . "FROM "
                . "     tbl_work_files_management as wfm "
                . " WHERE "
                . "         wfm.upload_video_id = '$upload_video_id'"
        ;
        $uploded_video_work_file = $this->db->query($sql)->row();

        if ($uploded_video_work_file) {
            if ($uploded_video_work_file->work_files_url) {
                $previous_work_files_url = 'content-library' . '/' . $creator_info->url . '/' . $uploded_video_work_file->work_files_url;
                $work_files_url = $uploded_video_work_file->work_files_url;
                $work_files_url = explode('/', $work_files_url);

                $file_name = $work_files_url[count($work_files_url) - 1];
                $file_name = explode('.', $file_name);
                $extension = $file_name[count($file_name) - 1];
                $work_file_new_location = 'content-library' . '/'
                        . $creator_info->url . '/'
                        . $work_files_url[0] . '/'
                        . $work_files_url[1] . '/'
                        . $work_files_url[2] . '/'
                        . $work_files_name . '.' . $extension;

                if (is_file($previous_work_files_url)) {
                    rename($previous_work_files_url, $work_file_new_location);
                    $work_files_url = $uploded_video_work_file->work_files_url;
                    $work_files_url = explode('/', $work_files_url);
                    $work_files_url[3] = $work_files_name . '.' . $extension;
                    $work_files_location = implode('/', $work_files_url);
                    $this->db->set('work_files_url', $work_files_location);
                    $this->db->where('work_files_management_id', $uploded_video_work_file->work_files_management_id);
                    $this->db->update('tbl_work_files_management');
                }
            }
        }
    }

    public function select_video_management_top_video($video_management_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_upload_video as uv "
                . " WHERE "
                . "         uv.video_management_id = '$video_management_id' "
                . "     AND uv.upload_video_status = 1 "
                . " ORDER BY uv.upload_video_id ASC"
        ;
        $result = $this->db->query($sql)->row();

        return $result;
    }

    public function create_subtitle($data) {
        $upload_video_location = explode('/', $data['video_location']);
        $file = explode('.', $upload_video_location[count($upload_video_location) - 1]);
        $file_name = $file[0];

        $subtitle_path = 'content-library/video-path/' . $file_name . '.xml';
        $video_duration = $data['video_time_length'];
        $time = explode(':', $video_duration);
        $duration_in_second = ($time[0] * 3600) + ($time[1] * 60) + $time[2];

        $this->cf->create_subtitle($subtitle_path, $data['transcript'], $duration_in_second);

        $return_data = array();
        $return_data['subtitle_path'] = $subtitle_path;
        return $return_data;
    }

    //    @@@@@@@@ it must be deleted after complete all function video course@@@@@@@@@@@@@@@@

    /**
     * @Function            : update_video_course_information 
     * @Used IN             : @function-'edit_video_course'     user_video[@controller],
     * @Description         : Update video course information
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-03-2016 08:36 PM
     * @Status              : available      
     * */
    public function update_video_course_information($video_course_info) {
        
        $vdata['person_id'] = $video_course_info->course_creator_id;
        $vdata['course_category_id'] = $this->input->post('course_category_id', TRUE);
        $vdata['video_folder_name'] = $this->input->post('video_folder_name', TRUE);

        if ($video_course_info->video_folder_name != $vdata['video_folder_name']) {
            $course_creator_url = $this->get_profile_url($video_course_info->course_creator_id);
            $old_folder = 'content-library/' . $course_creator_url . '/my-video/' . $video_course_info->video_folder_name . '/';
            $new_folder = 'content-library/' . $course_creator_url . '/my-video/' . $vdata['video_folder_name'] . '/';
            if (is_dir($old_folder)) {
                rename($old_folder, $new_folder);
            }
        }

        if ($video_course_info->person_role == 4) {
            $vdata['resource_person_id'] = $this->input->post('resource_person_id', TRUE);
        } else {
            //$resource_person_info = $this->profile_model->select_resource_person_info($video_course_info->course_creator_id);
            $vdata['resource_person_id'] = $video_course_info->resource_person_id;
        }

        $vdata['video_course_title'] = $this->input->post('video_course_title', TRUE);
        $vdata['video_course_type'] = 2;

//        if ($vdata['video_course_type'] == 1) {
//            $vdata['video_course_price'] = $this->input->post('video_course_price', TRUE);
//            $vdata['video_course_price_currency'] = $this->input->post('video_course_price_currency', TRUE);
//        } else {
//            $vdata['video_course_price'] = NULL;
//            $vdata['video_course_price_currency'] = NULL;
//        }

        if ($this->input->post('video_training_objectives', TRUE) != '') {
            if ($this->input->post('video_training_objectives', TRUE) != $video_course_info->video_training_objectives) {
                $vdata['video_training_objectives'] = $this->cf->get_tinymce_description_value_for_edit($this->input->post('video_training_objectives', TRUE), $video_course_info->video_training_objectives);
            } else {
                $vdata['video_training_objectives'] = $video_course_info->video_training_objectives;
            }
        }


        
        if ($this->input->post('video_training_outline', TRUE) != '') {
            if ($this->input->post('video_training_outline', TRUE) != $video_course_info->video_training_outline) {
                $vdata['video_training_outline'] = $this->cf->get_tinymce_description_value_for_edit($this->input->post('video_training_outline', TRUE), $video_course_info->video_training_outline);
            } else {
                $vdata['video_training_outline'] = $video_course_info->video_training_outline;
            }
        }

        $vdata['video_management_status'] = $video_course_info->video_management_status;
        $vdata['menu_id'] = $video_course_info->menu_id;
        $vdata['video_management_level'] = $this->input->post('video_management_level', TRUE);
        $vdata['video_access_level'] = $this->input->post('video_access_level', TRUE);
        $vdata['video_language'] = $this->input->post('video_language', TRUE);
        /*
         * Save URL Information 
         */
        if ($this->input->post('video_course_url', TRUE) != $video_course_info->url) {
            $vdata['url_id'] = $this->url_model->save_vedio_url($this->input->post('video_course_url', TRUE));
        } else {
            $vdata['url_id'] = $video_course_info->url_id;
        }

        /*
         * Manage Category or Other Category
         */
        if ($vdata['course_category_id'] == 'other') {
            $cat_data['person_id'] = $this->session->userdata('user_id');
            $cat_data['course_category_name'] = $this->input->post('course_category_name', TRUE);
            $cat_data['course_category_status'] = 4;

            // create course URl and save url id in course category database
            $cat_data['url_id'] = $this->url_model->create_course_category_url($cat_data['course_category_name']);
            $this->db->insert('tbl_course_category', $cat_data);
            $vdata['course_category_id'] = $this->db->insert_id();
        }
        
        $this->update_information_in_database('tbl_video_management', 'video_management_id', $video_course_info->video_management_id, $vdata);

        if ($vdata['video_access_level'] == 4 || $vdata['video_access_level'] == 5) {
            $this->update_video_access_permission($video_course_info->video_management_id, $video_course_info->video_access_level, $vdata);
        } else {
            if ($video_course_info->video_access_level == 4) {
                $group_info = $this->get_selected_group_by_video_course_id($video_course_info->video_management_id, 2);
                $this->delete_information_in_database('tbl_course_group_permission', 'course_group_permission_id', $group_info->course_group_permission_id);
            } else if ($video_course_info->video_access_level == 5) {
                $special_user_info = $this->get_selected_special_uesr_by_video_course_id($video_course_info->video_management_id, 2);
                $this->delete_information_in_database('tbl_course_person_permission', 'course_person_permission_id', $special_user_info->course_person_permission_id);
            }
        }
    }

    /**
     * @Function            : update_video_access_permission 
     * @Used IN             : @function-'update_video_course_information'    this[@Model]
     * @Description         : Update video permisssion if user select group or special user
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 20-03-2016 10:03 PM
     * @Status              : available      
     * */
    function update_video_access_permission($video_management_id, $video_access_level, $vdata) {
        if ($vdata['video_access_level'] == 4) {
            if ($video_access_level == $vdata['video_access_level']) {
                $group_info = $this->get_selected_group_by_video_course_id($video_management_id, 2);
                $gData['group_id'] = $this->input->post('hidden_search_group_name', TRUE);
                $this->update_information_in_database('tbl_course_group_permission', 'course_group_permission_id', $group_info->course_group_permission_id, $gData);
            } else {
                $gData['course_id'] = $video_management_id;
                $gData['group_id'] = $this->input->post('hidden_search_group_name', TRUE);
                $gData['course_group_type'] = 2;
                $this->db->insert('tbl_course_group_permission', $gData);
            }
            if ($video_access_level == 5) {
                $special_user_info = $this->get_selected_special_uesr_by_video_course_id($video_management_id, 2);
                $this->delete_information_in_database('tbl_course_person_permission', 'course_person_permission_id', $special_user_info->course_person_permission_id);
            }
        } else if ($vdata['video_access_level'] == 5) {
            if ($video_access_level == $vdata['video_access_level']) {
                $special_user_info = $this->get_selected_special_uesr_by_video_course_id($video_management_id, 2);
                $pData['person_id'] = $this->input->post('hidden_special_user_name', TRUE);
                $this->update_information_in_database('tbl_course_person_permission', 'course_person_permission_id', $special_user_info->course_person_permission_id, $pData);
            } else {
                $pData['course_id'] = $video_management_id;
                $pData['person_id'] = $this->input->post('hidden_special_user_name', TRUE);
                $pData['course_person_type'] = 2;
                $this->db->insert('tbl_course_person_permission', $pData);
            }
            if ($video_access_level == 4) {
                $group_info = $this->get_selected_group_by_video_course_id($video_management_id, 2);
                $this->delete_information_in_database('tbl_course_group_permission', 'course_group_permission_id', $group_info->course_group_permission_id);
            }
        }
    }

    /**
     * @Function            : select_all_available_course_category 
     * @Used IN             : @function-'add_video'    user_video[@Controller]
     * @Description         : get all published course category and pending category which iss created by whose user
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-08-2016 12:03 AM
     * @Status              : available      
     * */
    public function select_all_available_course_category($person_id) {
        $sql = "SELECT * 
                FROM
                    tbl_course_category AS cc
                WHERE ((cc.course_category_status = '1' 
                OR cc.course_category_status ='5') OR cc.person_id = '$person_id') ";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : check_course_category_name 
     * @Used IN             : @function-'course_category_name_check'    user_video[@Controller]
     * @Description         : check course category name existance
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 09-03-2016 12:25 AM
     * @Status              : available      
     * */
    function check_course_category_name($category_name) {
        $sql = "SELECT * 
                FROM 
                    tbl_course_category AS cc
                WHERE 
                    cc.course_category_name = '$category_name'";
        $result = $this->db->query($sql)->row();
        if ($result) {
            return 1;
        } else {
            return 2;
        }
    }

    /*
      -----------@@@RIPON@ End Video Course Part----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Video Course Work file Part----------------------------------
     */

    /**
     * @Function            : save_video_course_work_file 
     * @Used IN             : @function-'save_uploaded_video'    user_video[@Controller]
     * @Description         : Save video course work file into database
     * @Developed By        : Copied from super-admin-video-model
     * @Start DateTime      : 27-02-2016 06:38 PM
     * @Status              : available      
     * */
    function save_video_course_work_file() {
        $all_section_counter1 = explode(',', $this->input->post('all_section_counter', TRUE));
        $all_section_counter = array_filter($all_section_counter1);

        for ($i = 0; $i < count($all_section_counter); $i++) {
            $all_video_counter1 = $this->input->post('all_upload_video_ok_counter', TRUE);
            $all_video_counter2 = $all_video_counter1[$all_section_counter[$i]];
            $all_video_counter3 = explode(',', $all_video_counter2);
            $all_video_counter = array_filter($all_video_counter3);

            $all_upload_video1 = $this->input->post('all_upload_video_id', TRUE);
            $all_upload_video2 = $all_upload_video1[$all_section_counter[$i]];
            $all_upload_video3 = explode(',', $all_upload_video2);
            $all_upload_video = array_filter($all_upload_video3);

            $video_section_name1 = $this->input->post('video_section_name', TRUE);
            $video_section_name2 = $video_section_name1[$all_section_counter[$i]];
            $video_section_name = trim(preg_replace('/\s+/', ' ', $video_section_name2));

            $video_upload_info1 = $this->get_upload_video_information_by_upload_video_id($all_upload_video[0]);
            $course_creator_url = $this->get_profile_url($video_upload_info1->course_creator_id);
            if ($video_upload_info1->upload_video_section_name != $video_section_name) {
                $old_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_upload_info1->video_folder_name . '/' . $video_upload_info1->upload_video_section_name;
                $new_diriectory = 'content-library/' . $course_creator_url . '/my-video/' . $video_upload_info1->video_folder_name . '/' . $video_section_name;
                if (is_dir($old_diriectory)) {
                    rename($old_diriectory, $new_diriectory);
                }
            }

            $combine_array = array_combine($all_video_counter, $all_upload_video);
            for ($j = 0; $j < count($combine_array); $j++) {
                $this->save_upload_video_information($i, $j, $course_creator_url, $video_section_name, $all_section_counter, $all_video_counter, $all_upload_video);
            }

            if (($this->input->post('all_upload_video_work_file_ok_counter', TRUE) != '') && ($this->input->post('all_upload_video_work_file_id', TRUE))) {
                $all_video_work_file_counter1 = $this->input->post('all_upload_video_work_file_ok_counter', TRUE);
                $all_video_work_file_counter2 = $all_video_work_file_counter1[$all_section_counter[$i]];
                $all_video_work_file_counter3 = explode(',', $all_video_work_file_counter2);
                $all_video_work_file_counter = array_filter($all_video_work_file_counter3);

                $all_upload_video_work_file_id1 = $this->input->post('all_upload_video_work_file_id', TRUE);
                $all_upload_video_work_file_id2 = $all_upload_video_work_file_id1[$all_section_counter[$i]];
                $all_upload_video_work_file_id3 = explode(',', $all_upload_video_work_file_id2);
                $all_upload_video_work_file_id = array_filter($all_upload_video_work_file_id3);
                if ($all_video_work_file_counter && $all_upload_video_work_file_id) {
                    $combine_array1 = array_combine($all_video_work_file_counter, $all_upload_video_work_file_id);
                    for ($k = 0; $k < count($combine_array1); $k++) {
                        $this->save_video_work_file_information($i, $k, $course_creator_url, $video_section_name, $all_section_counter, $all_video_work_file_counter, $all_upload_video_work_file_id);
                    }
                }
            }
        }
    }

    /**
     * @Function            : save_upload_video_information 
     * @Used IN             : @function-'save_video_course_work_file'         this[@Model]
     * @Description         : Save Upload video information course work file into database
     * @Developed By        : Copied from 'super-admin-video-model'
     * @Start DateTime      : 27-02-2016 06:53 AM
     * @Status              : available      
     * */
    function save_upload_video_information($i, $j, $course_creator_url, $video_section_name, $all_section_counter, $all_video_counter, $all_upload_video) {
        $video_upload_info = $this->get_upload_video_information_by_upload_video_id($all_upload_video[$j]);

        if ($video_upload_info->upload_video_section_name != $video_section_name) {
            $data['upload_video_section_name'] = $video_section_name;
        } else {
            $data['upload_video_section_name'] = $video_upload_info->upload_video_section_name;
        }
        $work_files_url = explode('.', $video_upload_info->upload_video_location);
        $file_extension = $work_files_url[1];
        $section_directory = '/my-video/' . $video_upload_info->video_folder_name . '/' . $data['upload_video_section_name'];

        $upload_video_name1 = $this->input->post('upload_video_name', TRUE);
        $upload_video_name2 = $upload_video_name1[$all_section_counter[$i]][$all_video_counter[$j]];
        $upload_video_name = trim(preg_replace('/\s+/', ' ', $upload_video_name2));
        if ($video_upload_info->upload_video_name != $upload_video_name) {
            $data['upload_video_name'] = $upload_video_name;
            $data['upload_video_location'] = $section_directory . '/' . "$upload_video_name.$file_extension";

            $old_video_file = 'content-library/' . $course_creator_url . '/my-video/' . $video_upload_info->video_folder_name . '/' . $data['upload_video_section_name'] . '/' . "$video_upload_info->upload_video_name.$file_extension";
            $new_video_file = 'content-library/' . $course_creator_url . $data['upload_video_location'];
            if (file_exists($old_video_file)) {
                rename($old_video_file, $new_video_file);
            }
        } else {
            $data['upload_video_name'] = $video_upload_info->upload_video_name;
            $data['upload_video_location'] = $section_directory . '/' . "$video_upload_info->upload_video_name.$file_extension";
        }

        $upload_video_transcript1 = $this->input->post('upload_video_transcript', TRUE);
        $upload_video_transcript2 = $upload_video_transcript1[$all_section_counter[$i]][$all_video_counter[$j]];
        $upload_video_transcript = trim(preg_replace('/\s+/', ' ', $upload_video_transcript2));
        if ($video_upload_info->upload_video_transcript != $upload_video_transcript) {
            $data['upload_video_transcript'] = $upload_video_transcript;
        } else {
            $data['upload_video_transcript'] = $video_upload_info->upload_video_transcript;
        }

//        $upload_video_access_level1 = $this->input->post('upload_video_access_level', TRUE);
//        $upload_video_access_level = $upload_video_access_level1[$all_section_counter[$i]][$all_video_counter[$j]];
//        if ($video_upload_info->upload_video_access_level != $upload_video_access_level) {
//            $data['upload_video_access_level'] = $upload_video_access_level;
//        } else {
//            $data['upload_video_access_level'] = $video_upload_info->upload_video_access_level;
//        }

        $data['upload_video_status'] = 1;
        $this->update_information_in_database('tbl_upload_video', 'upload_video_id', $all_upload_video[$j], $data);
    }

    /**
     * @Function            : save_video_work_file_information 
     * @Used IN             : @function-'save_video_course_work_file'         this[@Model]
     * @Description         : Save Upload video work file information course work file into database
     * @Developed By        : Copied from 'super-admin-video-model'
     * @Start DateTime      : 27-02-2016 06:53 AM
     * @Status              : available      
     * */
    function save_video_work_file_information($i, $j, $course_creator_url, $video_section_name, $all_section_counter, $all_video_work_file_counter, $all_upload_video_work_file_id) {
        $video_work_file_info = $this->get_upload_video_work_file_info_by_work_file_id($all_upload_video_work_file_id[$j]);

        if ($video_work_file_info->work_file_folder_name != $video_section_name) {
            $data['work_file_folder_name'] = $video_section_name;
        } else {
            $data['work_file_folder_name'] = $video_work_file_info->work_file_folder_name;
        }
        $work_files_url = explode('.', $video_work_file_info->work_files_url);
        $file_extension = $work_files_url[1];
        $section_directory = '/my-video/' . $video_work_file_info->video_folder_name . '/' . $data['work_file_folder_name'];

        $work_files_name1 = $this->input->post('work_files_name', TRUE);
        $work_files_name2 = $work_files_name1[$all_section_counter[$i]][$all_video_work_file_counter[$j]];
        $work_files_name = trim(preg_replace('/\s+/', ' ', $work_files_name2));
        if ($video_work_file_info->work_files_name != $work_files_name) {
            $data['work_files_name'] = $work_files_name;
            $data['work_files_url'] = $section_directory . '/' . "$work_files_name.$file_extension";

            $old_video_file = 'content-library/' . $course_creator_url . '/my-video/' . $video_work_file_info->video_folder_name . '/' . $data['work_file_folder_name'] . '/' . "$video_work_file_info->work_files_name.$file_extension";
            $new_video_file = 'content-library/' . $course_creator_url . $data['work_files_url'];
            if (file_exists($old_video_file)) {
                rename($old_video_file, $new_video_file);
            }
        } else {
            $data['work_files_name'] = $video_work_file_info->work_files_name;
            $data['work_files_url'] = $section_directory . '/' . "$video_work_file_info->work_files_name.$file_extension";
        }

//        $work_files_management_access_level1 = $this->input->post('work_files_management_access_level', TRUE);
//        $work_files_management_access_level = $work_files_management_access_level1[$all_section_counter[$i]][$all_video_work_file_counter[$j]];
//        if ($video_work_file_info->work_files_management_access_level != $work_files_management_access_level) {
//            $data['work_files_management_access_level'] = $work_files_management_access_level;
//        } else {
//            $data['work_files_management_access_level'] = $video_work_file_info->work_files_management_access_level;
//        }
        $data['work_files_status'] = 1;
        $this->update_information_in_database('tbl_work_files_management', 'work_files_management_id', $all_upload_video_work_file_id[$j], $data);
    }

    /**
     * @Function            : get_single_video_course_information_by_url 
     * @Used IN             : @function-'edit_uploaded_video'              user_video[@Controller]
     * @                    : @function-'video_course'                     welcome[@Controller]
     * @                    : @function-'enroll_video_course'              welcome[@Controller]
     * @Description         : Select Single video By video_course_url 
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 24-02-2016 07:20 PM
     * @Status              : available      
     * */
    public function get_single_video_course_information_by_url($video_course_url) {
        $sql = "SELECT * ,vm.person_id AS course_creator_id
                FROM
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id
                AND u.url = '$video_course_url'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_video_course_information_by_id 
     * @Used IN             : @function-'uploaded_video_courses_video_file'                 user_video[@Controller]
     * @                    : @function-'add_video_course_section_area'                     user_video[@Controller]
     * @                    : @function-'add_video'                                         user_video[@Controller]
     * @Description         : Select Single video By video_course_id 
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 25-02-2016 11:35 AM
     * @Status              : available      
     * */
    public function get_single_video_course_information_by_id($video_course_id) {
        $sql = "SELECT *,vm.person_id AS course_creator_id, vm.url_id AS video_course_url_id 
                FROM
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id
                AND vm.video_management_id = '$video_course_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_profile_url 
     * @Used IN             : @function-'uploaded_video_courses_video_file'                  user_video[@Controller],
     * @                    : @function-'upload_video_course_work_file'                      user_video[@Controller],
     * @                    : @function-'remove_video_work_file_view'                        user_video[@Controller],
     * @                    : @function-'delete_single_video_course'                         user_video[@Controller],
     * @                    : @function-'remove_video_course_section_area'                   user_video[@Controller],
     * @Description         : get profile URl using person_id
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 14-02-2016 12:57 PM   
     * @Status              : available      
     * */
    public function get_profile_url($person_id) {
        $sql = "SELECT url
                FROM
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    p.person_id = '$person_id'
                AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result->url;
    }

    /**
     * @Function            : check_video_course_section_name 
     * @Used IN             : @function-'check_section_name_exist'    user_video[@Controller],
     * @Description         : check video section name
     * @Developed By        : Copied From - 'super_admin_video_model'
     * @Start DateTime      : 27-02-2016 04:19 PM     
     * @Status              : available      
     * */
    function check_video_course_section_name($video_management_id, $video_section_name, $all_upload_id) {
        $sql = "SELECT *
                FROM
                    tbl_upload_video AS uv
                WHERE 
                 uv.video_management_id = '$video_management_id'
                 AND uv.upload_video_section_name = '$video_section_name'";
        if ($all_upload_id) {
            $sql.= " AND uv.upload_video_id NOT IN ($all_upload_id)";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_upload_video_information_by_upload_video_id 
     * @Used IN             : @function-'uploaded_video_courses_video_file'                 user_video[@Controller]- 2 times
     * @                    : @function-'upload_video_course_work_file'                     user_video[@Controller]
     * @                    : @function-'delete_single_video_course'                        user_video[@Controller]
     * @                    : @function-'remove_video_course_section_area'                  user_video[@Controller]
     * @                    : @function-'check_video_file_name_exist'                       user_video[@Controller]
     * @                    : @function-'save_video_course_work_file'                       user_video[@Controller]
     * @                    : @function-'save_upload_video_information'                     user_video[@Controller]
     * @Description         : get all upload video information using upload_video_id
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 25-02-2016 12:00 PM
     * @Status              : available      
     * */
    function get_upload_video_information_by_upload_video_id($upload_video_id) {
        $sql = "SELECT * ,vm.person_id AS course_creator_id
                FROM 
                    tbl_upload_video AS uv,
                    tbl_video_management AS vm
                WHERE 
                    uv.video_management_id = vm.video_management_id
                AND uv.upload_video_id = '$upload_video_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_upload_video_name 
     * @Used IN             : @function-'check_video_file_name_exist'    user_video[@Controller],
     * @Description         : check upload video name
     * @Developed By        : Copied from - 'Super_admin_video'
     * @Start DateTime      : 27-02-2016 01:16 PM    
     * @Status              : available      
     * */
    function check_upload_video_name($video_management_id, $video_section_name, $video_name, $upload_video_id) {
        $sql = "SELECT *
                FROM
                    tbl_upload_video AS uv
                WHERE 
                 uv.video_management_id = '$video_management_id'
                 AND uv.upload_video_section_name = '$video_section_name'
                 AND uv.upload_video_name = '$video_name'";
        if ($upload_video_id != '') {
            $sql.=" AND uv.upload_video_id != '$upload_video_id'";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_video_course_work_file_name_existence 
     * @Used IN             : @function-'check_video_work_file_name_exist'      user_video[@Controller],
     * @Description         : check video course work file name existence
     * @Developed By        : Copied from - 'super_Admin_video'
     * @Start DateTime      : 27-02-2016 04:53 PM
     * @Status              : available      
     * */
    function check_video_course_work_file_name_existence($all_upload_video_id, $work_files_name, $upload_video_id) {
        $sql = "SELECT *
                FROM 
                    tbl_work_files_management AS wfm
                WHERE 
                    wfm.upload_video_id IN ($all_upload_video_id)
                AND wfm.work_files_name = '$work_files_name'";
        if ($upload_video_id != '') {
            $sql.=" AND wfm.upload_video_id != '$upload_video_id'";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_upload_video_work_file_info_by_work_file_id 
     * @Used IN             : @function-'upload_video_course_work_file'          user_video[@Controller]
     * @                    : @function-'remove_video_work_file_view'            user_video[@Controller]
     * @                    : @function-'save_video_work_file_information'       user_video[@Controller]
     * @Description         : get all upload video work file Information using $work_file_ID
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 25-02-2016 06:28 PM
     * @Status              : available      
     * */
    function get_upload_video_work_file_info_by_work_file_id($work_file_id) {
        $sql = "SELECT *, vm.person_id AS course_creator_id
                FROM
                    tbl_work_files_management AS wfm,
                    tbl_upload_video AS uv,
                    tbl_video_management AS vm
                WHERE 
                    wfm.work_files_management_id = '$work_file_id'
                AND wfm.upload_video_id = uv.upload_video_id
                AND uv.video_management_id = vm.video_management_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_upload_video_work_file_info_by_work_file_id 
     * @Used IN             : @function-'delete_single_video_course'           super_admin_video[@Controller]-2 times
     * @                    : @function-'remove_video_course_section_area'     super_admin_video[@Controller]-2 times
     * @Description         : get video work file using video_upload _id
     * @Developed By        : Copied fron - 'super_admin_video_model'
     * @Start DateTime      : 27-02-2016 12:18 PM
     * @Status              : available      
     * */
    function get_work_file_info_by_video_upload_id($upload_video_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_work_files_management AS wfm
                WHERE 
                    wfm.upload_video_id = '$upload_video_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : change_work_file_status_in_course_video 
     * @Used IN             : @function-'upload_video_course_work_file'           user_video[@Controller]
     * @                    : @function-'remove_video_work_file_view'             user_video[@Controller]
     * @Description         : change work file status in 'tbl_upload_video'
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 25-02-2016 06:28 PM
     * @Status              : available      
     * */
    function change_work_file_status_in_course_video($upload_video_id, $status) {
        $this->db->set('video_work_files', $status);
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->update('tbl_upload_video');
    }

    /**
     * @Function            : delete_single_video_course_by_upload_video_id 
     * @Used IN             : @function-'delete_single_video_course'           super_admin_video[@Controller] 2-times
     * @                    : @function-'remove_video_course_section_area'     super_admin_video[@Controller]
     * @Description         : delete uploaded video in upload_video_course
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 17-02-2016 06:01 PM
     * @Status              : available      
     * */
    function delete_single_video_course_by_upload_video_id($upload_video_id) {
        $this->db->where('upload_video_id', $upload_video_id);
        $this->db->delete('tbl_upload_video');
    }

    /**
     * @Function            : remove_upload_video_course_work_file_by_work_file_id 
     * @Used IN             : @function-'remove_video_work_file_view'          super_admin_video[@Controller]
     * @                    : @function-'delete_single_video_course'           super_admin_video[@Controller]- 2 times
     * @                    : @function-'remove_video_course_section_area'     super_admin_video[@Controller]- 2 times
     * @Description         : Remove work file from database using work_file_id
     * @Developed By        : Copied from 'super-admin-video-model'
     * @Start DateTime      : 27-02-2016 11:13 AM
     * @Status              : available      
     * */
    function remove_upload_video_course_work_file_by_work_file_id($work_files_management_id) {
        $this->db->where('work_files_management_id', $work_files_management_id);
        $this->db->delete('tbl_work_files_management');
    }

    /**
     * @Function            : select_resource_person_information 
     * @Used IN             : @function-'uploaded_course_video_file_size'        user_video[@Controller]
     * @Description         : get all upload video information using upload_video_id
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 25-02-2016 01:15 PM
     * @Status              : available      
     * */
    function select_resource_person_information($person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_person AS p,    
                    tbl_url AS u,
                    tbl_resource_person AS rp
                WHERE 
                    p.url_id = u.url_id
                AND p.person_id = rp.person_id
                AND p.person_id = '$person_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_all_organization_user 
     * @Used IN             : @function-'uploaded_course_video_file_size'        user_video[@Controller]
     * @Description         : get all person_info using organization
     * @Developed By        : Copied From 'super_admin_video_model'
     * @Start DateTime      : 25-02-2016 01:15 PM
     * @Status              : available      
     * */
    function select_all_organization_user_information($organization_id) {
        $sql = "SELECT *
                FROM 
                    tbl_person AS p,
                    tbl_url AS u,
                    tbl_resource_person AS rp
                WHERE 
                    p.url_id = u.url_id
                AND p.person_id = rp.person_id
                AND rp.organization_id = '$organization_id'";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_single_organization_information 
     * @Used IN             : @function-''        user_video[@Controller]
     * @Description         : get all organization information using organization_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 28-02-2016 04:09 PM
     * @Status              : available      
     * */
    function select_single_organization_information($organization_id) {
        $sql = "SELECT *, rp.feature_price_id AS resource_feature_price_id
                FROM 
                    tbl_organization AS o,
                    tbl_person AS p,
                    tbl_url AS u,
                    tbl_resource_person AS rp
                WHERE 
                    o.organization_id = '$organization_id'
                AND o.person_id = p.person_id
		AND o.person_id = rp.person_id
		AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_feature_price_information_bu_status 
     * @Used IN             : @function-''        user_video[@Controller]
     * @Description         : check feature price status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 28-02-2016 04:09 PM
     * @Status              : available      
     * */
    function check_feature_price_information_bu_status($status, $type) {
        $sql = "SELECT * 
                FROM 
                    tbl_feature_price AS fp
                WHERE 
                    fp.feature_price_status = '$status'
                AND fp.feature_price_talhatraining IN ($type)";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_feature_price_information_feature_id 
     * @Used IN             : @function-''        user_video[@Controller]
     * @Description         : get feature price information usinf feature price ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 28-02-2016 04:09 PM
     * @Status              : available      
     * */
    function get_feature_price_information_feature_id($feature_price_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_feature_price AS fp
                WHERE 
                    fp.feature_price_id = '$feature_price_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_all_upload_id_by_section_name1 
     * @Used IN             : @function-'edit_video_course_work_file'        super_admin_video[@Controller]
     * @                    : @function-'view_video_course'                  Welcome[@controller]
     * @Description         : get all upload video id using Upload_video_section_name
     * @Developed By        : Copied from - 'super_admin_video_model'
     * @Start DateTime      : 27-02-2016 12:15 PM
     * @Status              : available      
     * */
    function get_all_upload_id_by_section_name1($video_course_id, $upload_video_section_name) {
        $sql = "SELECT *
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.upload_video_section_name = '$upload_video_section_name'
                    AND uv.video_management_id = '$video_course_id'
                    ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_active_upload_id_by_section_name 
     * @Used IN             : @function-'view_video_course'    Welcome[@controller]
     * @Description         : get all available course using category ID  
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Parameter           : $video_course_id[INTEGER], $upload_video_section_name[STRING]
     * @Return              : all_active_upload_video_information    
     * @Status              : Available       
     * */
    function get_active_upload_id_by_section_name($video_course_id, $upload_video_section_name) {
        $sql = "SELECT *
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.upload_video_section_name = '$upload_video_section_name'
                    AND uv.video_management_id = '$video_course_id'
                    AND uv.upload_video_status = '1'
                    ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_active_upload_id_by_section_name 
     * @Used IN             : @function-'view_video_course'    Welcome[@controller]
     * @Description         : get all uploaded video by search  
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 11-04-2016 01:38 PM
     * @Parameter           : $video_course_id[INTEGER], $upload_video_section_name[STRING],$search_input[STRING], $type[INTEGER]
     * @Return              : all_active_upload_video_information    
     * @Status              : Available       
     * */
    function get_all_upload_video_info_by_search($video_course_id, $section_name, $search_input, $type) {
        $sql = "SELECT *
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.upload_video_section_name = '$section_name'
                    AND uv.video_management_id = '$video_course_id'
                    AND uv.upload_video_name LIKE '%$search_input%'";
        if ($type == 2) {
            $sql.=" AND uv.upload_video_status = '1'";
        }
        $sql.=" ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }
    /**
     * @Function            : get_course_permission_information 
     * @Used IN             : @function-'edit_course'    super_admin_course[@Controller]
     * @Description         : get user course permission information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 11-07-2016 12:45 PM
     * @Status              : available      
     * */
    function get_course_permission_information($course_type, $course_type_id, $course_permission_type) {
        $sql = "SELECT *
                FROM 
                    tbl_course_video_course_permission AS cvcp
                WHERE cvcp.course_video_course_type = '$course_type'
                AND cvcp.course_video_course_id = '$course_type_id'
                AND cvcp.course_video_course_permission_type = '$course_permission_type'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : removem_diretcory 
     * @USED IN             : @function-'delete_single_video_course'           super_admin_video[@controller]
     * @                    : @function-'remove_video_course_section_area'     super_admin_video[@controller]
     * @Description         : Delete directory with all child
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 04-02-2016 12:07 PM      
     * @Status              : available (copied from  'super_admin'@controller)      
     * */
    public function remove_directory($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . "/" . $object) == "dir") {
                        $this->remove_directory($dir . "/" . $object);
                    } else {
                        unlink($dir . "/" . $object);
                    }
                }
            }
            reset($objects);
            rmdir($dir);
        }
    }

    /**
     * @Function            : person_available_disk_space
     * @Used IN             : @function-'uploaded_course_video_file_size'          user_video[@controller]-2 times
     * @Description         : full size of content library for login user 
     * @Developed By        : Copied from 'super_admin_course_model'
     * @Start DateTime      : 02-02-2016 04:10 PM 
     * @Status              : available        
     * */
    public function person_available_disk_space($dir) {
        $size = 0;
        foreach (glob(rtrim($dir, '/') . '/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : $this->person_available_disk_space($each);
        }
        return $size;
    }

    /**
     * @Function            : select_all_video_course_section_by_video_course_id 
     * @Used IN             : @function-'edit_video_course_work_file'    super_admin_video[@Controller]
     * @                    : @function-'view_video_course'              Welcome[@Controller]
     * @Description         : select all uploaded video section using video_course_id
     * @Developed By        : Copied from 'super_admin0video_model'
     * @Start DateTime      : 21-03-2016 12:25 AM
     * @Status              : available      
     * */
    function select_all_video_course_section_by_video_course_id($video_course_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.video_management_id = '$video_course_id'
                GROUP BY uv.upload_video_section_name
                ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_video_course_section_by_search 
     * @Used IN             : @function-'get_uploaded_video_by_search'        Welcome[@Controller]
     * @Description         : get all section by searched uploaded video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-04-2016 04:19 PM
     * @Parameter           : $video_course_id[INTEGER],$search_input[STRING]
     * @Return              : all_active_video_course
     * @Status              : available      
     * */
    function select_all_video_course_section_by_search($video_course_id, $search_input, $type) {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.video_management_id = '$video_course_id'
                  AND uv.upload_video_name LIKE '%$search_input%'";
        if ($type == 2) {
            $sql.= "AND uv.upload_video_status = '1'";
        }
        $sql.=" GROUP BY uv.upload_video_section_name
                ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_active_video_course_section_by_video_course_id 
     * @Used IN             : @function-'view_video_course'              Welcome[@Controller]
     * @Description         : select active uploaded video section using video_course_id
     * @Developed By        : MD JAherul Islam
     * @Start DateTime      : 12-04-2016 01:08 PM
     * @Parameter           : $video_course_id[INTEGER]
     * @Return              : all_active_video_course
     * @Status              : available      
     * */
    function select_active_video_course_section_by_video_course_id($video_course_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.video_management_id = '$video_course_id'
               AND uv.upload_video_status = '1'
                GROUP BY uv.upload_video_section_name
                ORDER BY uv.upload_video_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_all_upload_video_id_by_video_course_id 
     * @Used IN             : @function-'skip_video_course_work_file'    super_admin_video[@Controller]
     * @Description         : select all uploaded video ID using video_course_id
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 23-03-2016 04:40 PM
     * @Status              : available      
     * */
    function get_all_upload_video_id_by_video_course_id($video_course_id) {
        $sql = "SELECT group_concat(uv.upload_video_id) as upload_video_id_string 
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.video_management_id = '$video_course_id'";
        $result = $this->db->query($sql)->row();
        return $result->upload_video_id_string;
    }

    /**
     * @Function            : get_single_free_video_information_by_video_course_id 
     * @Used IN             : @function-'view_video_course'   Welcome[@Controller] (1795)
     * @Description         : get single free uploaded video by video course ID
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 10-04-2016 04:04 PM  
     * @Parameter           : $video_course_id[INTEGER]
     * @Return              : Free_uploaded_video_info    
     * @Status              : Available        
     * */
    function get_single_free_video_information_by_video_course_id($video_course_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS up
                WHERE 
                    up.video_management_id = '$video_course_id'
                AND up.upload_video_access_level = '1'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_video_course_access_level 
     * @Used IN             : @function-'view_video_course'   Welcome[@Controller] (1795)
     * @Description         : check video course access level
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 12-04-2016 12:29 PM  
     * @Parameter           : $person_id[INTEGER], $data[ARRAY]
     * @Return              : 1(if matched) OR 2(not matched)   
     * @Status              : Available        
     * */
    function check_video_course_access_level($person_id, $data) {
        if ($person_id) {
            $result = $this->person_model->check_user_authentication_for_view_video_course($person_id, $data['video_course_info']->course_creator_id, $data['video_course_info']->resource_person_id);
            return $result;
        } else {
            return 2; // if user does not login
        }
    }

    function check_video_file_type($fileType) {
        $allowedFileType = Array("mp4", "flv");
        if (in_array($fileType, $allowedFileType)) {
            return 1;
        } else {
            return 2;
        }
    }

    /*
      -----------@@@RIPON@ End Video Course Work file Part----------------------------------
     */


    /*
      -----------@@@RIPON@ Start View public Video Course Part----------------------------------
     */

    /**
     * @Function            : get_all_video_courses 
     * @Used IN             : @function-'index'    video_course[@Controller]
     * @Description         : get all video course category
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 12:15 PM
     * @Status              : available      
     * */
    function get_all_video_courses($category_id, $video_management_level, $video_course_topic_array, $free_video_course_value, $video_priority_level, $search_input, $number) {
        $sql = "SELECT 
                    *
                FROM 
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url as u
                WHERE 
                    vm.video_management_status IN (1,4)
                AND vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id
                AND u.url_type = '8'";
        if ($category_id != '') {
            $sql.= " AND vm.course_category_id IN ($category_id)";
        }
        if ($video_management_level != '') {
            $sql.=" AND vm.video_management_level IN ($video_management_level)";
        }
        if ($video_course_topic_array) {
            $sql.= " AND (";
            for ($i = 0; $i < count($video_course_topic_array); $i++) {
                if ($i > 0) {
                    $sql.= " OR vm.video_management_keyword LIKE '%$video_course_topic_array[$i]%'";
                } else {
                    $sql.= " vm.video_management_keyword LIKE '%$video_course_topic_array[$i]%'";
                }
            }
            $sql.= " )";
        }
        if ($free_video_course_value != '') {
            $sql.= " AND vm.video_course_type = '$free_video_course_value'";
        }
        if ($search_input != '') {
            $sql.= " AND (vm.video_course_title LIKE '%$search_input%' OR vm.video_management_keyword LIKE '%$search_input%')";
        }
        if ($video_priority_level != '') {
            if ($video_priority_level == 1) {
                $sql.=" ORDER BY vm.video_course_view ASC";
            } else if ($video_priority_level == 2) {
                $sql.=" ORDER BY vm.video_course_view DESC";
            }
        } else {
            $sql.=" ORDER BY vm.video_course_title ASC";
        }
        $sql.=" LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_all_video_courses 
     * @Used IN             : @function-'index'    video_course[@Controller]
     * @Description         : get all video course category
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 12:15 PM
     * @Status              : available      
     * */
    function get_total_video_courses($category_id, $video_management_level, $video_course_topic_array, $free_video_course_value) {
        $sql = "SELECT count(*) AS total_video_course
                FROM 
                    tbl_video_management AS vm,
                    tbl_course_category AS cc,
                    tbl_person AS p,
                    tbl_url as u
                WHERE 
                    vm.video_management_status IN (1,4)
                AND vm.course_category_id = cc.course_category_id
                AND vm.person_id = p.person_id
                AND vm.url_id = u.url_id
                AND u.url_type = '8'";
        if ($category_id != '') {
            $sql.= " AND vm.course_category_id IN ($category_id)";
        }
        if ($video_management_level != '') {
            $sql.=" AND vm.video_management_level IN ($video_management_level)";
        }
        if ($video_course_topic_array) {
            $sql.= " AND (";
            for ($i = 0; $i < count($video_course_topic_array); $i++) {
                if ($i > 0) {
                    $sql.= " OR vm.video_management_keyword LIKE '%$video_course_topic_array[$i]%'";
                } else {
                    $sql.= " vm.video_management_keyword LIKE '%$video_course_topic_array[$i]%'";
                }
            }
            $sql.= " )";
        }
        if ($free_video_course_value != '') {
            $sql.= " AND vm.video_course_type = '$free_video_course_value'";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_all_published_video_course_category 
     * @Used IN             : @function-'index'    video_course[@Controller]
     * @Description         : get all video course category
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 12:15 PM
     * @Status              : available      
     * */
    function select_all_published_video_course_category($number) {
        $sql = "SELECT 
                    DISTINCT cc.course_category_id, cc.course_category_name
                FROM 
                    tbl_video_management AS vm,
                    tbl_course_category AS cc
                WHERE 
                    vm.video_management_status IN (1,4)
                AND vm.course_category_id = cc.course_category_id
                ORDER BY cc.course_category_name ASC
                LIMIT $number";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_total_published_video_course_category 
     * @Used IN             : @function-'view_video_course'    video_course[@Controller]
     * @Description         : get total video course category
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 24-03-2016 12:19 PM
     * @Status              : available      
     * */
    function select_total_published_video_course_category() {
        $sql = "SELECT DISTINCT cc.course_category_id, cc.course_category_name
                FROM 
                    tbl_video_management AS vm,
                    tbl_course_category AS cc
                WHERE 
                    vm.video_management_status IN (1,4)
                AND vm.course_category_id = cc.course_category_id";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_work_file_by_video_course_id 
     * @Used IN             : @function-'view_video_course'   welcome[@Controller]
     * @Description         : Select all work file by video course ID
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 11-04-2016 04:28 PM  
     * @Parameter           : $video_course_id[INTEGER],$type[INTEGER]
     * @Return              : all_video_work_file    
     * @Status              : Available        
     * */
    function select_all_work_file_by_video_course_id($video_course_id, $type) {
        $sql = "SELECT * 
                FROM 
                    tbl_upload_video AS uv,
                    tbl_work_files_management AS wfm
                WHERE 
                    uv.video_management_id = '$video_course_id'
                AND uv.upload_video_id = wfm.upload_video_id";
        if ($type == 2) {
            $sql.=" AND wfm.work_files_status = '1'";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_uploaded_video_by_video_course_id 
     * @Used IN             : @function-'view_video_course'   welcome[@Controller]
     * @Description         : get total uploaded video 
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 12-04-2016 05:02 PM  
     * @Parameter           : $video_course_id[INTEGER],$type[INTEGER]
     * @Return              : total_uploaaded_video    
     * @Status              : Available        
     * */
    function get_total_uploaded_video_by_video_course_id($video_course_id, $type) {
        $sql = "SELECT count(*) AS total
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.video_management_id = '$video_course_id'";
        if ($type == 2) {
            $sql.=" AND uv.upload_video_status = '1'";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_total_uploaded_video_duration_by_video_course_id 
     * @Used IN             : @function-'view_video_course'   welcome[@Controller]
     * @Description         : get total uploaded video duration
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 12-04-2016 05:22 PM  
     * @Parameter           : $video_course_id[INTEGER],$type[INTEGER]
     * @Return              : total_uploaaded_video_duration    
     * @Status              : Available        
     * */
    function get_total_uploaded_video_duration_by_video_course_id($video_course_id, $type) {
        $sql = "SELECT 
                	SEC_TO_TIME(SUM(TIME_TO_SEC(uv.upload_video_time_length))) AS duration
                FROM 
                    tbl_upload_video AS uv
                WHERE 
                    uv.video_management_id = '$video_course_id'";
        if ($type == 2) {
            $sql.=" AND uv.upload_video_status = '1'";
        }
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : video_course_registration 
     * @Used IN             : @function-'enroll_video_course'     Welcome[@controller],
     * @Description         : Video Course Registration  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 13-04-2016 02:26 PM    
     * @Parameter           : $data[ARRAY],$person_id[INTEGER]
     * @Return              : payment_id      
     * @Status              : available      
     * */
    public function video_course_registration($data, $person_id) {
        $s_data['course_id'] = $data['video_course_info']->video_management_id;
        $s_data['person_id'] = $person_id;
//        $s_data['student_type'] = '2';
        $student_id = $this->utility_model->save_information_in_database('tbl_student', $s_data);

        $data['student_info'] = $this->person_model->select_video_course_student_information_by_student_id($student_id);
        $p_data['payment_id'] = $this->payment_model->save_student_video_course_payment_info($data['student_info']);
        $this->update_information_in_database('tbl_student', 'student_id', $student_id, $p_data);
        return $p_data['payment_id'];
    }

    /**
     * @Function            : get_single_public_video_course_by_menu_id 
     * @Used IN             : @function-'public_menu_view'  application[@controller] - [338]
     * @Description         : get public video course by menu ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 11:52 AM
     * @Parameter           : $menu_id[INTEGER]
     * @Return              : video_course_info    
     * @Status              : Available       
     * */
    function get_single_public_video_course_by_menu_id($menu_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_video_management AS vm,
                    tbl_url AS u
                WHERE 
                    vm.url_id = u.url_id
                    AND u.url_type = '8'
                    AND vm.menu_id = '$menu_id'
                    AND vm.video_management_status  IN (1,4)";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@ End View public Video Course Part----------------------------------
     */

    /**
     * @Function            : save_information_in_database 
     * @Description         : Save Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Status              : available      
     * */
    function save_information_in_database($table_name, $data) {
        $this->db->insert($table_name, $data);
        return $this->db->insert_id();
    }

    /**
     * @Function            : update_information_in_database 
     * @Description         : Update Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Status              : available      
     * */
    function update_information_in_database($table_name, $table_id, $id, $data) {
        $data['video_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($data['video_training_objectives']);
        $data['video_training_outline'] = $this->tinymce_model->changed_special_character_to_text($data['video_training_outline']);        
        $this->db->where($table_id, $id);
        $this->db->update($table_name, $data);
    }

    /**
     * @Function            : delete_information_in_database 
     * @Description         : Delete Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Status              : available      
     * */
    function delete_information_in_database($table_name, $table_id, $user_id) {
        $this->db->where($table_id, $user_id);
        $this->db->delete($table_name);
    }

    /**
     * @Function            : get_video_duration 
     * @Description         : get video duration
     * @Developed By        : Ripon Jaherul
     * @Status              : available      
     * */
    function get_video_duration($video_path) {
        $matches = 0;
        $check_path = shell_exec("ffmpeg -i \"{$video_path}\" 2>&1");
        $search = '/Duration: (.*?),/';
        preg_match($search, $check_path, $matches);

        if ($matches) {
            return 1;
        } else {
            return 0;
        }
    }
    /**
     * @Function            : check_video_validation 
     * @Description         : check video validation
     * @Developed By        : Ripon Jaherul
     * @Status              : available      
     * */
    function check_video_validation($video_path) {
        $matches = 0;
        $check_path = shell_exec("ffmpeg -i \"{$video_path}\" 2>&1");
        $search = '/Duration: (.*?),/';
        preg_match($search, $check_path, $matches);

        if ($matches) {
            return 1;
        } else {
            return 0;
        }
    }

    /*
      -----------@@@RIPON@ Start public video course search Part----------------------------------
     */

    function get_video_course_value_by_search($data, $search_value, $start_limit, $end_limit) {
        $searched_video_course = $this->get_searched_video_course_information($search_value, $start_limit, $end_limit);
        if ($searched_video_course) {
            $data['searched_video_course'] = $searched_video_course;
            $data['total_searched_video_course'] = $this->get_total_searched_video_course_information($search_value);
        }
        return $data;
    }

    /**
     * @Function            : get_searched_video_course_information 
     * @Used IN             : @function-'view_searched_value'  welcome[@controller],
     * @Description         : get course information by search 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 10:14 AM   
     * @Status              : available      
     * */
    function get_searched_video_course_information($search_value, $start_limit, $end_limit) {
        $sql = "SELECT *
                FROM 
                    tbl_video_management AS vm,
                    tbl_url AS u
                WHERE
                    vm.url_id = u.url_id
                AND u.url_type = '8'
                AND vm.video_course_title LIKE '%$search_value%'
                AND vm.video_management_status IN (1,4)
                ORDER BY vm.video_course_title ASC
                LIMIT $start_limit,$end_limit";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_searched_video_course_information 
     * @Used IN             : @function-'view_searched_value'  welcome[@controller],
     * @Description         : get total course information by search 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 01:48 AM   
     * @Status              : available      
     * */
    function get_total_searched_video_course_information($search_value) {
        $sql = "SELECT count(*) AS total_video_course
                FROM 
                    tbl_video_management AS vm,
                    tbl_url AS u
                WHERE
                    vm.url_id = u.url_id
                AND u.url_type = '8'
                AND vm.video_course_title LIKE '%$search_value%'
                AND vm.video_management_status IN (1,4)";
        $resoult = $this->db->query($sql)->row();
        return $resoult->total_video_course;
    }
    
   
    /**
     * @Function            : get_all_course_category 
     * @Used IN             : @function-'edit_video_course'  User_video[@controller],
     * @Description         : get all video course category
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 27-03-2017   
     * @Status              : available     
     * */
    
 public function get_all_course_category(){
     $result = $this->db->select('course_category_id, course_category_name')
                        ->from('tbl_course_category')->get()->result();
     return $result;
 }
 
     /**
     * @Function            : update_video_course_status 
     * @Used IN             : @function-'delete_video_course'  User_video[@controller],
     * @Description         : changes video Course status to archieve
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 27-03-2017   
     * @Status              : available     
     * */
 public function update_video_course_status($video_management_id){
     $this->db->set('video_management_status', 2)
             ->where('video_management_id', $video_management_id)
             ->update('tbl_video_management');
 }

    /*
      -----------@@@RIPON@ Start public video course search Part----------------------------------
     */
}
