<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Super_Admin_Support_Model extends CI_Model {

    /**
     * Function            : save_knowledgebase
     * Used IN             : function['add_knowledgebase'] controller['super_admin_support']
     * Description         : To save knowledgebase information
     * Developed By        : Tania Akter
     * Start DateTime      : 27/04/2016  
     * Status              : available      
     * */
    function save_knowledgebase($person_id) {
        $data = array();
        $data['person_id'] = $person_id;
        $data['support_title'] = $this->input->post('knowledgebase_idea_title', TRUE);
        $data['support_description'] = $this->input->post('knowledgebase_description', TRUE);
        $data['support_type'] = 1; // here, 1 means support type is knowledgebase
        $data['support_status'] = 0; // here, o means support status is inactive
        $this->db->insert('tbl_support', $data);
    }

    /**
     * Function            : get_total_knowledgebase
     * Used IN             : *function['manage_knowledgebase'] *controller['super_admin_support']
     * Description         : To get total row numbers
     * Developed By        : Tania Akter
     * Start DateTime      : 27/04/2016  
     * Status              : available      
     * */
    function get_total_knowledgebase() {
        $sql = "SELECT "
                . "count(*) AS total_knowledgebase "
                . "FROM "
                . "tbl_support WHERE support_type='1'";
        return $this->db->query($sql)->row();
    }

    /**
     * Function            : select_all_knowledgebase_for_manage_knowledgebase
     * Used IN             : function['manage_knowledgebase'] controller['super_admin_support']
     * Description         : This function is used to get and arrange all knowledgebase information according to  pagination number
     * Developed By        : Tania Akter
     * Start DateTime      : 27/04/2016  
     * Status              : available      
     * */
    function select_all_knowledgebase_for_manage_knowledgebase($number) {
        $sql = "SELECT * FROM tbl_support WHERE support_type='1'  ORDER BY support_id DESC LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * Function            : get_edit_knowledgebase_info
     * Used IN             : function['edit_knowledgebase'] controller['super_admin_support']  line-84
     * Description         : get knowledgebase information by support_id
     * Developed By        : Tania Akter
     * Start DateTime      : 27/04/2016  
     * Status              : available      
     * */
    function get_edit_knowledgebase_info($support_id) {
        $sql = "SELECT * FROM tbl_support WHERE support_id='$support_id' ";
        return $this->db->query($sql)->row();
    }

    /**
     * Function            : update_knowledgebase_info
     * Used IN             : function['update_knowledgebase'] controller['super_admin_support']
     * Description         : To update knowledgebase information
     * Developed By        : Tania Akter
     * Start DateTime      : 27/04/2016  
     * Status              : available      
     * */
    function update_knowledgebase_info() {
        $support_id = $this->input->post('support_id', true);
        $data = array();
        $data['support_title'] = $this->input->post('knowledgebase_idea_title', TRUE);
        $data['support_description'] = $this->input->post('knowledgebase_description', TRUE);
        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);
    }

    /**
     * Function            : make_active_knowledgebase
     * Used IN             : function['active_knowledgebase'] controller['super_admin_support']
     * Description         : used to make active knowledgebase information
     * Developed By        : Tania Akter
     * Start DateTime      : 28/04/2016  
     * Status              : available      
     * */
    function make_active_knowledgebase() {
        $support_id = $this->input->post('support_id', true);
        $data = array();
        $data['support_status'] = 1; //here, 1 means support status is active

        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);
    }

    /**
     * Function            : make_inactive_knowledgebase
     * Used IN             : function['inactive_knowledgebase'] controller['super_admin_support']
     * Description         : used to make inactive knowledgebase information
     * Developed By        : Tania Akter
     * Start DateTime      : 28/04/2016  
     * Status              : available      
     * */
    function make_inactive_knowledgebase() {
        $support_id = $this->input->post('support_id', true);
        $data = array();
        $data['support_status'] = 0;    //here, 0 means support status is inactive 
        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);
    }

    /**
     * Function            : delete_knowledgebase_info_by_id
     * Used IN             : function['delete_knowledgebase_by_id'] controller['super_admin_support']
     * Description         : To delete knowledgebase information
     * Developed By        : Tania Akter
     * Start DateTime      : 27/04/2016  
     * Status              : available      
     * */
    function delete_knowledgebase_info_by_id() {
        $support_id = $this->input->post('support_id', true);
        $this->db->where('support_id', $support_id);
        $this->db->delete('tbl_support');
    }

    /** ---------------------support knowledgebase frontend start here------------------------------- * */

    /**
     * @Function            : select_related_idea_info
     * @Used IN             : *function['support_idea'],,['support_more_idea'],['support_bug_report'] *controller['front_end_support'];
                              *function [view_support_idea],['reply_support_idea'] ['view_support_bug_report']['reply_support_bug_report'] *controller['super_admin_support'];
     * @Description         : used to get related info (idea/ bug report)
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function select_related_info($number, $type) {
        $sql = "SELECT * FROM tbl_support WHERE support_type= '$type' AND support_status= '1' ORDER BY support_id DESC LIMIT $number";
        return $this->db->query($sql)->result();
    }
    /**
     * @Function            : select_total_related_idea_info
     * @Used IN             : *function['support_idea'],['support_more_idea'], *controller['front_end_support'];
                             *function[view_support_idea],['reply_support_idea'] *controller['super_admin_support'];
     * @Description         : get total numbers of idea file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function select_total_related_idea_info() {
        $sql = "SELECT count(*) AS total_idea FROM tbl_support WHERE support_type= '2' AND support_status= '1'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_download_info
     * @Used IN             : *function['support_idea']['support_bug_report'],*controller['front_end_support'];
     *                       *function[view_support_idea],['reply_support_idea'] ['view_support_bug_report']['reply_support_bug_report'] *controller['super_admin_support'];
     * @Description         : used to get  attachment
     * @Developed By        : Tania Akter
     * @Start DateTime      : 3/05/2016  
     * @Status              : available      
     * */
    function get_download_info($support_id, $type) {
        $sql = "SELECT * 
	FROM tbl_support_attachment AS a,
			tbl_support AS s,
			tbl_person AS p,
			tbl_url AS u			
			WHERE
			s.person_id= p.person_id
			AND
			p.url_id= u.url_id
			AND 
			a.support_type_id=s.support_id
                        AND
                        a.support_type_id= $support_id
			AND a.support_attachment_type='$type'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : sign_in_person_all_info
     * @Used IN             : *function[support_idea] *controller[front_end_support] line--165
     *                        *function['support_bug_report'] *controller[front_end_support]
     *                        *function[view_support_idea][reply_support_idea]['view_support_bug_report']['reply_support_bug_report']  *controller[super_admin_support]
     * @Description         : used to get person info who are signed in
     * @Developed By        : Tania Akter
     * @Start DateTime      : 05/05/2016  
     * @Status              : available      
     * */
    function sign_in_person_all_info($user_id) {
        $sql = "SELECT * FROM  tbl_person AS p, tbl_url AS u WHERE  p.url_id= u.url_id  AND p.person_id= '$user_id' ";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_all_idea_reply
     * @Used IN             : *function['support_idea'],*controller['front_end_support'];
     *                       *function[view_support_idea],['reply_support_idea'] *controller['super_admin_support'];
     * @Description         : used to get  file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 05/05/2016  
     * @Status              : available      
     * */
    function get_all_idea_reply($support_id) {
        $sql = "SELECT *
         FROM 
            tbl_support_reply AS r,            
            tbl_url AS u,
            tbl_person AS p    
        WHERE 
             r.support_id = '$support_id'
             AND r.person_id = p.person_id
             AND p.url_id = u.url_id";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_reply_download_info
     * @Used IN             : *function['support_idea'],*controller['front_end_support'];
     *                       *function[view_support_idea],['reply_support_idea']['view_support_bug_report']['reply_support_bug_report']  *controller['super_admin_support'];
     * @Description         : used to idea/bug report reply download info
     * @Developed By        : Tania Akter
     * @Start DateTime      : 05/05/2016  
     * @Status              : available      
     * */
    function get_reply_download_info($support_reply_id, $type) {
        $sql = "SELECT * 
	FROM tbl_support_attachment AS a,
			tbl_support_reply AS r,
			tbl_person AS p,
			tbl_url AS u			
			WHERE
			r.person_id= p.person_id
			AND
			p.url_id= u.url_id
			AND 
			a.support_type_id=r.support_reply_id
                        AND
                        r.support_reply_id= '$support_reply_id'
			AND a.support_attachment_type='$type'";
        return $this->db->query($sql)->row();
    }

  
/**
     * Function            : get_total_idea
     * Used IN             : function['manage_idea'] controller['super_admin_support']
     * Description         : used to get total idea
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function get_total_idea() {
        $sql = "SELECT count(*) AS total_idea
	FROM tbl_support AS s
	WHERE s.support_type = '2'";
        return $this->db->query($sql)->row();
    }
/**
     * Function            : select_all_idea_for_manage_idea
     * Used IN             : function['manage_idea'] controller['super_admin_support']
     * Description         : used to get idea according to pagination.
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function select_all_idea_for_manage_idea($number) {
        $sql = "SELECT * FROM tbl_support WHERE support_type='2'  ORDER BY support_id DESC LIMIT $number, 10";
        return $this->db->query($sql)->result();
    }

    /**
     * Function            : make_active_idea
     * Used IN             : function['active_idea'] controller['super_admin_support']
     * Description         : used to make active idea information
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function make_active_idea() {
        $support_id = $this->input->post('support_id', true);
        $data = array();
        $data['support_status'] = 1; //here, 1 means support status is active
        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);
    }

    /**
     * Function            : make_inactive_idea
     * Used IN             : function['inactive_idea'] controller['super_admin_support']
     * Description         : used to make inactive idea
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function make_inactive_idea() {
        $support_id = $this->input->post('support_id', true);
        $data = array();
        $data['support_status'] = 0;    //here, 0 means support status is inactive 
        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);
    }

    /**
     * Function            : delete_idea_by_id
     * Used IN             : function['delete_idea'] controller['super_admin_support']
     * Description         : used to delete idea by support_id
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function delete_idea_by_id() {
        $support_id = $this->input->post('support_id', true);
        $this->db->where('support_id', $support_id);
        $this->db->delete('tbl_support');
    }

    /**
     * Function            : get_edit_idea_info
     * Used IN             : function['edit_idea'] controller['super_admin_support']
     * Description         : used to get idea info by id
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function get_edit_idea_info($support_id) {
        $sql = "SELECT * FROM tbl_support WHERE support_id='$support_id' ";
        return $this->db->query($sql)->row();
    }

    /**
     * Function            : get_edit_idea_file
     * Used IN             : function['edit_idea'] controller['super_admin_support']
     * Description         : used to get idea file info
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function get_edit_idea_file($support_id) {
        $sql = "SELECT * 
                    FROM tbl_support_attachment AS a,
			tbl_support AS s,
			tbl_person AS p,
			tbl_url AS u			
			WHERE
			s.person_id= p.person_id
			AND
			p.url_id= u.url_id
			AND 
			a.support_type_id=s.support_id
                        AND
                        a.support_type_id= $support_id
			AND a.support_attachment_type='1'";
        return $this->db->query($sql)->row();
    }

    /**
     * Function            : update_idea_info
     * Used IN             : function['edit_idea'] controller['super_admin_support']
     * Description         : used to update idea attachment
     * Developed By        : Tania Akter
     * Start DateTime      : 08/05/2016  
     * Status              : available      
     * */
    function update_idea_info() {
        $support_id = $this->input->post('support_id', true);
        $update_file_info = $this->update_idea_file_by_id($support_id);
        $data = array();
        $data['support_title'] = $this->input->post('support_title', TRUE);
        $data['support_description'] = $this->input->post('support_description', TRUE);
        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);
        if ($_FILES['update_idea_file']) {
            if ($update_file_info->support_attachment_id) {
                $this->update_idea_file_upload($support_id);
            } else {
                $this->update_idea_file_upload_add($support_id);
            }
        }
    }

    /**
     * Function            : update_idea_file_upload
     * Used IN             : function['update_idea_info'] controller['super_admin_support']
     * Description         : used to update idea attachment
     * Developed By        : Tania Akter
     * Start DateTime      : 09/05/2016  
     * Status              : available      
     * */
    function update_idea_file_upload($support_id) {
        $update_file_info = $this->update_idea_file_by_id($support_id);
        $fileName = $_FILES["update_idea_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["update_idea_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["update_idea_file"]["size"]; // File size in bytes
        $new_file_name = $update_file_info->url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $update_file_info->url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->update_reply_file_move($update_file_info->support_type_id, $update_file_info->support_attachment_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }

    /** code start here for update idea file add* */

    /**
     * @Function            : update_idea_file_upload_add
     * @Used IN             : *function[update_idea_info], *model[super_admin_support_model];
     * @Description         : used to add idea assignment file 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 10/05/2016  
     * @Status              : available      
     * */
    function update_idea_file_upload_add($support_id) {
        $person_info = $this->get_idea_info($support_id);
        $person_url = $person_info->url;
        $fileName = $_FILES["update_idea_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["update_idea_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["update_idea_file"]["size"]; // File size in bytes
        $new_file_name = $person_url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $person_url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->update_idea_file_move_add($support_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }

    /**
     * @Function            : update_idea_file_move_add
     * @Used IN             : *function[update_idea_file_upload_add], *model[super_admin_support_model];
     * @Description         : used to move idea assignment file in target location
     * @Developed By        : Tania Akter
     * @Start DateTime      : 10/05/2016  
     * @Status              : available      
     * */
    function update_idea_file_move_add($support_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $this->update_save_idea_file_add($support_id, $support_attachment_location);
    }

    /**
     * @Function            : update_save_idea_file_add
     * @Used IN             : *function[update_idea_file_move_add], *model[super_admin_support_model];
     * @Description         : used to save idea assignment file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 10/05/2016  
     * @Status              : available      
     * */
    function update_save_idea_file_add($support_id, $support_attachment_location) {
        $data['support_attachment_location'] = $support_attachment_location;
        $data['support_attachment_type'] = 1; //here, 1 means support_type 
        $data['support_type_id'] = $support_id;
        $this->db->insert('tbl_support_attachment', $data);
    }

    /** code end here for update idea file add* */

    /**
     * Function            : update_reply_file_move
     * Used IN             : function['update_idea_file_upload'] controller['super_admin_support']
     * Description         : used to move idea attachment in target location
     * Developed By        : Tania Akter
     * Start DateTime      : 09/05/2016  
     * Status              : available      
     * */
    function update_reply_file_move($support_type_id, $support_attachment_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $data['support_type_id'] = $support_type_id;
        $data['support_attachment_location'] = $support_attachment_location;
        $this->db->where('support_attachment_id', $support_attachment_id);
        $this->db->update('tbl_support_attachment', $data);
    }

    /**
     * Function            : update_idea_file_by_id
     * Used IN             : function['update_idea_info']['update_idea_file_upload']['update_bug_report_info'] model['super_admin_support_model']
     * Description         : get idea attachment by support_id
     * Developed By        : Tania Akter
     * Start DateTime      : 09/05/2016  
     * Status              : available      
     * */
    function update_idea_file_by_id($support_id) {
        $sql = "SELECT * FROM 
	tbl_support_attachment AS a,
	tbl_support AS s,
	tbl_person AS p,
	tbl_url AS u
	WHERE
	s.support_id = a.support_type_id
	AND
	 s.person_id = p.person_id 
	 AND 
	 p.url_id=u.url_id
	 AND
	 s.support_id='$support_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * Function            : delete_idea_file_by_id
     * Used IN             : function['delete_idea_file'] controller['super_admin_support']
     * Description         : delete idea attachment by support_id
     * Developed By        : Tania Akter
     * Start DateTime      : 11/05/2016  
     * Status              : available      
     * */
    function delete_idea_file_by_id() {
        $support_attachment_id = $this->input->post('support_attachment_id', true);
        $this->db->where('support_attachment_id', $support_attachment_id);
        $this->db->delete('tbl_support_attachment');
    }

    /*     * ------------------------------------- end idea back_end ---------------------------------------------* */
  
 
    
  

     /**
     * @Function            : select_all_bug_report_for_manage_bug
     * @Used IN             : *function['manage_bug_report'], *controller[super_admin_support];
     * @Description         : get bug report according to pagination
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    
    function select_all_bug_report_for_manage_bug($number){
       $sql = "SELECT * FROM tbl_support WHERE support_type='3'  ORDER BY support_id DESC LIMIT $number, 10";
        return $this->db->query($sql)->result();  
    }
      /**
     * @Function            : get_total_bug
     * @Used IN             : *function['manage_bug_report'], *controller[super_admin_support];
     * @Description         : get total number of bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function get_total_bug(){
        $sql = "SELECT count(*) AS total_bug
	FROM tbl_support AS s
	WHERE s.support_type = '3'";
        return $this->db->query($sql)->row();   
    }
    
    /**
     * @Function            : delete_bug_report_by_support_id
     * @Used IN             : *function['delete_bug_report'], *model[super_admin_support];
     * @Description         : used to delete bug report
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function delete_bug_report_by_support_id(){
        $support_id = $this->input->post('support_id', true);
        $this->db->where('support_id', $support_id);
        $this->db->delete('tbl_support'); 
    }
    
      /**
     * @Function            : make_active_bug_report
     * @Used IN             : *function['active_bug_report'], *model[super_admin_support];
     * @Description         : used to bug report active
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function make_active_bug_report(){
        $support_id = $this->input->post('support_id', true);
        $data = array();
        $data['support_status'] = 1; //here, 1 means support status is active

        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);   
    }
       /**
     * @Function            : make_inactive_bug_report
     * @Used IN             : *function['inactive_bug_report'], *model[super_admin_support];
     * @Description         : used to bug report inactive
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function make_inactive_bug_report(){
        $support_id = $this->input->post('support_id', true);
        $data = array();
        $data['support_status'] = 0; //here, 1 means support status is active

        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);   
    }
    
       /**
     * @Function            : get_bug_report_info
     * @Used IN             : *function['support_bug_report'] *controller['front_end_support'];
        *                      *function['view_support_bug_report']['reply_support_bug_report']  *controller['super_admin_support'];
     * @Description         : used to get information about bug report 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function get_bug_report_info($support_id) {
        $sql = "SELECT *, s.person_id AS support_creator_id
                FROM tbl_support AS s,
                tbl_person AS p,
                tbl_url AS u
                WHERE s.person_id = p.person_id
                AND p.url_id = u.url_id
                AND s.support_id= '$support_id' ";
        return $this->db->query($sql)->row();
    }
    
    /**
     * @Function            : select_total_related_bug_report_info
     * @Used IN             : *function['support_more_bug_report'],['support_bug_report'], *controller['front_end_support'];
                             *function['view_support_bug_report'],['reply_support_bug_report'] *controller['super_admin_support'];
     * @Description         : get total numbers of bug report file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function select_total_related_bug_report_info() {
        $sql = "SELECT count(*) AS total_bug_report FROM tbl_support WHERE support_type= '3' AND support_status= '1'";
        return $this->db->query($sql)->row();
    }
   
    /**
     * @Function            : get_all_bug_report_reply
     * @Used IN             : *function['support_bug_report'],*controller['front_end_support'];
     *                       *function[view_support_bug_report],['reply_support_bug_report'] *controller['super_admin_support'];
     * @Description         : used to get  bug report reply 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 16/05/2016  
     * @Status              : available      
     * */
    function get_all_bug_report_reply($support_id) {
        $sql = " SELECT *
         FROM 
            tbl_support_reply AS r,            
            tbl_url AS u,
            tbl_person AS p    
        WHERE 
             r.support_id = '$support_id'
             AND r.person_id = p.person_id
             AND p.url_id = u.url_id             
            ";
        return $this->db->query($sql)->result();
    }


    
      /**17-05-2015
     * Function            : get_edit_bug_report_info
     * Used IN             : function['edit_bug_report'] controller['super_admin_support']
     * Description         : used to get Bug report  info by id
     * Developed By        : Tania Akter
     * Start DateTime      : 17/05/2016  
     * Status              : available      
     * */
    function get_edit_bug_report_info($support_id) {
        $sql = "SELECT * FROM tbl_support WHERE support_id='$support_id' ";
        return $this->db->query($sql)->row();
    }
    /**
     * Function            : get_edit_bug_report_attachment
     * Used IN             : function['edit_bug_report'] controller['super_admin_support']
     * Description         : used to get Bug report  file info
     * Developed By        : Tania Akter
     * Start DateTime      : 17/05/2016  
     * Status              : available      
     * */
    function get_edit_bug_report_attachment($support_id) {
        $sql = "SELECT * 
                    FROM tbl_support_attachment AS a,
			tbl_support AS s,
			tbl_person AS p,
			tbl_url AS u			
			WHERE
			s.person_id= p.person_id
			AND
			p.url_id= u.url_id
			AND 
			a.support_type_id=s.support_id
                        AND
                        a.support_type_id= $support_id
			AND a.support_attachment_type='1'";
        return $this->db->query($sql)->row();
    }
    /**
     * Function            : update_bug_report_info
     * Used IN             : function['edit_bug_report'] controller['super_admin_support']
     * Description         : used to update bug report attachment
     * Developed By        : Tania Akter
     * Start DateTime      : 17/05/2016  
     * Status              : available      
     * */
    function update_bug_report_info() {
        $support_id = $this->input->post('support_id', true);
        $update_file_info = $this->update_idea_file_by_id($support_id);
        $data = array();
        $data['support_title'] = $this->input->post('bug_subject', TRUE);
        $data['support_description'] = $this->input->post('bug_description', TRUE);
        $this->db->where('support_id', $support_id);
        $this->db->update('tbl_support', $data);
        if ($_FILES['update_bug_file']) {
           if ($update_file_info->support_attachment_id) {
                $this->update_bug_file_upload($support_id);
            } else {
                $this->update_bug_file_upload_add($support_id);
            }
        }
    }
    

    /**
     * Function            : update_bug_file_upload
     * Used IN             : function['update_bug_report_info'] *model[super_admin_support_model];
     * Description         : used to update bug report attachment
     * Developed By        : Tania Akter
     * Start DateTime      : 17/05/2016  
     * Status              : available      
     * */
    function update_bug_file_upload($support_id) {
        $update_file_info = $this->update_idea_file_by_id($support_id);
        $fileName = $_FILES["update_bug_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["update_bug_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["update_bug_file"]["size"]; // File size in bytes
        $new_file_name = $update_file_info->url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $update_file_info->url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->update_bug_file_move($update_file_info->support_type_id, $update_file_info->support_attachment_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }
       /**
     * Function            : update_bug_file_move
     * Used IN             : function['update_bug_file_upload'] *model[super_admin_support_model];
     * Description         : used to move bug report attachment in target location
     * Developed By        : Tania Akter
     * Start DateTime      : 09/05/2016  
     * Status              : available      
     * */
    function update_bug_file_move($support_type_id, $support_attachment_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $data['support_type_id'] = $support_type_id;
        $data['support_attachment_location'] = $support_attachment_location;
        $this->db->where('support_attachment_id', $support_attachment_id);
        $this->db->update('tbl_support_attachment', $data);
    }
    
    
    /** code start here for update bug report file add* */

    /**
     * @Function            : update_bug_file_upload_add
     * @Used IN             : *function[update_bug_report_info], *model[super_admin_support_model];
     * @Description         : used to add bug report attachment file 
     * @Developed By        : Tania Akter
     * @Start DateTime      : 10/05/2016  
     * @Status              : available      
     * */
    function update_bug_file_upload_add($support_id) {
        $person_info = $this->get_idea_info($support_id);
        $person_url = $person_info->url;
        $fileName = $_FILES["update_bug_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["update_bug_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["update_bug_file"]["size"]; // File size in bytes
        $new_file_name = $person_url . '-' . date('h-i-s-a-m-d-Y', (time()));
        if ($fileSize < 5242880) {
            $folder = 'content-library/' . $person_url . '/assignment-file/';
            $target_file = $folder . $fileName;
            if (move_uploaded_file($fileTmpLoc, $target_file)) {
                $this->update_bug_file_move_add($support_id, $target_file, $fileName, $new_file_name, $folder);
            }
        } else {
            echo 'File size must less then 5 Mb';
        }
    }

    /**
     * @Function            : update_idea_file_move_add
     * @Used IN             : *function[update_bug_file_upload_add], *model[super_admin_support_model];
     * @Description         : used to move bug report attachment in target location
     * @Developed By        : Tania Akter
     * @Start DateTime      : 10/05/2016  
     * @Status              : available      
     * */
    function update_bug_file_move_add($support_id, $target_file, $fileName, $new_file_name, $folder) {
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        rename("$target_file", "$folder$new_file_name.$file_extention");
        $support_attachment_location = "assignment-file/$new_file_name.$file_extention";
        $this->update_save_bug_file_add($support_id, $support_attachment_location);
    }

    /**
     * @Function            : update_save_idea_file_add
     * @Used IN             : *function[update_bug_file_move_add], *model[super_admin_support_model];
     * @Description         : used to save bug report assignment file
     * @Developed By        : Tania Akter
     * @Start DateTime      : 17/05/2016  
     * @Status              : available      
     * */
    function update_save_bug_file_add($support_id, $support_attachment_location) {
        $data['support_attachment_location'] = $support_attachment_location;
        $data['support_attachment_type'] = 1; //here, 1 means support_type 
        $data['support_type_id'] = $support_id;
        $this->db->insert('tbl_support_attachment', $data);
    }

    /** code end here for update bug report file add* */
        /**
     * Function            : delete_bug_attachment_by_id
     * Used IN             : function['delete_bug_file'] controller['super_admin_support']
     * Description         : delete bug report attachment by support_id
     * Developed By        : Tania Akter
     * Start DateTime      : 17/05/2016  
     * Status              : available      
     * */
    function delete_bug_attachment_by_id() {
        $support_attachment_id = $this->input->post('support_attachment_id', true);
        $this->db->where('support_attachment_id', $support_attachment_id);
        $this->db->delete('tbl_support_attachment');
    }
}