<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->library('image_lib');
    }

    /**
     * @Function            : get_dashboard_data 
     * @Used IN             : @function-'index'    super_admin[@controller]
     * @Description         : get dashboard data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-09-2016 12:02 PM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_dashboard_data($data) {
        $data['dashboard_user_info'] = $this->person_model->view_admin_user_information();
        $data['dashboard_course_info'] = $this->super_admin_course_model->view_admin_course_information();
        $data['course_notification_info'] = $this->course_model->set_person_id(1)->view_course_notification()->get_result();
        $data['payment_notification_info'] = $this->payment_model->set_person_id(1)->view_payment_notification()->get_result();
        return $data;
    }

    /**
     * @Function            : assign_data_for_fromt_end_user_view 
     * @Used IN             : @function-'view_detail'    super_admin[@controller]
     * @Description         : assign data id user(organization,teacher,learner) as view  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-05-2016 06:22 PM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function assign_data_for_fromt_end_user_view($data) {
        if ($data['person_info']->person_role == 3 || $data['person_info']->person_role == 4 || $data['person_info']->person_role == 5) {
            $data['top_menu'] = 'active';
            if ($data['person_info']->person_role == 3) {
                $data['as_organization'] = 0;
                $data['as_teacher'] = 1;
                $data['as_learner'] = 1;
            }
            if ($data['person_info']->person_role == 4) {
                $data['as_organization'] = 1;
                $data['as_teacher'] = 0;
                $data['as_learner'] = 1;
            }
            if ($data['person_info']->person_role == 5) {
                $data['as_organization'] = 0;
                $data['as_teacher'] = 0;
                $data['as_learner'] = 1;
            }
        }
        return $data;
    }

    /*
     * @@Start
     * By : Jaherul Islam
     * Description : View user (ADMIN Part) - 01-12-2016
     */

    /**
     * 
     * 
     * @Description         : select all user for manage user
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:25 AM       
     * */
    public function select_all_user($role, $status, $search_value, $sort, $number, $per_page_view) {
        $sql = "SELECT * 
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    p.url_id = u.url_id";
        if ($role != '') {
            $sql .= " AND p.person_role = '$role'";
        }
        if ($status != '') {
            $sql .= " AND p.person_status IN ($status)";
        }
        if ($search_value != '') {
            $sql .= " AND (person_first_name LIKE '$search_value%'
                OR person_last_name LIKE '$search_value%'
                OR person_email LIKE '$search_value%')";
        }
        if ($sort != '') {
            $sql .= " ORDER BY p.person_first_name $sort";
        }
        if (($role != '' || $status != '' || $search_value != '') && $sort == '') {
            $sql .= " ORDER BY p.person_id ASC";
        }
        if ($role == '' && $sort == '' && $search_value == '' && $status == '') {
            $sql .= " ORDER BY p.person_id ASC";
        }
        $sql .= " LIMIT $number,$per_page_view";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : select total user for manage user
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:25 AM       
     * */
    public function get_total_user($role, $status, $search_value) {
        $sql = "SELECT
                    count(*) AS total_user
                FROM
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    p.url_id = u.url_id";
        if ($role != '') {
            $sql .= " AND p.person_role = '$role'";
        }
        if ($status != '') {
            $sql .= " AND p.person_status = '$status'";
        }
        if ($search_value != '') {
            $sql .= " AND (person_first_name LIKE '$search_value%'
                    OR person_last_name LIKE '$search_value%'
                    OR person_email LIKE '$search_value%')";
        }
        return $this->db->query($sql)->row();
    }

    function get_single_user_info($person_id) {
        $this->db->select('person_id, person_email, person_first_name, person_last_name')
                ->from('tbl_person')
                ->where('person_id', $person_id);
        return $this->db->get()->row();
    }

    /*
     * @@End
     * By : Jaherul Islam
     * Description : View user (ADMIN Part) - 01-12-2016
     */



    /*
     * 
     * 
     * 
     * 
     * @@@Start
     * By : Jaherul Islam
     * Description : Add user (ADMIN Part) - 01-11-2016
     */

    /**
     * @Description         : check email in database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:02 AM       
     * */
    public function check_person_email($person_email) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_email', $person_email);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    /**
     * @Description         : check Organization Name in database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:02 AM       
     * */
    public function check_organization_name_code($organization_code, $organization_id) {
        $sql = "SELECT * FROM tbl_organization as o WHERE o.organization_code = '$organization_code' AND o.organization_id = $organization_id ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Description         : check Organization Code in database
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-12-2016 10:02 AM       
     * */
    public function select_organization_by_code($organization_code) {
        $sql = "SELECT * FROM tbl_organization as o WHERE o.organization_code = '$organization_code' ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'create_new_user'    super_admin[@controller],
     * @Description         : Save person information  
     * @                    : @Update2- remove feature information  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 18-01-2016 01:38 PM   |   01-03-2016 02:46 PM
     * @Updated By          : Ripon Jaherul         |   Ripon Jaherul
     * @Status              : available      
     * */
    public function save_person_information($url_data) {
        $pdata = array();
        $pdata['person_email'] = $this->input->post('person_email', TRUE);
        $pdata['person_password'] = md5($this->input->post('person_password', TRUE));
        $pdata['person_first_name'] = $this->input->post('person_first_name', TRUE);
        $pdata['person_last_name'] = $this->input->post('person_last_name', TRUE);
        $pdata['person_gender'] = $this->input->post('person_gender', TRUE);
        $country_code = $this->input->post('country_code', TRUE);
        $pdata['person_contact_number'] = $country_code . ' ' . $this->input->post('person_contact_number', TRUE);
        $pdata['person_country'] = $this->input->post('person_country', TRUE);
        $pdata['person_city'] = $this->input->post('person_city', TRUE);
        $pdata['person_zip'] = $this->input->post('person_zip', TRUE);
        $pdata['person_time_zone'] = $this->input->post('person_time_zone', TRUE);
        $pdata['person_address'] = $this->input->post('person_address', TRUE);
        $pdata['person_role'] = $this->input->post('person_role', TRUE);
        $pdata['person_status'] = $this->input->post('person_status', TRUE);
        $pdata['person_birthday'] = $this->input->post('person_birthday', TRUE);
        $pdata['person_join_tt'] = date('Y-m-d H:i:s');

        // Save URL information
        $pdata['url_id '] = $url_data['url_id'];
        /*
         * Start Image Upload
         */
        if ($_FILES['person_image']['name']) {
            $upload_path = 'content-library/' . $url_data['url'] . '/my-image/';
            $allowed_types = 'gif|jpg|png';
            $image_data = $this->image_model->upload_file($upload_path, $allowed_types, '2048', 'person_image');
            $pdata['person_image'] = 'my-image/' . $image_data['file_name'];

            $image_path = $upload_path . $image_data['file_name'];
            $new_image_name = $image_data['raw_name'] . '_thumb' . $image_data['file_ext'];
            $image_thumb = $upload_path . $new_image_name;

            $this->image_model->create_thumbnail_image($image_thumb, $image_path);
            $pdata['person_image_thumb'] = 'my-image/' . $new_image_name;
        }
        // END Create Thumbnail
        /*
         * End Image Ipload
         */
        $person_id = $this->utility_model->save_information_in_database('tbl_person', $pdata);

        if ($pdata['person_role'] == '4') {
            $this->save_organization_information($person_id);
        } else if ($pdata['person_role'] == '3') {
            $this->resource_person_model->set_person_id($person_id)
                    ->set_resource_person_type($this->input->post('resource_person_type', TRUE))->save();
        }
        $this->person_model->save_person_info_view_status($person_id);
        return $person_id;
    }

    /**
     * @Function            : save_organization_information 
     * @Used IN             : @function-'save_person_information'     this[@controller],
     * @Description         : save organization information  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 01-03-2016 02:52 PM    
     * @Status              : available      
     * */
    function save_organization_information($person_id) {
        // Save Organization information
        $this->organization_model->person_id = $person_id;
        $this->organization_model->organization_name = $this->input->post('organization_name', TRUE);
        $this->organization_model->organization_code = $this->input->post('organization_code', TRUE);
        $this->organization_model->organization_status = 1;
        $organization_id = $this->organization_model->set_table_name('tbl_organization')->save()->create_insert_id()->get_id();

        // save resource person infomation
        $resource_person_id = $this->resource_person_model->set_person_id($person_id)
                        ->set_resource_person_type(3)->save()->create_insert_id()->get_id();

        // Save organization resource person information
        $this->organization_model->set_empty();
        $this->organization_model->organization_id = $organization_id;
        $this->organization_model->resource_person_id = $resource_person_id;
        $this->organization_model->set_table_name('tbl_organization_resource_person')->save();
    }

    /*
     * 
     * 
     * 
     * 
     * @@@End
     * By : Jaherul Islam
     * Description : Add user (ADMIN Part) - 01-11-2016
     */

    /*
     * 
     * 
     * 
     * 
     * @@@Start
     * By : Jaherul Islam
     * Description : Update user (ADMIN Part) - 02-11-2016
     */

    /**
     * @Function            : update_user_information 
     * @Used IN             : @function-'edit_user_information'   super_admin[@controller],
     * @Description         : update user information 
     * @                    : @Update2 -  add url in ul model 
     * @                    : @Update3 -  remove all kind of feature issue 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-01-2016 01:38 PM  |  18-01-2016 10:38 AM  |  01-03-2016 05:38 PM
     * @Updated By          : Ripon Jaherul        |  Ripon Jaherul        |  Ripon Jaherul      
     * @Status              : available      
     * */
    public function update_user_information($person_id, $url_data) {
        $pdata = array();
        $pdata['person_email'] = $this->input->post('person_email', TRUE);
        $pdata['person_password'] = md5($this->input->post('person_password', TRUE));
        $pdata['person_first_name'] = $this->input->post('person_first_name', TRUE);
        $pdata['person_last_name'] = $this->input->post('person_last_name', TRUE);
        $pdata['person_gender'] = $this->input->post('person_gender', TRUE);
        $password = $this->input->post('person_password', TRUE);
        if ($password != '') {
            $pdata['person_password'] = md5($password);
        } else {
            $pdata['person_password'] = $this->input->post('old_password', TRUE);
        }
        $country_code = $this->input->post('country_code', TRUE);
        $pdata['person_contact_number'] = $country_code . ' ' . $this->input->post('person_contact_number', TRUE);
        $pdata['person_country'] = $this->input->post('person_country', TRUE);
        $pdata['person_city'] = $this->input->post('person_city', TRUE);
        $pdata['person_zip'] = $this->input->post('person_zip', TRUE);
        $pdata['person_address'] = $this->input->post('person_address', TRUE);
        $pdata['person_time_zone'] = $this->input->post('person_time_zone', TRUE);
        $person_role = $this->input->post('person_role', TRUE);
        $pdata['person_role'] = $person_role;
        $pdata['person_status'] = $this->input->post('person_status', TRUE);
        $pdata['person_birthday'] = $this->input->post('person_birthday', TRUE);
        // Save URL information
        if ($url_data) {
            if ($url_data['person_last_change_url_date']) {
                $pdata['person_last_change_url_date'] = $url_data['person_last_change_url_date'];
            }
        }
        /*
         * Image Upload
         */
        $old_person_image_path = 'content-library/' . $url_data['url'] . '/' . $this->input->post('old_person_image', TRUE);
        $old_person_image_thumb_path = 'content-library/' . $url_data['url'] . '/' . $this->input->post('old_person_image_thumb', TRUE);


        if ($_FILES['person_image']['name']) {
            $upload_path = 'content-library/' . $url_data['url'] . '/my-image/';
            $allowed_types = 'gif|jpg|png';
            $image_data = $this->image_model->upload_file($upload_path, $allowed_types, '2048', 'person_image');
            $pdata['person_image'] = 'my-image/' . $image_data['file_name'];

            $image_path = $upload_path . $image_data['file_name'];
            $new_image_name = $image_data['raw_name'] . '_thumb' . $image_data['file_ext'];
            $image_thumb = $upload_path . $new_image_name;

            $this->image_model->create_thumbnail_image($image_thumb, $image_path);
            $pdata['person_image_thumb'] = 'my-image/' . $new_image_name;

            if (file_exists($old_person_image_path)) {
                unlink($old_person_image_path);
                unlink($old_person_image_thumb_path);
            }
        } else {
            $pdata['person_image'] = $this->input->post('old_person_image', TRUE);
            $pdata['person_image_thumb'] = $this->input->post('old_person_image_thumb', TRUE);
        }
        /*
         * End Image Ipload
         */
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person', $pdata);


        $person_previous_role = $this->input->post('person_previous_role', TRUE);

        if ($pdata['person_role'] == '3') {
            if ($person_previous_role == $pdata['person_role']) {
                $resource_person_id = $this->input->post('resource_person_id', TRUE);
                $r_data['person_id'] = $person_id;
                $r_data['resource_person_type'] = $this->input->post('resource_person_type', TRUE);
                $this->utility_model->update_information_in_database('tbl_resource_person', 'resource_person_id', $resource_person_id, $r_data);
            } else {
                $rs_data['person_id'] = $person_id;
                $rs_data['resource_person_type'] = $this->input->post('resource_person_type', TRUE);
                $this->db->insert('tbl_resource_person', $rs_data);
            }
        }

        if ($pdata['person_role'] == '4') {
            if ($person_previous_role != $pdata['person_role']) {
                $o_data['person_id'] = $person_id;
                $o_data['organization_name'] = $this->input->post('organization_name', TRUE);
                $o_data['organization_code'] = $this->input->post('organization_code', TRUE);
                $o_data['organization_status'] = 1;
                $this->db->insert('tbl_organization', $o_data);
                $organization_id = $this->db->insert_id();

                //save resource person information
                if ($person_previous_role == 3) {
                    $r_data['person_id'] = $person_id;
                    $r_data['resource_person_type'] = 3;
                    $this->utility_model->update_information_in_database('tbl_resource_person', 'person_id', $person_id, $r_data);
                    $user_info_resource_person = $this->utility_model->set_single_row_info('*', 'tbl_resource_person', ['person_id' => 2])->get_single_row_info();
                    $resource_person_id = $user_info_resource_person->resource_person_id;
                } else {
                    $r_data['person_id'] = $person_id;
                    $r_data['resource_person_type'] = 3;
                    $this->db->insert('tbl_resource_person', $r_data);
                    $resource_person_id = $this->db->insert_id();
                }

                // Save organization resource person information
                $this->organization_model->set_empty();
                $this->organization_model->organization_id = $organization_id;
                $this->organization_model->resource_person_id = $resource_person_id;
                $this->organization_model->set_table_name('tbl_organization_resource_person')->save();
            } else {
                $o_data['organization_name'] = $this->input->post('organization_name', TRUE);
                $o_data['organization_code'] = $this->input->post('organization_code', TRUE);
                $this->utility_model->update_information_in_database('tbl_organization', 'person_id', $person_id, $o_data);
            }
        }
        return $person_id;
    }

    /*
     * 
     * 
     * ---------------------------------------------------------------------
     * 
     * @@@End
     * By : Jaherul Islam
     * Description : Update user (ADMIN Part) - 02-11-2016
     */



    /*
     * 
     * 
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Add Menu (ADMIN Part) - 03-12-2016
     * --------------------------------Start---------------------------------------------------------
     */

    /**
     * @Function            : get_course_by_category_id 
     * @Used IN             : @function-'manu_name_existance'    super_admin[@controller],
     * @Description         : Check manu name if name is exists  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 02-02-2016 01:38 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function check_menu_name($menu_name) {
        $sql = "SELECT * FROM tbl_menu as m WHERE m.menu_name = '$menu_name'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * 
     * 
     * @Description         : Add menu information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function select_published_menu($menu_id = NULL) {
        $sql = "SELECT * FROM tbl_menu as m, tbl_url as u WHERE ";
        if ($menu_id != NULL) {
            $sql .= "m.menu_id !='$menu_id' AND ";
        }
        $sql .= "u.url_id = m.url_id AND m.menu_status = '1'";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get all menu section
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_all_section_menu() {
        $sql = "SELECT DISTINCT `menu_section` FROM `tbl_menu` WHERE `menu_section` != '0' ORDER BY menu_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : save menu information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function save_menu_information($menu_url_id) {
        $data = [];
        $data['menu_type'] = $this->input->post('menu_type', TRUE);
        $data['menu_name'] = $this->input->post('menu_name', TRUE);
        $data['menu_status'] = $this->input->post('manu_status', TRUE);

        $manu_order = $this->input->post('menu_order', TRUE);
        if ($manu_order != '') {
            $data['menu_order'] = $manu_order;
        } else {
            $data['menu_order'] = 1;
        }

        $menu_section = $this->input->post('menu_section_name', TRUE);
        if ($menu_section != '') {
            if ($menu_section == '1') {
                $data['menu_section'] = $this->input->post('new_menu_section_name', TRUE);
            } else {
                $data['menu_section'] = $menu_section;
            }
        } else {
            $data['menu_section'] = 0;
        }

        $parent_menu = $this->input->post('parent_menu', TRUE);
        if ($parent_menu != '') {
            $data['parent_menu_id'] = $parent_menu;
        } else {
            $data['parent_menu_id'] = 0;
        }
        /*
         * Save URL Information 
         */
        $data['url_id'] = $menu_url_id;
        $this->db->insert('tbl_menu', $data);
    }

    /*
     * 
     * 
     * ----------------------------------END---------------------------
     * 
     * @@End
     * By : Jaherul Islam
     * Description : Add Menu (ADMIN Part) - 03-12-2016
     */

    /*
     * 
     * 
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Edit Menu (ADMIN Part) - 03-12-2016
     * ---------------------------------Start--------------------------------------------------------
     */

    /**
     * 
     * 
     * @Description         : get single menu information with url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_single_menu_value($menu_id) {
        $sql = "SELECT * FROM tbl_menu as m,tbl_url as u WHERE m.menu_id = '$menu_id' AND u.url_id = m.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : update_menu_information 
     * @Used IN             : @function-'edit_menu'  super_admin[@controller],
     * @Description         : get all available course using category ID  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 18-01-2016 01:38 PM  |  10-02-2016 01:38 PM
     * @Updated By          : Ripon Jaherul        |  Ripon Jaherul      
     * @Status              : available      
     * */
    public function update_menu_information($menu_id) {
        $data = [];
        $data['menu_type'] = $this->input->post('menu_type', TRUE);
        $data['menu_name'] = $this->input->post('menu_name', TRUE);
        $data['menu_status'] = $this->input->post('manu_status', TRUE);

        $manu_order = $this->input->post('menu_order', TRUE);
        if ($manu_order != '') {
            $data['menu_order'] = $manu_order;
        } else {
            $data['menu_order'] = 1;
        }

        $menu_section = $this->input->post('menu_section_name', TRUE);
        if ($menu_section != '') {
            if ($menu_section == '1') {
                $data['menu_section'] = $this->input->post('new_menu_section_name', TRUE);
            } else {
                $data['menu_section'] = $menu_section;
            }
        } else {
            $data['menu_section'] = 0;
        }

        $parent_menu = $this->input->post('parent_menu', TRUE);
        if ($parent_menu != '') {
            $data['parent_menu_id'] = $parent_menu;
        } else {
            $data['parent_menu_id'] = 0;
        }

        $this->db->where('menu_id', $menu_id);
        $this->db->update('tbl_menu', $data);
    }

    /*
     * 
     * --------------------------------End---------------------------------------------------------
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Edit Menu (ADMIN Part) - 03-12-2016
     */

    /*
     * 
     * 
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Manage Menu (ADMIN Part) - 03-12-2016
     * ---------------------------------Start--------------------------------------------------------
     */

    /**
     * 
     * 
     * @Description         : get all menu details
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_all_menu_details($count) {
        $sql = "SELECT *
                FROM
                    `tbl_menu` AS m,
                    `tbl_url` AS u
                WHERE
                    m.`url_id` = u.`url_id`
                order by
                    `menu_type` ASC,
                    `parent_menu_id` ASC,
                    `menu_section` ASC,
                    `menu_order` ASC
                    LIMIT $count, 10";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * 
     * 
     * @Description         : get total menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function get_total_menu() {
        $sql = "SELECT count(*) AS total_menu FROM `tbl_menu`";
        return $this->db->query($sql)->row();
    }

    /**
     * 
     * 
     * @Description         : get header menu value for admin manage menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_header_menu_value_for_type($type, $value, $parent_id = null) {
        $sql = "SELECT *
                FROM
                    tbl_menu AS m,
                    tbl_url AS u
                WHERE
                    m.url_id = u.url_id
                AND m.menu_type = '$type'";
        if ($value == 1) {
            $sql .= "AND m.parent_menu_id = '0'
                    AND m.menu_section = '0'";
        }
        if ($value == 2) {
            $sql .= "AND m.parent_menu_id = '$parent_id'
                    AND m.menu_section = '0'";
        }
        if ($value == 3) {
            $sql .= "AND m.parent_menu_id != '0'
                    AND m.menu_section != '0'";
        }
        $sql .= "ORDER BY menu_order ASC";
        $result = $this->db->query($sql)->result();
        $temp_array = Array();
        foreach ($result as $value) {
            $temp_array[] = $value->menu_id;
        }
        return $temp_array;
    }

    /**
     * 
     * 
     * @Description         : get menu value for admin manage menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_menu_for_type2($menu_id) {
        $sql = "SELECT * FROM tbl_menu
                WHERE
                    menu_type = '1'
                AND parent_menu_id = '$menu_id'
                AND menu_section = '0'
                ORDER BY menu_order ASC";
        $result = $this->db->query($sql)->result();
        $temp_array = Array();
        foreach ($result as $value) {
            $temp_array[] = $value->menu_id;
        }
        return $temp_array;
    }

    /**
     * 
     * 
     * @Description         : get menu section value for admin manage menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_all_header_section() {
        $sql = "SELECT DISTINCT menu_section, parent_menu_id
                FROM
                    tbl_menu AS m
                WHERE
                    menu_type = '1'
                AND parent_menu_id != '0'
                AND menu_section != '0'
                    order by
                `parent_menu_id` ASC,
                `menu_section` ASC,
                `menu_order` ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get header menu value for admin manage menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_header_menu_value_for_type3($parent_id, $menu_section) {
        $sql = "SELECT *
                FROM
                    tbl_menu
                WHERE
                    parent_menu_id = '$parent_id'
                AND menu_section = '$menu_section'
                ORDER BY menu_order ASC ";
        $result = $this->db->query($sql)->result();
        $temp_array = Array();
        foreach ($result as $value) {
            $temp_array[] = $value->menu_id;
        }
        return $temp_array;
    }

    /**
     * 
     * 
     * @Description         : get footer section
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_footer_section($type) {
        $sql = "SELECT DISTINCT `menu_section`
                FROM
                    `tbl_menu`
                WHERE
                    `menu_section` != '0'
                AND menu_type = '$type'
                AND parent_menu_id = '0'    
                ORDER BY menu_section ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get all header menu by menu type
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_header_all_section_value($menu_type, $menu_section) {
        $sql = "SELECT *
                FROM
                    `tbl_menu`
                WHERE
                    `menu_type` = '$menu_type'
                AND `menu_section` = '$menu_section'
                ORDER BY menu_order ASC ";
        $result = $this->db->query($sql)->result();
        $menu_id_array = Array();
        foreach ($result as $value) {
            $menu_id_array[] = $value->menu_id;
        }
        return $menu_id_array;
    }

    /**
     * 
     * 
     * @Description         : get all menu order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_menu_order($menu_type, $parent_menu_id, $section_name) {
        $menu_section = urldecode($section_name);

        $sql = "SELECT `menu_order`
                FROM
                `tbl_menu` ";
        switch ($menu_type) {
            case $menu_type && $parent_menu_id == 'null' && $menu_section == 'null':
                $sql .= "WHERE
                        menu_type = '$menu_type'
                    AND parent_menu_id = '0'
                    AND menu_section = '0' ";
                break;

            case $menu_type && $parent_menu_id && $menu_section == 'null':
                $sql .= "WHERE
                        menu_type = '$menu_type'
                    AND parent_menu_id = '$parent_menu_id'
                    AND menu_section = '0' ";
                break;

            case $menu_type && $parent_menu_id == 'null' && $menu_section:
                $sql .= "WHERE
                        menu_type = '$menu_type'
                    AND parent_menu_id = '0'
                    AND menu_section = '$menu_section' ";
                break;

            case $menu_type && $parent_menu_id && $menu_section:
                $sql .= "WHERE
                        menu_type = '$menu_type'
                    AND parent_menu_id = '$parent_menu_id'
                    AND menu_section = '$menu_section' ";
                break;
        }
        $sql .= "ORDER BY `menu_order` ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get header menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_header_menu($menu_type) {
        $sql = "SELECT * FROM tbl_menu WHERE menu_type = '$menu_type' order by `menu_type` ASC,`parent_menu_id` ASC,`menu_section` ASC,`menu_order` ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get section menu
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_section_menu($menu_type, $parent_id) {
        $sql = "SELECT DISTINCT menu_section
                FROM
                    tbl_menu
                WHERE
                    menu_type = '$menu_type'
                AND parent_menu_id = '$parent_id'
                AND menu_section != '0'
                ORDER BY menu_id ASC";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : change all menu order
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function change_menu_order($menu_id, $status) {
        $single_menu_details = $this->super_admin_model->select_single_menu_value($menu_id);

        if ($status == 'up') {
            $new_menu_order = $single_menu_details->menu_order - 1;
            $new_menu_details_to_order = $this->super_admin_model->get_menu_details_order_status($new_menu_order, $single_menu_details->menu_type, $single_menu_details->parent_menu_id, $single_menu_details->menu_section);

            if ($new_menu_details_to_order) {
                $data = array(
                    array(
                        'menu_id' => $menu_id,
                        'menu_order' => $new_menu_order
                    ),
                    array(
                        'menu_id' => $new_menu_details_to_order->menu_id,
                        'menu_order' => $single_menu_details->menu_order
                    )
                );
                $this->db->update_batch('tbl_menu', $data, 'menu_id');
                return 'success';
            } else {
                $this->db->set('menu_order', $new_menu_order);
                $this->db->where('menu_id', $menu_id);
                $this->db->update('tbl_menu');
                return 'success';
            }
        } else if ($status == 'down') {
            $new_menu_order = $single_menu_details->menu_order + 1;
            $new_menu_details_to_order = $this->super_admin_model->get_menu_details_order_status($new_menu_order, $single_menu_details->menu_type, $single_menu_details->parent_menu_id, $single_menu_details->menu_section);

            if ($new_menu_details_to_order) {
                $data = array(
                    array(
                        'menu_id' => $menu_id,
                        'menu_order' => $new_menu_order
                    ),
                    array(
                        'menu_id' => $new_menu_details_to_order->menu_id,
                        'menu_order' => $single_menu_details->menu_order
                    )
                );
                $this->db->update_batch('tbl_menu', $data, 'menu_id');
                return 'success';
            } else {
                $this->db->set('menu_order', $new_menu_order);
                $this->db->where('menu_id', $menu_id);
                $this->db->update('tbl_menu');
                return 'success';
            }
        }
    }

    /**
     * 
     * 
     * @Description         : check child ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function check_child_id($menu_id) {
        $sql = "SELECT * FROM tbl_menu WHERE parent_menu_id = '$menu_id'";
        return $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get single menu information by menu url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function get_menu_id_by_menu_url($menu_url) {
        $sql = "SELECT * FROM tbl_url AS u, tbl_menu AS m WHERE u.url = '$menu_url' AND m.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result->menu_id;
    }

    /**
     * 
     * 
     * @Description         : change menu status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function change_menu_status($id, $type) {
        if ($type == 'delete') {
            $sql = "DELETE m, t FROM tbl_menu AS m, tbl_url AS t WHERE m.menu_id = '$id' AND m.url_id = t.url_id";
            $this->db->query($sql);
        } else {
            switch ($type) {
                case 'active':
                    $this->db->set('menu_status', 1);
                    break;
                case 'inactive':
                    $this->db->set('menu_status', 3);
                    break;
                case 'archive':
                    $this->db->set('menu_status', 2);
                    break;
            }
            $this->db->where('menu_id', $id);
            $this->db->update('tbl_menu');
        }
    }

    /**
     * @Function            : select_menu_by_id 
     * @Description         : get menu information by menu ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-09-2016 04:47 PM
     * @Parameter           : $menu_id
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public function select_menu_by_id($menu_id) {
        $this->db->select('*')->from('tbl_menu AS m')->join('tbl_url as u', 'u.url_id = m.url_id')
                ->where("u.url_id = m.url_id AND m.menu_id = $menu_id");
        return $this->db->get()->row();
    }

    /**
     * 
     * 
     * @Description         : get menu details order status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_menu_details_order_status($menu_order, $menu_type, $menu_parent_id, $menu_section) {
        $sql = "SELECT * FROM tbl_menu WHERE menu_order = '$menu_order' AND menu_type = '$menu_type' "
                . "AND parent_menu_id = '$menu_parent_id' "
                . "AND menu_section = '$menu_section'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_all_menu_for_course_video_course 
     * @Used IN             : @function-'get_informaton_for_add_course'      super_admin_course_model[@Model]
     * @Description         : Get All menu if there is a section and check if there is assigned any course OR video Course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 12:45 PM  
     * @Parameter           : $url_id[INTEGER]
     * @Return              : $menu_INFO[ARRAY]        
     * @Status              : available      
     * */
    public function select_all_menu_for_course_video_course($url_id = '') {
        $course_menu_url_id = $this->super_admin_course_model->get_assigned_menu_url_id_in_course();
        return $this->select_all_active_menu($course_menu_url_id, $url_id);
    }

    /**
     * @Function            : select_all_active_menu 
     * @Used IN             : @function-'select_all_menu_for_course_video_course'  super_admin_model[@Model]
     * @Description         : Get All menu which has section, header menu type and menu_status is active
     * @                    : @Update1 => Convert to Codeignitor Active query
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 01:04 PM
     * @Updated Date Time   : 07-09-2016 01:29 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $course_menu_url_id[STRING]
     * @Return              : $menu_INFO[ARRAY]           
     * @Status              : available      
     * */
    function select_all_active_menu($course_menu_url_id, $url_id = '') {
        $this->db->select('*')->from('tbl_menu')
                ->where('menu_type', 1)
                ->where("menu_section != '0'")
                ->where('menu_status', 1)
                ->where_not_in('url_id', explode(',', $course_menu_url_id))
                ->or_where_in('url_id', explode(',', $url_id));
        return $this->db->get()->result();
    }

    /**
     * @Function            : get_all_menu_url_id 
     * @Used IN             : @function-'get_assigned_menu_url_id_in_course'  super_admin_course_model[@Model]
     * @Description         : Get All menu url ID AS concat
     * @                    : @Update1 => Convert to Codeignitor Active query
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 12:54 PM
     * @Updated Date Time   : 07-09-2016 12:29 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $url_id[STRING]
     * @Return              : $menu_utl_id[STRING]           
     * @Status              : available      
     * */
    function get_all_menu_url_id($url_id) {
        $this->db->select('GROUP_CONCAT(url_id) AS menu_url_id')->from('tbl_url')
                ->where('url_type', 1)
                ->where_in('url_id', explode(',', $url_id));
        return $this->db->get()->row()->menu_url_id;
    }

    /**
     * @Function            : assigned_menu_id_by_url_id 
     * @Used IN             : @function-'get_informaton_for_edit_course'  super_admin_course_model[@Model]
     * @Description         : Get Assigned course/Video Course menu ID by url_id when Update back end Course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 06-08-2016 05:24 PM
     * @Parameter           : $url_id[INTEGER]
     * @Return              : $menu_id[INTEGER]           
     * @Status              : available      
     * */
    function assigned_menu_id_by_url_id($url_id) {
        $sql = "SELECT * FROM tbl_menu AS m WHERE m.url_id = '$url_id'";
        return $this->db->query($sql)->row()->menu_id;
    }

    /**
     * @Function            : check_menu_url_for_public_view 
     * @Used IN             : @function-'public_menu_view'    application[@controller],
     * @Description         : check menu url for public view  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 11:29 AM
     * @Parameter           : $url[STRING]
     * @Return              : menu_info    
     * @Status              : Available       
     * */
    function check_menu_url_for_public_view($url) {
        $sql = "SELECT * 
                FROM 
                    tbl_menu AS m,
                    tbl_url AS u
                WHERE 
                    m.url_id = u.url_id
                AND u.url = '$url'
                AND u.url_type = '1'
                AND m.menu_type = '1'
                AND m.parent_menu_id != '0'
                AND m.menu_section != '0'
                AND m.menu_status = '1'";
        return $this->db->query($sql)->row();
    }

    /*
     * 
     * --------------------------------End---------------------------------------------------------
     * 
     * 
     * @@Start
     * By : Jaherul Islam
     * Description : Manage Menu (ADMIN Part) - 03-12-2016
     */

//--------Start---------------Use in super_admin_profile[Controller]----------------------------
    /**
     * 
     * 
     * @Description         : get person ID by url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function get_person_id_by_url($url) {
        $sql = "SELECT p.person_id FROM tbl_person AS p, tbl_url AS u WHERE p.url_id = u.url_id AND u.url = '$url'";
        return $result = $this->db->query($sql)->row();
    }

    /**
     * 
     * 
     * @Description         : get user information by ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_user_information_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . " tbl_person as p, "
                . " tbl_url as u"
                . " WHERE "
                . " p.person_id = $person_id"
                . " AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();

        if (!$result) {
            $sql = "SELECT p.*, p.person_id, o.organization_id, o.payment_id, o.organization_name, o.organization_code, o.number_of_student_person "
                    . " FROM tbl_person as p, tbl_organization as o "
                    . " WHERE p.person_id = $person_id AND p.person_id = o.person_id";
            $result = $this->db->query($sql)->row();
        }

        return $result;
    }

    /**
     * 
     * 
     * @Description         : get person work details information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_user_work_details_by_id($person_id) {
        $sql = "SELECT * FROM tbl_person as p, tbl_person_work_details as wd 
                WHERE p.person_id = '$person_id' AND wd.person_id = p.person_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * 
     * 
     * @Description         : get person education details information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_user_education_details_by_id($person_id) {
        $sql = "SELECT * FROM tbl_person as p, tbl_person_education_details as ed, tbl_education_institute as ei
                WHERE p.person_id = '$person_id' AND ed.person_id = p.person_id AND ei.education_institute_id = ed.education_institute_id";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * 
     * 
     * @Description         : get person self assessment information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_self_assessment_skills_by_id($person_id) {
        $sql = "SELECT * "
                . "FROM "
                . "tbl_self_assessment_skills "
                . "WHERE "
                . " person_id = '$person_id'";
        return $result = $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get person browse details information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_person_browse_details_by_id($person_id) {
        $sql = "SELECT * "
                . "FROM "
                . "tbl_person_pc_info "
                . "WHERE "
                . " person_id = '$person_id'"
                . "ORDER BY person_pc_info_id DESC";
        return $result = $this->db->query($sql)->result();
    }

    /**
     * 
     * 
     * @Description         : get person login time by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    function get_person_login_time_id($person_site_visit_start_time) {
        $sql = "SELECT person_pc_info_id FROM tbl_person_pc_info WHERE person_site_visit_start_time = '$person_site_visit_start_time'";
        return $this->db->query($sql)->row();
    }

    /**
     * 
     * 
     * @Description         : get person info view status information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_person_feature_details_by_id($person_id) {
        $sql = "SELECT * FROM tbl_person_info_view_status WHERE person_id = '$person_id'";
        return $result = $this->db->query($sql)->row();
    }

    /**
     * 
     * 
     * @Description         : get person interest field information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown      
     * */
    public function select_user_interest_field_all($person_id) {
        $this->db->select('*');
        $this->db->from('tbl_field_of_interest');
        $this->db->where('person_id', $person_id);
        $query_result = $this->db->get();
        $result = $query_result->result();
        return $result;
    }

    /**
     * 
     * 
     * @Description         : get person work details information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated By          : Md Mashqur Ul Alam      
     * */
    public function select_person_language_by_id($person_id) {
        $result = $this->db->select('*')->from('tbl_person_language')
                        ->where('person_id', $person_id)
                        ->get()->result();
        return $result;
    }
    
    public function select_person_limited_language_by_id($person_id, $limit_offset) {
        $result = $this->db->select('*')->from('tbl_person_language')
                        ->where('person_id', $person_id)
                        ->limit(10, $limit_offset)
                        ->get()->result();
        return $result;
    }

    //--------End---------------Use in super_admin_profile[Controller]----------------------------

    /*
      -----------@@@RIPON@ Start Coupon Part----------------------------------
     */

    /**
     * @Function            : save_coupon_information 
     * @Used IN             : @function-'add_coupon'    super_admin[@controller]
     * @Description         : Save all coupon save into database  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 12:57 PM      
     * @Status              : available      
     * */
    function save_coupon_information() {
        $data['coupon_name'] = preg_replace('/\s+/', ' ', trim($this->input->post('coupon_name', TRUE)));
        $data['coupon_code'] = $this->input->post('coupon_code', TRUE);

        $data['coupon_expire_type'] = $this->input->post('coupon_expire_type', TRUE);
        if ($data['coupon_expire_type'] == '1') {
            $data['coupon_can_use_number'] = $this->input->post('coupon_can_use_number', TRUE);
        } else if ($data['coupon_expire_type'] == '2') {
            $data['coupon_start_date'] = $this->input->post('coupon_start_date', TRUE);
            $data['coupon_finish_date'] = $this->input->post('coupon_finish_date', TRUE);
        }

        $data['coupon_price_type'] = $this->input->post('coupon_price_type', TRUE);
        if ($data['coupon_price_type'] == '1') {
            $data['coupon_discount_amount'] = $this->input->post('coupon_discount_amount1', TRUE);
        } else if ($data['coupon_price_type'] == '2') {
            $data['coupon_discount_amount'] = $this->input->post('coupon_discount_amount2', TRUE);
        }

        $data['coupon_type'] = $this->input->post('coupon_type', TRUE);
        $data['coupon_status'] = $this->input->post('coupon_status', TRUE);

        $this->save_information_in_database('tbl_coupon', $data);
    }

    /**
     * @Function            : update_coupon_information 
     * @Used IN             : @function-'edit_coupon'    super_admin[@controller]
     * @Description         : Update all coupon save into database  
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 12:57 PM      
     * @Status              : available      
     * */
    function update_coupon_information($coupon_value) {
        $coupon_name = preg_replace('/\s+/', ' ', trim($this->input->post('coupon_name', TRUE)));
        if ($coupon_value->coupon_name != preg_replace('/\s+/', ' ', trim($this->input->post('coupon_name', TRUE)))) {
            $data['coupon_name'] = $coupon_name;
        } else {
            $data['coupon_name'] = $coupon_value->coupon_name;
        }

        if ($this->input->post('coupon_code', TRUE) != $coupon_value->coupon_code) {
            $data['coupon_code'] = $this->input->post('coupon_code', TRUE);
        } else {
            $data['coupon_code'] = $coupon_value->coupon_code;
        }

        $data['coupon_expire_type'] = $this->input->post('coupon_expire_type', TRUE);
        if ($data['coupon_expire_type'] == '1') {
            $data['coupon_can_use_number'] = $this->input->post('coupon_can_use_number', TRUE);
            if ($coupon_value->coupon_expire_type == '2') {
                $data['coupon_start_date'] = NULL;
                $data['coupon_finish_date'] = NULL;
            }
        } else if ($data['coupon_expire_type'] == '2') {
            $data['coupon_start_date'] = $this->input->post('coupon_start_date', TRUE);
            $data['coupon_finish_date'] = $this->input->post('coupon_finish_date', TRUE);
            if ($coupon_value->coupon_expire_type == '1') {
                $data['coupon_can_use_number'] = NULL;
            }
        }

        $data['coupon_price_type'] = $this->input->post('coupon_price_type', TRUE);
        if ($data['coupon_price_type'] == '1') {
            $data['coupon_discount_amount'] = $this->input->post('coupon_discount_amount1', TRUE);
        } else if ($data['coupon_price_type'] == '2') {
            $data['coupon_discount_amount'] = $this->input->post('coupon_discount_amount2', TRUE);
        }

        $data['coupon_type'] = $this->input->post('coupon_type', TRUE);
        $data['coupon_status'] = $this->input->post('coupon_status', TRUE);

        $this->update_information_in_database('tbl_coupon', 'coupon_id', $coupon_value->coupon_id, $data);
    }

    /**
     * @Function            : save_information_in_database 
     * @Used IN             : @function-'save_coupon_information'            this[@Model]
     * @                    : @function-'save_person_information'            this[@Model]
     * @                    : @function-'save_organization_information'      this[@Model]- times
     * @                    : @function-'update_user_information'            this[@Model]- times
     * @Description         : Save Information inn Database
     * @Developed By        : Coied from - 'Super_admin_video_model'
     * @Start DateTime      : 29-02-2016 01:12 PM
     * @Status              : available      
     * */
    function save_information_in_database($table_name, $data) {
        $this->db->insert($table_name, $data);
        return $this->db->insert_id();
    }

    /**
     * @Function            : update_information_in_database 
     * @Used IN             : @function-'check_coupon_status_by_coupon_id'    super_admin[@Controller]
     * @                    : @function-'update_coupon_information'           super_admin[@Controller]
     * @                    : @function-'update_user_information'             super_admin[@Controller]- 3 times
     * @Description         : Update Information inn Database
     * @Developed By        : Copied from - 'super_admin_video_model'
     * @Start DateTime      : 29-02-2016 02:16 PM
     * @Status              : available      
     * */
    function update_information_in_database($table_name, $table_id, $id, $data) {
        $this->db->where($table_id, $id);
        $this->db->update($table_name, $data);
    }

    /**
     * @Function            : delete_information_in_database 
     * @Used IN             : @function-'check_coupon_status_by_coupon_id'      super_admin[@Controller]
     * @Description         : Delete Information inn Database
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 02:09 PM
     * @Status              : available      
     * */
    function delete_information_in_database($table_name, $table_id, $user_id) {
        $this->db->where($table_id, $user_id);
        $this->db->delete($table_name);
    }

    /**
     * @Function            : select_all_coupon 
     * @Used IN             : @function-'manage_coupon'      super_admin[@Controller]
     * @                    : @function-'search_coupon'      super_admin[@Controller]
     * @Description         : Select all Coupon
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 01:44 PM
     * @Status              : available      
     * */
    function select_all_coupon($search_value, $number) {
        $sql = "SELECT * 
                FROM 
                    tbl_coupon AS c";
        if ($search_value != '') {
            $sql .= " WHERE (c.coupon_name LIKE '%$search_value%' OR c.coupon_code LIKE '%$search_value%')";
        }
        $sql .= " ORDER BY c.coupon_id ASC
                LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_total_coupon 
     * @Used IN             : @function-'manage_coupon'      super_admin[@Controller]
     * @Description         : Select all Coupon
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 04:22 PM
     * @Status              : available      
     * */
    function select_total_coupon() {
        $sql = "SELECT count(*) AS total 
                FROM 
                    tbl_coupon AS c";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_coupon_value_by_coupon_id 
     * @Used IN             : @function-'check_coupon_status_by_coupon_id'      super_admin[@Controller]
     * @Description         : Select  Coupon Using coupon ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 02:24 PM
     * @Status              : available      
     * */
    function get_single_coupon_value_by_coupon_id($coupon_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_coupon AS c
                    WHERE c.coupon_id = '$coupon_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_coupon_value_by_coupon_code 
     * @Used IN             : @function-'edit_coupon'      super_admin[@Controller]
     * @Description         : Select  Coupon Using coupon Code
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 06:30 PM
     * @Status              : available      
     * */
    function get_single_coupon_value_by_coupon_code($coupon_code) {
        $sql = "SELECT * 
                FROM 
                    tbl_coupon AS c
                    WHERE c.coupon_code = '$coupon_code'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_coupon_name_existence 
     * @Used IN             : @function-'check_coupon_name_existence'      super_admin[@Controller]
     * @                    : @function-'check_coupon_name'                super_admin[@Controller]
     * @Description         : get coupon Name and check existence 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 05:27 PM
     * @Status              : available      
     * */
    function check_coupon_name_existence($coupon_name) {
        $sql = "SELECT * FROM tbl_coupon AS cp WHERE cp.coupon_name = '$coupon_name'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : check_coupon_code_existence 
     * @Used IN             : @function-'check_coupon_code_existence'      super_admin[@Controller]
     * @                    : @function-'check_coupon_code'                super_admin[@Controller]
     * @Description         : get coupon Code and check existence 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 29-02-2016 05:27 PM
     * @Status              : available      
     * */
    function check_coupon_code_existence($coupon_code) {
        $sql = "SELECT * FROM tbl_coupon AS cp WHERE cp.coupon_code = '$coupon_code'";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@ End Coupon Part----------------------------------
     */

    /*
      -----------@@@RIPON@ Start Technology Keyword Management Part----------------------------------
     */

    public function save_technology_keyword_information() {

        $data['technology_keyword_name'] = $this->input->post('technology_keyword_name', TRUE);
        $data['technology_keyword_status'] = '1';
        $this->db->insert('tbl_technology_keyword', $data);
    }

    public function update_technology_keyword_information($technology_keyword_id) {

        $data['technology_keyword_name'] = $this->input->post('technology_keyword_name', TRUE);
        $this->db->where('technology_keyword_id', $technology_keyword_id);
        $this->db->update('tbl_technology_keyword', $data);
    }

    public function select_technology_keyword() {

        $sql = "SELECT * FROM tbl_technology_keyword";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function make_technology_keyword_active($technology_keyword_id) {

        $this->db->set('technology_keyword_status', '1');
        $this->db->where('technology_keyword_id', $technology_keyword_id);
        $this->db->update('tbl_technology_keyword');
    }

    public function make_technology_keyword_inactive($technology_keyword_id) {

        $this->db->set('technology_keyword_status', '0');
        $this->db->where('technology_keyword_id', $technology_keyword_id);
        $this->db->update('tbl_technology_keyword');
    }

    public function make_technology_keyword_archive($technology_keyword_id) {

        $this->db->set('technology_keyword_status', '2');
        $this->db->where('technology_keyword_id', $technology_keyword_id);
        $this->db->update('tbl_technology_keyword');
    }

    public function select_technology_keyword_by_id($technology_keyword_id) {

        $sql = "SELECT * FROM tbl_technology_keyword WHERE technology_keyword_id = $technology_keyword_id";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /*
      -----------@@@RIPON@ Start Technology Keyword Management Part----------------------------------
     */
    /*
      -----------@@@RIPON@ Start Wishlist Part----------------------------------
     */

    public function select_all_wishlist() {
        $sql = "SELECT * FROM  tbl_wish_list_management";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_person_info($person_id) {
        $sql = "SELECT * FROM tbl_person WHERE person_id='$person_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_course_info($course_id) {
        $sql = "SELECT * FROM  tbl_course WHERE course_id='$course_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_course_status_info($person_id) {
        $sql = "SELECT * FROM  tbl_person WHERE person_id='$person_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function check_resource_person_role($person_id) {
        $sql = "SELECT * FROM tbl_resource_person WHERE person_id= '$person_id' ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function deleted_wishlistist($wishList_id) {
        $this->db->where('wish_list_management_id', $wishList_id);
        $this->db->delete('tbl_wish_list_management');
    }

    /*
      -----------@@@RIPON@ Start Wishlist Part----------------------------------
     */
}
