<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Super_admin_feature_model extends CI_Model {

    public function select_talhatraining_resource_person() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_resource_person as rp,"
                . "     tbl_url as u"
                . " WHERE "
                . "         rp.resource_person_type = 1 "
                . "     AND rp.person_id = p.person_id "
                . "     AND p.url_id = u.url_id "
                . "     AND p.person_status = 1";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_talhatraining_resource_person_by_person_list($resource_person_list) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_resource_person as rp,"
                . "     tbl_url as u"
                . " WHERE "
                . "         rp.resource_person_type = 1 "
                . "     AND rp.person_id = p.person_id "
                . "     AND p.url_id = u.url_id "
                . "     AND p.person_status = 1"
                . "     AND p.person_id IN ($resource_person_list 0)";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function save_virtual_classroom_feature_info($data) {
        $this->db->insert('tbl_feature_price', $data);
        return $this->db->insert_id();
    }

    public function save_expert_resume_info($data) {
        $this->db->insert('tbl_feature_price', $data);
    }

    public function update_virtual_classroom_feature_info($data, $feature_price_id) {
        $this->db->where('feature_price_id', $feature_price_id);
        $this->db->update('tbl_feature_price', $data);
    }

    public function save_online_exam_feature_info($data) {
        $this->db->insert('tbl_feature_price', $data);
    }

    public function update_online_exam_feature_info($data, $feature_price_id) {
        $this->db->where('feature_price_id', $feature_price_id);
        $this->db->update('tbl_feature_price', $data);
    }

    public function save_explore_expert_resume_feature($data) {
        $this->db->insert('tbl_feature_price', $data);
    }

    public function update_explore_expert_resume_feature($data, $feature_price_id) {
        $this->db->where('feature_price_id', $feature_price_id);
        $this->db->update('tbl_feature_price', $data);
    }

    public function select_online_exam_feature_info() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "         fp.online_exam_feature_number != '' "
                . " ORDER BY "
                . "         fp.online_exam_feature_number ASC, "
                . "         fp.online_exam_feature_price ASC ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_virtual_classroom_feature_info() {
        $sql = "SELECT * "
                . " FROM "
                . "      tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number != ''"
                . " ORDER BY "
                . "         fp.virtual_classroom_number ASC, "
                . "         fp.virtual_classroom_attendees_number ASC, "
                . "         fp.virtual_classroom_type ASC, "
                . "         fp.virtual_classroom_type ASC ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_tt_virtual_classroom_feature() {
        $sql = "SELECT * "
                . " FROM "
                . "      tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number != ''"
                . "     AND fp.feature_price_talhatraining = 1 ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_free_virtual_classroom_feature() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number != '' "
                . "     AND fp.feature_price_status = 3 ";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_free_online_exam_feature() {
        $sql = "SELECT * FROM tbl_feature_price as fp WHERE fp.online_exam_feature_number != '' AND fp.feature_price_status = 3";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_free_explore_expert_resume_feature() {
        $sql = "SELECT * FROM tbl_feature_price as fp WHERE fp.explore_expert_resume_per_day != '' AND fp.feature_price_status = 3";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_explore_expert_resume_feature_info() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "     fp.explore_expert_resume_per_day != '' "
                . " ORDER BY "
                . "         fp.online_exam_feature_number ASC, "
                . "         fp.online_exam_feature_price ASC ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_virtual_classroom_feature_info_by_id($feature_id) {
        $sql = "SELECT * "
                . " FROM"
                . "      tbl_feature_price as fp "
                . " WHERE "
                . "     fp.feature_price_id = '$feature_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_online_exam_feature_info_by_id($online_exam_feature_id) {
        $this->db->select('*');
        $this->db->where('feature_price_id', $online_exam_feature_id);
        $query_result = $this->db->get('tbl_feature_price');
        $result = $query_result->row();
        return $result;
    }

    public function select_feature_info_by_id($feature_id) {
        $sql = "SELECT * "
                . " FROM"
                . "      tbl_feature_price as fp "
                . " WHERE "
                . "     fp.feature_price_id = '$feature_id'";
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_active_feature_by_feature_id($feature_price_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "         fp.feature_price_id = '$feature_price_id' "
                . "     AND (fp.feature_price_status = 1 "
                . "     OR fp.feature_price_status = 3 )";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function inactive_select_virtual_classroom_feature($feature_price_id) {
        $this->db->set('feature_price_status', 0);
        $this->db->where('feature_price_id', $feature_price_id);
        $this->db->update('tbl_feature_price');
    }

    public function active_select_virtual_classroom_feature($feature_price_id) {

        $this->db->set('feature_price_status', 1);
        $this->db->where('feature_price_id', $feature_price_id);
        $this->db->update('tbl_feature_price');
    }

    public function archive_select_virtual_classroom_feature($feature_price_id) {
        $this->db->set('feature_price_status', 2);
        $this->db->where('feature_price_id', $feature_price_id);
        $this->db->update('tbl_feature_price');
    }

    public function delete_select_virtual_classroom_feature($feature_price_id) {
        $this->db->where('feature_price_id', $feature_price_id);
        $this->db->delete('tbl_feature_price');
    }

    public function select_free_feature_user_from_payment_table() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_payment as p "
                . " WHERE "
                . "     p.feature_price_payment_status = 1 "
                . "     AND p.payment_status = 7 ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_free_feature_user() {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_resource_person as rp "
                . " WHERE "
                . "     rp.feature_price_id = NULL "
                . "     AND p.payment_status = 7 ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    /**
     * @Function            :   update_organization_feature_price_id
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-17 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   update_organization_feature_price_id
     * 
     *
     * @parameter           :   $feature_price_id, $organization_id
     * @Return              :   NO
     * @Redirect            :   NO
     *
     * @External call       :   
     * @Internal call       :   $this->delete_person_feature_price_id()
     *
     * */
    public function update_organization_feature_price_id($feature_price_id, $organization_id) {
        $sql = "UPDATE "
                . "     tbl_organization SET feature_price_id =  '$feature_price_id' "
                . " WHERE "
                . "     organization_id = '$organization_id' ";
        $this->db->query($sql);
    }

    /**
     * @Function            :   update_resource_person_feature_price_id
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-17 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   update_resource_person_feature_price_id
     * 
     *
     * @parameter           :   $feature_price_id, $feature_price_payment_id, $resource_person_id
     * @Return              :   NO
     * @Redirect            :   NO
     *
     * @External call       :   
     * @Internal call       :   $this->update_free_virtual_classroom_feature_user()
     *                          $this->update_talhatraining_resource_person_virtual_feature()
     *                          $this->delete_person_feature_price_id()
     *
     * */
    public function update_resource_person_feature_price_id($feature_price_id, $feature_price_payment_id, $resource_person_id) {
        $sql = "UPDATE "
                . "     tbl_resource_person SET feature_price_id =  '$feature_price_id', "
                . "     feature_price_payment_id =  '$feature_price_payment_id' "
                . " WHERE "
                . "     resource_person_id = '$resource_person_id' ";
        $this->db->query($sql);
    }

    public function select_virtual_classroom_feature_payment_info($person_id) {

        $sql = "SELECT * "
                . " FROM "
                . "     tbl_payment as p "
                . " WHERE "
                . "         p.person_id = $person_id"
                . "     AND p.payment_status = 1 "
                . " ORDER BY p.payment_id";

        $result = $this->db->query($sql)->row();
        return $result;
    }

    /**
     * @Function            :   update_talhatraining_resource_person_virtual_feature
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-15 12:18 PM   |   2016-03-02 03:28 PM 
     * @Updated Date Time   :                         |   Ripon Jaherul
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   update_talhatraining_resource_person_virtual_feature 
     *                          Assign tt feature_price_id IN resource person table
     *                          #Ripon@update - if add any TT feature then does not save in 'tbl_payment' 
     *
     * @parameter           :   $resource_person, $feature_id, $feature_selected_user array
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   super_admin_virtual_classroom -> edit_virtual_classroom_feature()
     * @Internal call       :   
     *
     * */
    public function update_talhatraining_resource_person_virtual_feature($resource_person, $feature_id, $resource_person_array) {
        $today = date('Y-m-d H:i:s', time() - $this->session->userdata('time_offset'));
        $expiry_date = date('Y-m-d', strtotime("+12 months", strtotime($today)));

        $data['virtual_classroom_feature'] = $this->select_virtual_classroom_feature_info_by_id($feature_id);
        foreach ($resource_person as $person_id) {
            if (!in_array($person_id, $resource_person_array)) {
                $sql = "SELECT * "
                        . " FROM "
                        . "     tbl_resource_person as rp "
                        . " WHERE "
                        . "         rp.person_id = '$person_id' ";
                $result = $this->db->query($sql)->row();

                $feature_price_id = $result->feature_price_id;
                $feature_price_id = explode(',', $feature_price_id);

                $feature_price_id[0] = $feature_id;
                if (!isset($feature_price_id[1])) {
                    $feature_price_id[1] = '';
                }
                if (!isset($feature_price_id[2])) {
                    $feature_price_id[2] = '';
                }
                $feature_price_id = implode(',', $feature_price_id);
                $data['person_info'] = $this->profile_model->person_info_by_person_id($person_id);
                $feature_price_payment_id = $result->feature_price_payment_id;
                $payment_id_array = explode(',', $feature_price_payment_id);
                $payment_id_array[0] = $payment_id;
                if (!isset($payment_id_array[1])) {
                    $payment_id_array[1] = '';
                }
                if (!isset($payment_id_array[2])) {
                    $payment_id_array[2] = '';
                }
                $feature_price_payment_id = implode(',', $payment_id_array);

                $this->vc_model->update_resource_person_feature_price_id($feature_price_id, $feature_price_payment_id, $result->resource_person_id);
            }
        }
    }

    /**
     * @Function            :   update_free_virtual_classroom_feature_user
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-15 12:18 PM   |   2016-03-02 03:45 PM (Ripon Jaherul)
     * @Updated Date Time   :   2016-02-22 11:43 AM
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   update_free_virtual_classroom_feature_user
     *                          will assign non free feature holder 
     *                          (whose 1 month join date not expire) 
     *                          (whose are previously did not get any free feature)
     *                          (whose payment_description blunk)
     *                          #ripon@Update - comment all payment isssue if when save free feature 
     * @parameter           :   $feature_id
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   super_admin_virtual_classroom -> edit_virtual_classroom_feature()
     * @Internal call       :   
     *
     * */
    public function update_free_virtual_classroom_feature_user($feature_id) {

        $free_virtual_classroom_feature = $this->select_free_virtual_classroom_feature();
        $free_online_exam_feature = $this->select_free_online_exam_feature();
        $free_explore_expert_resume_feature = $this->select_free_explore_expert_resume_feature();
        $data['virtual_classroom_feature'] = $free_virtual_classroom_feature;

        if ($free_virtual_classroom_feature) {
            $free_vc_feature_id = $free_virtual_classroom_feature->feature_price_id;
        }
        if ($free_online_exam_feature) {
            $free_online_feature_id = $free_online_exam_feature->feature_price_id;
        } else {
            $free_online_feature_id = '';
        }
        if ($free_explore_expert_resume_feature) {
            $free_eer_feature_id = $free_explore_expert_resume_feature->feature_price_id;
        } else {
            $free_eer_feature_id = '';
        }

        $data['virtual_classroom_free_user'] = $this->select_virtual_classroom_free_user($free_virtual_classroom_feature->feature_price_id);
        if ($data['virtual_classroom_free_user']) {
            $payment_data = array();
            $today = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
            $payment_data['invoice_created_date'] = $today;
            $payment_data['due_date'] = $today;
            $payment_data['payment_status'] = 7; // free invoice
            $payment_data['quantity'] = '1';
            $payment_data['unit_price'] = 0.00;
            $payment_data['total_price'] = 0.00;
            $payment_data['feature_price_paid_date'] = $today;
            $payment_data['feature_price_payment_status'] = 1;
            $person_feature_updated = array();
            foreach ($data['virtual_classroom_free_user'] as $value) {
                $data['person_info'] = $this->profile_model->person_info_by_person_id($value->person_id);
                if ($data['person_info']->resource_person_type == 3) {
                    $data['organization_info'] = $this->profile_model->select_organization_info_by_id($data['person_info']->organization_id);
                    $payment_person_id = $data['organization_info']->person_id;
                } else {
                    $payment_person_id = $data['person_info']->person_id;
                }
                $payment_id_array = explode(',', $data['person_info']->feature_price_payment_id);
                $data['feature_payment_info'] = $this->payment_model->select_virtual_classroom_feature_payment_info_by_id($payment_id_array[0], $payment_person_id);
                $data['person_previous_free_feature'] = $this->select_person_previous_free_feature_info($value->person_id);

                $feature_price_id = explode(',', $data['person_info']->feature_price_id);

                $joining_date_expire = date('Y-m-d', strtotime("+1 months", strtotime($data['person_info']->person_join_tt)));
                if (!$data['person_previous_free_feature']) {
                    if ($person_feature_updated[$data['person_info']->person_id] == FALSE) {

                        $feature_price_id[0] = $feature_id;
                        if (!isset($feature_price_id[1])) {
                            $feature_price_id[1] = $free_online_feature_id;
                        }
                        if (!isset($feature_price_id[2])) {
                            $feature_price_id[2] = $free_eer_feature_id;
                        }
                        $feature_price_id = implode(',', $feature_price_id);

                        $payment_data['person_id'] = $data['person_info']->person_id;
                        $payment_data ['payment_name'] = $data ['person_info']->person_first_name . ' ' . $data['person_info']->person_last_name;
                        $payment_data['invoice_number'] = 'tt-' . $data['person_info']->url . '-' . date('Y-m-d-H-i-s', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
                        $payment_data['payment_description'] = $this->virtual_classroom_payment_description($data);
                        $payment_id = $this->payment_model->save_payment_info($payment_data);

                        $payment_id_array[0] = $payment_id;
                        if (!isset($payment_id_array[1])) {
                            $payment_id_array[1] = '';
                        }
                        if (!isset($payment_id_array[2])) {
                            $payment_id_array[2] = '';
                        }
                        $feature_price_payment_id = implode(',', $payment_id_array);

                        if ($data['person_info']->person_role == 4) {
                            $data['org_resource_person'] = $this->user_course_model->select_organization_resource_person_by_org_id($data['person_info']->organization_id);
                            $this->vc_model->update_organization_feature_price_id($feature_price_id, $data['person_info']->organization_id);
                            foreach ($data['org_resource_person'] as $v_resource) {
                                $this->vc_model->update_resource_person_feature_price_id($feature_price_id, $feature_price_payment_id, $v_resource->resource_person_id);
                                $person_feature_updated[$v_resource->person_id] = TRUE;
                            }
                        } else {
                            $this->vc_model->update_resource_person_feature_price_id($feature_price_id, $feature_price_payment_id, $data['person_info']->resource_person_id);
                        }
                    }
                } else {
                    if ($data['person_info']->person_role == 4) {
                        $data['org_resource_person'] = $this->user_course_model->select_organization_resource_person_by_org_id($data['person_info']->organization_id);
                        foreach ($data['org_resource_person'] as $v_resource) {
                            $person_feature_updated[$v_resource->person_id] = TRUE;
                        }
                    } else {
                        $person_feature_updated[$v_resource->person_id] = TRUE;
                    }
                }
            }
        }
    }

    /**
     * @Function            :   virtual_classroom_payment_description
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-15 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   virtual classroom payment_description
     *
     * @parameter           :   $data: virtual_classroom_feature
     * @Return              :   $payment_description
     * @Redirect            :   no
     *
     * @External call       :   $this->unassign_talhatraining_resource_person_virtual_feature()
     * @Internal call       :   
     *
     * */
    public function virtual_classroom_payment_description($data) {
        $payment_description = '';
        $payment_description .= '<p>Virtual classroom number ' . '( ' . $data['virtual_classroom_feature']->virtual_classroom_number . ' )</p>';
        $payment_description .= '<p>Virtual classroom per day ' . '( ' . $data['virtual_classroom_feature']->virtual_classroom_per_day . ' )</p>';
        if ($data['virtual_classroom_feature']->virtual_classroom_type == 1) {
            $payment_description .= '<p>Classroom Live Broadcast';
        } else if ($data['virtual_classroom_feature']->virtual_classroom_type == 2) {
            $payment_description .= '<p>Classroom Live Broadcast with Recording</p>';
        }
        $payment_description .= '<p>Virtual classroom attendees number ' . '( ' . $data['virtual_classroom_feature']->virtual_classroom_attendees_number . ' )</p>';
        $payment_description .= '<p>Storage ' . '( ' . $data['virtual_classroom_feature']->feature_price_storage . ' GB )</p>';
        return $payment_description;
    }

    /**
     * @Function            :   delete_person_feature_price_id
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-17 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   delete_person_feature_price_id
     * 
     *
     * @parameter           :   $person_feature ( including person_info )
     * @Return              :   NO
     * @Redirect            :   NO
     *
     * @External call       :   super_admin_virtual_classroom->delete_select_virtual_classroom_feature()
     * @Internal call       :   
     *
     * */
    public function delete_person_feature_price_id($person_feature) {

        $feature_price_id = $person_feature->feature_price_id;
        $feature_price_id_array = explode(',', $feature_price_id);
        $feature_price_id_array[0] = '';
        $feature_price_id_list = implode(',', $feature_price_id_array);

        if ($person_feature->person_role == 4) {
            $this->update_organization_feature_price_id($feature_price_id_list, $person_feature->organization_id);
        }

        $feature_price_payment_id = $person_feature->feature_price_payment_id;
        $feature_price_payment_id_array = explode(',', $feature_price_payment_id);
        $feature_price_payment_id_list = implode(',', $feature_price_payment_id_array);

        $this->update_resource_person_feature_price_id($feature_price_id_list, $feature_price_payment_id_list, $person_feature->resource_person_id);
    }

    public function select_virtual_classroom_free_user($feature_price_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_resource_person as rp, "
                . "     tbl_person as p "
                . " WHERE "
                . "         (       FIND_IN_SET('$feature_price_id', rp.feature_price_id) = 1"
                . "           OR    FIND_IN_SET('',rp.feature_price_id) = 1)"
                . "     AND rp.person_id = p.person_id ";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_feature_holder($feature_price_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_resource_person as rp, "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         ( FIND_IN_SET('$feature_price_id', rp.feature_price_id) > 0 )"
                . "     AND rp.person_id = p.person_id "
                . "     AND u.url_id = p.url_id ";
        $result = $this->db->query($sql)->result();
      return $result;
    }

    /**
     * @Function            :   unassign_talhatraining_resource_person_virtual_feature
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-15 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   unassign_talhatraining_resource_person_virtual_feature 
     *                          remove feature_price_id from resource person table
     *
     * @parameter           :   $data: feature_selected_user, new_assigned_user_id, feature_id
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   super_admin_virtual_classroom -> edit_virtual_classroom_feature()
     * @Internal call       :   
     *
     * */
    public function unassign_talhatraining_resource_person_virtual_feature($data) {
        $new_assign = array();
        if ($data['new_assigned_user_id']) {
            $new_assign = $data['new_assigned_user_id'];
        } else {
            $new_assign = array();
        }

        if ($data['feature_selected_user']) {
            $free_virtual_classroom_feature = $this->select_free_virtual_classroom_feature();
            if ($free_virtual_classroom_feature) {
                $data['virtual_classroom_feature'] = $free_virtual_classroom_feature;
                $data['payment_description'] = $this->virtual_classroom_payment_description($data);
            }
            $today = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d')) - $this->session->userdata('time_offset'));
            foreach ($data['feature_selected_user'] as $value) {
                if (!in_array($value->person_id, $new_assign)) {
                    $feature_price_id = $value->feature_price_id;
                    $feature_price_id_array = explode(',', $feature_price_id);

                    $feature_price_payment_id = $value->feature_price_payment_id;
                    $feature_price_payment_id_array = explode(',', $feature_price_payment_id);
                    $data['feature_payment_info'] = $this->payment_model->select_virtual_classroom_feature_payment_info_by_id($feature_price_payment_id_array[0], $value->person_id);
                    $data['person_previous_free_feature'] = $this->select_person_previous_free_feature_info($value->person_id);

                    $joining_date_expire = $data['feature_price_expire_date'] = date('Y-m-d', strtotime("+1 months", strtotime($value->person_join_tt)));
                    if (!$data['person_previous_free_feature']) {
                        if ($free_virtual_classroom_feature) {
                            $data['person_info'] = $value;
                            $payment_id = $this->save_free_feature_payment_info($data);
                            $feature_price_id_array[0] = $free_virtual_classroom_feature->feature_price_id;
                            $feature_price_payment_id_array[0] = $payment_id;
                        } else {
                            $feature_price_id_array[0] = '';
                        }
                    } else {
                        $feature_price_id_array[0] = '';
                    }

                    $feature_price_id_list = implode(',', $feature_price_id_array);
                    $feature_price_payment_id_list = implode(',', $feature_price_payment_id_array);
                    $this->vc_model->update_resource_person_feature_price_id($feature_price_id_list, $feature_price_payment_id_list, $value->resource_person_id);
                }
            }
        }
    }

    /**
     * @Function            :   select_person_previous_free_feature_info
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-15 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   select_person_previous_free_feature_info
     *
     * @parameter           :   $person_id
     * @Return              :   $result
     * @Redirect            :   no
     *
     * @External call       :   $this->unassign_talhatraining_resource_person_virtual_feature()
     * @Internal call       :   
     *
     * */
    public function select_person_previous_free_feature_info($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_payment as p "
                . " WHERE "
                . "         p.feature_price_payment_status = 1 "
                . "     AND p.payment_description != '' "
                . "     AND p.person_id = '$person_id' ";
        $result = $this->db->query($sql)->result();
      return $result;
    }

    /**
     * @Function            :   save_free_feature_payment_info
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-15 12:18 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   save_free_feature_payment_info
     *
     * @parameter           :   $data: person_info, feature_price_expire_date, payment_description
     * @Return              :   no
     * @Redirect            :   no
     *
     * @External call       :   $this->edit_virtual_classroom_feature()
     * @Internal call       :   
     *
     * */
    public function save_free_feature_payment_info($data) {
        $today = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')));
        $expiry_date = date('Y-m-d', strtotime("+1 months", strtotime($today)));

        $payment_data = array();
        $payment_data['person_id'] = $data['person_info']->person_id;
        $payment_data['payment_name'] = $data['person_info']->person_first_name . ' ' . $data['person_info']->person_last_name;
        $payment_data['invoice_number'] = 'tt-' . $data['person_info']->url . '-' . str_replace(':', '-', str_replace(' ', '-', $today));
        $payment_data['invoice_created_date'] = $today;
        $payment_data['due_date'] = $today;
        $payment_data['payment_status'] = 7;
        $payment_data['payment_description'] = $data['payment_description'];
        $payment_data['quantity'] = '1';
        $payment_data['unit_price'] = 0.00;
        $payment_data['total_price'] = 0.00;
        $payment_data['feature_price_paid_date'] = $today;
        $payment_data['feature_price_payment_status'] = 1;

        $payment_id = $this->payment_model->save_payment_info($payment_data);
        return $payment_id;
    }

    /**
     * @Function            :   select_virtual_classroom_feature_info_by_combination
     * @Developed By        :   Mahabub-A-Mawla <mahabub.cgbd@yahoo.com> <+8801925821707> |
     * @DevelopeDateTime    :   2016-02-18 12:36 PM   |
     * @Updated Date Time   :
     * @Updated By          :
     * @Router              :   
     *
     * @Works               :   select_virtual_classroom_feature_info_by_combination by classroom_number, attendees_number, class_type
     *
     * @parameter           :   $v_classroom_number, $v_attendees_number, $v_class_type
     * @Return              :   $result
     * @Redirect            :   no
     *
     * @External call       :   $this->super_admin_virtual_classroom->check_paid_feature_combination()
     * @Internal call       :   
     *
     * */
    public function select_virtual_classroom_feature_info_by_combination($classroom_number, $virtual_classroom_per_day, $attendees_number, $class_type) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_feature_price as fp "
                . " WHERE "
                . "         fp.virtual_classroom_number = '$classroom_number' "
                . "     AND fp.virtual_classroom_per_day = '$virtual_classroom_per_day' "
                . "     AND fp.virtual_classroom_attendees_number = '$attendees_number' "
                . "     AND fp.virtual_classroom_type = '$class_type' "
                . "     AND fp.feature_price_talhatraining = '2' "
                . "     AND fp.feature_price_status != '3' "
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    /*
      -----------@@@RIPON@ Start feature information Part----------------------------------
     */

    /**
     * @Function            : check_cpurse_feature_information 
     * @Used IN             : @function-'schedule_class'                        classroom[@controller]
     * @                    : @function-'check_feature_status'                  classroom[@controller]
     * @                    : @function-'change_student_permission'             classroom[@controller]
     * @                    : @function-'get_information_for_add_video_course'  user_video_model[@Model] - [44]
     * @Description         : check feature status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-03-2016 10:45 AM    
     * @Parameter           : $person_id[INTEGER]
     * @Return              : feature_info    
     * @Status              : available      
     * */
    function check_course_feature_information($person_id) {
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        $data['resource_person_info'] = $this->resource_person_model->single_resource_person_information_by_person_id($data['person_info']->person_id);
        if ($data['person_info']->person_role == 3) {
            if ($data['resource_person_info']->resource_person_type == 1) {
                return $this->check_tt_resource_person_feature_sataus($data['resource_person_info']->resource_person_id);
            } else if ($data['resource_person_info']->resource_person_type == 2) {
                return $this->get_free_feature();
            } else if ($data['resource_person_info']->resource_person_type == 3) {
                return $this->get_free_feature();
            }
        } else if ($data['person_info']->person_role == 4) {
            return $this->get_free_feature();
        }
    }

    /**
     * @Function            : get_feature_information 
     * @Used IN             : @function-'check_course_feature_information'      this[@Model] - 4 times
     * @Description         : check feature status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 10-03-2016 10:45 PM    
     * @Status              : available      
     * */
    public function get_feature_information_by_feature_id($feature_price_id, $person_id) {
        if ($feature_price_id != '') {
            $feature_id = explode(',', $feature_price_id);
            if ($feature_id[0] != '') {
                return $this->user_course_model->get_feature_information($feature_id[0], $person_id);
            } else {
                return $this->user_course_model->get_feature_information('', $person_id);
            }
        } else {
            return $this->user_course_model->get_feature_information('', $person_id);
        }
    }

    /**
     * @Function            : check_tt_resource_person_feature_sataus 
     * @Used IN             : @function-'check_resource_person_feature_status'      super_admin_classroom[@Controller]
     * @                    : @function-'edit_schedule_classroom'                   super_admin_classroom[@Controller]
     * @Description         : check tt teacher feature status
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 15-03-2016 04:02 PM    
     * @Status              : available      
     * */
    public function check_tt_resource_person_feature_sataus($resource_person_id) {
        $resource_person_info = $this->profile_model->select_resource_person_info_by_resource_person_id($resource_person_id);
        if ($resource_person_info->feature_price_id != '') {
            $feature_id = explode(',', $resource_person_info->feature_price_id);
            if ($feature_id[0] != '') {
                return $feature_info = $this->user_course_model->select_feature_info_by_feature_id($feature_id[0]);
            } else {
                return $feature_info = $this->user_course_model->get_free_feature();
            }
        } else {
            return $feature_info = $this->user_course_model->get_free_feature();
        }
    }

    /**
     * @Function            : get_free_feature 
     * @Used IN             : @function-'get_feature_information'    this[@Model]
     * @Description         : get free feature
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-03-2016 06:26 PM    
     * @Status              : available      
     * */
    function get_free_feature() {
        $sql = "SELECT * FROM
                    tbl_feature_price AS fp
                WHERE 
                    fp.feature_price_status = '3'";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@ End feature information Part----------------------------------
     */
}
