<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of cmis_model
 *
 * @author Shawon
 */
class Super_Admin_Course_Model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : view_admin_course_information 
     * @Used IN             : @function-'get_dashboard_data'    super_admin_model[@Model]
     * @Description         : get all course information for dashboard
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-09-2016 03:50 PM 
     * @Parameter           : Null
     * @Return              : $data[STRING]    
     * @Status              : available      
     * */
    function view_admin_course_information() {
        $data = Array();
        $todays_date = date("y-m-d", (strtotime(date("Y-m-d h:i:s a")) - $this->session->userdata('time_offset'))) . '---';
        $this_month = date("m", (strtotime(date("Y-m-d h:i:s a")) - $this->session->userdata('time_offset')));
        $data['todays_course'] = $this->get_courses_by_datetime($todays_date, '');
        $data['this_month_course'] = $this->get_courses_by_datetime('', $this_month);
        $data['active_course'] = $this->get_total_course(Array(1, 4));
        $data['inactive_course'] = $this->get_total_course(Array(2, 3, 5, 6));
        $data['total_course'] = $data['active_course'] + $data['inactive_course'];
        return $data;
    }

    /**
     * @Function            : get_courses_by_datetime 
     * @Used IN             : @function-'get_admin_course_information'    super_admin_course_model[@Model]
     * @Description         : get all course information using Datetime
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-09-2016 03:59 PM 
     * @Parameter           : $date/$month
     * @Return              : $course_data[Array]    
     * @Status              : available      
     * */
    function get_courses_by_datetime($todays_date, $this_month) {
        $this->db->select('*')->from('tbl_course AS c')
                ->join('tbl_notification_type_info AS nti', 'c.course_id = nti.notification_type_id')
                ->join('tbl_notification AS n', 'nti.notification_id = n.notification_id')
                ->where('n.notification_type', 6);
        if ($todays_date != '') {
            $this->db->where('DATE(n.notification_date_time)', $todays_date);
        }
        if ($this_month != '') {
            $this->db->where('MONTH(n.notification_date_time)', $this_month);
        }
        return $this->db->count_all_results();
    }

    /**
     * @Function            : get_total_course 
     * @Used IN             : @function-'get_admin_course_information'    super_admin_course_model[@Model]
     * @Description         : get total course information using Status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-09-2016 04:14 PM 
     * @Parameter           : $status
     * @Return              : $course_data[Array]    
     * @Status              : available      
     * */
    function get_total_course($status) {
        return $this->db->select('*')->from('tbl_course')->where_in('course_status', $status)->count_all_results();
    }

    /*
      -----------@@@RIPON@@ Start Course Common Function part (03-08-16)----------------------------------
     */

    /**
     * @Function            : get_all_course_url_id 
     * @Used IN             : @function-'get_assigned_menu_url_id_in_course'    super_admin_course[@controller]
     * @Description         : get all course url id AS concat
     * @                    : @Update1=> Convert to Codignitor active query
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 12:54 PM 
     * @Updated Date Time   : 07-09-2016 12:24 PM
     * @Updated By          : MD Jaherul Islam    
     * @Parameter           : Null
     * @Return              : $course_url_id[STRING]    
     * @Status              : available      
     * */
    function get_all_course_url_id() {
        $this->db->select('GROUP_CONCAT(c.url_id) AS course_url_id')->from('tbl_course AS c');
        return $this->db->get()->row()->course_url_id;
    }

    /**
     * @Function            : get_assigned_menu_url_id_in_course 
     * @Used IN             : @function-'add_course'    super_admin_course[@controller]
     * @Description         : get assigned menu url ID in Course AS concat
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 12:57 PM     
     * @Parameter           : NULL
     * @Return              : $data[ARRAY]    
     * @Status              : available      
     * */
    function get_assigned_menu_url_id_in_course() {
        $course_url_id = $this->get_all_course_url_id();
        if ($course_url_id != '') {
            return $this->super_admin_model->get_all_menu_url_id($course_url_id);
        } else {
            return '';
        }
    }

    /**
     * @Function            : select_all_resource_persons 
     * @Used IN             : @function-'get_informaton_for_edit_course'    this[@Model]
     * @Description         : get all resource person 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-08-2016 09:42 AM     
     * @Parameter           : $data[ARRAY]
     * @Return              : $all_resource_person[ARRAY]    
     * @Status              : available      
     * */
    function select_all_resource_persons($data) {
        if ($data['course_creator_info']->person_role == 1 || $data['course_creator_info']->person_role == 6) {
            return $this->resource_person_model->select_all_tt_resource_persons();
        }
        if ($data['course_creator_info']->person_role == 4) {
            $data['organization_info'] = $this->organization_model->select_single_organization_info_by_person_id($data['course_creator_info']->person_id);
            $resource_person_info = $this->resource_person_model->get_all_resource_person_info_by_organizarion_id($data['organization_info']->organization_id);
            $resource_person_info[] = $this->resource_person_model->select_resource_person_information_by_person_id($data['course_creator_info']->person_id);
            return array_reverse($resource_person_info);
        }
        if ($data['course_creator_info']->person_role == 3) {
            $resource_person = Array();
            $resource_person_info = $this->resource_person_model->select_resource_person_information_by_person_id($data['course_creator_info']->person_id);
            if ($resource_person_info->resource_person_type == 2) {
                $resource_person[] = $resource_person_info;
                return $resource_person;
            }
        }
    }

    /*
      -----------@@@RIPON@@ End Course Common Function part (03-08-16)----------------------------------
     */



    /*
      -----------@@@RIPON@@ Start add Course part (14-07-16)----------------------------------
     */

    /**
     * @Function            : get_informaton_for_add_course 
     * @Used IN             : @function-'add_course'    super_admin_course[@controller]
     * @Description         : get information for add course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 14-07-2016 04:01 PM     
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : available      
     * */
    function get_informaton_for_add_course($data) {
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'add_course';
        $data['all_menu'] = $this->super_admin_model->select_all_menu_for_course_video_course();
        $data['parent_topic'] = $this->topic_model->select_all_parent_topic_id_if_child();
        $data['resource_persons'] = $this->resource_person_model->select_all_tt_resource_persons();
        return $data;
    }

    /**
     * @Function            : save_course_information 
     * @Used IN             : @function-'add_course'    super_admin_course[@controller]
     * @Description         : save course information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-01-2016 04:01 PM   
     * @Updated Date Time   : 14-07-2016 05:38 PM
     * @Updated By          : MD Jaherul Islam  
     * @Parameter           : $person_id[INTEGER],$course_url_id[INTEGER]
     * @Return              : $course_id[INTEGER]    
     * @Status              : available      
     * */
    public function save_course_information($person_id, $course_url_id) {
        $data = array();
        //$data['person_id'] = $this->session->userdata('person_id');
        $data['person_id'] = '1';
        $data['course_name'] = $this->input->post('course_name', TRUE);
        $data['url_id'] = $course_url_id;
        $data['topic_id'] = $this->input->post('topic_id', TRUE);
        $data['resource_person_id'] = $this->input->post('resource_person_id', TRUE);
        $data['course_level'] = $this->input->post('course_level', TRUE);
        $data['number_of_classes'] = $this->input->post('number_of_classes', TRUE);
        $data['class_hour_per_day'] = $this->input->post('class_hour_per_day', TRUE);
        $data['course_author'] = $this->input->post('course_author', TRUE);
        $data['course_meta_title'] = $this->input->post('course_meta_title', TRUE);
        $data['course_language'] = $this->input->post('course_language', TRUE);
        $data['course_rating'] = $this->input->post('course_rating', TRUE);
        $data['course_access_level'] = $this->input->post('course_access_level', TRUE);
        $data['course_status'] = $this->input->post('course_status', TRUE);
        $data['course_work_files'] = 2;
        $data['course_type'] = $this->input->post('course_type', TRUE);
        $data['course_meta_description'] = $this->input->post('course_meta_description', TRUE);

        $course_start_date = $this->input->post('course_start_date', TRUE);
        $data['course_start_date'] = ($course_start_date != '') ? $course_start_date : '';

        $course_data = $this->save_course_more_information($data);
        $course_id = $this->utility_model->save_information_in_database('tbl_course', $course_data); // save information in course
        $this->save_course_other_information($person_id, $course_id, $course_url_id, $course_data);
    }

    /**
     * @Function            : save_course_other_information 
     * @Used IN             : @function-'add_course'    super_admin_course[@controller]
     * @Description         : save other information AS function course information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-08-2016 11:34 AM   
     * @Parameter           : $person_id, $course_id, $course_url_id, $data
     * @Return              : Null  
     * @Status              : available      
     * */
    function save_course_other_information($person_id, $course_id, $course_url_id, $data) {
        if ($data['course_type'] == '1') {
            $this->price_model->save_price_information(1, $course_id);  // save course price information
        }
        $this->save_course_all_tinymce_information($person_id, $course_id, $course_url_id); // save course tinymce information 
        // save notification for add course
        $notification_id = $this->notification_course_model->save_add_course_notification($course_id, $data);
        // send Email for add course
        $this->mailer_model->send_email_for_add_course($notification_id);
    }

    /**
     * @Function            : save_course_more_information 
     * @Used IN             : @function-'add_course'    super_admin_course[@controller]
     * @Description         : save other  course information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-08-2016 11:34 AM   
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]  
     * @Status              : available      
     * */
    function save_course_more_information($data) {
        $course_days = $this->input->post('course_days', TRUE);
        $data['course_days'] = ($course_days != '') ? implode(',', $course_days) : '';

        $course_finished_date = $this->input->post('course_finished_date', TRUE);
        $data['course_finished_date'] = ($course_finished_date != '') ? $course_finished_date : '';

        $class_time = $this->input->post('class_time', TRUE);
        $data['class_time'] = ($class_time != '') ? date('H:i:s', strtotime($class_time)) : '';

        $last_date_of_registration = $this->input->post('last_date_of_registration', TRUE);
        $data['last_date_of_registration'] = ($last_date_of_registration != '') ? $last_date_of_registration : '';

        $course_meta_keywords = $this->input->post('course_meta_keywords', TRUE);
        $data['course_meta_keywords'] = ($course_meta_keywords != '') ? implode(',', $course_meta_keywords) : '';

        $course_resource_person_edit = $this->input->post('course_resource_person_edit', TRUE);
        $data['course_resource_person_edit'] = ($course_resource_person_edit != '' ? 1 : 2);

        $course_resource_person_view_invoice = $this->input->post('course_resource_person_view_invoice', TRUE);
        $data['course_resource_person_view_invoice'] = ($course_resource_person_view_invoice != '' ? 1 : 2);

        $upcoming_course = $this->input->post('upcoming_course', TRUE);
        $data['upcoming_course'] = ($upcoming_course != '' ? 1 : 2);

        $course_resource_person_pay_invoice = $this->input->post('course_resource_person_pay_invoice', TRUE);
        $data['course_resource_person_pay_invoice'] = ($course_resource_person_pay_invoice != '' ? 1 : 2);
        return $data;
    }

    /**
     * @Function            : save_course_all_tinymce_information 
     * @Used IN             : @function-'save_course_information'    this[@Model]
     * @Description         : save course all tinymce information information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-07-2016 02:58 PM   
     * @Parameter           : $person_id[INTEGER], $course_id[[INTEGER], $course_url_id[[INTEGER]
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_course_all_tinymce_information($person_id, $course_id, $course_url_id) {
        $course_training_objectives = $this->input->post('course_training_objectives', FALSE);
        if ($course_training_objectives) {
            $course_updated_training_objectives = $this->save_course_tinymce_information($person_id, $course_id, $course_url_id, $course_training_objectives);
            $data['course_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_objectives);
        } else {
            $data['course_training_objectives'] = '';
        }

        $course_training_outline = $this->input->post('course_training_outline', FALSE);
        if ($course_training_outline) {
            $course_updated_training_outline = $this->save_course_tinymce_information($person_id, $course_id, $course_url_id, $course_training_outline);
            $data['course_training_outline'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_outline);
        } else {
            $data['course_training_outline'] = '';
        }

        $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_id, $data);

        $person_url = $this->person_model->get_profile_url($person_id);
        $directory = 'source/' . $person_url . '/';
        $this->utility_model->remove_directory_without_root($directory);
    }

    /**
     * @Function            : save_course_tinymce_value 
     * @Used IN             : @function-'add_course'            super_admin_course[@controller]
     * @Description         : save course tinymce information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 16-07-2016 10:34 AM 
     * @Parameter           : $person_id[INTEGER], $course_id[INTEGER], $course_url_id[INTEGER], $course_description[STRING]
     * @Return              : $description[STRING]            
     * @Status              : available      
     * */
    function save_course_tinymce_information($person_id, $course_id, $course_url_id, $course_description) {
        $person_url = $this->person_model->get_profile_url($person_id);
        $destination_path = 'content-library/' . $person_url . '/my-work-file';
        $type = '1,5';
        $c_type = 2; // content library type for course
        $find_path = 'source'; // find file from source directory
        $course_url_info = $this->url_model->get_url_by_url_id($course_url_id, $type);
        $new_directory = $destination_path . '/' . $course_url_info->url;

        return $this->tinymce_model->get_tinymce_description($course_id, $new_directory, $course_description, $c_type, $find_path);
    }

    /*
      -----------@@@RIPON@@ End add Course part (14-07-16)----------------------------------
     */


    /*
      -----------@@@RIPON@@ Start Edit Course part (06-08-16)----------------------------------
     */

    /**
     * @Function            : get_informaton_for_edit_course 
     * @Used IN             : @function-'edit_course'            super_admin_course[@controller]
     * @Description         : get information for edit Course
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 06-08-2016 03:29 PM 
     * @Parameter           : $data[ARRAY]
     * @Return              : $course_data[ARRAY]            
     * @Status              : available      
     * */
    function get_informaton_for_edit_course($data) {
        $data['active_menu'] = 'course';
        $data['active_sub_menu'] = 'manage_course';
        $url_id = ($data['course_info']->url_type == 1) ? $data['course_info']->url_id : ''; // if Url_type=>menu then assign in $url_id variable
        $data['all_menu'] = $this->super_admin_model->select_all_menu_for_course_video_course($url_id);
        // get menu id if course assigned in menu
        $data['assigned_menu_id'] = ($data['course_info']->url_type == 1) ? $this->super_admin_model->assigned_menu_id_by_url_id($data['course_info']->url_id) : '';
        $data['parent_topic'] = $this->topic_model->select_all_parent_topic_id_if_child();
        // get resource person if course created by Talhatraining, Organization, Ind Teacher
        $data['resource_persons'] = $this->select_all_resource_persons($data);
        $data['parent_topic_info'] = $this->topic_model->select_topic_info_by_topic_id($data['course_info']->topic_id);
        if ($data['course_info']->course_type == 1) { // for paid course
            $data['course_price_info'] = $this->price_model->get_single_price_information(1, $data['course_info']->course_id);
        }
        return $data;
    }

    /**
     * @Function            : update_course_information
     * @Used IN             : @function-'edit_course'            super_admin_course[@controller]
     * @Description         : Update Course information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 11-08-2016 12:44 PM 
     * @Parameter           : $data[ARRAY]
     * @Return              : $course_data[ARRAY]            
     * @Status              : available      
     * */
    function update_course_information($data) {
        $course_data = array();
        $course_data['course_name'] = $this->input->post('edit_course_name', TRUE);
        $course_data['topic_id'] = $this->input->post('topic_id', TRUE);
        $course_data['resource_person_id'] = $this->input->post('resource_person_id', TRUE);
        $course_data['course_level'] = $this->input->post('course_level', TRUE);
        $course_data['number_of_classes'] = $this->input->post('number_of_classes', TRUE);
        $course_data['class_hour_per_day'] = $this->input->post('class_hour_per_day', TRUE);
        $course_data['course_author'] = $this->input->post('course_author', TRUE);

        $course_start_date = $this->input->post('course_start_date', TRUE);
        $course_data['course_start_date'] = ($course_start_date != '') ? $course_start_date : '';

        $course_finished_date = $this->input->post('course_finished_date', TRUE);
        $course_data['course_finished_date'] = ($course_finished_date != '') ? $course_finished_date : '';

        $class_time = $this->input->post('class_time', TRUE);
        $course_data['class_time'] = ($class_time != '') ? date('H:i:s', strtotime($class_time)) : '';

        $last_date_of_registration = $this->input->post('last_date_of_registration', TRUE);
        $course_data['last_date_of_registration'] = ($last_date_of_registration != '') ? $last_date_of_registration : '';

        $course_more_data = $this->update_course_more_information($course_data);

        $upload_dir = 'content-library/' . $data['course_creator_info']->url . '/my-work-file/' . $data['course_info']->url;
        if (is_dir($upload_dir)) {
            // update tinymce information if remain directory with Course url
            $course_tinymce_data = $this->update_course_all_tinymce_information($data, $course_more_data);
        } else {
            // update tinymce information
            $course_tinymce_data = $this->update_course_all_tinymce_information_for_url_non_existence($data, $course_more_data);
        }

        $menu_id = $this->input->post('menu_id', TRUE); // Update Course URl
        $course_tinymce_data['url_id'] = $this->url_model->update_course_url_for_back_end($menu_id, $data, $upload_dir);
        $this->utility_model->update_information_in_database('tbl_course', 'course_id', $data['course_info']->course_id, $course_tinymce_data);
        // Update COurse Other Information
        $this->update_course_other_information($data, $course_tinymce_data);
    }

    /**
     * @Function            : update_course_more_information
     * @Used IN             : @function-'update_course_information'     super_admin_course_model[@Model]
     * @Description         : Update more Course information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 13-08-2016 05:16 PM 
     * @Parameter           : $course_data[ARRAY]
     * @Return              : $course_data[ARRAY]            
     * @Status              : available      
     * */
    function update_course_more_information($course_data) {
        $course_days = $this->input->post('course_days', TRUE);
        $course_data['course_days'] = ($course_days != '') ? implode(',', $course_days) : '';

        $course_data['course_meta_title'] = $this->input->post('course_meta_title', TRUE);

        $course_meta_keywords = $this->input->post('course_meta_keywords', TRUE);
        $course_data['course_meta_keywords'] = ($course_meta_keywords != '') ? implode(',', $course_meta_keywords) : '';

        $course_data['course_language'] = $this->input->post('course_language', TRUE);
        $course_data['course_rating'] = $this->input->post('course_rating', TRUE);
        $course_data['course_access_level'] = $this->input->post('course_access_level', TRUE);
        $course_data['course_status'] = $this->input->post('course_status', TRUE);
        $course_data['course_type'] = $this->input->post('course_type', TRUE);
        $course_data['course_meta_description'] = $this->input->post('course_meta_description', TRUE);

        $course_resource_person_edit = $this->input->post('course_resource_person_edit', TRUE);
        $course_data['course_resource_person_edit'] = ($course_resource_person_edit != '' ? 1 : 2);

        $course_resource_person_view_invoice = $this->input->post('course_resource_person_view_invoice', TRUE);
        $course_data['course_resource_person_view_invoice'] = ($course_resource_person_view_invoice != '' ? 1 : 2);

        $upcoming_course = $this->input->post('upcoming_course', TRUE);
        $course_data['upcoming_course'] = ($upcoming_course != '' ? 1 : 2);

        $course_resource_person_pay_invoice = $this->input->post('course_resource_person_pay_invoice', TRUE);
        $course_data['course_resource_person_pay_invoice'] = ($course_resource_person_pay_invoice != '' ? 1 : 2);
        return $course_data;
    }

    /**
     * @Function            : update_course_other_information
     * @Used IN             : @function-'update_course_information'     super_admin_course_model[@Model]
     * @Description         : Update Course information
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 13-08-2016 05:16 PM 
     * @Parameter           : $course_data[ARRAY]
     * @Return              : $course_data[ARRAY]            
     * @Status              : available      
     * */
    function update_course_other_information($data, $course_more_data) {
        if ($data['course_info']->course_type == '1') { // Delete price information
            $this->price_model->delete_price_information(1, $data['course_info']->course_id);
        }

        if ($course_more_data['course_type'] == '1') { // Save price information
            $this->price_model->save_price_information(1, $data['course_info']->course_id);  // save course price information
        }
        // notification for Update COurse
        $notification_id = $this->notification_course_model->save_update_course_notification($data['course_info']->course_id, $data, $course_more_data, 1);  // save notification for add course
        // send mail for update course for Update COurse
        $this->mailer_model->send_email_for_edit_course($notification_id);
    }

    /**
     * @Function            : update_course_all_tinymce_information_for_non_existence 
     * @Used IN             : @function-'update_course_more_information'   this[@Model]
     * @Description         : update course Tinymce information if course url does not existence
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-08-2016 03:56 PM
     * @Parameter           : $data[ARRAY],$course_data[ARRAY]
     * @Return              : $course_data[ARRAY]  
     * @Status              : available      
     * */
    function update_course_all_tinymce_information_for_url_non_existence($data, $course_data) {
        $type = 2; // content library type for course
        $find_path = 'source'; // find file from source directory
        $upload_dir = 'content-library/' . $data['course_creator_info']->url . '/my-work-file/' . $data['course_info']->url;

        $course_training_objectives = $this->input->post('course_training_objectives', FALSE);
        if ($course_training_objectives) { // if found Course_training_objective
            $course_updated_training_objectives = $this->tinymce_model->get_tinymce_description($data['course_info']->course_id, $upload_dir, $course_training_objectives, $type, $find_path);
            $course_data['course_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_objectives);
        } else {
            $course_data['course_training_objectives'] = '';
        }

        $course_training_outline = $this->input->post('course_training_outline', FALSE);
        if ($course_training_outline) { // if found course_training_outline
            $course_updated_training_outline = $this->tinymce_model->get_tinymce_description($data['course_info']->course_id, $upload_dir, $course_training_outline, $type, $find_path);
            $course_data['course_training_outline'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_outline);
        } else {
            $course_data['course_training_outline'] = '';
        }

        $directory = 'source/' . $data['course_creator_info']->url . '/';
        $this->utility_model->remove_directory_without_root($directory); // Remove file from TINYMCE source derectory
        return $course_data;
    }

    /**
     * @Function            : update_course_all_tinymce_information 
     * @Used IN             : @function-'update_course_information'   this[@Model]
     * @Description         : update tinymce information if remain directory with Course url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-08-2016 03:56 PM
     * @Parameter           : $data[ARRAY],$course_data[ARRAY]
     * @Return              : $course_data[ARRAY] 
     * @Status              : available      
     * */
    function update_course_all_tinymce_information($data, $course_data) {
        $type = 2; // content library type for course
        $upload_dir = 'content-library/' . $data['course_creator_info']->url . '/my-work-file/' . $data['course_info']->url;

        $course_training_objectives = $this->input->post('course_training_objectives', FALSE);
        if ($course_training_objectives) { // if found Course_training_objective
            $course_updated_training_objectives = $this->tinymce_model->update_tinymce_information($data['course_info']->course_id, $data['course_creator_info']->url, $data['course_info']->url, $course_training_objectives, $data['course_info']->course_training_objectives, $type);
            $course_data['course_training_objectives'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_objectives);
        } else {
            $course_data['course_training_objectives'] = '';
        }

        $course_training_outline = $this->input->post('course_training_outline', FALSE);
        if ($course_training_outline) { // if found course_training_outline
            $course_updated_training_outline = $this->tinymce_model->update_tinymce_information($data['course_info']->course_id, $data['course_creator_info']->url, $data['course_info']->url, $course_training_outline, $data['course_info']->course_training_outline, $type);
            $course_data['course_training_outline'] = $this->tinymce_model->changed_special_character_to_text($course_updated_training_outline);
        } else {
            $course_data['course_training_outline'] = '';
        }
        // remove all used file and Empty directory
        $this->remove_course_tinymce_file($type, $upload_dir, $data, $course_data);
        $this->tinymce_model->check_folder_for_tinymce($data['course_info']->course_id, $upload_dir);
        return $course_data;
    }

    /**
     * @Function            : remove_course_tinymce_file 
     * @Used IN             : @function-'update_course_information'   this[@Model]
     * @Description         : Remove unused tinymce file 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-08-2016 03:56 PM
     * @Parameter           : $type[INTEGER](Which type - Course/Video Course/Quiz.....) 
     *                        $upload_dir[STRING],$data[ARRAY],$course_data[ARRAY]
     * @Return              : Null 
     * @Status              : available      
     * */
    function remove_course_tinymce_file($type, $upload_dir, $data, $course_data) {
        if ($course_data['course_training_objectives'] == '') {
            if ($data['course_info']->course_training_objectives != '') { //previous tinymce have file
                $this->content_library_model->remove_multiple_content_library_file($data['course_info']->course_id, $data['course_info']->course_training_objectives, $type, $upload_dir);
            }
        }
        if ($course_data['course_training_outline'] == '') {
            if ($data['course_info']->course_training_outline != '') { //previous tinymce have file
                $this->content_library_model->remove_multiple_content_library_file($data['course_info']->course_id, $data['course_info']->course_training_outline, $type, $upload_dir);
            }
        }
    }

    /*
      -----------@@@RIPON@@ End Edit Course part (06-08-16)----------------------------------
     */


    /*
      -----------@@@RIPON@@ Start Manage Course part (03-08-16)----------------------------------
     */

    /**
     * @Function            : view_course_info_for_manage_course 
     * @Used IN             : @function-'manage_course'      super_admin_course[@controller]
     * @Description         : view course information for manage Course
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 06-08-2016 10:45 AM 
     * @Parameter           : $data[ARRAY],$page_number[INTEGER]
     * @Return              : NULL            
     * @Status              : available      
     * */
    function view_course_info_for_manage_course($data, $page_number, $search_input = '', $status = '', $sort_by = '') {
        $limit = ($page_number - 1) * 10;
        $person_role = $this->session->userdata('person_role');
        $course_editor_id = ($person_role == 9) ? $this->session->userdata('person_id') : '';
        $data['all_course'] = $this->select_all_course($limit, $search_input, $status, $sort_by, $course_editor_id);
        foreach ($data['all_course'] as $course_value) {
            $data['creator_info'][$course_value->course_id] = $this->person_model->get_single_person_information_by_person_id($course_value->person_id);
            $data['resource_person_info'][$course_value->course_id] = $this->resource_person_model->person_information_by_resource_person_id($course_value->resource_person_id);
            $data['topic_info'][$course_value->course_id] = $this->topic_model->select_topic_info_by_topic_id($course_value->topic_id);
            $data['student_info'][$course_value->course_id] = $this->student_model->get_all_concat_student_id_list_by_course_id(1, $course_value->course_id);
        }
        $page_url = 'admin/manage-course/'; // rederect URl
        $total_rows = $this->total_course($search_input, $status, $course_editor_id); // total row
        $params = array('url' => $page_url, 'total_row' => $total_rows, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['pagination_link'] = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }

    /**
     * @Function            : select_all_course 
     * @Used IN             : @function-'manage_course'      super_admin_course[@controller]
     * @Description         : get all Course frim database
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-08-2016 12:45 PM 
     * @Parameter           : $limit[INTEGER]
     * @Return              : NULL            
     * @Status              : available      
     * */
    function select_all_course($limit, $search_input = '', $status = '', $sort_by = '', $course_editor_id = '') {
        $this->db->select('*')
                ->from('tbl_course AS c')
                ->join('tbl_url AS u', 'u.url_id=c.url_id')
                ->join('tbl_person AS p', 'p.person_id=c.person_id');
        if ($course_editor_id != '') {
            $this->db->where('c.person_id', $course_editor_id);
        }
        if ($status != '') {
            $this->db->where('c.course_status', $status);
        }
        if ($search_input != '') {
            $like = "(c.course_name LIKE '%$search_input%' OR CONCAT_WS(' ',p.person_first_name,p.person_last_name) LIKE '%$search_input%')";
            $this->db->where($like);
        }

        if ($sort_by != '') {
            $this->db->order_by('c.course_name', $sort_by);
        }
        $this->db->limit(10, $limit);
        return $this->db->get()->result();
    }

    /**
     * @Function            : total_course 
     * @Used IN             : @function-'manage_course'      super_admin_course[@controller]
     * @Description         : total Course
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 03-08-2016 05:56 PM 
     * @Parameter           : Null
     * @Return              : NULL            
     * @Status              : available      
     * */
    function total_course($search_input = '', $status = '', $course_editor_id = '') {
        $this->db->select('*')
                ->from('tbl_course AS c')
                ->join('tbl_person AS p', 'p.person_id=c.person_id');
        if ($course_editor_id != '') {
            $this->db->where('c.person_id', $course_editor_id);
        }
        if ($status != '') {
            $this->db->where('c.course_status', $status);
        }
        if ($search_input != '') {
            $like = "(c.course_name LIKE '%$search_input%' OR CONCAT_WS(' ',p.person_first_name,p.person_last_name) LIKE '%$search_input%')";
            $this->db->where($like);
        }
        return $this->db->count_all_results();
    }

    /**
     * @Function            : delete_course 
     * @Used IN             : @function-'change_course_status'      super_admin_course[@controller]
     * @Description         : delete Course with content library folder
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 04-09-2016 05:56 PM 
     * @Parameter           : $course_id[INTEGER]
     * @Return              : NULL            
     * @Status              : available      
     * */
    function delete_course($course_info) {
        if ($course_info->course_type == 1) {
            $this->price_model->delete_price_information(1, $course_info->course_id);
        }

        $course_creator_url = $this->person_model->get_profile_url($course_info->person_id);
        $directory = 'content-library/' . $course_creator_url . '/my-work-file/' . $course_info->url;
        if (is_dir($directory)) {
            $this->utility_model->remove_directory($directory);
        }

        $content_library_result = $this->content_library_model->get_content_library_infomation(2, $course_info->course_id, 1);
        if ($content_library_result) {
            foreach ($content_library_result as $value) {
                $this->utility_model->delete_information_in_database('tbl_content_library', 'content_library_id', $value->content_library_id);
            }
        }

        $all_student = $this->student_model->get_all_concat_student_id_list_by_course_id(1, $course_info->course_id);
        if ($all_student != '') {
            $this->utility_model->delete_multiple_field_in_table('tbl_student', 'student_id', $all_student);
        }

        $url_info = $this->url_model->get_url_by_url_id($course_info->url_id, 5);
        if ($url_info) {
            $this->utility_model->delete_information_in_database('tbl_url', 'url_id', $url_info->url_id);
        }

        $notification_type = '6';
        $notification_id_list = $this->notification_model->get_notification_id_list_by_notification_type_id($course_info->course_id, $notification_type);
        $notification_type_id_list = $this->notification_model->get_notification_type_id_list_by_notification_type_id($course_info->course_id, $notification_type);
        if ($notification_id_list != '') {
            $this->utility_model->delete_multiple_field_in_table('tbl_notification', 'notification_id', $notification_id_list);
        }

        if ($notification_type_id_list != '') {
            $this->utility_model->delete_multiple_field_in_table('tbl_notification_type_info', 'notification_type_info_id', $notification_type_id_list);
        }

        $this->utility_model->delete_information_in_database('tbl_course', 'course_id', $course_info->course_id);
    }

    /**
     * @Function            : view_course_register_student_info 
     * @Used IN             : @function-'view_course_register_student'      super_admin_course[@controller]
     * @Description         : view all course register student info
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-09-2016 05:37 PM 
     * @Parameter           : $data[Array],$page_number[INTEGRE]
     * @Return              : NULL            
     * @Status              : available      
     * */
    function view_course_register_student_info($data, $date_data, $page_number) {
        $limit = ($page_number - 1) * 10;
        $data['course_register_student'] = $this->student_model->get_all_student_list_by_course_id(1, $data['course_info']->course_id, $date_data, $limit);
        $data['total_course_register_student'] = $this->student_model->get_total_student_by_course_id(1, $data['course_info']->course_id, $date_data);

        $params = array('url' => '', 'div_id' => 'registerCourseStudentPagination', 'total_row' => $data['total_course_register_student'], 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['register_course_student_paginzation_link'] = $this->tt_pagination->view_pagination_link($params);
        return $data;
    }

    /*
      -----------@@@RIPON@@ End Manage Course part (03-08-16)----------------------------------
     */





    /*
      -----------@@@RIPON@@ Start Course WOrk file part----------------------------------
     */

    /**
     * @Function            : update_course_work_file_status 
     * @Used IN             : save_upload_work_file             this@model- use 1 times]   
     *                      : delete_work_file                  super_admin_course[@controller]   
     *                      : delete_single_course_work_file    super_admin_course[@controller]   
     * @Description         : update 'course_work_file' to 1 or 2 in tbl_course if user add or remove work file    
     * @Developed By        : Ripon Jahrul
     * @Start DateTime      : 03-02-2016 05:47 PM  
     * @Updated Date Time   : 04-02-2016 11:23 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available       
     * */
    public function update_course_work_file_status($course_id, $value) {
        $this->db->set('course_work_files', $value);
        $this->db->where('course_id', $course_id);
        $this->db->update('tbl_course');
    }

    /**
     * @Function            : check_course_work_file_name 
     * @Used IN             : get work file name using Work Folder Name , Work File Name and course ID 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-02-2016 02:06 PM 
     * @Updated Date Time   : 03-02-2016 11:11 AM
     * @Updated By          : Ripon Jaherul             
     * @Changed IN          : check work file ID if second time change work file name             
     * */
    public function check_course_work_file_name($course_id, $folder_name, $file_name, $work_file_id) {
        $sql = "SELECT *
                FROM 
                    tbl_work_files_management AS w
                WHERE 
                        w.course_id = '$course_id'
                    AND w.work_file_folder_name= '$folder_name' 
                    AND w.work_files_name = '$file_name'
                    AND w.work_files_management_id != '$work_file_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : save_upload_work_file 
     * @Used IN             : Save work Single file into Database 
     * @Developed By        : Ripon Jahrul
     * @Start DateTime      : 02-02-2016 03:44 PM      
     * */
    public function save_upload_work_file($folder_name, $fileName, $fileSize, $work_files_url) {
        $data['course_id'] = $this->input->post('course_id', TRUE);

        $this->update_course_work_file_status($data['course_id'], 1);
        $this->change_course_work_file_status_to_draft($data['course_id']);

        $data['work_file_folder_name'] = $folder_name;
        $data['work_files_name'] = $fileName;
        $data['work_files_upload_date'] = date('Y/m/d', (time()));
        $data['work_file_size'] = $fileSize;
        $data['work_files_url'] = $work_files_url;
        $data['work_files_management_access_level'] = $this->input->post('work_files_management_access_level', TRUE);
        $data['work_files_status'] = 3;
        $this->db->insert('tbl_work_files_management', $data);
        return $this->db->insert_id();
    }

    /**
     * @Function            : get_work_file_value 
     * @Used IN             :  
     * @Developed By        : Ripon Jahrul
     * @Start DateTime      : 02-02-2016 03:53 PM
     * @Status              : Now Unused            
     * */
    public function get_work_file_value($work_file_id) {
        $sql = "SELECT *
                FROM 
                    tbl_work_files_management
                WHERE 
                    work_files_management_id = '$work_file_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : update_upload_course_work_file 
     * @Used IN             : @function-'upload_course_work_file'  super_admin_course[@controller],
     * @Description         : Update uploaded file if user upload more than one file and change status 3 
     *                        in all work file by following course  
     * @Developed By        : Ripon Jahrul
     * @Start DateTime      : 02-02-2016 03:58 PM    
     * @Updated Date Time   : 04-02-2016 04:41 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available        
     * */
    public function update_upload_course_work_file($work_file_id, $folder_name, $work_files_name, $fileSize, $work_files_url) {
        $data['course_id'] = $this->input->post('course_id', TRUE);

        $this->change_course_work_file_status_to_draft($data['course_id']);

        $data['work_file_folder_name'] = $folder_name;
        $data['work_files_name'] = $work_files_name;
        $data['work_files_upload_date'] = date('Y/m/d', (time()));
        $data['work_file_size'] = $fileSize;
        $data['work_files_url'] = $work_files_url;
        $data['work_files_management_access_level'] = $this->input->post('work_files_management_access_level', TRUE);
        $data['work_files_status'] = 3;
        $this->db->where('work_files_management_id', $work_file_id);
        $this->db->update('tbl_work_files_management', $data);
        return $work_file_id;
    }

    /**
     * @Function            : change_course_work_file_status_to_draft 
     * @Used IN             : @function-'update_upload_course_work_file'  this[@Model],
     *                      : @function-'save_upload_work_file'  this[@Model],
     * @Description         : change status draft all work file by selecting course  
     * @Developed By        : Ripon Jahrul 
     * @Start DateTime      : 04-02-2016 04:43 PM      
     * */
    public function change_course_work_file_status_to_draft($course_id) {
        $result = $this->get_all_course_work_file_by_course_id1($course_id);
        if ($result) {
            foreach ($result as $work_file_value) {
                $this->db->set('work_files_status', 3);
                $this->db->where('work_files_management_id', $work_file_value->work_files_management_id);
                $this->db->update('tbl_work_files_management');
            }
        }
    }

    /**
     * @Function            : person_available_disk_space (copied from 'Welcome_model') 
     * @Used IN             : @function-'person_available_disk_space'                      super_admin_course[@controller],
     * @                    : @function-'view_video_course_file_size_by_video_course_id'   super_admin_video[@controller],
     * @Description         : full size of content library for login user 
     * @Developed By        : Ripon Jahrul 
     * @Start DateTime      : 02-02-2016 04:10 PM      
     * */
    public function person_available_disk_space($dir) {
        $size = 0;
        foreach (glob(rtrim($dir, '/') . '/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : $this->person_available_disk_space($each);
        }
        return $size;
    }

    /**
     * @Function            : delete_single_course_work_file 
     * @Used IN             : @function-'get_course_value'  super_admin_course[@controller],
     *                        @function-'delete_single_work_file'  super_admin_course[@controller],
     * @Description         : delete single course work file by id  
     * @Developed By        : Ripon Jahrul 
     * @Start DateTime      : 02-02-2016 04:10 PM 
     * @Updated Date Time   : 04-02-2016 10:31 AM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available           
     * */
    public function delete_single_course_work_file($work_file_id) {
        $this->db->where('work_files_management_id', $work_file_id);
        $this->db->delete('tbl_work_files_management');
    }

    /**
     * @Function            : save_course_work_file
     * @Used IN             : save course work file if user complete uploading all course work file 
     * @Developed By        : Ripon Jahrul 
     * @Start DateTime      : 03-02-2016 03:23 PM      
     * */
    public function save_course_work_file() {
        $folder_name = $this->input->post('work_file_folder_name', TRUE);
        $work_file_name = $this->input->post('work_file_name', TRUE);
        $work_files_management_access_level = $this->input->post('work_files_management_access_level', TRUE);
        $upload_id = explode(',', $this->input->post('all_upload_id', TRUE));
        $counter_id = explode(',', $this->input->post('all_counter_ok_id', TRUE));

        $single_work_file = $this->super_admin_course_model->get_course_and_category_details_by_work_upload_id($upload_id[0]);
        $course_crerator_url = $this->super_admin_course_model->get_profile_url($single_work_file->course_creator_id);


        if ($single_work_file->work_file_folder_name != $folder_name) {
            $old_dir = 'content-library/' . $course_crerator_url . '/my-work-file/' . $single_work_file->work_file_folder_name;
            $new_dir = 'content-library/' . $course_crerator_url . '/my-work-file/' . $folder_name;

            if (file_exists($old_dir)) {
                rename($old_dir, $new_dir);
            }
        }

        for ($i = 0; $i < count($upload_id); $i++) {
            $single_work_files_name = $work_file_name[$counter_id[$i]];

            $course_work_file = $this->get_course_and_category_details_by_work_upload_id($upload_id[$i]);
            $course_crerator_url = $this->get_profile_url($course_work_file->course_creator_id);

            $value_array = explode('.', $course_work_file->work_files_url);
            $file_extension = $value_array[1];

            $data['work_file_folder_name'] = $folder_name;

            if ($single_work_files_name != $course_work_file->work_files_name) {
                $data['work_files_name'] = $single_work_files_name;
                $data['work_files_url'] = 'my-work-file/' . $folder_name . '/' . "$single_work_files_name.$file_extension";
                $old_work_files_url = 'my-work-file/' . $folder_name . '/' . "$course_work_file->work_files_name.$file_extension";

                $old_file_dir = 'content-library/' . $course_crerator_url . '/' . $old_work_files_url;
                $new_file_dir = 'content-library/' . $course_crerator_url . '/' . $data['work_files_url'];

                if (file_exists($old_file_dir)) {
                    rename($old_file_dir, $new_file_dir);
                }
            }


            $data['work_files_upload_date'] = date('Y/m/d', (time()));
            $data['work_files_management_access_level'] = $work_files_management_access_level[$counter_id[$i]];
            $data['work_files_status'] = 1;
            $this->db->where('work_files_management_id', $upload_id[$i]);
            $this->db->update('tbl_work_files_management', $data);
        }
    }

    /**
     * @Function            : get_all_course_by_work_file 
     * @Used IN             : @function-'manage_work_file'  super_admin_course[@controller],
     * @Description         : get all available course which have work file
     *                        @Update 1 => add course category for view course category
     *                        @Update 2 => add search option if user search course work file using course-name, course-category-name
     *                        @Update 3 => add limit count for pagination
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-02-2016 06:10 PM
     * @Updated Date Time   : 06-02-2016 09:50 AM
     * @Updated By          : Ripon Jaherul  
     * @Status              : available      
     * */
    function get_all_course_by_work_file($number, $search_input = NULL) {
        $sql = "SELECT * 
                FROM 
                    tbl_course AS c,
                    tbl_url AS u,
                    tbl_course_category AS cc
                WHERE 
                    c.course_work_files = '1'
                AND c.url_id = u.url_id
                AND c.course_category_id = cc.course_category_id";
        if ($search_input) {
            $sql.=" AND (cc.course_category_name LIKE '%$search_input%' OR c.course_name LIKE '%$search_input%')";
        }
        $sql.=" LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_course_by_work_file 
     * @Used IN             : @function-'manage_work_file'  super_admin_course[@controller],
     * @Description         : get total course which have work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 06-02-2016 10:50 PM 
     * @Status              : available      
     * */
    function get_total_course_by_work_file() {
        $sql = "SELECT count(*) AS total_courses 
                FROM 
                    tbl_course AS c,
                    tbl_url AS u,
                    tbl_course_category AS cc
                WHERE 
                    c.course_work_files = '1'
                AND c.url_id = u.url_id
                AND c.course_category_id = cc.course_category_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : delete_work_file_by_course_id 
     * @Used IN             : @function-'delete_work_file'  super_admin_course[@controller],
     * @Description         : Delete work file selecting course ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 04-02-2016 11:18 PM 
     * @Status              : available      
     * */
    function delete_work_file_by_course_id($course_id) {
        $this->db->where('course_id', $course_id);
        $this->db->delete('tbl_work_files_management');
    }

    /**
     * @Function            : get_course_work_file_by_course_id 
     * @Used IN             : @function-'view_work_file'  super_admin_course[@controller],
     * @Description         : get LIMIT available course work file using course ID for view course work file view page
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-02-2016 06:37 PM
     * @Updated Date Time   : 04-02-2016 10:14 AM
     * @Updated By          : Ripon Jaherul    
     * @Status              : Available      
     * */
    function get_all_course_work_file_by_course_id($course_id, $number) {
        $sql = "SELECT * 
                FROM 
                    tbl_work_files_management
                WHERE 
                    course_id = '$course_id' LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_all_course_work_file_by_course_id1 
     * @Used IN             : @function-'edit_course_work_file'  super_admin_course[@controller]
     *                      : @function-'change_course_work_file_status'  this[@Model]
     * @Description         : get all available course work file using course ID for edit course work file
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-02-2016 01:03 PM
     * @Status              : Available      
     * */
    function get_all_course_work_file_by_course_id1($course_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_work_files_management AS w
                WHERE 
                    w.course_id = '$course_id'";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_course_work_file_by_course_id 
     * @Used IN             : @function-'view_work_file'                   super_admin_course[@controller],
     * @                    : @function-'delete_single_course_work_file'   super_admin_course[@controller],
     * @Description         : get total amount available course work file using course ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 04-02-2016 10:52 PM
     * @Status              : Available      
     * */
    function get_total_course_work_file_by_course_id($course_id) {
        $sql = "SELECT count(work_files_management_id) AS total_work_file
                FROM 
                    tbl_work_files_management
                WHERE 
                    course_id = '$course_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_course_and_category_details_by_work_upload_id 
     * @Used IN             : @function-'view_course_category_for_work_file'   super_admin_course[@controller],
     * @                    : @function-'delete_single_course_work_file'       super_admin_course[@controller],
     * @                    : @function-'upload_course_work_file'              super_admin_course[@controller],
     * @                    : @function-'person_available_disk_space'          super_admin_course[@controller],
     * @                    : @function-'save_course_work_file'                this[@Model] - 2 times,
     * @Description         : get course category detail using 'work_files_management_id'
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 04-02-2016 08:41 PM
     * @Updated Date Time   : 09-02-2016 10:12 AM
     * @Updated By          : Ripon Jaherul     
     * @Status              : Available      
     * */
    function get_course_and_category_details_by_work_upload_id($work_upload_id) {
        $sql = "SELECT *,c.person_id AS course_creator_id
                FROM 
                    tbl_work_files_management AS w,
                    tbl_course AS c,
                    tbl_course_category AS cc
                WHERE 
                    w.work_files_management_id = '$work_upload_id'
                    AND w.course_id = c.course_id
                    AND c.course_category_id = cc.course_category_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_course_work_file_details_by_course_id 
     * @Used IN             : @function-'manage_work_file'  super_admin_course[@controller],
     *                      : @function-'delete_work_file'  super_admin_course[@controller],
     *                      : @function-'edit_course_work_file'  super_admin_course[@controller],
     * @Description         : view course folder name, view status and total work file
     * @                    : @update1 - add course creator ID in SQL 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 03-02-2016 06:50 PM
     * @Updated Date Time   : 04-02-2016 04:08 PM   |   10-02-2016 09:48 PM
     * @Updated By          : Ripon Jaherul         |   Ripon Jaherul
     * @Status              : Available      
     * */
    function get_course_work_file_details_by_course_id($course_id) {
        $sql = "SELECT *,work_files_status,c.person_id AS course_creator_id1,
                       count(work_files_management_id) AS total_work_file 
                FROM 
                    tbl_work_files_management AS w,
                    tbl_course AS c,
                    tbl_course_category AS cc
                WHERE 
                    w.course_id = '$course_id'
                    AND c.course_id = w.course_id
                    AND c.course_category_id = cc.course_category_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_course_information_by_course_id 
     * @Used IN             : @function-'view_course_work_file_status'  super_admin_course[@controller],
     * @                    : @function-'upload_course_work_file'       super_admin_course[@controller],
     * @Description         : get all available course using Course ID  
     * @                    : @Update1 - add course creator id in this QUERY 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Updated Date Time   : 06-03-2016 11:02 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function select_course_information_by_course_id($course_id) {
        $sql = "SELECT * ,c.person_id AS course_creator_id
                FROM 
                    tbl_course c, 
                    tbl_url as u 
                WHERE 
                    c.course_id = '$course_id' 
                AND u.url_id = c.url_id ";
        return $this->db->query($sql)->row();
    }

    /*
      -----------@@@RIPON@@End Course WOrk file part----------------------------------
     */
}
