<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description => all about account information
 *
 * @author Md Jaherul Islam
 */
class Super_admin_account_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : view_all_register_course_information 
     * @Used IN             : @function-'larner_course'     super_admin_account[@Controller]
     * @Description         : get all course register student information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-08-2016 01:23 PM  
     * @Parameter           : $data[ARRAY],$student_type=> Course or Video Course
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function view_all_register_course_information($data, $search_input, $selected_date, $limit) {
        $data['all_student'] = $this->get_all_register_student(1, $search_input, $selected_date, $limit);

        foreach ($data['all_student'] as $value) {
            $data['course_info'][$value->student_id] = $this->course_model->set_course_id($value->student_type_id)
                            ->set_field_name('url,course_type')->set_course_info_with_url_by_course_id()->get_result();
        }

        $data['page_url'] = 'admin/larner-course/'; // rederect URl
        $data['total_rows'] = $this->get_total_register_student(1, $search_input, $selected_date); // total row
        return $data;
    }

    /**
     * @Function            : get_all_course_register_student 
     * @Used IN             : @function-'larner_course'     super_admin_account[@Controller]
     * @Description         : get all course register student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-08-2016 11:37 AM  
     * @Parameter           : $student_type=> Course or Video Course
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_all_register_student($student_type, $search_input, $selected_date, $limit) {
        $sql = "SELECT * FROM tbl_student AS s,tbl_person AS p,tbl_url AS u  
                WHERE s.student_type = '$student_type' AND s.person_id = p.person_id AND p.url_id = u.url_id";
        if ($search_input != '') {
            $sql.=" AND (CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$search_input%'
                    OR p.person_contact_number LIKE '%$search_input%' 
                    OR p.person_email LIKE '%$search_input%'
                    OR s.student_roll_number LIKE '%$search_input%')";
        }
        if ($selected_date != '') {
            $sql.=" AND DATE_FORMAT(s.register_date_time,'%Y-%m') ='$selected_date'";
        }
        $sql.=" ORDER BY s.register_date_time DESC";
        $sql.=" LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_register_student 
     * @Used IN             : @function-'larner_course'     super_admin_account[@Controller]
     * @Description         : get total course register student
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-08-2016 12:26 PM  
     * @Parameter           : $student_type=> Course or Video Course
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_total_register_student($student_type, $search_input, $selected_date) {
        $sql = "SELECT count(*) AS total FROM tbl_student AS s,tbl_person AS p 
                WHERE s.student_type = '$student_type' AND s.person_id = p.person_id";
        if ($search_input != '') {
            $sql.=" AND (CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$search_input%'
                    OR p.person_contact_number LIKE '%$search_input%' 
                    OR p.person_email LIKE '%$search_input%'
                    OR s.student_roll_number LIKE '%$search_input%')";
        }
        if ($selected_date != '') {
            $sql.=" AND DATE_FORMAT(s.register_date_time,'%Y-%m') ='$selected_date'";
        }
        return $this->db->query($sql)->row()->total;
    }

}
