<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Send_video_course_invitation_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : send_video_course_invitation_info insert in db
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation
     * @Return              : insert_id 
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_video_course_invitation_info($invitation){
        $this->db->insert('tbl_invitation', $invitation);
        return $this->db->insert_id();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : send_invitation_receive_person_info insert in db
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_receive_person
     * @Return              : null 
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_invitation_receive_person_info($invitation_receive_person){
        $this->db->insert('tbl_invitation_receive_person', $invitation_receive_person);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 6-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : invitation, send_invitation_receive_person_info update in db
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_receive_person
     * @Return              : invitation_user_number 
     * @value               : $invitation_info get the data invitation
     *                        $invitation_user_number get the updated valut to update in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function update_send_invitation_receive_person_info($invitation_receive_person){
        $this->db->where('invitation_id', $invitation_receive_person['invitation_id'])
                ->where('invitation_send_to_email', $invitation_receive_person['invitation_send_to_email'])
                ->update('tbl_invitation_receive_person', $invitation_receive_person);
        
        
        $invitation_info = $this->db->select('*')
                ->from('tbl_invitation')
                ->where('invitation_id', $invitation_receive_person['invitation_id'])
                ->get()->row();
        $invitation_user_number = $invitation_info->invitation_user_number - 1;
        $invitation['invitation_user_number'] = ($invitation_user_number < 0) ? 0 : $invitation_user_number;
            
        $this->db->where('invitation_id', $invitation_info->invitation_id)
                ->update('tbl_invitation', $invitation);
        
        return $invitation['invitation_user_number'];
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : Get the user email based on send_invitation_type
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_user_number, $send_invitation_type
     * @Return              : all person email 
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function send_invitation_user_email($invitation_user_number, $send_invitation_type){
        //person_role
        if($send_invitation_type == 2){
            $this->db->select('person_email')
                    ->from('tbl_person')
                    ->limit($invitation_user_number);
            return $this->db->get()->result_array();
        }else{
            $this->db->select('person_email')
                    ->from('tbl_person')
                    ->where('person_role', $send_invitation_type)
                    ->limit($invitation_user_number);
            return $this->db->get()->result_array();
        }
        
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : get_send_invitation_receive_person_info 
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_id
     * @Return              : invitation_receive_person data
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_send_invitation_receive_person_info($invitation_id) {
        $this->db->select('*')
                ->from('tbl_invitation_receive_person')
                ->where('invitation_receive_person_status', 1)
                ->where('invitation_id', $invitation_id)
                ->limit(1);
        return $this->db->get()->row();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : get_send_invitation_receive_person_info based on invitation_receive_person_status
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_id, $invitation_receive_person_status
     * @Return              : invitation_receive_person data which is match with invitation_id, invitation_receive_person_status
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function sent_invitation_receive_person_info_by_invitation_id($invitation_id, $invitation_receive_person_status = NULL, $limit_offset = NULL) {
        if($invitation_receive_person_status == ''){
            $invitation_receive_person_status = array(1,2,3);
        }
        $data['invitation_receive_person_data'] = $this->db->select('*')
                ->from('tbl_invitation_receive_person')
                ->where_in('invitation_receive_person_status', $invitation_receive_person_status)
                ->where('invitation_id', $invitation_id)
                ->limit(10, $limit_offset)
                ->get()->result();
        $invitation_receive_person = $this->db->select('*')
                ->from('tbl_invitation_receive_person')
                ->where_in('invitation_receive_person_status', $invitation_receive_person_status)
                ->where('invitation_id', $invitation_id)
                ->get()->result();
        $data['count_invitation_receive_person'] = count($invitation_receive_person);
        return $data;
    }
    
     /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 7-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : get single invitation info
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_id
     * @Return              : invitation data
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_send_video_course_invitation_info($invitation_id) {
        $this->db->select('*')
                ->from('tbl_invitation')
                ->where('invitation_id', $invitation_id);
        return $this->db->get()->row();
    }
    
     /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : get invitation, invitation_receive_person all data and how many email successfully sent
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_type_id
     * @Return              : all data
     * @value               : 
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_send_video_course_invitation_info_by_invitation_type_id($invitation_type_id){
        $data['invitation'] = $this->db->select('*')
                ->from('tbl_invitation')
                ->where('invitation_type_id', $invitation_type_id)
                ->get()->result();
        
        if(isset($data['invitation'])){
            for ($i = 0; $i < (count($data['invitation'])); $i++) {
                $data[$data['invitation'][$i]->invitation_id] = $this->db->select('*')
                        ->from('tbl_invitation_receive_person')
                        ->where('invitation_id', $data['invitation'][$i]->invitation_id)
                        ->get()->result();
            }
        }
        if(isset($data['invitation'])){
            for ($i = 0; $i < (count($data['invitation'])); $i++) {
                $data['invitation_sent'][$data['invitation'][$i]->invitation_id] = $this->db->select('*')
                        ->from('tbl_invitation_receive_person')
                        ->where_in('invitation_receive_person_status', 2)
                        ->where('invitation_id', $data['invitation'][$i]->invitation_id)
                        ->count_all_results();
            }
        }
        return $data;
    }
    
    public function send_video_course_invitation_anonymous_info($invitation_type_id, $page_number){
        $limit_offset = ($page_number - 1) * 10;
        $data['invitation'] = $this->db->select('*')
                ->from('tbl_invitation')
                ->where('invitation_send_type', 1)
                ->where('invitation_type_id', $invitation_type_id)
                ->order_by('invitation_id', 'DESC')
                ->limit(10, $limit_offset)->get()->result();
        
        if(isset($data['invitation'])){
            $data['invitation_receive_person'] = $this->send_video_course_invitation_receive_person_data($data['invitation']);
        }
        $invitation_data = $this->db->select('*')
                ->from('tbl_invitation')
                ->where('invitation_send_type', 1)
                ->where('invitation_type_id', $invitation_type_id)
                ->order_by('invitation_id', 'DESC')->get()->result();
        
        $data['count_invitation'] = count($invitation_data);
        
        $total_row = $data['count_invitation'];
        $params = array('url' => '', 'div_id' => 'anonymous_view_video_course_invitation_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['anonymous_view_video_course_invitation_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        return $data;
    }
    
    public function send_video_course_invitation_tt_user_info($invitation_type_id, $page_number){
        $limit_offset = ($page_number - 1) * 10;
        $invitation_send_type = array(2,3,4);
        $data['invitation'] = $this->db->select('*')
                ->from('tbl_invitation')
                ->where_in('invitation_send_type', $invitation_send_type)
                ->where('invitation_type_id', $invitation_type_id)
                ->order_by('invitation_id', 'DESC')->limit(10, $limit_offset)->get()->result();
        
        if(isset($data['invitation'])){
            $data['invitation_receive_person'] = $this->send_video_course_invitation_receive_person_data($data['invitation']);
        }
        
        $invitation_data = $this->db->select('*')
                ->from('tbl_invitation')
                ->where_in('invitation_send_type', $invitation_send_type)
                ->where('invitation_type_id', $invitation_type_id)
                ->order_by('invitation_id', 'DESC')->get()->result();
        
        $data['count_invitation'] = count($invitation_data);
        
        $total_row = $data['count_invitation'];
        $params = array('url' => '', 'div_id' => 'user_view_video_course_invitation_pagination', 'total_row' => $total_row, 'per_page' => 10, 'current_page' => $page_number, 'total_link' => 10);
        $data['user_view_video_course_invitation_pagination'] = $this->tt_pagination->view_pagination_link($params);
        
        return $data;
    }
    
    public function send_video_course_invitation_receive_person_data($invitation) {
        $data[] = array();
        for ($i = 0; $i < (count($invitation)); $i++) {
            $data[$invitation[$i]->invitation_id] = $this->db->select('*')
                    ->from('tbl_invitation_receive_person')
                    ->where('invitation_id', $invitation[$i]->invitation_id)
                    ->get()->result();
        }
        for ($i = 0; $i < (count($invitation)); $i++) {
            $data['invitation_sent'][$invitation[$i]->invitation_id] = $this->db->select('*')
                    ->from('tbl_invitation_receive_person')
                    ->where_in('invitation_receive_person_status', 2)
                    ->where('invitation_id', $invitation[$i]->invitation_id)
                    ->count_all_results();
        }
        return $data;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : get single invitation_receive_person data
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_receive_person_id
     * @Return              : all data
     * @value               : 
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_send_invitation_receive_person_info_by_invitation_receive_person_id($invitation_receive_person_id) {
        $this->db->select('*')
                ->from('tbl_invitation_receive_person')
                ->where('invitation_receive_person_id', $invitation_receive_person_id);
        return $this->db->get()->row();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : delete invitation_receive_person info & update invitation
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_receive_person_id, $invitation_receive_person
     * @Return              : null
     * @value               : $invitation_info get the data invitation
     *                        $invitation_user_number get the updated valut to update in db
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_invitation_receive_person($invitation_receive_person_id, $invitation_receive_person) {
        $this->db->where('invitation_receive_person_id', $invitation_receive_person_id)
                ->delete('tbl_invitation_receive_person');
        
        $invitation_receive_person_info = $this->db->select('*')
                ->from('tbl_invitation_receive_person')
                ->where('invitation_id', $invitation_receive_person->invitation_id)
                ->get()->result();
        
        if(count($invitation_receive_person_info) == 0){
            $this->db->where('invitation_id', $invitation_receive_person->invitation_id)
                    ->delete('tbl_invitation');
        }else{
            $invitation_info = $this->db->select('*')
                    ->from('tbl_invitation')
                    ->where('invitation_id', $invitation_receive_person->invitation_id)
                    ->get()->row();
            $invitation_user_number = $invitation_info->invitation_user_number - 1;
            $invitation['invitation_user_number'] = ($invitation_user_number < 0) ? 0 : $invitation_user_number;
            $this->db->where('invitation_id', $invitation_receive_person->invitation_id)
                    ->update('tbl_invitation', $invitation);
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 8-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : check send email to person email
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $invitation_receive_person
     * @Return              : null
     * @value               : $data[$invitation_person->invitation_receive_person_id] is used for keep the data of match email
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function check_send_invitation_email_with_person_email($invitation_receive_person) {
        foreach ($invitation_receive_person as $invitation_person){
            $data[$invitation_person->invitation_receive_person_id] = $this->db->select('p.person_id,p.person_email,p.person_first_name,p.person_last_name,u.*')
                    ->from('tbl_person as p')
                    ->join('tbl_url as u', 'p.url_id = u.url_id')
                    ->where('p.person_email', $invitation_person->invitation_send_to_email)
                    ->get()->row();
        }
        if(isset($data)){
            return $data;
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 9-8-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : null
     * @Description         : search manage send invitation [video_course_title]
     * @view                : null
     * @redirect            : null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : null
     * @Parameter           : $search_value, $limit_offset
     * @Return              : null
     * @value               : $data array keep the data of video_course, count_video_course
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function search_send_video_course_invitation_info($search_value, $limit_offset = NULL){
        $data['video_course'] = $this->db->select('*')
                ->from('tbl_video_course AS vc')
                ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                ->like('vc.video_course_title', $search_value, 'both')
                ->limit(10, $limit_offset)
                ->get()->result();
        
        $video_course_data = $this->db->select('*')
                ->from('tbl_video_course AS vc')
                ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                ->like('vc.video_course_title', $search_value, 'both')
                ->get()->result();
        $data['count_video_course'] = count($video_course_data);
        
        return $data;
    }
    
    public function search_send_video_course_invitation_user_list($search_value, $invitation_id, $limit_offset = NULL){
        $data['invitation_receive_person_data'] = $this->db->select('*')
                ->from('tbl_invitation_receive_person')
                ->where('invitation_id', $invitation_id)
                ->like('invitation_send_to_email', $search_value, 'both')
                ->limit(10, $limit_offset)
                ->get()->result();
        $invitation_receive_person = $this->db->select('*')
                ->from('tbl_invitation_receive_person')
                ->where('invitation_id', $invitation_id)
                ->like('invitation_send_to_email', $search_value, 'both')
                ->get()->result();
        $data['count_invitation_receive_person'] = count($invitation_receive_person);
        return $data;
    }
}

