<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of rating_model
 *
 * @author User
 */
class Rating_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : update_rating_infomation
     * @Used IN             : @function-'save_course_rating'   'course[@Controller]'  
     * @Description         : Update rating information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 18-08-2016 05:01 PM    
     * @Parameter           : $person_id[rated person ID]
     *                        $type[Rating type=>course,Video Course], 
     *                        $type_id[Rating type ID=>course id,Video Course ID], 
     *                        $rating_value[rated value]
     * @Return              : Null   
     * @Status              : available      
     * */
    function update_rating_infomation($person_id, $type, $type_id, $rating_value) {
        $rating_result = $this->get_single_rating_information($person_id, $type, $type_id);

        if ($rating_result) {
            $data = Array();
            $data['rating_value'] = $rating_value;
            $this->utility_model->update_information_in_database('tbl_rating', 'rating_id', $rating_result->rating_id, $data);
        } else {
            $this->save_rating_information($person_id, $type, $type_id, $rating_value);
        }

        if ($type == 1) {
            $this->update_course_rating_information($type, $type_id);
        }
    }

    /**
     * @Function            : get_single_rating_information
     * @Used IN             : @function-'update_rating_infomation'     this[@Model]  
     * @Description         : get single rating information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 18-08-2016 05:01 PM    
     * @Parameter           : $person_id[Rated person ID]
     *                        $type[Rating type=>course,Video Course], 
     *                        $type_id[Rating type ID=>course id,Video Course ID],
     * @Return              : Null   
     * @Status              : available      
     * */
    function get_single_rating_information($person_id, $type, $type_id) {
        $sql = "SELECT * FROM tbl_rating AS rt
                WHERE rt.person_id = '$person_id' AND rt.rating_type = '$type' AND rt.rating_type_id = '$type_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_rating_information
     * @Used IN             : @function-'update_rating_infomation'     this[@Model]  
     * @Description         : get rating information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 18-08-2016 05:01 PM    
     * @Parameter           : $type[Rating type=>course,Video Course], 
     *                        $type_id[Rating type ID=>course id,Video Course ID],
     * @Return              : Null   
     * @Status              : available      
     * */
    function get_rating_information($type, $type_id) {
        $sql = "SELECT count(*) AS total,sum(rt.rating_value) AS avg_rating 
                FROM tbl_rating AS rt
                WHERE rt.rating_type = '$type' AND rt.rating_type_id = '$type_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : update_rating_infomation
     * @Used IN             : @function-'save_course_rating'   'course[@Controller]'  
     * @Description         : Update rating information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 18-08-2016 05:01 PM    
     * @Parameter           : $person_id[rated person ID]
     *                        $type[Rating type=>course,Video Course], 
     *                        $type_id[Rating type ID=>course id,Video Course ID], 
     *                        $rating_value[rated value]
     * @Return              : Null   
     * @Status              : available      
     * */
    function save_rating_information($person_id, $type, $type_id, $rating_value) {
        $data = Array();
        $data['person_id'] = $person_id;
        $data['rating_type'] = $type;
        $data['rating_type_id'] = $type_id;
        $data['rating_value'] = $rating_value;
        $this->db->insert('tbl_rating', $data);
    }

    /**
     * @Function            : update_rating_infomation
     * @Used IN             : @function-'save_course_rating'   'course[@Controller]'  
     * @Description         : Update rating information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 18-08-2016 06:15 PM    
     * @Parameter           : $course_id[INTEGER]
     * @Return              : Null   
     * @Status              : available      
     * */
    function update_course_rating_information($type, $course_id) {
        $rating_info = $this->get_rating_information($type, $course_id);
        $data = Array();
        $data['course_rating'] = ($rating_info->avg_rating / $rating_info->total);
        $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_id, $data);
    }

}
