<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of price_model
 *
 * @author MD Jaherul Islam
 */
class Price_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : save_course_price_information 
     * @Used IN             : @function-'save_course_information'    this[@Model]
     * @Description         : save course price information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-07-2016 11:43 AM   
     * @Parameter           : $type=>course/Video course, $typed_id=>Course_id/video_course_id
     * @Return              : Null    
     * @Status              : available      
     * */
    function save_price_information($type, $typed_id) {
        $data = Array();
        $data['price_currency'] = $this->input->post('course_price_currency', TRUE);
        $data['price'] = $this->input->post('course_price', TRUE);
        $data['price_type'] = $type;
        $data['price_type_id'] = $typed_id;
        $this->db->insert('tbl_price', $data);
    }

    /**
     * @Function            : get_single_price_information 
     * @Used IN             : @function-'get_information_for_edit_course'   user_course_model[@Model]
     * @Description         : get single price information using price Type and Course OR video COurse ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-07-2016 01:07 PM
     * @Parameter           : $price_type[INTEGER],$price_type_id[INTEGER]
     * @Return              : $price_info[ARRAY]           
     * @Status              : available      
     * */
    function get_single_price_information($price_type, $price_type_id) {
        $sql = "SELECT * FROM tbl_price AS p WHERE p.price_type = '$price_type' AND p.price_type_id = '$price_type_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : update_price_information 
     * @Used IN             : @function-'update_course_more_information'   user_course_model[@Model]
     * @Description         : update price information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-07-2016 12:47 PM
     * @Parameter           : $price_type[INTEGER],$price_type_id[INTEGER]
     * @Return              : Null           
     * @Status              : available      
     * */
    function update_price_information($price_type, $price_type_id) {
        $data = Array();
        $price_info = $this->get_single_price_information($price_type, $price_type_id);
        $data['price_currency'] = $this->input->post('course_price_currency', TRUE);
        $data['price'] = $this->input->post('course_price', TRUE);
        $this->utility_model->update_information_in_database('tbl_price', 'price_id', $price_info->price_id, $data);
    }

    /**
     * @Function            : delete_price_information 
     * @Used IN             : @function-'delete_course'   super_admin_course_model[@Model]
     * @Description         : Delete price information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-08-2016 12:06 PM
     * @Parameter           : $price_type[INTEGER],$price_type_id[INTEGER]
     * @Return              : Null           
     * @Status              : available      
     * */
    function delete_price_information($price_type, $price_type_id) {
        $sql = "DELETE p
                FROM tbl_price AS p
                WHERE p.price_type = '$price_type'
                AND p.price_type_id = '$price_type_id'";
        $this->db->query($sql);
    }

}
