<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of post_model
 *
 * @author rIpOn
 */
class Post_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

//---------------------------------- Start Front End Deshboard Post-----------------------------  

    /**
     * @Function            : get_dashboard_post_data 
     * @Used IN             : @function-'index'     welcome[@controller],
     * @Description         : get deshboard post value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 10:09 AM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]   
     * @Status              : Available       
     * */
    function get_dashboard_post_data($data) {
        $data['all_post'] = $this->select_all_post($data['person_info']->person_id, 10);
        $data['total_post'] = $this->select_total_post($data['person_info']->person_id);
        $data['all_approved_group'] = $this->select_approved_group_by_person_id($data['person_info']->person_id);
        $data['all_link'] = $this->get_all_linked_person($data['person_info']->person_id);
        $data['all_linked_person'] = $this->get_all_linked_person_info($data['person_info']->person_id);
        $result = $this->get_last_post_id();
        if ($result) {
            $data['last_post_id'] = $result->post_id;
        }
        return $this->get_all_post_data($data);
    }

    /**
     * @Function            : get_all_post_data 
     * @Used IN             : @function-'get_dashboard_post_data'     this[@Model]
     * @                    : @function-'view_all_post'               post[@Controller]
     * @Description         : get all post data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 10:26 AM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_all_post_data($data) {
        foreach ($data['all_post'] as $post_value) {
            $data['post_url'][$post_value->post_id] = $this->select_post_comment_url($post_value->post_id, 1);
            $data['group_member_id'][$post_value->post_id] = $this->get_group_member_id($post_value->post_id);
            $data['post_function'][$post_value->post_id] = $this->get_post_value_by_post_id($post_value->post_id);
            if ($data['post_function'][$post_value->post_id]) {
                $data = $this->get_person_like_value($data, $post_value);
            }
            $data['total_comment'][$post_value->post_id] = $this->get_total_first_comment_by_post_id($post_value->post_id);
            $data['post_comment'][$post_value->post_id] = $this->get_post_first_comment_by_post_id($post_value->post_id);

            $data = $this->get_all_post_commment_data($data, $data['person_info']->person_id, $post_value->post_id);
        }
        return $data;
    }

    /**
     * @Function            : get_single_post_data 
     * @Used IN             : @function-'view_note_alert'     profile[@Controller]
     * @Description         : get single post data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-06-2016 12:29 PM
     * @Parameter           : $person_id[INTEGER], $post_id[INTEGER]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_single_post_data($data, $person_id, $post_id) {
        $data['all_link'] = $this->get_all_linked_person($person_id);
        $data['post_url'] = $this->select_post_comment_url($post_id, 1);
        $data['post_function'][$post_id] = $this->get_post_value_by_post_id($post_id);
        if ($data['post_function'][$post_id]) {
            if ($data['post_function'][$post_id]->post_like_by != '') {
                $data['post_liked_person'][$post_id] = $this->get_all_post_liked_person_info($person_id, $data['all_link'], $data['post_function'][$post_id]->post_like_by);
            } else {
                $data['post_liked_person'][$post_id] = '';
            }
        }
        $data['total_comment'][$post_id] = $this->get_total_first_comment_by_post_id($post_id);
        $data['post_comment'][$post_id] = $this->get_post_first_comment_by_post_id($post_id);
        return $this->get_all_post_commment_data($data, $person_id, $post_id);
    }

    /**
     * @Function            : get_all_post_commment_data 
     * @Used IN             : @function-'get_all_post_data'     this[@Model]
     * @Description         : get all post comment data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 10:26 AM
     * @Parameter           : $data[ARRAY],$post_value[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_all_post_commment_data($data, $person_id, $post_id) {
        foreach ($data['post_comment'][$post_id] as $post_comment_value) {
            $data['comment_url'][$post_comment_value->comment_id] = $this->select_post_comment_url($post_comment_value->comment_id, 2);
            if ($post_comment_value->comment_like_by != '') {
                $data['comment_liked_person'][$post_comment_value->comment_id] = $this->get_all_post_liked_person_info($person_id, $data['all_link'], $post_comment_value->comment_like_by);
            }

            $data['comment_reply'][$post_comment_value->comment_id] = $this->get_post_comment_replay_limit_post_comment_id($post_comment_value->comment_id);
            $data['total_comment_reply'][$post_comment_value->comment_id] = $this->get_total_comment_by_comment_id($post_comment_value->comment_id);

            $data = $this->get_all_post_reply_commment_data($data, $person_id, $post_comment_value->comment_id);
        }
        return $data;
    }

    /**
     * @Function            : get_all_post_reply_commment_data 
     * @Used IN             : @function-'get_all_post_commment_data'     this[@Model]
     * @Description         : get all post reply comment data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 10:26 AM
     * @Parameter           : $data[ARRAY],$post_value[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_all_post_reply_commment_data($data, $person_id, $comment_id) {
        foreach ($data['comment_reply'][$comment_id] as $comment_reply_value) {
            if ($comment_reply_value->comment_like_by != '') {
                $data['reply_liked_person'][$comment_reply_value->comment_id] = $this->get_all_post_liked_person_info($person_id, $data['all_link'], $comment_reply_value->comment_like_by);
            }
            $data['reply_comment_url'][$comment_reply_value->comment_id] = $this->select_post_comment_url($comment_reply_value->comment_id, 2);
            $data['total_nested_reply'][$comment_reply_value->comment_id] = $this->get_total_comment_by_comment_id($comment_reply_value->comment_id);
        }
        return $data;
    }

    /**
     * @Function            : get_all_post_nested_reply_data 
     * @Used IN             : @function-'view_nested_replies'     post[@Controller]
     * @Description         : get all post nested reply data
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-06-2016 11:37 AM
     * @Parameter           : $data[ARRAY],$person_id[INTEGER]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_all_post_nested_reply_data($data, $person_id) {
        foreach ($data['nested_reply'] as $nested_reply_value) {
            if ($nested_reply_value->comment_like_by != '') {
                $data['nested_reply_liked_person'][$nested_reply_value->comment_id] = $this->get_all_post_liked_person_info($person_id, $data['all_link'], $nested_reply_value->comment_like_by);
            }
            $data['nested_reply_url'][$nested_reply_value->comment_id] = $this->post_model->select_post_comment_url($nested_reply_value->comment_id, 2);
            $data['total_replies_reply'][$nested_reply_value->comment_id] = $this->post_model->get_total_comment_by_comment_id($nested_reply_value->comment_id);
        }
        return $data;
    }

    /**
     * @Function            : get_person_like_value 
     * @Used IN             : @function-'get_all_post_data'     this[@Model]
     * @Description         : get person like value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 01:00 AM
     * @Parameter           : $data[ARRAY],$post_value[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_person_like_value($data, $post_value) {
        if ($data['post_function'][$post_value->post_id]->post_like_by != '') {
            $data['post_liked_person'][$post_value->post_id] = $this->get_all_post_liked_person_info($data['person_info']->person_id, $data['all_link'], $data['post_function'][$post_value->post_id]->post_like_by);
        } else {
            $data['post_liked_person'][$post_value->post_id] = '';
        }

        return $data;
    }

    /**
     * @Function            : get_all_linked_person 
     * @Used IN             : @function-'get_all_post_data'          this[@Model]
     * @                    : @function-'view_comment_details'       post[@Controller]
     * @                    : @function-'add_comment_reply_like'     post[@Controller]
     * @Description         : get all linked person using loggin person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 04:16 AM
     * @Parameter           : $person_id[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_all_linked_person($person_id, $status = NUll) {
        $sql = "SELECT 
                CONCAT(
                GROUP_CONCAT(DISTINCT(pl.requested_person_id)),',',
                GROUP_CONCAT(DISTINCT(pl.person_id))) AS linked_person_id 
                FROM 
                    tbl_person_link AS pl
                WHERE (pl.person_id = '$person_id' OR pl.requested_person_id = '$person_id')";
        if ($status == NULL) {
            $sql .= " AND pl.add_link_request_status IN (1,3)";
        } else {
            $sql .= " AND pl.add_link_request_status IN ($status)";
        }
        $result = $this->db->query($sql)->row();
        if ($result->linked_person_id != '') {
            return explode(',', $result->linked_person_id);
        } else {
            return Array();
        }
    }

    /**
     * @Function            : get_all_linked_person_info 
     * @Used IN             : @function-'get_all_post_data'          this[@Model]
     * @Description         : get all linked person using loggin person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-07-2016 03:38 PM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $data[ARRAY]    
     * @Status              : Available       
     * */
    function get_all_linked_person_info($person_id) {
        $linked_persin_id_array = array_unique($this->get_all_linked_person($person_id, 1));
        $linked_persin_id_array1 = array_diff($linked_persin_id_array, array($person_id));
        if ($linked_persin_id_array1) {
            return $this->person_model->get_all_selected_person(implode(',', $linked_persin_id_array1));
        } else {
            return Array();
        }
    }

    /**
     * @Function            : get_all_linked_person 
     * @Used IN             : @function-'get_all_post_data'     this[@Model]
     * @Description         : get liked person
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 01:01 AM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Unused       
     * */
//    function get_all_linked_person($data) {
//        $data['all_linked_person'] = Array();
//        $data['active_link'] = Array();
//        $data['request_sent_link'] = Array();
//        $data['request_receive_link'] = Array();
//        $data['all_link'] = $this->get_all_linked_person_by_person_id($data['person_info']->person_id);
//        if ($data['all_link']) {
//            $data = $this->assign_link_value($data);
//        }
//        return $data;
//    }

    /**
     * @Function            : assign_link_value 
     * @Used IN             : @function-'get_all_linked_person'     this[@Model]
     * @Description         : assigned link value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 01:02 PM
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]    
     * @Status              : Unsued       
     * */
    function assign_link_value($data) {
        foreach ($data['all_link'] as $link_value) {
//            $data['active_link'][] = $link_value->person_id;
//            if ($link_value->add_link_request_status == 1) {
//                if ($link_value->person_id != $data['person_info']->person_id) {
//                    $data['active_link'][] = $link_value->person_id;
//                }
//                if ($link_value->requested_person_id != $data['person_info']->person_id) {
//                    $data['active_link'][] = $link_value->requested_person_id;
//                }
//            }
//            if ($link_value->add_link_request_status == 3) {
//                if ($link_value->person_id != $data['person_info']->person_id) {
//                    $data['request_sent_link'][] = $link_value->person_id;
//                }
//                if ($link_value->requested_person_id != $data['person_info']->person_id) {
//                    $data['request_receive_link'][] = $link_value->requested_person_id;
//                }
//            }
        }
        return $data;
    }

    /**
     * @Function            : get_all_linked_person_by_person_id 
     * @Used IN             : @function-'get_all_linked_person'     this[@Model]
     * @Description         : get all available link value
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 31-05-2016 01:02 PM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $linked_person_info[ARRAY]    
     * @Status              : Unused       
     * */
    function get_all_linked_person_by_person_id($person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_person_link AS pl
                WHERE 
                    pl.person_id = '$person_id' OR pl.requested_person_id = '$person_id'";
        return $this->db->query($sql)->result();
    }

    /**
      Date :
      @Name: Ripon
      Work: Select all post (front end)
      End : 27-01-2016
     */
    function select_all_post($person_id, $counter) {
        $result = $this->get_linked_person_id($person_id);
        $sql = "SELECT *
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE 
                    p.posted_by = pr.person_id
                AND pr.url_id = u.url_id
                AND p.post_status = '1'
                AND (p.post_publication_status = '1' 
                OR p.post_publication_status = '2'";
        if ($result) {
            $sql .= " OR (p.post_publication_status = '3' AND p.posted_by IN (" . $result . "))";
        } else {
            $sql .= " OR (p.post_publication_status = '3' AND p.posted_by = '$person_id')";
        }
        $sql .= " OR (p.post_publication_status = '4' AND '$person_id' IN (SELECT gm.person_id 
                FROM 
                    tbl_post_group AS pg,
                    tbl_group_member gm
                WHERE 
                    pg.post_id = p.post_id
                AND pg.group_id = gm.group_id
                AND gm.group_member_status = '1'))";
        $sql .= ") ORDER BY p.post_id DESC";
        $sql .= " LIMIT $counter";
        return $this->db->query($sql)->result();
    }

    function select_total_post($person_id) {
        $result = $this->get_linked_person_id($person_id);
        $sql = "SELECT count(p.post_id) AS total_post
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE 
                    p.posted_by = pr.person_id
                AND pr.url_id = u.url_id
                AND p.post_status = '1'
                AND (p.post_publication_status = '1' 
                OR p.post_publication_status = '2'";
        if ($result) {
            $sql .= " OR (p.post_publication_status = '3' AND p.posted_by IN (" . $result . "))";
        } else {
            $sql .= " OR (p.post_publication_status = '3' AND p.posted_by = '$person_id')";
        }
        $sql .= " OR (p.post_publication_status = '4' AND '$person_id' IN (SELECT gm.person_id 
                FROM 
                    tbl_post_group AS pg,
                    tbl_group_member gm
                WHERE 
                    pg.post_id = p.post_id
                AND pg.group_id = gm.group_id
                AND gm.group_member_status = '1'))";
        $sql .= ") ORDER BY p.post_id DESC";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_linked_person_id 
     * @Used IN             : @function-'select_total_post'   this[@Model]
     * @Description         : get all linked person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-04-2016 09:55 AM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function get_linked_person_id($person_id) {
        $link_array = array();
        $my_link = $this->get_all_link_by_person_id($person_id);
        if ($my_link) {
            foreach ($my_link as $link_value) {
                $link_array[] = $link_value->person_id;
                $link_array[] = $link_value->requested_person_id;
            }
        }
        $link_array1 = array_unique($link_array);
        return implode(",", $link_array1);
    }

    function select_approved_group_by_person_id($person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_group_member AS gm,
                    tbl_group AS g
                WHERE 
                    gm.person_id = '$person_id'
                AND g.group_id = gm.group_id
                AND g.group_status = '1'
                AND gm.group_member_status = '1'";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_post_by_post_id 
     * @Used IN             : @function-'view_note_alert'       profile[@controller]
     * @Description         : get all grouped per song using post ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 05-06-2016 01:09 PM
     * @Parameter           : $post_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_all_grouped_person_by_post_id($post_id) {
        $sql = "SELECT GROUP_CONCAT(DISTINCT(gm.person_id))  AS grouped_person_id
                FROM 
                    tbl_post_group AS pg,
                    tbl_group_member gm
                WHERE 
                    pg.post_id = '$post_id'
                AND pg.group_id = gm.group_id
                AND gm.group_member_status = '1'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_post_by_post_id 
     * @Used IN             : @function-'delete_post_comment'       post[@controller],
     * @                    : @function-'view_comment_details'      post[@controller],
     * @                    : @function-'add_comment_reply_like'    post[@controller],
     * @                    : @function-'view_note_alert'           profile[@controller],
     * @Description         : get post information by post ID 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-06-2016 03:08 PM
     * @Parameter           : $post_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function select_post_by_post_id($post_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u 
                WHERE 
                    p.post_id = '$post_id'
                    AND p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_post_by_post_id 
     * @Used IN             : @function-'edit_post'       profile[@controller]
     * @Description         : select post coment URL
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : UNknown
     * @Parameter           : $post_id[INTEGER]
     * @Return              : $post_or_comment_id[INTEGER],$type[INTEGER]    
     * @Status              : Available       
     * */
    function select_post_comment_url($post_or_comment_id, $type) {
        $sql = "SELECT * 
                FROM 
                    tbl_post_comment_url
                WHERE 
                    post_or_comment_id = '$post_or_comment_id'
                AND post_comment_url_type = '$type'";
        return $this->db->query($sql)->row();
    }

    function get_group_member_id($post_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_post_group AS pg,
                    tbl_group_member gm
                WHERE 
                    pg.post_id = '$post_id'
                AND pg.group_id = gm.group_id
                AND gm.group_member_status = '1'";
        return $this->db->query($sql)->result();
    }

    function get_all_link_by_person_id($person_id) {
        $sql = "SELECT * 
              FROM 
                 tbl_person_link as pl
                 WHERE 
                         (pl.person_id = '$person_id'
                     OR pl.requested_person_id = '$person_id')
                     AND (pl.add_link_request_status = 1 )
                 GROUP BY pl.person_link_id";
        return $this->db->query($sql)->result();
    }

    function get_last_post_id() {
        $sql = "SELECT 
                    post_id 
                FROM 
                    tbl_post
                ORDER BY post_id DESC
                LIMIT 1";
        return $this->db->query($sql)->row();
    }

    function check_post_status($person_id, $recent_post_id) {
        $new_post_id = '';
        $post_value = $this->get_single_post_by_post_id($recent_post_id);
        if ($post_value->post_publication_status == 1 || $post_value->post_publication_status == 2) {
            $new_post_id = $post_value->post_id;
        } else if ($post_value->post_publication_status == 3) {
            $link_array = $this->get_link_array($person_id);
            if (in_array($post_value->posted_by, $link_array)) {
                $new_post_id = $post_value->post_id;
            }
        } else if ($post_value->post_publication_status == 4) {
            $group_array = $this->get_group_array($recent_post_id);
            if (in_array($person_id, $group_array)) {
                $new_post_id = $post_value->post_id;
            }
        }
        return $new_post_id;
    }

    function get_post_compared_id($post_id, $recent_post_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_post
                WHERE 
                    (post_id BETWEEN '$post_id' AND '$recent_post_id')
                AND post_id != '$post_id'";
        return $this->db->query($sql)->result();
    }

    function get_link_array($person_id) {
        $link_array = array();
        $my_link = $this->get_all_link_by_person_id($person_id);
        foreach ($my_link as $link_value) {
            $link_array[] = $link_value->person_id;
            $link_array[] = $link_value->requested_person_id;
        }
        $fliped_link_array = array_flip($link_array);
        unset($fliped_link_array[$person_id]);
        return array_flip($fliped_link_array);
    }

    function get_group_array($post_id) {
        $group_person_array = array();
        $group_member = $this->get_group_member_id($post_id);
        foreach ($group_member as $group_person_id) {
            $group_person_array[] = $group_person_id->person_id;
        }
        return array_unique($group_person_array);
    }

    function save_note($person_id) {
        $this->tt_post->set_filter_input_data($this->input->post('post_details', FALSE));
        $data['post_details'] = $this->tt_post->get_filter_input_data();
        $data['posted_by'] = $person_id;
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', time());
        $data['post_type'] = $this->input->post('post_type', TRUE);
        $data['post_status'] = 1;
        $data['post_file_original_name'] = '';

        $this->db->insert('tbl_post', $data);
        $post_id = $this->db->insert_id();
//
        if ($data['post_publication_status'] == 4) {
            $selected_group = $this->input->post('selected_group', TRUE);
            $selected_group_array = explode(",", $selected_group);
            for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                $sql = "INSERT INTO tbl_post_group(post_id, group_id)"
                        . "VALUES('$post_id', '$selected_group_array[$i]')";
                $this->db->query($sql);
            }
            //....................save notification by afrin jahan noumin...........
            $this->notification_model->save_post_notification_for_group_post($selected_group_array, $post_id, 'a note', 'added');
        } else if ($data['post_publication_status'] == 3) {
            $this->notification_model->save_notification_for_link_post($post_id, 'a note', 'added');
        }
        //.................... end save notification by afrin jahan noumin...........

        $post_url_info = $this->input->post('post_url_info', TRUE);
        if ($post_url_info == 'null') {
            return;
        } else {
            $uData['post_or_comment_id'] = $post_id;
            $uData['post_comment_url_info'] = $post_url_info;
            $uData['post_comment_url_type'] = 1;
            $this->db->insert('tbl_post_comment_url', $uData);
        }
    }

    /**
     * @Function            : update_note_details 
     * @Used IN             : @function-'update_note'      post[@controller]
     * @Description         : Update note details  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-06-2016 12:34 PM
     * @Parameter           : $post_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_note_details($post_id) {
        $post_info = $this->get_single_post_by_post_id($post_id);
        if ($post_info->post_publication_status == 4) {
            $this->utility_model->delete_information_in_database('tbl_post_group', 'post_id', $post_id);
            //....................notification by afrin jahan noumin...........
//            $this->notification_model->update_notification_while_editing_group_post($post_info, 4);
            //....................notification by afrin jahan noumin...........
        } else if ($post_info->post_publication_status == 3) {
            //....................notification by afrin jahan noumin...........
//            $this->notification_model->update_notification_while_editing_group_post($post_info, 3);
            //....................notification by afrin jahan noumin...........
        }

        $this->tt_post->set_filter_input_data($this->input->post('post_details', FALSE));
        $post_data['post_details'] = $this->tt_post->get_filter_input_data();
        $post_data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $post_data['post_status'] = 1;
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $post_data);

        if ($post_data['post_publication_status'] == 4) {
            $this->update_group_post($post_id);
        } else if ($post_data['post_publication_status'] == 3) {
            $type = '';
            $post_info1 = $this->get_single_post_by_post_id($post_id);
            switch ($post_info1->post_type) {
                case 1:
                    $type = 'a note';
                    break;
                case 2:
                    $type = 'an alert';
                    break;
                case 3:
                    $type = 'an assaignment';
                    break;
                case 4:
                    $type = 'an image';
                    break;
                case 5:
                    $type = 'a video';
                    break;
            }
            $this->notification_model->save_notification_for_link_post($post_id, $type, 'updated');
        }

        $post_url_info = $this->input->post('post_url_info', TRUE);
        if ($post_url_info != 'null') {
            $uData['post_or_comment_id'] = $post_id;
            $uData['post_comment_url_info'] = $post_url_info;
            $uData['post_comment_url_type'] = 1;
            $this->db->insert('tbl_post_comment_url', $uData);
        }
    }

    /**
     * @Function            : update_group_post 
     * @Used IN             : @function-'update_note_details'      this[@Model]
     * @Description         : Update group post  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-06-2016 12:54 PM
     * @Parameter           : $post_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_group_post($post_id) {
        $selected_group = $this->input->post('selected_group', TRUE);
        $selected_group_array = array_filter(explode(",", $selected_group));

        for ($i = 0; $i < count($selected_group_array); $i++) {
            $group_data['post_id'] = $post_id;
            $group_data['group_id'] = $selected_group_array[$i];
            $this->db->insert('tbl_post_group', $group_data);
        }
        //....................save notification by afrin jahan noumin...........
        $post_info1 = $this->get_single_post_by_post_id($post_id);
        $type = '';
        switch ($post_info1->post_type) {
            case 1:
                $type = 'a note';
                break;
            case 2:
                $type = 'an alert';
                break;
            case 3:
                $type = 'an assaignment';
                break;
            case 4:
                $type = 'an image';
                break;
            case 5:
                $type = 'a video';
                break;
        }

        $this->notification_model->save_post_notification_for_group_post($selected_group_array, $post_id, $type, 'updated');
        //.................... end save notification by afrin jahan noumin...........
    }

    function get_single_note($post_id) {
        $sql = "SELECT *
                    FROM
                        tbl_post AS p,
                        tbl_person AS pr,
                        tbl_url AS u
                    WHERE
                        post_id = '$post_id'
                    AND p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id
                    AND p.post_status =  '1'";
        return $this->db->query($sql)->row();
    }

    function save_alert($person_id) {
        $this->tt_post->set_filter_input_data($this->input->post('post_details', FALSE));
        $data['post_details'] = $this->tt_post->get_filter_input_data();
        $data['posted_by'] = $person_id;
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', time());
        $data['post_type'] = $this->input->post('post_type', TRUE);
        $data['post_status'] = 1;
        $data['post_file_original_name'] = '';
        $this->db->insert('tbl_post', $data);
        $post_id = $this->db->insert_id();

        if ($data['post_publication_status'] == 4) {
            $selected_group = $this->input->post('selected_group', TRUE);
            $selected_group_array = explode(",", $selected_group);
            for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                $sql = "INSERT INTO tbl_post_group(post_id, group_id)"
                        . "VALUES('$post_id', '$selected_group_array[$i]')";
                $this->db->query($sql);
            }
            //....................save notification by afrin jahan noumin...........
            $this->notification_model->save_post_notification_for_group_post($selected_group_array, $post_id, 'an alert', 'added');

            //.................... end save notification by afrin jahan noumin...........
        } else if ($data['post_publication_status'] == 3) {
            $this->notification_model->save_notification_for_link_post($post_id, 'an alert', 'added');
        }

        $post_url_info = $this->input->post('post_url_info', TRUE);
        if ($post_url_info == 'null') {
            return;
        } else {
            $uData['post_or_comment_id'] = $post_id;
            $uData['post_comment_url_info'] = $post_url_info;
            $uData['post_comment_url_type'] = 1;
            $this->db->insert('tbl_post_comment_url', $uData);
        }
    }

    function save_upload_file($data) {
        $this->db->insert('tbl_post', $data);
        return $this->db->insert_id();
    }

    function delete_single_post_by_post_id($post_id) {
        $this->db->where('post_id', $post_id);
        $this->db->delete('tbl_post');
    }

    function save_assignment_file() {
        $post_id = $this->input->post('file_upload_id', TRUE);
//        
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', time());
        $data['post_status'] = 1;

        $this->db->where('post_id', $post_id);
        $this->db->update('tbl_post', $data);

        if ($data['post_publication_status'] == 4) {
            $selected_group = $this->input->post('selected_group', TRUE);
            $selected_group_array = explode(",", $selected_group);
            for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                $sql = "INSERT INTO tbl_post_group(post_id, group_id)"
                        . "VALUES('$post_id', '$selected_group_array[$i]')";
                $this->db->query($sql);
            }
            //....................save notification by afrin jahan noumin...........
            $this->notification_model->save_post_notification_for_group_post($selected_group_array, $post_id, 'an assignment', 'added');
        } else if ($data['post_publication_status'] == 3) {
            $this->notification_model->save_notification_for_link_post($post_id, 'an assignment', 'added');
        }
        //.................... end save notification by afrin jahan noumin...........
    }

    /**
     * @Function            : upload_edit_assignment 
     * @Used IN             : @function-'upload_edit_assignment'   post@controller
     * @Description         : upload edit assignment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 08:56 AM  
     * @Parameter           : $post_id[INTEGER], $profile_url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_edit_assignment($post_id, $profile_url) {
        $fileName = $_FILES["assignment_file"]["name"]; // The file name
        $fileTmpLoc = $_FILES["assignment_file"]["tmp_name"]; // File in the PHP tmp folder
        $fileSize = $_FILES["assignment_file"]["size"]; // File size in bytes
        $new_file_name = $profile_url . '-' . date('h-i-s-a-m-d-Y', time());
        $file_explode = explode('.', $fileName);
        $file_extention = $file_explode[count($file_explode) - 1];
        if (!$fileTmpLoc) { // if file not chosen
            echo "error_location";
        } else {
            if ($fileSize == 0) {
                echo 'error_size_zero';
            } else if ($fileSize > 52428800) {
                echo 'error_size';
            } else if ($this->check_assignment_file_type(strtolower($file_extention)) == 2) {
                echo 'error_type';
            } else {
                if ($post_id) {
                    $result = $this->get_single_post_by_post_id($post_id);
                    unlink('content-library/' . $profile_url . '/' . $result->post_details);
                }

                $folder = 'content-library/' . $profile_url . '/assignment-file/';
                $target_file = $folder . $fileName;
                if (move_uploaded_file($fileTmpLoc, $target_file)) {

                    rename("$target_file", "$folder$new_file_name.$file_extention");

                    $post_data['post_details'] = "assignment-file/$new_file_name.$file_extention";
                    $post_data['post_file_original_name'] = $fileName;
                    $post_data['post_status'] = 5;
                    $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $post_data);
                }
            }
        }
    }

    /**
     * @Function            : update_post_file_details 
     * @Used IN             : @function-'update_assignment'   post@controller
     * @Description         : update assignment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 10:12 AM  
     * @Parameter           : $post_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function update_post_file_details($post_id) {
        $post_info = $this->get_single_post_by_post_id($post_id);
        if ($post_info->post_publication_status == 4) {
            $this->utility_model->delete_information_in_database('tbl_post_group', 'post_id', $post_id);
//            $this->notification_model->update_notification_while_editing_group_post($post_info, 4); //notification by afrin jahan noumin
        } else if ($post_info->post_publication_status == 3) {//notification by afrin jahan noumin
//            $this->notification_model->update_notification_while_editing_group_post($post_info, 3); //notification by afrin jahan noumin
        }//notification by afrin jahan noumin

        $post_data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $post_data['post_status'] = 1;
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $post_data);

        if ($post_data['post_publication_status'] == 4) {
            $this->update_group_post($post_id);
        } else if ($post_data['post_publication_status'] == 3) {
            $type = '';
            $post_info1 = $this->get_single_post_by_post_id($post_id);
            switch ($post_info1->post_type) {
                case 1:
                    $type = 'a note';
                    break;
                case 2:
                    $type = 'an alert';
                    break;
                case 3:
                    $type = 'an assaignment';
                    break;
                case 4:
                    $type = 'an image';
                    break;
                case 5:
                    $type = 'a video';
                    break;
            }
            $this->notification_model->save_notification_for_link_post($post_id, $type, 'updated');
        }
    }

    /**
     * @Function            : check_file_type
     * @Used IN             : @function-'Self'    
     * @Description         : check valid file type
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 06-02-2016 12:20 PM     
     * @Status              : available      
     * */
    function check_assignment_file_type($fileType) {
        $allowedFileType = Array("zip", "rar", "pdf", "doc", "docx", "xls", "xlsx", "pptx", "ppt", "txt");
        if (in_array($fileType, $allowedFileType)) {
            return 1;
        } else {
            return 2;
        }
    }

    /**
     * @Function            : upload_post_image_video_file 
     * @Used IN             : @function-'upload_Image_vedio'   post[@controller]
     * @Description         : upload post image and video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-05-2016 02:59 PM
     * @Parameter           : NULL
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_post_image_video_file() {
        $user_id = $this->session->userdata('user_id');
        $profile_url = $this->post_model->get_profile_url($user_id);
        $post_type = $this->input->post('post_type', TRUE);
        $uploaded_imageVedio_id = $this->input->post('uploaded_imageVedio_id', TRUE);
        $new_file_name = $profile_url->url . '-' . date('h-i-s-a-m-d-Y', time());
        $file_name = $_FILES["imagevediofile"]["name"]; // The file name
        $file_temp_loc = $_FILES["imagevediofile"]["tmp_name"]; // File in the PHP tmp folder
        $file_size = $_FILES["imagevediofile"]["size"]; // File size in bytes
        switch ($post_type) {
            case 4:
                $this->upload_post_image_file($profile_url, $file_name, $new_file_name, $file_temp_loc, $file_size, $uploaded_imageVedio_id);
                break;
            case 5:
                $this->upload_post_video_file($profile_url, $file_name, $new_file_name, $file_temp_loc, $file_size, $uploaded_imageVedio_id);
                break;
        }
    }

    /**
     * @Function            : upload_post_image_file 
     * @Used IN             : @function-'upload_post_image_video_file'   this[@Model]
     * @Description         : upload post image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-05-2016 03:13 PM
     * @Parameter           : $profile_url, $file_name, $new_file_name, $file_temp_loc, $file_size, $uploaded_imageVedio_id
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_post_image_file($profile_url, $file_name, $new_file_name, $file_temp_loc, $file_size, $uploaded_imageVedio_id) {
        $image_allowance_type = Array('jpeg', 'gif', 'png', 'bmp', 'jpg');
        $file_explode = explode('.', $file_name);
        $file_extention = $file_explode[count($file_explode) - 1];

        if (in_array(strtolower($file_extention), $image_allowance_type)) {
            $check_image = getimagesize($file_temp_loc);
            if ($check_image) {
                if ($file_size < 2097152) {
                    if ($uploaded_imageVedio_id) {
                        $result = $this->get_single_post_by_post_id($uploaded_imageVedio_id);
                        unlink('content-library/' . $profile_url->url . '/' . $result->post_details);
                        $this->utility_model->delete_information_in_database('tbl_post', 'post_id', $uploaded_imageVedio_id);
                    }

                    $folder = 'content-library/' . $profile_url->url . '/my-image/' . 'post-image' . '/';
                    if (!is_dir($folder)) {
                        mkdir($folder, 0777, true);
                    }
                    $this->change_post_image_path($profile_url->url);

                    $target_file = $folder . $file_name;
                    if (move_uploaded_file($file_temp_loc, $target_file)) {
                        rename("$target_file", "$folder$new_file_name.$file_extention");

                        $data['posted_by'] = $this->session->userdata('user_id');
                        $data['post_details'] = "my-image/post-image/$new_file_name.$file_extention";
                        $data['post_date_time'] = date('Y/m/d H:i:s', time());
                        $data['post_file_original_name'] = $file_name;
                        $data['post_type'] = 4;
                        $data['post_status'] = 5;
                        echo $this->utility_model->save_information_in_database('tbl_post', $data);
                    }
                } else {
                    echo 'error';
                }
            } else {
                echo 'error';
            }
        } else {
            echo 'error';
        }
    }

    /**
     * @Function            : change_post_image_path 
     * @Used IN             : @function-'upload_post_image_video_file'   this[@Model]
     * @Description         : change post image path
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-06-2016 11:47 AM
     * @Parameter           : $person_url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function change_post_image_path($person_url) {
        $user_id = $this->session->userdata('user_id');
        $post_info = $this->select_all_post_value_by_person_id($user_id, 4);

        foreach ($post_info as $post_value) {
            $file_name = explode('/', $post_value->post_details);
            $source = 'content-library/' . $person_url . '/my-image/' . $file_name[1];

            if (is_file($source)) {
                $dest = 'content-library/' . $person_url . '/my-image/post-image/' . $file_name[1];
                $data['post_details'] = 'my-image/post-image/' . $file_name[1];
                $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_value->post_id, $data);
                copy($source, $dest);
                unlink($source);
            }
        }
    }

    /**
     * @Function            : select_all_post_value_by_person_id 
     * @Used IN             : @function-'change_post_image_path'   this[@Model]
     * @Description         : slect all post value using person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-06-2016 11:52 AM
     * @Parameter           : $user_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function select_all_post_value_by_person_id($user_id, $type) {
        $sql = "SELECT * FROM tbl_post AS p WHERE p.posted_by = '$user_id' AND p.post_type = '$type'";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : upload_edit_image 
     * @Used IN             : @function-'upload_edit_image_video'   post[@Controller]
     * @Description         : upload edit post image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 11:07 AM
     * @Parameter           : $post_id[INTEGER], $profile_url[STRING], $new_file_name[STRING], $file_name[STRING], $file_size[INTEGER], $file_temp_loc[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_edit_image($post_id, $profile_url, $new_file_name, $file_name, $file_size, $file_temp_loc) {
        $image_allowance_type = Array('jpeg', 'gif', 'png', 'bmp', 'jpg');
        $file_explode = explode('.', $file_name);
        $file_extention = $file_explode[count($file_explode) - 1];
        $check_image = getimagesize($file_temp_loc);

        if (!in_array(strtolower($file_extention), $image_allowance_type)) {
            echo 'error_type';
        } else if (!$check_image) {
            echo 'error_validation';
        } else if ($file_size == 0) {
            echo 'error_size_zero';
        } else if ($file_size > 2097152) {
            echo 'error_size_image';
        } else {
            if ($post_id) {
                $result = $this->get_single_post_by_post_id($post_id);
                unlink('content-library/' . $profile_url . '/' . $result->post_details);
            }

            $folder = 'content-library/' . $profile_url . '/my-image/' . 'post-image' . '/';
            if (!is_dir($folder)) {
                mkdir($folder, 0777, true);
            }
            $this->change_post_image_path($profile_url);

            $target_file = $folder . $file_name;
            if (move_uploaded_file($file_temp_loc, $target_file)) {
                rename("$target_file", "$folder$new_file_name.$file_extention");

                $post_data['post_details'] = "my-image/post-image/$new_file_name.$file_extention";
                $post_data['post_file_original_name'] = $file_name;
                $post_data['post_type'] = 4;
                $post_data['post_status'] = 5;
                $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $post_data);
            }
        }
    }

    /**
     * @Function            : upload_post_video_file 
     * @Used IN             : @function-'upload_post_image_video_file'   this[@Model]
     * @Description         : upload post image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 29-05-2016 03:55 PM
     * @Parameter           : $profile_url, $file_name, $new_file_name, $file_temp_loc, $file_size, $uploaded_imageVedio_id
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_post_video_file($profile_url, $file_name, $new_file_name, $file_temp_loc, $file_size, $uploaded_imageVedio_id) {
        $video_allowance_type = Array('mp4', 'flv', '3gp', 'avi', 'webm', 'wmv');
        $file_explode = explode('.', $file_name);
        $file_extention = $file_explode[count($file_explode) - 1];
        if (in_array(strtolower($file_extention), $video_allowance_type)) {
//            $check_video = $this->user_video_model->get_video_duration($file_temp_loc);
//            if ($check_video == 1) {
            if ($file_size < 600000000) {
                if ($uploaded_imageVedio_id) {
                    $result = $this->get_single_post_by_post_id($uploaded_imageVedio_id);
                    unlink('content-library/' . $profile_url->url . '/' . $result->post_details);
                    $this->utility_model->delete_information_in_database('tbl_post', 'post_id', $uploaded_imageVedio_id);
                }

                $folder = 'content-library/' . $profile_url->url . '/my-video/post-video/';
                if (!is_dir($folder)) {
                    mkdir($folder, 0755, true);
                }
                $this->change_post_video_path($profile_url->url);
                $target_file = $folder . $file_name;

                if (move_uploaded_file($file_temp_loc, $target_file)) {
                    $new_file_name = str_replace(' ', '-', $new_file_name);
                    $source_file = "$folder$new_file_name.$file_extention";

                    rename("$target_file", "$source_file");

                    $conversion_file_detail['file_name'] = "$new_file_name.$file_extention";
                    $conversion_file_detail['file_ext'] = ".$file_extention";
                    $conversion_file_detail['full_path'] = FCPATH . $source_file;
                    $conversion_file_detail['file_path'] = str_replace($conversion_file_detail['file_name'], '', $conversion_file_detail['full_path']);

                    $this->load->library('tt_video_converter');
                    $test_output = $this->tt_video_converter->set_file($conversion_file_detail)
                                    ->convert_video()->get_full_report();
                    
                    if (!isset($test_output['error_message']['conversion_error_720p'])) {                        
                        $data['posted_by'] = $this->session->userdata('user_id');
                        $data['post_details'] = "my-video/post-video/$new_file_name" . "_converted_720p.mp4";
                        $data['post_date_time'] = date('Y/m/d H:i:s', time());
                        $data['post_file_original_name'] = $file_name;
                        $data['post_type'] = 5;
                        $data['post_status'] = 5;
                        echo $this->utility_model->save_information_in_database('tbl_post', $data);
                    }else{
                        echo '<pre>';
                        print_r($test_output);
                        echo '</pre>';
                        echo 'error';
                    }
                }
            } else {
                echo 'error';
            }
//            } else {
//                echo 'error';
//            }
        } else {
            echo 'error';
        }
    }

    /**
     * @Function            : change_post_video_path 
     * @Used IN             : @function-'upload_post_video_file'   this[@Model]
     * @Description         : change post video path
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-06-2016 12:58 PM
     * @Parameter           : $person_url[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function change_post_video_path($person_url) {
        $user_id = $this->session->userdata('user_id');
        $post_info = $this->select_all_post_value_by_person_id($user_id, 5);

        foreach ($post_info as $post_value) {
            $file_name = explode('/', $post_value->post_details);
            $source = 'content-library/' . $person_url . '/my-video/' . $file_name[1];

            if (is_file($source)) {
                $dest = 'content-library/' . $person_url . '/my-video/post-video/' . $file_name[1];
                $data['post_details'] = 'my-video/post-video/' . $file_name[1];
                $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_value->post_id, $data);
                copy($source, $dest);
                unlink($source);
            }
        }
    }

    /**
     * @Function            : upload_edit_video 
     * @Used IN             : @function-'upload_edit_image_video'   post[@Controller]
     * @Description         : upload edit post video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 11:18 AM
     * @Parameter           : $post_id[INTEGER], $profile_url[STRING], $new_file_name[STRING], $file_name[STRING], $file_size[INTEGER], $file_temp_loc[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function upload_edit_video($post_id, $profile_url, $new_file_name, $file_name, $file_size, $file_temp_loc) {
        $video_allowance_type = Array('mp4', 'flv', '3gp', 'avi', 'webm', 'wmv');
        $file_explode = explode('.', $file_name);
        $file_extention = $file_explode[count($file_explode) - 1];

//        $check_video = $this->user_video_model->check_video_validation($file_temp_loc);
        if (!in_array(strtolower($file_extention), $video_allowance_type)) {
            echo 'error_type';
        } else if ($file_size == 0) {
            echo 'error_size_zero';
        }
//        else if ($check_video != 1) {
//            echo 'error_validation';
//        }
        else if ($file_size > 26214400) {
            echo 'error_size_video';
        } else {
            if ($post_id) {
                $result = $this->get_single_post_by_post_id($post_id);
                $path = FCPATH . 'content-library/' . $profile_url . '/' . $result->post_details;
                if (file_exists($path)) {
                    unlink('content-library/' . $profile_url . '/' . $result->post_details);
                }
            }

            $folder = 'content-library/' . $profile_url . '/my-video/post-video/';
            if (!is_dir($folder)) {
                mkdir($folder, 0777, true);
            }
            $this->change_post_video_path($profile_url);
            $target_file = $folder . $file_name;

            if (move_uploaded_file($file_temp_loc, $target_file)) {
                $new_file_name = str_replace(' ', '-', $new_file_name);
                $source_file = "$folder$new_file_name.$file_extention";

                rename("$target_file", "$source_file");

                $conversion_file_detail['file_name'] = "$new_file_name.$file_extention";
                $conversion_file_detail['file_ext'] = ".$file_extention";
                $conversion_file_detail['full_path'] = FCPATH . $source_file;
                $conversion_file_detail['file_path'] = str_replace($conversion_file_detail['file_name'], '', $conversion_file_detail['full_path']);

                $this->load->library('tt_video_converter');
                $test_output = $this->tt_video_converter->set_file($conversion_file_detail)
                                ->convert_video()->check_converted_video()->get_full_report();

                $post_data['post_details'] = "my-video/post-video/$new_file_name" . "_converted_720p.mp4";
                $post_data['post_file_original_name'] = $file_name;
                $post_data['post_type'] = 5;
                $post_data['post_status'] = 5;
                $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $post_data);
            }
        }
    }

    /**
     * @Function            : save_image_or_video_file 
     * @Used IN             : @function-'upload_edit_image_video'   post[@Controller]
     * @Description         : save image video
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-06-2016 11:18 AM
     * @Parameter           : Null
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_image_or_video_file() {
        $post_id = $this->input->post('file_upload_id', TRUE);
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $data['post_date_time'] = date('Y/m/d H:i:s', time());
        $data['post_status'] = 1;

        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $data);

        if ($data['post_publication_status'] == 4) {
            $selected_group = $this->input->post('selected_group', TRUE);
            $selected_group_array = explode(",", $selected_group);
            for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                $sql = "INSERT INTO tbl_post_group(post_id, group_id)"
                        . "VALUES('$post_id', '$selected_group_array[$i]')";
                $this->db->query($sql);
            }
            //....................save notification by afrin jahan noumin...........
            $this->notification_model->save_post_notification_for_group_post($selected_group_array, $post_id, 'an image/video', 'added');
        } else if ($data['post_publication_status'] == 3) {
            $this->notification_model->save_notification_for_link_post($post_id, 'an image/video', 'added');
        }
        //.................... end save notification by afrin jahan noumin...........
    }

    function get_profile_url($person_id) {
        $sql = "SELECT 
                    url
                FROM
                    tbl_person AS p,
                     tbl_url AS u
                WHERE
                    u.url_id = p.url_id
                AND p.person_id = '$person_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_person_post_details_by_person_id 
     * @Used IN             : @function-'get_person_all_image_data_by_person_id'   post_model[@Model]
     * @Description         : get perso post details
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-06-2016 02:28 PM
     * @Updated By          : Md Mashqur Ul Alam [14-01-17]
     * @Parameter           : $person_id[INTEGER], $type[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_person_post_details_by_person_id($person_id, $type) {
        $result = $this->db->select('*')->from('tbl_post')->where('posted_by', $person_id)
                        ->where('post_type', $type)->where('post_status', 1)->group_by('post_type')
                        ->get()->result();
        return $result;
    }

    //---------------------------------- End Front End Deshboard Post----------------------------- 
    //
    //
    //---------------------------Start Like , Comments & Add to Libraary-----------------
    /**
     * @Function            : get_all_postlike_person_info 
     * @Used IN             : @function-'index'                     Welcome[@controller],
     * @                    : @function-'add_comment_reply_like'    post[@controller],
     * @                    : @function-'view_comment_details'      post[@controller],
     * @Description         : get all available course using category ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-02-2016 01:38 PM
     * @Parameter           : $all_person_id[STRING]
     * @Return              : person_info[ARRAY]    
     * @Status              : Available       
     * */
    function get_all_post_liked_person_info($person_id, $all_link, $all_person_id) {
        $all_link_unique = array_unique($all_link);
        $sql = "SELECT * 
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    p.person_id IN ($all_person_id)
                    AND p.url_id = u.url_id
                    AND u.url_type = '10'
                    ORDER BY p.person_id = '$person_id' DESC";
        if ($all_link_unique) {
            $all_link1 = implode(',', $all_link_unique);
            $sql .= ", p.person_id IN ($all_link1) DESC";
        }
        return $this->db->query($sql)->result();
    }

    function save_like($post_id, $person_id) {
        $result = $this->get_post_value_by_post_id($post_id);
        if ($result) {
            if ($result->post_like_by == '') {
                $data['post_like_by'] = $person_id;
                $this->utility_model->update_information_in_database('tbl_post_functions', 'post_id', $post_id, $data);
            } else {
                $post_like_by = $result->post_like_by . ',' . $person_id;
                $data['post_like_by'] = implode(',', array_unique(array_filter(explode(',', $post_like_by))));
                $this->utility_model->update_information_in_database('tbl_post_functions', 'post_id', $post_id, $data);
            }
        } else {
            $data['post_id'] = $post_id;
            $data['post_like_by'] = $person_id;
            $this->db->insert('tbl_post_functions', $data);
        }
    }

    function remove_like($post_id, $person_id) {
        $result = $this->get_post_value_by_post_id($post_id);
        $liked_array = explode(",", $result->post_like_by);
        $fliped_liked_array = array_flip($liked_array);
        unset($fliped_liked_array[$person_id]);
        $final_array = array_flip($fliped_liked_array);
        $data['post_like_by'] = implode(',', array_unique(array_filter($final_array)));
        $this->utility_model->update_information_in_database('tbl_post_functions', 'post_id', $post_id, $data);
    }

    function get_post_value_by_post_id($post_id) {
        $sql = "SELECT *
                FROM
                    tbl_post AS p,
                    tbl_post_functions AS pf
                WHERE
                    p.post_id = '$post_id'
                AND p.post_id = pf.post_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_post_counter_by_post_id 
     * @Used IN             : @function-'save_post_write'             this[@Model]
     * @                    : @function-'save_reply_comment_write'    this[@Model]
     * @Description         : get post counter by post ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-06-2016 04:41 PM  
     * @Parameter           : $post_id[INTEGER]
     * @Return              : $comment_info[ARRAY]    
     * @Status              : Available        
     * */
    function get_post_counter_by_post_id($post_id) {
        $sql = "SELECT post_comment_count FROM tbl_post WHERE post_id = '$post_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_post_comment_by_post_id 
     * @Used IN             : @function-'save_post_write'    this[@Model]
     * @Description         : get post comment by post ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 02-06-2016 04:33 AM  
     * @Parameter           : $post_id[INTEGER], $person_id[INTEGER]
     * @Return              : $comment_info[ARRAY]    
     * @Status              : Available        
     * */
    function get_post_comment_by_post_id($post_id) {
        $sql = "SELECT * FROM tbl_comment WHERE post_id = '$post_id'";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : save_post_write 
     * @Used IN             : @function-'save_post_write'    post[@controller]
     * @Description         : save post wite
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-04-2016 09:55 AM  
     * @Updated Date Time   : 02-02-2016 01:38 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $post_id[INTEGER], $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available        
     * */
    function save_post_write($post_id, $person_id) {
        $result = $this->get_post_comment_by_post_id($post_id);
        if (!$result) {
            $data['post_comment_count'] = 1;
        } else {
            $counter_result = $this->get_post_counter_by_post_id($post_id);
            $data['post_comment_count'] = ++$counter_result->post_comment_count;
        }
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_id, $data);

        //-------------------save comment----------------------
        $this->tt_post->set_filter_input_data($this->input->post('post_comment_details', FALSE));
        $comment_data['comment_details'] = $this->tt_post->get_filter_input_data();
        $comment_data['post_id'] = $post_id;
        $comment_data['comment_reply_by'] = $person_id;
        $comment_data['comment_date_time'] = date('Y/m/d H:i:s', time());
        $comment_data['comment_status'] = 1;
        $comment_id = $this->utility_model->save_information_in_database('tbl_comment', $comment_data);

        if ($this->input->post('post_url_info', TRUE) != 'null') {
            $uData['post_or_comment_id'] = $comment_id;
            $uData['post_comment_url_info'] = $this->input->post('post_url_info', TRUE);
            $uData['post_comment_url_type'] = 2;
            $this->db->insert('tbl_post_comment_url', $uData);
        }
    }

    function get_limit_post_comment_by_post_id($post_id, $counter = NULL) {
        $sql = "SELECT *
                FROM
                    tbl_comment AS c,
                    tbl_person AS p,
                     tbl_url AS u
                WHERE
                    c.comment_parent_id = '$post_id'
                AND c.comment_reply_by = p.person_id
                AND p.url_id = u.url_id
                AND c.comment_status = '1'
                    ORDER BY comment_id DESC";
        if ($counter != NULL) {
            $sql .= " LIMIT $counter";
        } else {
            $sql .= " LIMIT 3";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_post_first_comment_by_post_id 
     * @Used IN             : @function-'view_comment_details'   post[@Controller]
     * @Description         : get first priority comment by post ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-04-2016 09:55 AM  
     * @Parameter           : $post_id[INTEGER]
     * @Return              : $total_comment[INTEGER]    
     * @Status              : Available        
     * */
    function get_post_first_comment_by_post_id($post_id, $counter = NULL) {
        $sql = "SELECT *
                FROM
                    tbl_comment AS c,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    c.post_id = '$post_id'
                AND c.comment_reply_by = p.person_id
                AND p.url_id = u.url_id
                AND c.comment_status = '1'
                    ORDER BY comment_id DESC";
        if ($counter != NULL) {
            $sql .= " LIMIT $counter";
        } else {
            $sql .= " LIMIT 3";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_first_comment_by_post_id 
     * @Used IN             : @function-'view_comment_details'   post[@Controller]
     * @Description         : get total comment by post ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 03-04-2016 09:55 AM  
     * @Parameter           : $post_id[INTEGER]
     * @Return              : $total_comment[INTEGER]    
     * @Status              : Available        
     * */
    function get_total_first_comment_by_post_id($post_id) {
        $sql = "SELECT count(post_id) AS total_comment
                FROM
                    tbl_comment
                WHERE
                    post_id = '$post_id'
                    AND comment_status = '1'";
        return $this->db->query($sql)->row();
    }

    function get_total_comment_by_post_id($post_id) {
        $sql = "SELECT count(comment_parent_id) AS total_comment
                FROM
                    tbl_comment
                WHERE
                    comment_parent_id = '$post_id'
                    AND comment_status = '1'";
        return $this->db->query($sql)->row();
    }

    function add_to_library($post_id, $person_id) {
        $result = $this->get_post_value_by_post_id($post_id);
        if ($result) {
            if ($result->post_add_to_my_library_by == '') {
                $data['post_add_to_my_library_by'] = $person_id;
                $this->utility_model->update_information_in_database('tbl_post_functions', 'post_id', $post_id, $data);
            } else {
                $post_add_to_my_library_by = $result->post_add_to_my_library_by . ',' . $person_id;
                $data['post_add_to_my_library_by'] = implode(',', array_unique(array_filter(explode(',', $post_add_to_my_library_by))));
                $this->utility_model->update_information_in_database('tbl_post_functions', 'post_id', $post_id, $data);
            }
        } else {
            $data['post_id'] = $post_id;
            $data['post_add_to_my_library_by'] = $person_id;
            $this->db->insert('tbl_post_functions', $data);
        }
    }

    function remove_to_library($post_id, $person_id) {
        $result = $this->get_post_value_by_post_id($post_id);
        $library_array = explode(",", $result->post_add_to_my_library_by);
        $fliped_library_array = array_flip($library_array);
        unset($fliped_library_array[$person_id]);

        $final_array = array_flip($fliped_library_array);
        $data['post_add_to_my_library_by'] = implode(',', array_unique(array_filter($final_array)));
        $this->utility_model->update_information_in_database('tbl_post_functions', 'post_id', $post_id, $data);
    }

    //---------------------------END Like , Comments & Add to Libraary-----------------
    //---------------------------Start Replay Like , Comments-----------------

    /**
     * @Function            : save_comment_like 
     * @Used IN             : @function-'add_comment_like'          post[@controller],
     * @                    : @function-'add_comment_reply_like'    post[@controller],
     * @Description         : Save comment like  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-06-2016 05:10 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_comment_like($comment_id, $person_id) {
        $result = $this->get_single_post_comment_value($comment_id);
        if ($result) {
            if ($result->comment_like_by == '') {
                $data['comment_like_by'] = $person_id;
                $this->utility_model->update_information_in_database('tbl_comment', 'comment_id', $comment_id, $data);
            } else {
                $comment_like_by = $result->comment_like_by . ',' . $person_id;
                $data['comment_like_by'] = implode(',', array_unique(array_filter(explode(',', $comment_like_by))));
                $this->utility_model->update_information_in_database('tbl_comment', 'comment_id', $comment_id, $data);
            }
        }
    }

    /**
     * @Function            : save_comment_like 
     * @Used IN             : @function-'add_comment_like'          post[@controller],
     * @                    : @function-'add_comment_reply_like'    post[@controller],
     * @Description         : Save comment like  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-06-2016 05:14 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function remove_comment_like($comment_id, $person_id) {
        $result = $this->get_single_post_comment_value($comment_id);
        $post_comment_array = explode(",", $result->comment_like_by);
        $fliped_post_comment_array = array_flip($post_comment_array);
        unset($fliped_post_comment_array[$person_id]);

        $final_array = array_flip($fliped_post_comment_array);
        $data['comment_like_by'] = implode(',', array_unique(array_filter($final_array)));
        $this->utility_model->update_information_in_database('tbl_comment', 'comment_id', $comment_id, $data);
    }

    /**
     * @Function            : get_single_post_comment_value 
     * @Used IN             : @function-'get_course_value'          post[@controller],
     * @                    : @function-'add_comment_reply_like'    post[@controller],
     * @                    : @function-'view_more_reply'           post[@controller],
     * @Description         : get single comment value with related inforrmation using comment_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown  
     * @Parameter           : $comment_id[INTEGER]
     * @Return              : comment_data[Array]    
     * @Status              : Available        
     * */
    function get_single_post_comment_value($comment_id) {
        $sql = "SELECT *
                FROM 
                    tbl_comment AS c,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    comment_id = '$comment_id'
                    AND c.comment_reply_by = p.person_id
                    AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : save_reply_comment_write 
     * @Used IN             : @function-'save_reply_comment_write'  post[@controller],
     * @Description         : save reply comment
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 04-06-2016 01:05 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_reply_comment_write($comment_id, $person_id) {
        $post_result = $this->get_post_id($comment_id);
        $result = $this->get_post_comment_by_post_id($post_result->post_id);
        if (!$result) {
            $pData['post_comment_count'] = 1;
        } else {
            $counter_result = $this->get_post_counter_by_post_id($post_result->post_id);
            $pData['post_comment_count'] = ++$counter_result->post_comment_count;
        }
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_result->post_id, $pData);

        $data['post_id'] = 0;
        $data['comment_parent_id'] = $comment_id;
        $this->tt_post->set_filter_input_data($this->input->post('comment_replay_details', FALSE));
        $data['comment_details'] = $this->tt_post->get_filter_input_data();
        $data['comment_reply_by'] = $person_id;
        $data['comment_date_time'] = date('Y/m/d H:i:s', time());
        $data['comment_status'] = 1;
        $reply_comment_id = $this->utility_model->save_information_in_database('tbl_comment', $data);

        if ($this->input->post('post_url_info', TRUE) != 'null') {
            $uData['post_or_comment_id'] = $reply_comment_id;
            $uData['post_comment_url_info'] = $this->input->post('post_url_info', TRUE);
            $uData['post_comment_url_type'] = 2;
            $this->db->insert('tbl_post_comment_url', $uData);
        }
    }

    /**
     * @Function            : get_post_id 
     * @Used IN             : @function-'save_reply_comment_write'  this[@Model]
     * @Description         : get post id by comment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 04-06-2016 01:05 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function get_post_id($comment_id) {
        $sql = "SELECT post_id FROM tbl_comment WHERE comment_id = '$comment_id'";
        return $this->db->query($sql)->row();
    }

    function get_post_comment_replay_limit_post_comment_id($comment_id, $counter = NULL) {
        $sql = "SELECT * 
                FROM 
                    tbl_comment AS c,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    c.comment_parent_id = '$comment_id'
                    AND c.comment_reply_by = p.person_id
                    AND p.url_id = u.url_id
                    AND c.comment_status = '1' 
                    ORDER BY comment_id DESC";
        if ($counter != NULL) {
            $sql .= " LIMIT $counter";
        } else {
            $sql .= " LIMIT 1";
        }
        return $this->db->query($sql)->result();
    }

    function get_post_comment_replay_comment_id($comment_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_comment AS c,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    c.comment_parent_id = '$comment_id'
                    AND c.comment_reply_by = p.person_id
                    AND p.url_id = u.url_id
                    AND c.comment_status = '1' 
                    ORDER BY comment_id DESC";
        return $this->db->query($sql)->result();
    }

    function get_total_comment_by_comment_id($comment_id) {
        $sql = "SELECT count(comment_id) AS total_comment
                FROM 
                    tbl_comment
                WHERE 
                comment_parent_id = '$comment_id'
                AND comment_status = '1'";
        return $this->db->query($sql)->row();
    }

    //---------------------------End Replay Like , Comments-----------------

    function get_post_details($id, $type) {
        if ($type == 'post') {
            $sql = "SELECT post_details FROM tbl_post WHERE post_id = '$id'";
            $result = $this->db->query($sql)->row();
            return $result->post_details;
        } elseif ($type == 'comment') {
            $sql = "SELECT comment_details FROM tbl_comment WHERE comment_id = '$id'";
            $result = $this->db->query($sql)->row();
            return $result->comment_details;
        } elseif ($type == 'reply') {
            $sql = "SELECT comment_details FROM tbl_comment WHERE comment_id = '$id'";
            $result = $this->db->query($sql)->row();
            return $result->comment_details;
        }
    }

    //------------------------Start Nested Reply----------------------------

    /**
     * @Function            : get_post_id_for_nested_comment 
     * @Used IN             : @function-'add_comment_reply_like'       post[@controller],
     * @                    : @function-'delete_comment_reply'         post[@controller],
     * @                    : @function-'save_nested_reply'            this[@Model],
     * @                    : @function-'save_nested_reply'            this[@Model],
     * @Description         : get post ID using any comment id or nested coomment ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Parameter           : $comment_id[INTEGER]
     * @Return              : $comment_value[ARRAY]    
     * @Status              : Available       
     * */
    function get_post_id_for_nested_comment($comment_id) {
        $sql = "SELECT *
                FROM 
                    tbl_comment
                WHERE 
                    comment_id = '$comment_id'";
        $result = $this->db->query($sql)->row();

        while ($result->post_id == 0) {
            $result = $this->get_post_id_for_nested_comment($result->comment_parent_id);
            if ($result->post_id != 0) {
                break;
            }
        }
        return $result;
    }

    /**
     * @Function            : save_nested_reply 
     * @Used IN             : @function-'save_nested_reply'     post[@controller],
     * @Description         : save nested reply 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 04-06-2016 02:$8 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $comment_id[INTEGER], $person_id[INTEGER]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function save_nested_reply($comment_id, $person_id) {
        $post_result = $this->get_post_id_for_nested_comment($comment_id);
        $result = $this->get_post_comment_by_post_id($post_result->post_id);
        if (!$result) {
            $pData['post_comment_count'] = 1;
        } else {
            $counter_result = $this->get_post_counter_by_post_id($post_result->post_id);
            $pData['post_comment_count'] = ++$counter_result->post_comment_count;
        }
        $this->utility_model->update_information_in_database('tbl_post', 'post_id', $post_result->post_id, $pData);


        $data['post_id'] = 0;
        $data['comment_parent_id'] = $comment_id;
        $this->tt_post->set_filter_input_data($this->input->post('nested_comment_details', FALSE));
        $data['comment_details'] = $this->tt_post->get_filter_input_data();
        $data['comment_reply_by'] = $person_id;
        $data['comment_date_time'] = date('Y/m/d H:i:s', time());
        $data['comment_status'] = 1;
        $nested_reply_id = $this->utility_model->save_information_in_database('tbl_comment', $data);

        if ($this->input->post('post_url_info', TRUE) != 'null') {
            $uData['post_or_comment_id'] = $nested_reply_id;
            $uData['post_comment_url_info'] = $this->input->post('post_url_info', TRUE);
            $uData['post_comment_url_type'] = 2;
            $this->db->insert('tbl_post_comment_url', $uData);
        }
    }

    /**
     * @Function            : get_all_child_comment_id 
     * @Used IN             : @function-'delete_post_comment'     post[@controller],
     * @                    : @function-'delete_comment_reply'    post[@controller],
     * @Description         : get all comment child ID 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-06-2016 01:03 PM
     * @Parameter           : $comment_id
     * @Return              : NULL    
     * @Status              : Available       
     * */
    public $comment_id_array = Array();

    function get_all_child_comment_id($comment_id) {
        $sql = "SELECT * 
                FROM tbl_comment AS cm
                WHERE 
                    cm.comment_parent_id = '$comment_id'";
        $result = $this->db->query($sql)->result();
        foreach ($result as $value) {
            $this->comment_id_array[] = $value->comment_id;
            $this->get_all_child_comment_id($value->comment_id);
        }
        return $this->comment_id_array;
    }

    /**
     * @Function            : delete_post_comment 
     * @Used IN             : @function-'delete_post_comment'     post[@controller],
     * @                    : @function-'delete_comment_reply'    post[@controller],
     * @Description         : delete post comment  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-06-2016 02:44 PM
     * @Parameter           : $all_comment_id[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function delete_post_comment($all_comment_id) {
        $sql = "DELETE c
                FROM 
                    tbl_comment AS c
                WHERE c.comment_id IN ($all_comment_id)";
        $this->db->query($sql);
    }

    /**
     * @Function            : delete_post_comment 
     * @Used IN             : @function-'delete_post_comment'     post[@controller],
     * @                    : @function-'delete_comment_reply'    post[@controller],
     * @Description         : delete post comment  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 01-06-2016 02:44 PM
     * @Parameter           : $all_comment_id[STRING]
     * @Return              : NULL    
     * @Status              : Available       
     * */
    function delete_post_comment_url($all_comment_id, $type) {
        $sql = "DELETE pcu  
                FROM 
                    tbl_post_comment_url AS pcu
                WHERE 
                    pcu.post_or_comment_id IN ($all_comment_id)
                AND pcu.post_comment_url_type = '$type'";
        $this->db->query($sql);
    }

    //------------------------END Nested Reply----------------------------
    //
    //
    //
    //------------------------Start Profile view (alert/Note) Sction for POST----------------------------

    function select_all_note_alert_by_person_id($person_id, $number) {
        $sql = "SELECT * 
                FROM 
                    tbl_post 
                WHERE 
                    posted_by = '$person_id'
                AND (post_type = '1' OR post_type = '2')
                AND post_status != '4'
                ORDER BY post_id DESC 
                LIMIT $number,10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_all_post_url_value_by_post_id 
     * @Used IN             : @function-'my_note_alert'          profile[@controller],
     * @                    : @function-'delete_post_comment'    post[@controller],
     * @                    : @function-'delete_comment_reply'   post[@controller],
     * @Description         : get post or comment url by post or comment ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : UNknown
     * @Updated Date Time   : 01-06-2016 06:20 PM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $post_comment_id[INTEGER], $type[INTEGER]
     * @Return              : post_value[ARRAY]    
     * @Status              : Available       
     * */
    function select_all_post_url_value_by_post_id($post_comment_id, $type) {
        $sql = "SELECT * 
                FROM 
                    tbl_post_comment_url AS pc
                WHERE 
                    pc.post_or_comment_id IN ($post_comment_id)
                AND pc.post_comment_url_type = '$type'";
        return $this->db->query($sql)->result();
    }

    function total_note_alert_by_person_id($person_id) {
        $sql = "SELECT 
                    count(post_id) AS total_note_alert
                FROM 
                    tbl_post 
                WHERE 
                    posted_by = '$person_id'
                    AND (post_type = '1' OR post_type = '2')
                    AND post_status != '4'";
        return $this->db->query($sql)->row();
    }

    function change_post_status($post_id, $status) {
        if ($status == 'inactive') {
            $this->db->set('post_status', 2);
        } elseif ($status == 'active') {
            $this->db->set('post_status', 1);
        } elseif ($status == 'delete') {
            $this->db->set('post_status', 4);
        }
        $this->db->where('post_id', $post_id);
        $this->db->update('tbl_post');
    }

    function get_single_post_by_post_id($post_id) {
        $sql = "SELECT * FROM tbl_post WHERE post_id = '$post_id'";
        return $this->db->query($sql)->row();
    }

    function get_all_selected_group($post_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_post_group AS pg,
                    tbl_group AS g 
                WHERE 
                    pg.post_id = '$post_id'
                    AND pg.group_id = g.group_id";
        return $this->db->query($sql)->result();
    }

    function update_note_alert($post_id) {
        $data['post_details'] = $this->input->post('post_details', TRUE);
        $data['post_publication_status'] = $this->input->post('post_publication_status', TRUE);
        $previous_group = $this->input->post('previous_group', TRUE);
        $this->db->where('post_id', $post_id);
        $this->db->update('tbl_post', $data);

        if ($previous_group == 4) {
            $this->db->where('post_id', $post_id);
            $this->db->delete('tbl_post_group');
        }

        if ($data['post_publication_status'] == 4) {
            $selected_group = $this->input->post('selected_group', TRUE);
            $selected_group_array = explode(",", $selected_group);
            $this->db->where('post_id', $post_id);
            $this->db->delete('tbl_post_group');
            for ($i = 0; $i < count($selected_group_array) - 1; $i++) {
                $sql = "INSERT INTO tbl_post_group(post_id, group_id)"
                        . "VALUES('$post_id', '$selected_group_array[$i]')";
                $this->db->query($sql);
            }
        }
    }

//------------------------End Profile view (alert/Note) Sction for POST----------------------------
//
//
//
//------------------------Start Profile view (My Content Library) Sction for POST----------------------------
    function select_my_note_alert_by_person_id($person_id, $number) {
        $result = $this->get_other_content_library_selected_by_person_id($person_id);
        if ($result) {
            $post_id_array = array();
            foreach ($result as $value) {
                $post_id_array[] = $value->post_id;
            }
            $post_id = implode(',', $post_id_array);
            return $this->get_note_alert_query($person_id, $number, $post_id);
        } else {
            return $this->get_note_alert_query($person_id, $number);
        }
    }

    function get_note_alert_query($person_id, $number, $post_id = NULL) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id
                    AND (posted_by = '$person_id'
                    AND (p.post_type IN (1,2))";
        if ($post_id != NULL) {
            $sql .= " OR (post_id IN ($post_id)))
                AND p.post_type IN (1,2)
                AND (post_status != 4)
                ORDER BY post_id DESC 
                LIMIT 10 OFFSET $number";
        } else {
            $sql .= ") AND (post_status != '4')
                ORDER BY post_id DESC 
               LIMIT 10 OFFSET $number";
        }
        return $this->db->query($sql)->result();
    }

    function total_my_note_alert_by_person_id($person_id) {
        $result = $this->get_other_content_library_selected_by_person_id($person_id);
        if ($result) {
            $post_id_array = array();
            foreach ($result as $value) {
                $post_id_array[] = $value->post_id;
            }
            $post_id = implode(',', $post_id_array);
            return $this->get_total_note_alert_query($person_id, $post_id);
        } else {
            return $this->get_total_note_alert_query($person_id);
        }
    }

    function get_total_note_alert_query($person_id, $post_id = NULL) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id
                    AND (posted_by = '$person_id'
                    AND (p.post_type IN (1,2))";
        if ($post_id != NULL) {
            $sql .= " OR (post_id IN ($post_id)))
                AND p.post_type IN (1,2)
                AND (post_status != 4)ORDER BY post_id DESC 
                ";
        } else {
            $sql .= ") AND (post_status != '4')
                ORDER BY post_id DESC";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : my_content_library 
     * @Used IN             : @self
     * @Description         : view content library if user post or add to content library
     * @                    : @Update1 - check if user can add other content library
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 26-02-2016 12:07 AM
     * @Updated By          : Ripon Jaherul
     * @Status              : available      
     * */
    function select_my_content_library_by_person_id($person_id, $number) {
        $result = $this->get_other_content_library_selected_by_person_id($person_id);

        if ($result) {
            $post_id_array = array();
            foreach ($result as $value) {
                $post_id_array[] = $value->post_id;
            }
            $post_id = implode(',', $post_id_array);
            return $this->get_content_library_query($person_id, $number, $post_id);
        } else {
            return $this->get_content_library_query($person_id, $number);
        }
    }

    function total_content_library_by_person_id($person_id) {
        $result = $this->get_other_content_library_selected_by_person_id($person_id);

        if ($result) {
            $post_id_array = array();
            foreach ($result as $value) {
                $post_id_array[] = $value->post_id;
            }
            $post_id = implode(',', $post_id_array);
            return $this->get_total_content_library_query($person_id, $post_id);
        } else {
            return $this->get_total_content_library_query($person_id);
        }
    }

    function get_content_library_query($person_id, $number, $post_id = NULL) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id
                    AND (posted_by = '$person_id'
                    AND (p.post_type IN (3,5))";
        if ($post_id != NULL) {
            $sql .= " OR (post_id IN ($post_id)))
                AND p.post_type IN (3,5)
                AND (post_status != 4)
                ORDER BY post_id DESC
                LIMIT 10 OFFSET $number";
        } else {
            $sql .= ") AND (post_status != '4')
                ORDER BY post_id DESC
                LIMIT 10 OFFSET $number";
        }
        return $this->db->query($sql)->result();
    }

    function get_total_content_library_query($person_id, $post_id = NULL) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE p.posted_by = pr.person_id
                    AND pr.url_id = u.url_id
                    AND (posted_by = '$person_id'
                    AND (p.post_type IN (3,5))";
        if ($post_id != NULL) {
            $sql .= " OR (post_id IN ($post_id)))
                AND p.post_type IN (3,5)
                AND (post_status != 4)
                ORDER BY post_id DESC";
        } else {
            $sql .= ") AND (post_status != '4')
                ORDER BY post_id DESC";
        }
        return $this->db->query($sql)->result();
    }

    function get_other_content_library_selected_by_person_id($person_id) {
        $sql = "SELECT *
                FROM 
                    tbl_post_functions
                WHERE 
                    FIND_IN_SET('$person_id', post_add_to_my_library_by)";
        return $this->db->query($sql)->result();
    }

//------------------------End Profile view (My Content Library) Sction for POST----------------------------
//------------------------Start Profile view (all public post) Sction for POST----------------------------

    function all_public_note_alert_person_id($person_id, $post_counter) {
        $sql = "SELECT * 
                FROM 
                    tbl_post
                WHERE 
                    posted_by = '$person_id'
                AND (post_type='1' OR post_type='2')
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC
                LIMIT $post_counter,3";
        return $this->db->query($sql)->result();
    }

    function all_public_note_person_id($person_id, $post_counter) {
        $sql = "SELECT * 
                FROM 
                    tbl_post
                WHERE 
                    posted_by = '$person_id'
                AND (post_type='1')
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC
                LIMIT $post_counter,5";
        return $this->db->query($sql)->result();
    }

    function all_public_alert_person_id($person_id, $post_counter) {
        $sql = "SELECT * 
                FROM 
                    tbl_post
                WHERE 
                    posted_by = '$person_id'
                AND (post_type='2')
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC
                LIMIT $post_counter,5";
        return $this->db->query($sql)->result();
    }

    function total_count_public_note_alert_person_id($person_id, $post_type) {
        $this->db->select('count(post_id) AS total_note_alert,posted_by')
                ->from('tbl_post')
                ->where('posted_by', $person_id)
                ->where('post_type', $post_type)
                ->where('post_status', '1')
                ->where('post_publication_status', '1');
        return $this->db->get()->row();
    }
    
    function total_public_note_alert_person_id($person_id) {
        $sql = "SELECT count(post_id) AS total_note_alert,posted_by  
                FROM 
                    tbl_post
                WHERE 
                    posted_by = '$person_id'
                AND (post_type='1' OR post_type='2')
                AND post_status = '1'
                AND post_publication_status = '1'";
        return $this->db->query($sql)->row();
    }

    function all_public_assignment_person_id($person_id, $post_counter) {
        $sql = "SELECT * 
                FROM 
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE 
                    posted_by = '$person_id'
                AND p.posted_by = pr.person_id
                AND pr.url_id = u.url_id
                AND post_type='3'
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC
                LIMIT $post_counter,5";
        return $this->db->query($sql)->result();
    }

    function total_public_assaignment_person_id($person_id) {
        $sql = "SELECT  COUNT(post_id) AS total_assignment,posted_by
                FROM 
                    tbl_post
                WHERE 
                    posted_by = '$person_id'
                AND post_type='3'
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC";
        return $this->db->query($sql)->row();
    }

    function all_public_image_person_id($person_id, $post_counter) {
        $sql = "SELECT * 
                FROM 
                   tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE 
                    p.posted_by = '$person_id'
                AND p.posted_by = pr.person_id
                AND pr.url_id = u.url_id
                AND post_type='4'
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC
                LIMIT $post_counter,6";
        return $this->db->query($sql)->result();
    }

    public function total_public_image_person_id($person_id) {
        $sql = "SELECT count(post_id) AS total_image,posted_by
                FROM 
                    tbl_post
                WHERE 
                    posted_by = '$person_id'
                AND post_type='4'
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC";
        return $this->db->query($sql)->row();
    }

    function all_public_video_person_id($person_id, $post_counter) {
        $sql = "SELECT * 
                FROM
                    tbl_post AS p,
                    tbl_person AS pr,
                    tbl_url AS u
                WHERE 
                    p.posted_by = '$person_id'
                AND p.posted_by = pr.person_id
                AND pr.url_id = u.url_id
                AND post_type='5'
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC
                LIMIT $post_counter,1";
        return $this->db->query($sql)->result();
    }

    function total_public_video_person_id($person_id) {
        $sql = "SELECT count(*) AS total_video,posted_by 
                FROM 
                    tbl_post
                WHERE 
                    posted_by = '$person_id'
                AND post_type='5'
                AND post_publication_status = '1'
                AND post_status = '1'
                ORDER BY post_id DESC";
        return $this->db->query($sql)->row();
    }

//------------------------END Profile view (all public post) Sction for POST----------------------------
}
