<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// Using all person related information

class Person_model extends CI_Model {

    private $tbl_name = 'tbl_person';
    private $primary_key = 'person_id';

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : view_admin_user_information 
     * @Used IN             : @function-'get_dashboard_data'       super_admin_model[Model]
     * @Description         : view all user information
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 07-04-2016 12:07 PM  
     * @Parameter           : Null
     * @Return              : $user_info[Array]    
     * @Status              : Available        
     * */
    function view_admin_user_information() {
        $data = Array();
        $data['total_teacher'] = $this->get_total_person_info(Array(3));
        $data['total_organization'] = $this->get_total_person_info(Array(4));
        $data['total_learner'] = $this->get_total_person_info(Array(5));
        $data['total_user'] = ($data['total_teacher'] + $data['total_organization'] + $data['total_learner']);
        return $data;
    }

    /**
     * @Function            : get_total_person_info 
     * @Used IN             : @function-'view_admin_user_information'     this[Model]
     * @Description         : view all user information
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 07-04-2016 12:07 PM  
     * @Parameter           : $person_role[Integer]
     * @Return              : $total_user[Array]    
     * @Status              : Available        
     * */
    function get_total_person_info($person_role) {
        return $this->db->select('*')->from('tbl_person')->where_in('person_role', $person_role)->count_all_results();
    }

    /**
     * @Function            : update_user_password 
     * @Used IN             : @function-'__construct'       user_video[Controller] (24)
     * @Description         : view all front end person information by person ID
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 07-04-2016 12:07 PM  
     * @Parameter           : $person_id[INTEGER]
     * @Return              : active_person_info    
     * @Status              : Available        
     * */
    function select_active_person_information_by_user_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         p.person_id= '$person_id'"
                . "     AND p.url_id = u.url_id "
                . "     AND p.person_status = 1"
                . "     AND (p.person_role = 3 OR p.person_role = 4 OR p.person_role = 5) ";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_backend_active_person_information_by_user_id 
     * @Used IN             : @function-'__construct'       super_admin[Controller] 
     * @Description         : view all back end person information by person ID
     * @                    : =>Convert to active query
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 11-05-2016 12:50 PM  
     * @Updated Date Time   : 07-09-2016 11:15 AM
     * @Updated By          : MD Jaherul Islam
     * @Parameter           : $person_id[INTEGER]
     * @Return              : active_person_info    
     * @Status              : Available        
     * */
    function select_backend_active_person_information_by_user_id($person_id) {
        $this->db->select('person_id')
                ->from('tbl_person')
                ->where('person_id', $person_id)
                ->where('person_status', 1)
                ->where_in('person_role', Array(1, 2, 6, 8, 9));
        return $this->db->get()->row();
    }

    /**
     * @Function            : get_single_person_info_by_person_id 
     * @Description         : view single person information by person ID
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 18-07-2016 04:25 PM  
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $active_person_info    
     * @Status              : Available   (used only 5)     
     * */
    function get_single_person_info_by_person_id($person_id) {
        $sql = "SELECT * FROM tbl_person AS p WHERE p.person_id = '$person_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_person_information_by_person_id 
     * @Used IN             : @function-'add_video_course'                                               user_video[@controller] (42)
     * @                    : @function-'check_login_user_authentication_for_view_video_course'          Welcome[@controller] (1726)
     * @                    : @function-'delete_draft_post'                                              Application[@controller] (1726)
     * @                    : @function-'view_invoices'                                                  user_payment[@controller] (1726)
     * @Description         : get person information using person_id
     * @Developed By        : Mohammad Jaherul Islam
     * @Start DateTime      : 07-04-2016 12:50 PM   
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $person_info[ARRAY]       
     * @Status              : available      
     * */
    public function get_single_person_information_by_person_id($person_id) {
        $sql = "SELECT *
                FROM
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    p.person_id = '$person_id'
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_person_information_by_person_url 
     * @Used IN             : @function-'view_detail'                              super_admin[@controller]
     * @Description         : get person information using person url
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-05-2016 10:38 AM   
     * @Parameter           : $person_url[STRING]
     * @Return              : person_info       
     * @Status              : available      
     * */
    public function get_single_person_information_by_person_url($person_url) {
        $sql = "SELECT * 
                FROM 
                    tbl_person AS p,
                    tbl_url AS u,
                    tbl_person_info_view_status AS pivw
                WHERE 
                    p.url_id = u.url_id
                AND u.url = '$person_url'
                AND u.url_type = '10'
                AND p.person_id = pivw.person_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_profile_url 
     * @Used IN             : @function-'upload_course_work_file_in_database'     user_course[@controller]2 times
     * @                    : @function-'delete_single_course_work_file'          user_course[@controller]
     * @                    : @function-'delete_course_work_file_for_skip'        user_course[@controller]
     * @                    : @function-'save_course_work_file'                   this[@Model]
     * @Description         : get Person URL using person_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-02-2016 10:14 AM
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $url[STRING]  
     * @Status              : available      
     * */
    public function get_profile_url($person_id) {
        $sql = "SELECT url
                FROM
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    p.person_id = '$person_id'
                AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();
        return $result->url;
    }

    /**
     * @Function            : get_all_front_end_person_info 
     * @Description         : get all front end person information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-08-2016 04:13 PM
     * @Parameter           : $person_id[INTEGRE] (person_id of Assign resource person),
     *                        $selected_user_id [Selected person for special course for add course],
     *                        $search_input [search value], $limit
     * @Return              : $person_data[ARRAY] 
     * @Status              : available      
     * */
    function get_all_front_end_person_info($person_id = '', $selected_user_id = '', $search_input = '', $limit = '') {
        $sql = "SELECT * FROM tbl_person AS p WHERE p.person_role IN (3,4,5)";
        if ($person_id != '') {
            $sql.=" AND p.person_id != '$person_id'";
        }
        if ($selected_user_id != '') {
            $sql.=" AND p.person_id NOT IN ($selected_user_id)";
        }
        if ($search_input != '') {
            $sql.=" AND CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$search_input%'";
        }
        if ($limit != '') {
            $sql.=" LIMIT $limit";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : all_front_end_person_id_array
     * @Used IN             : @function-'check_special_user'       super_admin_course[@Controller]  
     * @Description         : return front end person_id id AS array
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 09-08-2016 12:54 PM  
     * @Parameter           : Null
     * @Return              : $person_id_array[ARRAY]    
     * @Status              : Available        
     * */
    function all_front_end_person_id_array() {
        $person_id_array = Array();
        $person_data = $this->get_all_front_end_person_info();

        foreach ($person_data as $person_value) {
            $person_id_array[] = $person_value->person_id;
        }
        return $person_id_array;
    }

    /**
     * @Function            : get_all_selected_person 
     * @Used IN             : @function-'get_selected_user_list_for_front_end_special_user_name'     this[@Model] - [470]
     * @Description         : get person info by selected_user_list
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-04-2016 05:18 PM
     * @Parameter           :  $all_user_id[INTEGER](multiple user id) ,$person_id[INTEGRE] (person_id of Assign resource person),
     *                         $selected_user_id [Selected person for special course for add course],
     *                         $search_input [search value], $limit
     * @Return              : all_selected_user_list      
     * @Status              : available      
     * */
    function get_all_selected_person($all_user_id, $person_id = '', $selected_person_id = '', $search_input = '', $limit = '') {
        $sql = "SELECT *
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    p.person_id IN ($all_user_id)
                AND p.url_id = u.url_id";
        if ($person_id != '') {
            $sql.=" AND p.person_id != '$person_id'";
        }
        if ($selected_person_id != '') {
            $sql.=" AND p.person_id NOT IN ($selected_person_id)";
        }
        if ($search_input != '') {
            $sql.=" AND CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$search_input%'";
        }
        if ($limit != '') {
            $sql.=" LIMIT $limit";
        }
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : select_single_person_information_by_resource_person_id 
     * @Used IN             : @function-'upload_course_work_file'               user_course[@controller]
     * @Description         : get person information using resource person ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 15-05-2016 03:39 PM   
     * @Parameter           : $resource_person_id[INEGER]
     * @Return              : person_info[ARRAY]       
     * @Status              : available      
     * */
    function select_single_person_information_by_resource_person_id($resource_person_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_resource_person AS rp,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    rp.resource_person_id = '$resource_person_id'
                AND rp.person_id = p.person_id
                AND p.url_id = u.url_id
                AND u.url_type = '10'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_resource_person_information_by_person_id 
     * @Used IN             : @function-'get_information_for_add_video_course'          user_video_model[@Model] (43)
     * @                    : @function-'get_information_for_add_course'                course[@Controller] (450)
     * @Description         : get resource persion information using person_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-04-2016 12:53 PM  
     * @Parameter           : $person_id[INTEGER]
     * @Return              : resource_person_info[ARRAY]      
     * @Status              : available      
     * */
    public function select_resource_person_information_by_person_id($person_id) {
        $sql = "SELECT *
                FROM
                    tbl_resource_person AS rp,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE
                    rp.person_id = '$person_id'
                AND rp.person_id = p.person_id
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_organization_info_by_person_id 
     * @Used IN             : @function-'check_login_user_authentication_for_view_video_course'      Welcome[@Controller] (1735)
     * @                    : @function-'check_enroll_course_validation'                             course[@Controller] (455)
     * @Description         : get organization information using person_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-04-2016 01:18 PM      
     * @Parameter           : $person_id[INTEGER]
     * @Return              : organization information          
     * @Status              : available      
     * */
    public function select_organization_info_by_person_id($person_id) {
        $sql = "SELECT * FROM
			tbl_person AS p,
			tbl_url AS u,
			tbl_person_info_view_status AS pvs,
			tbl_organization AS o,
			tbl_resource_person AS rp
                WHERE
                    o.person_id = '$person_id'
                AND p.person_id = o.person_id
                AND u.url_id = p.url_id
                AND pvs.person_id = o.person_id
                AND rp.person_id = o.person_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_single_organization_info_by_person_id 
     * @Used IN             : @function-'save_resource_person_info'      this[@Model] 
     * @Description         : get single organization information using person_id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-07-2016 12:04 PM      
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $organization_info[ARRAY]         
     * @Status              : available      
     * */
    function select_single_organization_info_by_person_id($person_id) {
        $sql = "SELECT * FROM tbl_organization AS o WHERE o.person_id = '$person_id'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_person_information_by_organization_id 
     * @Used IN             : @function-'check_login_user_authentication_for_view_video_course'      Welcome[@Controller] (1735)
     * @Description         : get person information using organization ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 06:37 PM      
     * @Parameter           : $person_id[INTEGER]
     * @Return              : organization information          
     * @Status              : available      
     * */
    function select_person_information_by_organization_id($organization_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_organization AS o,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    o.organization_id = '$organization_id'
                AND o.person_id = p.person_id
                AND p.url_id = u.url_id
                AND u.url_type = '10'";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : select_video_course_student_information_by_student_id 
     * @Used IN             : @function-'video_course_registration'      user_video_model[@Model],
     * @Description         : get video course student information using Student ID 
     * @Developed By        : MD Jaherul Islam 
     * @Start DateTime      : 13-04-2016 03:44 PM  
     * @Parameter           : $student_id[INTEGER]
     * @Return              : student information        
     * @Status              : available      
     * */
    function select_video_course_student_information_by_student_id($student_id) {
        $sql = "SELECT * 
                FROM
                    tbl_student AS s,
                    tbl_video_management AS vm,
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    s.student_id = '$student_id'
                AND s.student_type = '2'
                AND s.course_id = vm.video_management_id
                AND s.person_id = p.person_id
                AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_all_resource_person_by_organization_id 
     * @Used IN             : @function-'check_login_user_authentication_for_view_video_course'      Welcome[@Controller] (1735)
     * @Description         : get all resource person info by organization ID
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-04-2016 01:48 PM      
     * @Parameter           : $organization_id[INTEGER]
     * @Return              : resource person info          
     * @Status              : available      
     * */
    public function get_all_resource_person_by_organization_id($organization_id) {
        $sql = "SELECT group_concat(rp.person_id) as resource_person_id_array 
                FROM 
                    tbl_resource_person AS rp
                WHERE 
                    rp.person_id = '$organization_id'";
        $result = $this->db->query($sql)->row();
        return $result->resource_person_id_array;
    }

    /**
     * @Function            : get_organization_all_resource_person_id_by_person_id 
     * @Used IN             : @function-'get_front_end_group_name'      user_video[@Controller] (1236)
     * @Used IN             : @function-'check_group_validation'      user_video[@Controller] (211)
     * @Description         : get all resource person of a organization by person id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 23-04-2016 04:33 PM      
     * @Parameter           : $person_id[INTEGER]
     * @Return              : all_resource_person_id        
     * @Status              : available      
     * */
    function get_all_resource_person_of_organization_by_person_id($person_id) {
        $data['person_info'] = $this->person_model->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role == 4) {
            $resource_person_info = $this->select_resource_person_information_by_person_id($person_id);
            return $this->get_all_resource_person_by_organization_id($resource_person_info->organization_id);
        } else if ($data['person_info']->person_role == 3) {
            return $person_id;
        }
    }

    /**
     * @Function            : save_person_info_view_status 
     * @Used IN             : @function-'save_resource_person_info'      this[@Model]
     * @Description         : save person info view status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 08-05-2016 04:11 PM      
     * @Parameter           : $person_id[INTEGER]
     * @Return              : None       
     * @Status              : available      
     * */
    function save_person_info_view_status($person_id) {
        $status_data['person_id'] = $person_id;
        $status_data['person_email_view_status'] = 1;
        $status_data['person_contact_number_view_status'] = 1;
        $status_data['person_address_view_status'] = 1;
        $status_data['person_birthday_view_status'] = 1;
        $status_data['person_self_assessment_skills_view_status'] = 1;
        $this->db->insert('tbl_person_info_view_status', $status_data);
    }

    /**
     * @Function            : check_person_login_status 
     * @Used IN             : @function-'_constructot'      super_admin[@Controller]
     * @Description         : save person login status
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 11-05-2016 01:12 PM      
     * @Parameter           : None
     * @Return              : None       
     * @Status              : available      
     * */
    function check_person_login_status() {
        $start_time = $this->session->userdata('login_start_time');
        $refresh_time = time();
        if ($refresh_time - $start_time > 1800) {
            $person_pc_info_id = $this->session->userdata('person_pc_info_id');
            $data['person_login_status'] = 3;
            $this->utility_model->update_information_in_database('tbl_person_pc_info', 'person_pc_info_id', $person_pc_info_id, $data);
        } else {
            $sData['login_start_time'] = $refresh_time;
            $this->session->set_userdata($sData);
        }
    }

    /**
     * @Function            : check_user_authentication_for_view_video_course 
     * @Used IN             : @function-'check_login_user_authentication_for_view_video_course'      Welcome[@Controller] (1735)
     * @Description         : check user authentication for view video course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 12-04-2016 10:38 PM      
     * @Parameter           : $person_id[INTEGER],$course_creator_id[INTEGER],$resourse_person_id[INTEGER]
     * @Return              : 1(if matched) OR 2(not matched)        
     * @Status              : available      
     * */
    function check_user_authentication_for_view_video_course($person_id, $course_creator_id, $resourse_person_id) {
        $data['person_info'] = $this->get_single_person_information_by_person_id($person_id);
        if ($data['person_info']->person_role == 6 || $data['person_info']->person_role == 1) {
            return 1; // if person are Admin or super Admin
        } else if ($person_id == $course_creator_id) {
            return 1; // if person are creator of this course
        } else {
            if ($data['person_info']->person_role == 4) {  // if login user are organization
                $organization_info = $this->select_organization_info_by_person_id($person_id);
                $all_resource_person = $this->get_all_resource_person_by_organization_id($organization_info->organization_id);
                $all_resource_person_array = explode(',', $all_resource_person);
                if (in_array($course_creator_id, $all_resource_person_array)) {   // if login user are teacher of this organization
                    return 1; // if any organization teacher create this course
                } else {
                    return 2; // if any organization teacher does not create this course
                }
            } else if ($data['person_info']->person_role == 3) {   // if login user are Teacher
                $resource_person_info = $this->select_resource_person_information_by_person_id($person_id);
                if ($resource_person_info->resource_person_id == $resourse_person_id) {   // if video course assigned teacher are same as login user
                    return 1;
                } else {
                    return 2;
                }
            } else {
                return 2;
            }
        }
    }

    /**
     * @Function            : get_person_information_for_login 
     * @Used IN             : @function-'check_login'          Application[@Controller] (29)
     * @Used IN             : @function-'check_admin_login'    babbamamma[@Controller] 
     * @Description         : get person information by person_email and person_password
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-04-2016 02:10 PM  
     * @Parameter           : $user_email[String], $user_password[String]
     * @Return              : person_info    
     * @Status              : Available        
     * */
    function get_person_information_for_login($user_email, $user_password) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         p.person_email = '$user_email' "
                . "     AND p.person_password = '$user_password' "
                . "     AND p.url_id = u.url_id";
        return $this->db->query($sql)->row();
    }
    
    
    /**
     * @Function            : get_resource_person_type 
     * @Used IN             : @function-'set_data_into_session'    Sign_in[@Controller]
     * @Description         : get the resource person type
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 19-03-17
     * @Parameter           : $person_id   
     * @Status              : Available        
     * */
    function get_resource_person_type($person_id){
        $result = $this->db->select('resource_person_type')
                           ->from('tbl_resource_person')
                           ->where('person_id', $person_id)
                           ->get()->row();
        return isset($result) ? $result->resource_person_type : '';
    }

    /**
     * @Function            : check_person_email_existance 
     * @Used IN             : @function-'check_login'    Application[@Controller] (37)
     * @Description         : check person email
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 18-04-2016 03:53 PM  
     * @Parameter           : $user_email[String]
     * @Return              : person_info    
     * @Status              : Available        
     * */
    function check_person_email_existance($user_email) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_url as u "
                . " WHERE "
                . "         p.person_email = '$user_email' "
                . "     AND p.url_id = u.url_id ";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_person_total_used_storage 
     * @Used IN             : @function-'uploaded_video_courses_video_file'  user_video[@Controller]
     * @Description         : get login person total storage
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 10-04-2016 03:11 AM  
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $total_used_space[INTEGER]    
     * @Status              : Available        
     * */
    function get_person_total_used_storage($person_id) {
        $total_used_space = '';
        $resource_person_info = $this->select_resource_person_information_by_person_id($person_id);
        if ($resource_person_info->resource_person_type == 3) {
            $all_organization_user = $this->get_all_resource_person_info_by_organizarion_id($resource_person_info->organization_id);
            foreach ($all_organization_user as $organization_user_value) {
                $directory = 'content-library/' . $organization_user_value->url;
                $total_used_space+= $this->user_video_model->person_available_disk_space($directory);
            }
        } else {
            $directory = 'content-library/' . $resource_person_info->url;
            $total_used_space = $this->user_video_model->person_available_disk_space($directory);
        }
        return $total_used_space;
    }

    /**
     * @Function            : get_person_used_storage 
     * @Description         : get person total used storage
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 07-05-2016 05:57 PM  
     * @Parameter           : $person_id[INTEGER]
     * @Return              : $total_used_space[INTEGER]    
     * @Status              : Available        
     * */
    function get_person_used_storage($person_id) {
        $resource_person_info = $this->select_resource_person_information_by_person_id($person_id);
        if ($resource_person_info->resource_person_type == 3) {
            $person_info = $this->select_person_information_by_organization_id($resource_person_info->organization_id);
            $directory = 'content-library/' . $person_info->url;
            return $this->person_available_disk_space($directory);
        } else if ($resource_person_info->resource_person_type == 1) {
            $person_info = $this->get_single_person_information_by_person_id(1);
            $directory = 'content-library/' . $person_info->url;
            return $this->person_available_disk_space($directory);
        } else {
            $directory = 'content-library/' . $resource_person_info->url;
            return $this->person_available_disk_space($directory);
        }
    }

    /**
     * @Function            : person_available_disk_space
     * @Used IN             : @function-'uploaded_course_video_file_size'          user_video[@controller]-2 times
     * @Description         : full size of content library for login user 
     * @Developed By        : Copied from 'super_admin_course_model'
     * @Start DateTime      : 02-02-2016 04:10 PM 
     * @Status              : available        
     * */
    public function person_available_disk_space($dir) {
        $size = 0;
        foreach (glob(rtrim($dir, '/') . '/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : $this->person_available_disk_space($each);
        }
        return $size;
    }

    /**
     * @Function            : save_resource_person_id 
     * @Used IN             : @function-'save_video_course_information1'       user_video_model[@Model] - [100]
     * @Description         : save resource person id
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 25-04-2016 03:32 PM  
     * @Parameter           : $person_info[ARRAY], $resource_person_id[INTEGER]
     * @Return              : $resource_person_id[INTEGER]
     * @Status              : Available        
     * */
    function save_resource_person_id_for_video_course($data, $resource_person_id) {
        $person_role = $this->session->userdata('person_role');
        if ($person_role == 4) {
            return $resource_person_id;
        } else {
            return $data['resource_person_info']->resource_person_id;
        }
    }

    /*
      -----------@@@RIPON@ Start public person search Part----------------------------------
     */

    function get_person_value_by_search($data, $search_value, $start_limit, $end_limit) {
        $searched_person = $this->get_searched_person_information($search_value, $start_limit, $end_limit);
        if ($searched_person) {
            $data['searched_person'] = $searched_person;
            $data['total_searched_person'] = $this->get_total_searched_person_information($search_value);
        }
        return $data;
    }

    /**
     * @Function            : get_searched_person_information 
     * @Used IN             : @function-'view_searched_value'  welcome[@controller],
     * @Description         : get person information by search 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 09:54 AM   
     * @Status              : available      
     * */
    public function get_searched_person_information($search_value, $start_limit, $end_limit) {
        $sql = "SELECT *
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    p.url_id = u.url_id
                AND u.url_type = '10'
                AND CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$search_value%'
                AND p.person_status = '1'
                ORDER BY p.person_first_name ASC
                LIMIT $start_limit,$end_limit";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_searched_person_information 
     * @Used IN             : @function-'view_searched_value'  welcome[@controller],
     * @Description         : get total person by search 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 11:32 AM   
     * @Status              : available      
     * */
    function get_total_searched_person_information($search_value) {
        $sql = "SELECT COUNT(*) AS total_person
                FROM 
                    tbl_person AS p,
                    tbl_url AS u
                WHERE 
                    p.url_id = u.url_id
                AND u.url_type = '10'
                AND CONCAT(p.person_first_name,' ',p.person_last_name) LIKE '%$search_value%'
                AND p.person_status = '1'";
        $result = $this->db->query($sql)->row();
        return $result->total_person;
    }

    /*
      -----------@@@RIPON@ End public person search Part----------------------------------
     */

    /**
     * @Function            : get_person_content_library_by_person_id 
     * @Used IN             : @function-'update_profile_image_into_database'  profile_model[@Model]
     * @Description         : get person content library by person ID 
     * @Developed By        : MD JAherul ISlam
     * @Start DateTime      : 23-06-2016 01:00 PM
     * @Updated By          : Md Mashqur Ul Alam
     * @Update DateTime     : 12-01-17
     * @Status              : available      
     * */
    function get_person_content_library_by_person_id($person_id) {
        $result = $this->db->select('*')->from('tbl_content_library')
                        ->where('content_library_type_id', $person_id)
                        ->where('content_deletion_status', 1)
                        ->group_by('content_library_type')
                        ->get()->result();
        return $result;
    }

    /**
     * @Function            : get_person_content_library_information 
     * @Used IN             : @function-'update_profile_image_into_database'  profile_model[@Model]
     * @Description         : get person content library information 
     * @Developed By        : MD JAherul ISlam
     * @Start DateTime      : 22-06-2016 09:58 PM
     * @Updated By          : Md Mashqur Ul Alam 11-01-2017   
     * @Status              : available      
     * */
    function get_person_content_library_information($user_id, $type, $status) {
        $this->db->select('*')->from('tbl_content_library')
                ->where('content_library_type_id', $user_id)
                ->where('content_library_type', $type)
                ->where('content_deletion_status', $status);
        $result = $this->db->get()->result();
        return $result;
    }

    /**
     * @Function            : get_person_content_library_information_by_id 
     * @Used IN             : @function-'update_profile_image_into_database'  profile_model[@Model]
     * @Description         : get person content library information 
     * @Developed By        : MD JAherul ISlam
     * @Start DateTime      : 22-06-2016 09:58 PM
     * @Updated By          : Md Mashqur Ul Alam [14-01-17]   
     * @Status              : available      
     * */
    function get_person_content_library_information_by_id($content_library_id) {
        $this->db->select('*')->from('tbl_content_library AS tcl')
                ->join('tbl_person AS p', 'p.person_id = tcl.content_library_type_id')
                ->join('tbl_url AS u', 'p.url_id = u.url_id')
                ->where('tcl.content_library_id', $content_library_id)
                ->where('tcl.content_library_type', 1);
        return $this->db->get()->row();
    }

    /**
     * 
     * @Description         : set person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 09:56 AM         
     * */
    private $person_id;

    function set_person_id($person_id) {
        $this->person_id = $person_id;
        return $this;
    }

    /**
     * 
     * @Description         : set person Url
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 09:56 AM         
     * */
    private $person_url;

    function set_person_url($url) {
        $this->person_url = $url;
        return $this;
    }

    /**
     * 
     * @Description         : set field name
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 09:57 AM         
     * */
    private $field_name;

    function set_field_name($field_name) {
        $this->field_name = $field_name;
        return $this;
    }

    /**
     * 
     * @Description         : set person information by person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 04:58 PM         
     * */
    private $person_info;

    function set_info_by_id() {
        $this->person_info = $this->utility_model
                ->get_table_information($this->field_name, $this->tbl_name, [$this->primary_key => $this->person_id]);
        return $this;
    }

    /**
     * 
     * @Description         : set person information
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 09:57 AM         
     * */
    function set_info_by_url() {
        $this->person_info = $this->db->select($this->field_name)->from($this->tbl_name)
                        ->join('tbl_url', "$this->tbl_name.url_id = tbl_url.url_id")
                        ->where('url', $this->person_url)->get()->row();
        return $this;
    }

    /**
     * 
     * @Description         : set person information
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 09:57 AM         
     * */
    function set_info_with_url_by_id() {
        $this->person_info = $this->db->select($this->field_name)->from($this->tbl_name)
                        ->join('tbl_url', "$this->tbl_name.url_id = tbl_url.url_id")
                        ->where('person_id', $this->person_id)->get()->row();
        return $this;
    }

    /**
     * 
     * @Description         : set multiple person information with url by multiple person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 12:12 PM         
     * */
    function set_multiple_person_info_with_url_by_person_id() {
        $this->person_info = $this->db->select($this->field_name)->from($this->tbl_name)
                        ->join('tbl_url', "$this->tbl_name.url_id = tbl_url.url_id")
                        ->where_in('person_id', $this->person_id)->get()->result();
        return $this;
    }

    /**
     * 
     * @Description         : get person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 07-12-2016 12:19 PM         
     * */
    function get_person_id() {
        return $this->person_id;
    }

    /**
     * 
     * @Description         : get person information
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 10:02 AM         
     * */
    function get_info() {
        return $this->person_info;
    }

    /**
     * 
     * @Description         : set person role
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:32 PM         
     * */
    public function __set($name, $value) {
        $this->person_data[$name] = $value;
        return $this;
    }

    /**
     * 
     * @Description         : update person data
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 01-12-2016 03:36 PM         
     * */
    private $person_data = [];

    function update() {
        $this->db->where($this->primary_key, $this->person_id)->update($this->tbl_name, $this->person_data);
    }

    /**
     * 
     * @Description         : delete person data using person ID
     * @Developed By        : MD Jaherul Islam
     * @Develop Datetime    : 02-12-2016 12:16 PM         
     * */
    function delete() {
        $this->db->where($this->primary_key, $this->person_id)->delete($this->tbl_name);
    }

    public function __destruct() {
        if (!empty($this->person_id)) {
            unset($this->person_id);
        }
        if (!empty($this->person_data)) {
            unset($this->person_data);
        }
    }

    function dd($image_path, $thumb_image_path) {
        if (!empty($image_path)) {
            if (file_exists($image_path)) {
                if (file_exists($thumb_image_path)) {
                    echo 'thumb image';
                } else {
                    echo $image;
                }
            }
        } else {
            echo 'dafeult image path';
        }
    }

}
