<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notification_dashboard_model extends CI_Model {

    function __construct() {

        parent::__construct();
    }

     /*
     * @Function            : save_accept_request_notification
     * @Description         : saves notification upon accepting link request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 07-06-17 
     * @Parameter           : $notify_by, $notify_to, $link_request_id
     * @Return              : $notification_id;
     * @Status              : available      
     */
    function save_accept_request_notification($notify_by, $notify_to, $link_request_id) {
        $nData = array();          
        $nData['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->time_offset));
        $nData['notify_by'] = $notify_by;
        $nData['notify_to'] = $notify_to;
        $nData['notification_description'] = $this->accept_request_description($notify_by, $notify_to);
        $nData['notification_type'] = 2;  // type->2 for accept link request
        $notification_id = $this->utility_model->save_information_in_database('tbl_notification', $nData); // save notification information for add course
        $this->notification_model->save_notification_type_info($notification_id, $link_request_id); // save notofication information
        return $notification_id;
    }
    //Created By Kazol
    function save_accept_profile_request_notification($notify_to, $notify_by, $link_request_id) {
        $nData = array();          
        $nData['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->time_offset));
        $nData['notify_by'] = $notify_by;
        $nData['notify_to'] = $notify_to;
        $nData['notification_description'] = $this->accept_request_description($notify_by, $notify_to);
        $nData['notification_type'] = 2;  // type->2 for accept link request
        $notification_id = $this->utility_model->save_information_in_database('tbl_notification', $nData); // save notification information for add course
        $this->notification_model->save_notification_type_info($notification_id, $link_request_id); // save notofication information
        return $notification_id;
    }

     /*
     * @Function            : save_send_link_request_notification
     * @Description         : saves notification upon Sending link request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 07-06-17 
     * @Parameter           : $notify_by, $notify_to, $link_request_id
     * @Return              : $notification_id;
     * @Status              : available      
     */
    function save_send_link_request_notification($notify_to, $notify_by, $link_request_id) { //notify to -> notification_receiver_person_id ,$notify_by->notification_sender_person_id 
        $nData = array();          
        $nData['notification_date_time'] = date('Y/m/d H:i:s', (time() - $this->session->time_offset));
        $nData['notify_by'] = $notify_by;
        $nData['notify_to'] = $notify_to;
        $nData['notification_description'] = $this->send_request_description($notify_by, $notify_to);
        $nData['notification_type'] = 1;  // type->1 for send link request
        $notification_id = $this->utility_model->save_information_in_database('tbl_notification', $nData); // save notification information for add course
        $this->notification_model->save_notification_type_info($notification_id, $link_request_id); // save notofication information
        return $notification_id;
    }
    
     /*
     * @Function            : send_request_description
     * @Description         : prepares notification message for Sending link request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 07-06-17 
     * @Parameter           : $notify_by, $notify_to
     * @Return              : $description;
     * @Status              : available
     */
    public function send_request_description($notify_by, $notify_to){
        $notify_by_name = $this->get_person_name($notify_by);
        $notify_to_name = $this->get_person_name($notify_to);
        $description[$notify_by] = "You Have sent a link Request to $notify_to_name";
        $description[$notify_to] = "You Have a Link Request From $notify_by_name";
        return serialize($description);
    }
    
    
    /*
     * @Function            : accept_request_description
     * @Description         : prepares notification message for accepting link request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 07-06-17 
     * @Parameter           : $notify_by, $notify_to
     * @Return              : $description;
     * @Status              : available
     */
    public function accept_request_description($notify_by, $notify_to){
        $notify_by_name = $this->get_person_name($notify_by);
        $notify_to_name = $this->get_person_name($notify_to);
        $description[$notify_by] = "You Have accepted link Request From $notify_to_name";
        $description[$notify_to] = "$notify_by_name Have Accepted Your Link Request";
        return serialize($description);
    }
    
    
     /*
     * @Function            : get_person_name
     * @Description         : gets person name using person id
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 07-06-17 
     * @Parameter           : $person_id
     * @Status              : available
     */
    public function get_person_name($person_id){
        $result  = $this->db->select('person_first_name, person_last_name')
                        ->where('person_id', $person_id)
                        ->from('tbl_person')->get()->row();
        return $result->person_first_name.' '.$result->person_last_name;
    }
}
