<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of map_model
 *
 * @author Md Mashqur Ul ALam
 */
class My_link_model extends CI_Model {
    /*
     * @Function            : get_linked_user_model- @function 
     * @Used IN             : @function-'get_pending_request'  
     * @Description         : gets the id of linked users  
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 22-11-2016 05:44 PM    
     * @Parameter           : $person_id, $request_status
     * @Status              : available      
     */

    public function get_linked_user_model($person_id, $request_status) {
        $result_rp = $this->db->select("GROUP_CONCAT( DISTINCT requested_person_id ORDER BY person_link_id DESC) as id")
                        ->from('tbl_person_link')
                        ->where('person_id', $person_id)
                        ->where('add_link_request_status', $request_status)
                        ->get()
                        ->row()->id;

        $result_p = $this->db->select("GROUP_CONCAT( DISTINCT person_id ORDER BY person_link_id DESC) as id")
                        ->from('tbl_person_link')
                        ->where('requested_person_id', $person_id)
                        ->where('add_link_request_status', $request_status)
                        ->get()
                        ->row()->id;

        if ($result_rp && $result_p) {
            return $result_p . ',' . $result_rp;
        } else if ($result_rp) {
            return $result_rp;
        } else if ($result_p) {
            return $result_p;
        }
    }
    /*
     * @Function            : get_pending_link_model- @function 
     * @Used IN             : @function-'get_pending_request'  
     * @Description         : gets the id of linked users  
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 25-11-2016 10:44 AM    
     * @Parameter           : $person_id, $request_status
     * @Status              : available      
     */
    public function get_pending_link_model($person_id, $request_status){
        $result_rp = $this->db->select("GROUP_CONCAT( DISTINCT requested_person_id ORDER BY person_link_id DESC) as id")
                        ->from('tbl_person_link')
                        ->where('person_id', $person_id)
                        ->where('add_link_request_status', $request_status)
                        ->get()
                        ->row()->id;
        if($result_rp){
            return $result_rp;
        }
    }


    /*
     * @Function            : model_change_link_status @function 
     * @Used IN             : @function-'delete_link, block_link'  
     * @Description         : delete or unlink link
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 24-11-2016 04:40 PM    
     * @Parameter           : $person_id, $del_person_id
     * @Status              : available      
     */
    public function model_change_link_status($requested_person_id, $person_id, $link_status) {
        $data = array(
            'person_id' => $person_id,
            'requested_person_id' => $requested_person_id,
            'add_link_request_status'=> $link_status
        );
        
        $person_link_id = $this->db->select('person_link_id')
                           ->from('tbl_person_link')
                           ->where("person_id = $person_id AND requested_person_id = $requested_person_id")
                           ->or_where("person_id = $requested_person_id AND requested_person_id = $person_id")
                           ->get()
                           ->row();
        
        if($person_link_id->person_link_id){
            $this->db->set($data)
                     ->where('person_link_id', $person_link_id->person_link_id)
                     ->update('tbl_person_link');
            return $person_link_id->person_link_id;
        }else{
            $this->db->insert('tbl_person_link', $data);
            return $this->db->insert_id();
        }
    }
    
    /*
     * @Function            : get_edu_work_info_model @function 
     * @Used IN             : @function- my_link_suggestion  
     * @Description         : gets the education inst. and
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 26-11-2016 10:00 AM    
     * @Parameter           : $tbl_name, $field_name, $person_id
     * @Status              : available      
     */
    public function get_edu_work_info_model($tbl_name, $field_name, $person_id){
        $result = $this->db->select("GROUP_CONCAT($field_name) as $field_name")
                           ->from($tbl_name)
                           ->where('person_id',$person_id)
                           ->get()
                           ->row()->$field_name;
        return $result;
    }
    
    /*
     * @Function            : get_all_edu_work_suggestion_id @function 
     * @Used IN             : @function- my_link_suggestion  
     * @Description         : gets the person id based on education and work info
     * @Developed By        : Md Mashqur Ul Alam  
     * @Start DateTime      : 26-11-2016 02:40 PM    
     * @Parameter           : $person_id, $del_person_id
     * @Status              : available      
     */
    public function get_all_edu_work_suggestion_id($tbl_name, $field_name, $field_data, $person_id){
        $result = $this->db->select("GROUP_CONCAT(DISTINCT person_id) as id")
                           ->from($tbl_name)
                           ->where_not_in('person_id', $person_id)
                           ->where_in($field_name,$field_data)
                           ->get()
                           ->row()->id;
        return $result;
    }

}
