<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of map_model
 *
 * @author Shawon
 */
class Map_model extends CI_Model {

    /*
     * @Function            : get_current_geo_location @function 
     * @Used IN             : @function-'get_current_location'  
     * @Description         : get the current location from the tbl_travel
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 23-10-2016 04:00 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_current_geo_location_model($person_id) {

        $this->db->select('person_country, person_city, person_address, person_current_latitude_longitude');
        $this->db->where('person_id', $person_id);
        $this->db->from('tbl_person');
        $query_result = $this->db->get();
        $result = $query_result->row();

        return $result;
    }

    /*
     * @Function            : update_profile_location @function 
     * @Used IN             : @function-'/change-current-location'  
     * @Description         : insert the current location information in the tbl_travel
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 24-10-2016 10:00 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function update_profile_location_model($person_id) {

        $data['person_country'] = $this->input->post('countryName');
        $data['person_city'] = $this->input->post('cityName');
        $data['person_address'] = $this->input->post('address');
        $data['person_current_latitude_longitude'] = $this->input->post('geoLocation');

        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person', $data);
    }

    /*
     * @Function            : add_new_geo_info_model @function 
     * @Used IN             : @function-'change_current_location,'  
     * @Description         : add a new travel location for user
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 31-10-2016 12:00 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function add_new_geo_info_model() {
        $data['geo_country_name'] = $this->input->post('countryName');
        $data['geo_city_name'] = $this->input->post('cityName');
        $data['geo_latitude_longitude'] = $this->input->post('geoInfoLocation');


        $this->db->select('*');
        $this->db->where('geo_city_name', $data['geo_city_name']);
        $this->db->where('geo_country_name', $data['geo_country_name']);
        $this->db->from('tbl_geo_information');
        $query_result = $this->db->get();
        $tl_result = $query_result->row();


        if ($tl_result) {
            if ($tl_result->geo_latitude_longitude) {
                return $tl_result->geo_information_id;
            } else {

                $this->db->set('geo_latitude_longitude', $data['geo_latitude_longitude']);
                $this->db->where('geo_city_name', $data['geo_city_name']);
                $this->db->where('geo_country_name', $data['geo_country_name']);
                $this->db->where('geo_information_id', $tl_result->geo_information_id);
                $this->db->update('tbl_geo_information');

                return $tl_result->geo_information_id;
            }
        } else {

            if ($data['geo_country_name'] && $data['geo_city_name'] && $data['geo_latitude_longitude']) {

                $this->db->insert('tbl_geo_information', $data);
                $geo_information_id = $this->db->insert_id();

                return $geo_information_id;
            }
        }
    }

    /*
     * @Function            : get_geo_info_model @function 
     * @Used IN             : @function-'add_travel_location,get_travel_location'  
     * @Description         : gets the existing geo info id of travel locations
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 31-10-2016 02:30 PM    
     * @Parameter           : persion_id
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_geo_info_model($person_id) {

        $this->db->select('*');
        $this->db->where('person_id', $person_id);
        $this->db->from('tbl_travel');
        $query_result = $this->db->get();
        $result = $query_result->row();

        return $result;
    }

    /*
     * @Function            : add_travel_location_model 
     * @Used IN             : @function-'add_travel_location,'  
     * @Description         : Insert or update the travel locations of user
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 31-10-2016 02:30 PM    
     * @Parameter           : persion_id, geo_information_id
     * @Return              : Null   
     * @Status              : available      
     */

    public function add_travel_location_model($person_id, $geo_information_id) {

        $travel_location = $this->get_geo_info_model($person_id);

        if ($travel_location) {
            $this->db->set('geo_information_id', $geo_information_id);
            $this->db->where('person_id', $person_id);
            $this->db->update('tbl_travel');
        } else {
            $data['person_id'] = $person_id;
            $data['geo_information_id'] = $geo_information_id;

            $this->db->insert('tbl_travel', $data);
        }
    }

    /*
     * @Function            : get_travel_location_model 
     * @Used IN             : @function-'get_travel_location,' 
     * @Description         : Insert or update the travel locations of user
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 1-11-2016 03:40 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_travel_location_model($geo_travel) {

        $this->db->select('*');
        $this->db->where_in('geo_information_id', $geo_travel);
        $this->db->from('tbl_geo_information');
        $query_result = $this->db->get();
        $result = $query_result->result();

        return $result;
    }

    /*
     * @Function            : get_linked_users_id_model 
     * @Used IN             : @function-'get_link_location,' 
     * @Description         : Gets the person id of the linked users
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 1-11-2016 03:40 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_linked_users_id_model($person_id) {

        $result = $this->db->select('person_id, requested_person_id')
                ->from('tbl_person_link AS pl')
                ->where("(pl.person_id = $person_id OR pl.requested_person_id = $person_id)")
                ->where('add_link_request_status', 1)
                ->get()
                ->result();
        if($result){
            return $result;
        }
    }

    /*
     * @Function            : get_linked_locations_model 
     * @Used IN             : @function-'get_link_location,' 
     * @Description         : Gets the locations of the linked persons
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 7-11-2016 09:40 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_linked_locations_model($linked_person) {

        $result = $this->db->select('person_id, person_first_name, person_last_name, person_current_latitude_longitude')
                ->where_in('person_id', $linked_person)
                ->from('tbl_person')
                ->get()
                ->result();
        return $result;
    }

    /*
     * @Function            : get_link_requested_id_model 
     * @Used IN             : @function-'get_link_suggestion,' 
     * @Description         : get id of users who are linked or sent link request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 8-11-2016 09:40 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_link_requested_id_model($person_id) {

        $result = $this->db->select('person_id, requested_person_id')
                ->from('tbl_person_link')
                ->where('person_id', $person_id)
                ->or_where('requested_person_id', $person_id)
                ->get()
                ->result();
        return $result;
    }

    /*
     * @Function            : get_suggestion_id_model 
     * @Used IN             : @function-'get_link_suggestion_A, get_link_suggestion_B,' 
     * @Description         : get id of users who are linked or sent link request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 8-11-2016 10:42 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_suggestion_id_model($person_city) {
        
        $person_role = array(3,4,5);
        
        $result = $this->db->select('person_id')
                ->from('tbl_person')
                ->where('person_status', 1)
                ->where_in('person_city', $person_city)
                ->where_in('person_role', $person_role)
                ->get()
                ->result();
        return $result;
    }  

    /*
     * @Function            : get_link_suggestion_details
     * @Used IN             : @function-'get_link_suggestion,' 
     * @Description         : get the details of suggested users
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 8-11-2016 12:18 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */

    public function get_link_suggestion_details_model($person_id) {

        $data['person_name'] = $this->db->select('person_id, url_id, person_first_name, person_last_name, person_image_thumb')
                ->from('tbl_person')
                ->where_in('person_id', $person_id)                
                ->get()
                ->result();

        $data['person_work'] = $this->db->select('person_id, company_name, designation, work_currently_here')
                ->from('tbl_person_work_details')
                ->where_in('person_id', $person_id)
                ->get()
                ->result();

        $data['person_education'] = $this->db->select('person_id, education_institute_id, person_current_education_instute')
                ->from('tbl_person_education_details')
                ->where_in('person_id', $person_id)
                ->get()
                ->result();

        $data['education_institute'] = $this->db->select('education_institute_id, education_institute_name')
                ->from('tbl_education_institute')
                ->get()
                ->result();
        
        $data['url_info'] = $this->db->select('url_id, url')
                                     ->from('tbl_url')
                                     ->where('url_type', 10)
                                     ->get()
                                     ->result();

        return $data;
    }
    
        /*
     * @Function            : send_link_request
     * @Used IN             : @function-'connect_connectivity_suggested_user' 
     * @Description         : send link request
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 12-11-2016 12:50 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */
       
    public function send_link_request($data) {
        $this->db->insert('tbl_person_link', $data);
        $this->db->insert_id();
    }
    
    
    /*
     * @Function            : block_person_link_model
     * @Used IN             : @function-'block_person_link,' 
     * @Description         : select the link id based on person id and request person id
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 11-11-2016 05:07 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     */   
    
    public function block_person_link_model($person_id, $resquest_person_id){            
        $data = array(
            'person_id' => $person_id,
            'requested_person_id' => $resquest_person_id,
            'add_link_request_status' => 5
        );        
        $this->db->insert('tbl_person_link', $data);
        
    }
    
    /*
     * @Function            : person_id_by_url_model
     * @Used IN             : @map, my_link 
     * @Description         : get the person id based on the provided url
     * @Developed By        : Md Mashqur Ul ALam 
     * @Start DateTime      : 23-11-2016 10:00 AM    
     * @Parameter           : $person_url
     * @Return              : Null   
     * @Status              : available      
     */
    
    public function model_person_id_by_url($person_url) {
        
        $result_url = $this->db->select('url_id')
                           ->from('tbl_url')
                           ->where('url',$person_url)
                           ->where('url_type', 10)
                           ->get()
                           ->row();
        
        $result = $this->db->select('person_id')
                              ->from('tbl_person')
                              ->where('person_status',1)
                              ->where('url_id', $result_url->url_id)
                              ->get()
                              ->row();
        
        return $result->person_id;
    }
    
}
