<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of Manage_video_section_model
 *
 * @author Talha Training
 */
class Manage_video_section_model extends CI_Model{
    public function __construct() {
        parent::__construct();
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 27-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for adding section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $data
 * @Return              :      
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function add_video_section_info($data){
        $this->db->insert('tbl_section',$data);
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 27-07-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for manage section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $video_course_id
 * @Return              : $result    
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function manage_video_section_info($video_course_id, $limit_offset){
        if ($this->db->table_exists('tbl_section') ){
            $data['all_section_info'] = $this->db->select('*')
                    ->from('tbl_section')
                    ->where('section_type_id',$video_course_id)
                    ->order_by('section_id', 'desc')
                    ->limit(10, $limit_offset)
                    ->get()
                    ->result();
            if(isset($data['all_section_info'])){
                for ($i = 0; $i < (count($data['all_section_info'])); $i++) {
                    $data[$data['all_section_info'][$i]->section_id] = $this->db->select('*')
                            ->from('tbl_section_video')
                            ->where('section_id', $data['all_section_info'][$i]->section_id)
                            ->count_all_results();
                }
            }
            $count_data = $this->db->select('*')
                ->from('tbl_section')
                ->where('section_type_id',$video_course_id)
                ->get()
                ->result();
            $data['count_data'] = count($count_data);
        }else{
            $data = 'Table not exits';
        }
        return $data;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 05-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for edit section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $result    
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function edit_video_section_info($section_id){
        if ($this->db->table_exists('tbl_section') ){
            $result = $this->db->select('*')
                    ->from('tbl_section')
                    ->where('section_id', $section_id)
                    ->get()
                    ->row();
        }else{
            $result = 'Table not exits';
        }
        return $result;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for update section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id, $data
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_video_section_info($section_id, $data){
        $this->db->where('section_id', $section_id)
                ->update('tbl_section', $data);
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 06-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for search and pagination of video section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $search_value, $video_course_id, $limit_offset = NULL
 * @Return              : $data   
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function search_video_section_info($search_value, $video_course_id, $limit_offset = NULL){
        $data['all_section_info'] = $this->db->select('*')
                ->from('tbl_section')
                ->where('section_type_id', $video_course_id)
                ->like('section_name', $search_value)
                ->limit(10, $limit_offset)
                ->get()
                ->result();
        $row_count = $this->db->select('*')
                ->from('tbl_section')
                ->where('section_type_id', $video_course_id)
                ->like('section_name', $search_value)
                ->get()
                ->result();
        $data['count_data'] = count($row_count);
        return $data;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 07-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for checking video section exist
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_name, $video_course_id
 * @Return              : $result   
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function check_video_section_exist($section_name, $video_course_id){
        if ($this->db->table_exists('tbl_section') ){
            $result = $this->db->select('*')
                    ->from('tbl_section')
                    ->where('section_type_id', $video_course_id)
                    ->where('section_name', $section_name)
                    ->get()
                    ->row();
        }else{
            $result = 'Table not exits';
        }
        return $result;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 07-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for checking edit video section exist
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_name, $section_id, $video_course_id
 * @Return              : $result   
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function check_edit_section_exist($section_name, $section_id, $video_course_id){
        if ($this->db->table_exists('tbl_section') ){
            $result = $this->db->select('*')
                    ->from('tbl_section')
                    ->where('section_type_id', $video_course_id)
                    ->where('section_id', $section_id)
                    ->where('section_name', $section_name)
                    ->get()
                    ->row();
        }else{
            $result = 'Table not exits';
        }
        return $result;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 08-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for selecting the videos which is not assign to any section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : 
 * @Return              : $data   
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function assign_admin_video_to_section(){
        $all_manage_video_id = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->get()->result_array();
        
        foreach($all_manage_video_id as $manage_id){
            $manage_video_id[] = $manage_id['manage_video_id'];
        }
       
        if(isset($all_manage_video_id) && !empty($all_manage_video_id)){
        $data['manage_video'] = $this->db->select('*')
                ->from('tbl_manage_video')
                ->where_not_in('manage_video_id',$manage_video_id)
                ->get()->result();
        }else{
        $data['manage_video'] = $this->db->select('*')
                ->from('tbl_manage_video')
                ->get()->result();
        }
        if(isset($data['manage_video'])){
            for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                $data[$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                        ->from('tbl_manage_video_location')
                        ->where('manage_video_id', $data['manage_video'][$i]->manage_video_id)
                        ->get()->result();
            }
        }
        if(isset($data['manage_video'])){
            for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                $data['work_files'][$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                        ->from('tbl_work_files')
                        ->where('work_file_type_id', $data['manage_video'][$i]->manage_video_id)
                        ->get()->row();
            }
        }
        $manage_all_video = $this->db->select('*')
                                ->from('tbl_manage_video')
                                ->get()->result();
        $data['count_all_video']  = count($manage_all_video);
        return $data;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 08-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for inserting the section_id and manage_video_id to database for assign 
  *                       videos 
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $data
 * @Return              :    
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function save_assign_video_information($data){
        $this->db->insert('tbl_section_video', $data);
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 08-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for selecting total video of a section
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $data  
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function section_total_video_info($section_id, $limit_offset = NULL){
        $manage_video_id_info = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->get()->result_array();
        foreach($manage_video_id_info as $manage_id){
            $manage_video_id[] = $manage_id['manage_video_id'];
        }
        //$this->cf->dd($manage_video_id);
        if(isset($manage_video_id)){
           $data['manage_video'] = $this->db->select('*')
                ->from('tbl_section_video AS sv')
                ->join('tbl_manage_video AS mv','mv.manage_video_id = sv.manage_video_id')
                ->where_in('mv.manage_video_id', $manage_video_id)
                ->order_by('sv.section_video_order','asc')
                ->limit(10, $limit_offset)
                ->get()->result(); 
           if(isset($data['manage_video'])){
                for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                    $data[$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                            ->from('tbl_manage_video_location')
                            ->where('manage_video_id', $data['manage_video'][$i]->manage_video_id)
                            ->get()->result();
                }
            }
            if(isset($data['manage_video'])){
                for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                    $data['work_files'][$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                            ->from('tbl_work_files')
                            ->where('work_file_type_id', $data['manage_video'][$i]->manage_video_id)
                            ->get()->row();
                }
            }
            $all_section_video = $this->db->select('*')
                ->from('tbl_section_video AS sv')
                ->join('tbl_manage_video AS mv','mv.manage_video_id = sv.manage_video_id')
                ->where_in('mv.manage_video_id', $manage_video_id)
                ->order_by('sv.section_video_order','asc')
                ->get()->result();
            $data['count_all_video'] = count($all_section_video);
        return $data;
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for check section wheather video have or not
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $section_info  
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function check_section_video_exist($section_id){
        $section_info = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->get()
                ->result();
        return $section_info;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for ordering videos when section have more than one videos
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $data  
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function order_video_section_when_video_exist_info($section_id, $manage_video_id_info = NULL){
        //$this->cf->dd($manage_video_id);
        $all_manage_video_id = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->where_not_in('manage_video_id', $manage_video_id_info)
                ->get()
                ->result_array();
        
        if(isset($all_manage_video_id)){
            foreach($all_manage_video_id as $v_video_id){
                $manage_video_id[] = $v_video_id['manage_video_id'];
            }
        }
        //$this->cf->dd($manage_video_id);
        $data = $this->db->select('manage_video_id,manage_video_title')
                ->from('tbl_manage_video')
                ->where_in('manage_video_id', $manage_video_id)
                ->get()->result();
        return $data;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 09-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting the video info by section_id
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $result  
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_video_information_by_section_id($section_id, $moved_video_order = NULL, $subtract_value = NULL){
        $result = $this->db->select('*')
                ->from('tbl_section_video AS sv')
                ->join('tbl_manage_video AS mv','sv.manage_video_id = mv.manage_video_id')
                ->where('section_id', $section_id)
                ->limit($subtract_value, $moved_video_order)
                ->get()
                ->result();
        return $result;
                
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 16-08-2017  
 * @ModifiedDate        : 17-08-2017
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for getting the rows when we order video by clicking after from dropdown
                          and order the video from upper to lower
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id,$moved_video_order,$updated_value
 * @Return              : $result  
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_all_video_information_when_video_order_upper_to_lower($section_id,$moved_video_order,$updated_value){
        for($i = $moved_video_order+1; $i <= $updated_value; $i++){
            $moved_all_video_order[] = $i;
        }
        //$this->cf->dd($tt);
        $result = $this->db->select('*')
                ->from('tbl_section_video AS sv')
                ->join('tbl_manage_video AS mv','sv.manage_video_id = mv.manage_video_id')
                ->where('section_id', $section_id)
                ->where_in('section_video_order',$moved_all_video_order)
                ->get()
                ->result();
        return $result;
                
    }
    /*
 * @Author              : Kazol 
 * @CreatedDate         : 16-08-2017  
 * @ModifiedDate        : 17-08-2017
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for getting the rows when we order video by clicking after from dropdown
                          and order the video from lower to upper
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id,$moved_video_order,$updated_value
 * @Return              : $result  
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_all_video_information_when_video_order_lower_to_upper($section_id,$moved_video_order,$updated_value){
        for($i = $moved_video_order; $i < $updated_value; $i++){
            $moved_all_video_order[] = $i;
        }
        //$this->cf->dd($tt);
        $result = $this->db->select('*')
                ->from('tbl_section_video AS sv')
                ->join('tbl_manage_video AS mv','sv.manage_video_id = mv.manage_video_id')
                ->where('section_id', $section_id)
                ->where_in('section_video_order',$moved_all_video_order)
                ->get()
                ->result();
        return $result;
                
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting total count video in a section for ordering video in the bottom
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $data  
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function count_total_video_in_a_section($section_id){
        $result = $this->db->select('*')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->get()
                ->result();
        $data = count($result);
        return $data;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for update the previous value of the section_video_order coloumn of 
  *                       tbl_section_video for order the video in the top
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              :   
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_assign_video_information($section_id){
        $this->db->set('section_video_order', 'section_video_order+1', FALSE)
        ->where('section_id', $section_id)
        ->update('tbl_section_video');
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 10-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting all the information when selecting ordering video by selecting
                          after from the dropdown by manage video id of selected video from another dropdown list
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_id
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_section_video_id_by_manage_video_id_for_after($manage_video_id){
        $result = $this->db->select('*')
                ->from(' tbl_section_video')
                ->where('manage_video_id', $manage_video_id)
                ->get()
                ->row();
        return $result;
    }
/*
 * @Author              : Kazol 
 * @CreatedDate         : 10-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for updating the value when add video after a video before inserting
                          the video information in the database
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_video
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_value_after_specific_row($section_video){
        
       foreach($section_video['section_video_id'] as $section_video_id){
            $data['section_video_order'] = $section_video['section_video_order'][$section_video_id];
            $this->db->where('section_video_id', $section_video_id)
                    ->update('tbl_section_video', $data);
          }
    }
/*
 * @Author              : Kazol 
 * @CreatedDate         : 13-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for move the video to top/bottom from any position
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id, $manage_video_id, $updated_value
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_move_video_information($section_id, $manage_video_id, $updated_value){
        $this->db->set('section_video_order', $updated_value, FALSE)
        ->where('section_id', $section_id)
        ->where('manage_video_id', $manage_video_id)
        ->update('tbl_section_video');
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 13-08-2017  
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting all the information by manage_video_id when click after
                          from dropdown for moving the video
 * @view                : 
 * @redirect            : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_id_for_after
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_section_video_id_by_move_video_id_for_after($manage_video_id_for_after){
        $result = $this->db->select('*')
                ->from(' tbl_section_video')
                ->where('manage_video_id', $manage_video_id_for_after)
                ->get()
                ->row();
        return $result;
    }
/*
 * @Author              : Kazol 
 * @CreatedDate         : 17-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for delete a video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id, $manage_video_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_single_section_video_info($manage_video_id){
        $this->db->where('manage_video_id', $manage_video_id)
                ->delete('tbl_section_video');
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 17-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for delete a section and it contains all videos and workfiles
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id, $video_course_id
 * @Return              :     
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_single_section_with_contains($section_id, $video_course_id){
        //$this->cf->dd($section_id);
        $this->db->where('section_type_id', $video_course_id)
                ->where('section_id', $section_id)
                ->delete('tbl_section');
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 19-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for getting the video and workfile location by manage_video_id
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_id
 * @Return              : $data    
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_video_location_for_assign_video($manage_video_id){
        $data['manage_video_location'] = $this->db->select('*')
                ->from('tbl_manage_video_location')
                ->where('manage_video_id', $manage_video_id)
                ->get()
                ->result();
        $data['manage_video_workfile'] = $this->db->select('work_file_location')
                ->from('tbl_work_files')
                ->where('work_file_type_id', $manage_video_id)
                ->get()
                ->result();
        
        return $data;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 19-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for getting video course url by video course id for creating video course 
  *                       folder
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $video_course_id
 * @Return              : $video_course_url    
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_video_course_url($video_course_id){
        
        $url_id = $this->db->select('url_id')
                ->from('tbl_video_course')
                ->where('video_course_id', $video_course_id)
                ->get()->row();
//        $this->cf->dd($url_id);
        $video_course_url = $this->db->select('url')
                ->from('tbl_url')
                ->where('url_id', $url_id->url_id)
                ->get()->row();
        return $video_course_url;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 19-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for updating manage video location 
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_id, $manage_video_location_id, $vmdata
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_video_location($manage_video_id, $manage_video_location_id, $vmdata){
        $this->db->where('manage_video_id', $manage_video_id)
                ->where('manage_video_location_id', $manage_video_location_id)
                ->update('tbl_manage_video_location', $vmdata);
      
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 19-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : Kazol
 * @Route               : 
 * @Description         : This function is used for updating manage workfile location 
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_id, $wmdata
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function update_workfile_location($manage_video_id, $wmdata){
        $this->db->where('work_file_type_id', $manage_video_id)
                ->update('tbl_work_files', $wmdata);
      
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 19-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting video course id by section id
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $result->section_type_id
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_video_course_id_by_section_id($section_id){
        $result = $this->db->select('section_type_id')
                ->from('tbl_section')
                ->where('section_id', $section_id)
                ->get()
                ->row();
        return $result->section_type_id;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 20-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting all video information for deleting a single section videos
                          from content library
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $this->db->get()->result()
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_video_information($section_id){
        $all_manage_video_id = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->get()
                ->result_array();
        
        if(isset($all_manage_video_id)){
            foreach($all_manage_video_id as $v_video_id){
                $manage_video_id[] = $v_video_id['manage_video_id'];
            }
        }
        
        $this->db->select('*')
                ->from('tbl_manage_video AS mv')
                ->join('tbl_manage_video_location AS mvl', 'mv.manage_video_id = mvl.manage_video_id')
                ->where_in('mv.manage_video_id', $manage_video_id);
        return $this->db->get()->result();
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 20-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting all workfile information for deleting a single section workfile
                          from content library
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : $this->db->get()->result()
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_workfile_information($section_id){
        $all_manage_video_id = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->get()
                ->result_array();
        
        if(isset($all_manage_video_id)){
            foreach($all_manage_video_id as $v_video_id){
                $work_file_type_id[] = $v_video_id['manage_video_id'];
            }
        }
        
        $this->db->select('*')
            ->from('tbl_work_files')
            ->where_in('work_file_type_id', $work_file_type_id);
        return $this->db->get()->result();
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 20-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for delete a single video section and its all contains from database
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $section_id
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_section_video_info($section_id){
        $all_manage_video_id = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->get()
                ->result_array();
        
        if(isset($all_manage_video_id)){
            foreach($all_manage_video_id as $v_video_id){
                $manage_video_id[] = $v_video_id['manage_video_id'];
            }
        }
        $this->db->where_in('manage_video_id',$manage_video_id);
        $this->db->delete('tbl_manage_video');
        
        $this->db->where_in('manage_video_id',$manage_video_id);
        $this->db->delete('tbl_manage_video_location');
        
        $this->db->where('section_id',$section_id);
        $this->db->delete('tbl_section_video');
        
        $this->db->where_in('work_file_type_id', $manage_video_id);
        $this->db->delete('tbl_work_files');
    }
/*
 * @Author              : Kazol 
 * @CreatedDate         : 22-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for search video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $search_value, $manage_admin_video_status, $section_id, $limit_offset
 * @Return              : $data
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function search_section_video_info($search_value, $manage_admin_video_status, $section_id, $limit_offset){
        if($manage_admin_video_status == 0){
            $manage_video_status = array(1,2);
        }else{
            $manage_video_status = $manage_admin_video_status;
        }
        $manage_video_id_info = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where('section_id', $section_id)
                ->get()->result_array();
        foreach($manage_video_id_info as $manage_id){
            $manage_video_id[] = $manage_id['manage_video_id'];
        }
        if(isset($manage_video_id)){
           $data['manage_video'] = $this->db->select('*')
                ->from('tbl_section_video AS sv')
                ->join('tbl_manage_video AS mv','mv.manage_video_id = sv.manage_video_id')
                ->like('mv.manage_video_title', $search_value, 'both')
                ->where_in('mv.manage_video_id', $manage_video_id)
                ->where_in('mv.manage_video_status', $manage_video_status)
                ->order_by('sv.section_video_order','asc')
                ->limit(10, $limit_offset)
                ->get()->result();
           
           if(isset($data['manage_video'])){
                for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                    $data[$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                            ->from('tbl_manage_video_location')
                            ->where('manage_video_id', $data['manage_video'][$i]->manage_video_id)
                            ->get()->result();
                }
            }
            if(isset($data['manage_video'])){
                for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                    $data['work_files'][$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                            ->from('tbl_work_files')
                            ->where('work_file_type_id', $data['manage_video'][$i]->manage_video_id)
                            ->get()->row();
                }
            }
            $all_section_video = $this->db->select('*')
                ->from('tbl_section_video AS sv')
                ->join('tbl_manage_video AS mv','mv.manage_video_id = sv.manage_video_id')
                ->like('mv.manage_video_title', $search_value, 'both')
                ->where_in('manage_video_status', $manage_video_status)
                ->where_in('mv.manage_video_id', $manage_video_id)
                ->order_by('sv.section_video_order','asc')
                ->get()->result();
            $data['count_all_video'] = count($all_section_video);
        return $data;
        }
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting the location information of a single resolution video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_location_id
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function select_section_video_location_info($manage_video_location_id){
        $result = $this->db->select('*')
                ->from('tbl_manage_video_location AS mvl')
                ->join('tbl_manage_video AS mv','mv.manage_video_id = mvl.manage_video_id')
                ->where('manage_video_location_id', $manage_video_location_id)
                ->get()
                ->row();
        return $result;
    }
  /*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting all information of a single video of a section by manage_video_id
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_id
 * @Return              : $result
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function select_section_video_info($manage_video_id){
        //$this->cf->dd($manage_video_id);
        $result = $this->db->select('*')
                ->from('tbl_manage_video AS mv')
                ->join('tbl_manage_video_location AS mvl','mvl.manage_video_id = mv.manage_video_id')
                ->where('mv.manage_video_id', $manage_video_id)
                ->get()
                ->result();
        return $result;
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for delete single resolution video of a single video of a section
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_location_id
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_section_single_resolution_video($manage_video_location_id){
        $this->db->where('manage_video_location_id',$manage_video_location_id);
        $this->db->delete('tbl_manage_video_location');
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for getting workfile information by manage_video_id
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $manage_video_id
 * @Return              : $this->db->get()->row()
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function get_section_video_workfile_information_by_work_file_type_id($manage_video_id){
        $this->db->select('*')
            ->from('tbl_work_files')
            ->where('work_file_type_id', $manage_video_id);
        return $this->db->get()->row();
    }
 /*
 * @Author              : Kazol 
 * @CreatedDate         : 23-08-2017 
 * @ModifiedDate        : 
 * @ModifiedBy          : 
 * @Route               : 
 * @Description         : This function is used for delete workfile of a single video of a section and updated the 
                          manage_video_work_file into 2
 * @view                : 
 * @deprecated          : 
 * @exception           : 
 * @inheritDoc          : 
 * @Parameter           : $work_file_type_id
 * @Return              : 
 * @value               : 
 * @Status              : active
 * @version             : v2.1         
 */
    public function delete_section_video_workfile($work_file_type_id){
        $this->db->where('work_file_type_id', $work_file_type_id);
        $this->db->delete('tbl_work_files');
        
        $manage_video['manage_video_work_file'] = 2;
        $this->db->where('manage_video_id', $work_file_type_id);
        $this->db->update('tbl_manage_video', $manage_video);
    }
}
