<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Manage_video_course_meta_model extends CI_Model {
    
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : manage-video-course-meta/(.+)
     * @Description         : This function is used for insert the meta data into the tbl_meta 
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function add_video_course_meta_info($video_course_id){
        $meta_keywords = $this->input->post('to_address', TRUE);
        $meta_keyword_array = explode(",", $meta_keywords);
        for ($i = 0; $i < count($meta_keyword_array) - 1; $i++) {
            $data['meta_title'] = $this->input->post('meta_title');
            $data['meta_url'] = $this->input->post('meta_url');
            $data['meta_keywords'] = $meta_keyword_array[$i];
            $data['meta_description'] = $this->input->post('meta_description');
            $data['meta_author'] = $this->input->post('meta_author');
            $data['meta_type'] = 3;
            $data['meta_type_id'] = $video_course_id;
            $this->db->insert('tbl_meta', $data);
        }
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : manage-video-course-meta/(.+)
     * @Description         : This function is used for getting meta title of a video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $get_meta
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function manage_video_course_meta_info($video_course_id){
        $get_meta = $this->db->select('meta_title')
                ->from('tbl_meta')
                ->where('meta_type_id', $video_course_id)
                ->get()
                ->row();
        //$this->cf->dd($get_meta);
        return $get_meta;
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : edit-video-course-meta/(.+)
     * @Description         : This function is used for getting all meta information except meta keywords of a video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $get_meta_for_edit
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function edit_video_course_meta_info($video_course_id){
        $get_meta_for_edit = $this->db->select('*')
                ->from('tbl_meta')
                ->where('meta_type_id', $video_course_id)
                ->get()
                ->row();
        //$this->cf->dd($get_meta);
        return $get_meta_for_edit;
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : edit-video-course-meta/(.+)
     * @Description         : This function is used for getting only meta keywords of a video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $get_meta_keywords
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function get_meta_keywords_for_edit_meta($video_course_id){
        $get_meta_keywords = $this->db->select('meta_keywords')
                ->from('tbl_meta')
                ->where('meta_type_id', $video_course_id)
                ->get()
                ->result();
        //$this->cf->dd($get_meta);
        return $get_meta_keywords;
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 16-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : update-video-course-meta/(.+)
     * @Description         : This function is used for updating meta information of a video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function update_video_course_meta_info($video_course_id){
        $this->db->where('meta_type_id', $video_course_id);
        $this->db->delete('tbl_meta');
        $meta_keywords = $this->input->post('to_address', TRUE);
        $meta_keyword_array = explode(",", $meta_keywords);
        for ($i = 0; $i < count($meta_keyword_array) - 1; $i++) {
            $data['meta_title'] = $this->input->post('meta_title');
            $data['meta_url'] = $this->input->post('meta_url');
            $data['meta_keywords'] = $meta_keyword_array[$i];
            $data['meta_description'] = $this->input->post('meta_description');
            $data['meta_author'] = $this->input->post('meta_author');
            $data['meta_type'] = 3;
            $data['meta_type_id'] = $video_course_id;
            $this->db->insert('tbl_meta', $data);
        }
    }
}
