<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Manage_admin_video_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 12-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Admin add video data in db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Function            : add_admin_video_location_info() is used for insert manage video location by following resulation
     * @Parameter           : $manage_video is used for get admin upload video all information to insert in db
                              $manage_video_location is used for get admin upload video location to insert in db
     * @Return              : admin upload video manage_video_id       
     * @value               : $admin_video_data is used for get manage_video_id from db 
                              $admin_video_location_data array is used for insert admin upload video location information in db 
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_admin_video_info($manage_video, $manage_video_location){
        $this->db->insert('tbl_manage_video', $manage_video);
        
        $admin_video_data = $this->db->select('manage_video_id')
                            ->from('tbl_manage_video')
                            ->order_by('manage_video_id', 'DESC')
                            ->limit(1)
                            ->get()->row();
        
        if(isset($manage_video_location['manage_video_location_1080p'])){
            $this->add_admin_video_location_info($admin_video_data->manage_video_id, $manage_video_location['manage_video_location_1080p'], '1080p');
        }
        if(isset($manage_video_location['manage_video_location_720p'])){
            $this->add_admin_video_location_info($admin_video_data->manage_video_id, $manage_video_location['manage_video_location_720p'], '720p');
        }
        if(isset($manage_video_location['manage_video_location_360p'])){
            $this->add_admin_video_location_info($admin_video_data->manage_video_id, $manage_video_location['manage_video_location_360p'], '360p');
        }
        if(isset($manage_video_location['manage_video_location_144p'])){
            $this->add_admin_video_location_info($admin_video_data->manage_video_id, $manage_video_location['manage_video_location_144p'], '144p');
        }
        return $admin_video_data->manage_video_id;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 12-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Admin add video data in db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Used in             : add_admin_video_info()
     * @Parameter           : $manage_video_id is used for get admin upload video id
                              $manage_video_location is used for get admin upload video location to insert in db
                              $manage_video_location_resolution is used for get admin upload video resolution to insert in db
     * @Return              : Null     
     * @value               : $admin_video_location_data array is used for insert admin upload video location, resolution information in db 
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_admin_video_location_info($manage_video_id, $manage_video_location, $manage_video_location_resolution){
        $admin_video_location = array(
                'manage_video_id' => $manage_video_id,
                'manage_video_location' => $manage_video_location,
                'manage_video_location_resolution' => $manage_video_location_resolution
            );
        $this->db->insert('tbl_manage_video_location', $admin_video_location);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 13-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Admin add video data in db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $manage_video_id is used for get manage_video_id
                              $manage_video is used for get admin upload video all information to update in db
                              $manage_video_location is used for get admin upload video location to update in db
     * @Return              : null      
     * @value               : null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function update_admin_video_info($manage_video_id, $manage_video, $manage_video_location){
        $this->db->where('manage_video_id', $manage_video_id);
        $this->db->update('tbl_manage_video', $manage_video);
        
        if(isset($manage_video_location) && !empty($manage_video_location)){
            $this->db->where('manage_video_id', $manage_video_id);
            $this->db->delete('tbl_manage_video_location');
        }
        if(isset($manage_video_location['manage_video_location_1080p'])){
            $this->add_admin_video_location_info($manage_video_id, $manage_video_location['manage_video_location_1080p'],'1080p');
        }
        if(isset($manage_video_location['manage_video_location_720p'])){
            $this->add_admin_video_location_info($manage_video_id, $manage_video_location['manage_video_location_720p'],'720p');
        }
        if(isset($manage_video_location['manage_video_location_360p'])){
            $this->add_admin_video_location_info($manage_video_id, $manage_video_location['manage_video_location_360p'],'360p');
        }
        if(isset($manage_video_location['manage_video_location_144p'])){
            $this->add_admin_video_location_info($manage_video_id, $manage_video_location['manage_video_location_144p'],'144p');
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 12-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Admin add video data in db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $manage_video_id is used for pass admin upload video manage_video_id
     * @Return              : admin upload video all information           
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_admin_video_information_by_manage_video_id($manage_video_id){
        $this->db->select('*')
                ->from('tbl_manage_video AS mv')
                ->join('tbl_manage_video_location AS mvl', 'mv.manage_video_id = mvl.manage_video_id')
                ->where('mv.manage_video_id', $manage_video_id);
        return $this->db->get()->result();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 23-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Get Admin all video data from db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : Null
     * @Return              : admin uploaded all video information           
     * @value               : $data['manage_video'] is used to keep all video information
     *                          $data[$data['manage_video'][$i]->manage_video_id] is used for keep individual video location information
     *                          $data['work_files'][$data['manage_video'][$i]->manage_video_id] is used for keep video workfile information (if have)
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function manage_admin_video_info($limit_offset = NULL) {
        $data['manage_video'] = $this->db->select('*')
                ->from('tbl_manage_video')
                ->limit(10, $limit_offset)
                ->get()->result();
        if(isset($data['manage_video'])){
            for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                $data[$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                        ->from('tbl_manage_video_location')
                        ->where('manage_video_id', $data['manage_video'][$i]->manage_video_id)
                        ->get()->result();
            }
        }
        if(isset($data['manage_video'])){
            for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                $data['work_files'][$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                        ->from('tbl_work_files')
                        ->where('work_file_type_id', $data['manage_video'][$i]->manage_video_id)
                        ->get()->row();
            }
        }
        $manage_all_video = $this->db->select('*')
                                        ->from('tbl_manage_video')
                                        ->get()->result();
        $data['count_all_video']  = count($manage_all_video);
        return $data;
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Admin add video workfile data in db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $work_files is used for get admin upload workfiles data to insert in db
     * @Return              : insert_id     
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_admin_video_workfile_info($work_files){
        $manage_video['manage_video_work_file'] = 1;
        $this->db->where('manage_video_id', $work_files['work_file_type_id']);
        $this->db->update('tbl_manage_video', $manage_video);
        
        $this->db->insert('tbl_work_files', $work_files);
        return $this->db->insert_id();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Admin update video workfile data in db 
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $work_file_id is used for get admin workfiles id 
     *                        $work_files is used for get admin upload workfiles data to insert in db
     * @Return              : Null     
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function update_admin_video_work_file_info($work_file_id, $work_files){
        $this->db->where('work_file_id', $work_file_id);
        $this->db->update('tbl_work_files', $work_files);
        
        $work_files_info = $this->db->select('*')
                ->from('tbl_work_files')
                ->where('work_file_id',$work_file_id)
                ->get()->row();
        $manage_video['manage_video_work_file'] = 1;
        $this->db->where('manage_video_id', $work_files_info->work_file_type_id);
        $this->db->update('tbl_manage_video', $manage_video);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Get workfile information by work file id
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $work_file_id is used for get admin workfiles id 
     * @Return              : workfile info     
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_admin_workfile_information_by_work_file_id($work_file_id){
        $this->db->select('*')
                ->from('tbl_work_files')
                ->where('work_file_id', $work_file_id);
        return $this->db->get()->row();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 25-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Get Admin all video data from db by $manage_video_location_id
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $manage_video_location_id
     * @Return              : single video all information           
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_admin_video_information_by_manage_video_location_id($manage_video_location_id){             
        $this->db->select('*')
                ->from('tbl_manage_video_location AS mvl')
                ->join('tbl_manage_video AS mv', 'mvl.manage_video_id = mv.manage_video_id')
                ->where('mvl.manage_video_location_id', $manage_video_location_id);
        return $this->db->get()->row();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 25-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : insert user location information
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $geo_information
     * @Return              : geo_information_id from db          
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_geo_information_info($geo_information){
        $this->db->insert('tbl_geo_information', $geo_information);
        return $this->db->insert_id();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 25-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : insert view content information in db
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $view_content_info
     * @Return              : view_content_info_id from db          
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_view_content_info($view_content_info){
        $this->db->insert('tbl_view_content_info', $view_content_info);
        return $this->db->insert_id();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 25-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : insert user view content information
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $person_view_content_info
     * @Return              : Null       
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function add_person_view_content_info($person_view_content_info){
        $this->db->insert('tbl_person_view_content_info', $person_view_content_info);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Get workfile information by work file type id
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $work_file_type_id is used for get admin $work_file_type_id  
     * @Return              : workfile info     
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_admin_workfile_information_by_work_file_type_id($work_file_type_id){
        $this->db->select('*')
            ->from('tbl_work_files')
            ->where('work_file_type_id', $work_file_type_id);
        return $this->db->get()->row();
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Delete video all information, video file, workfile(if have)
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $manage_video_id is used for get admin video all information  
     * @Return              : Null     
     * @value               : $work_file is used to keep work file info(if have) for delete
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_admin_video_info($manage_video_id){
        $this->db->where('manage_video_id',$manage_video_id);
        $this->db->delete('tbl_manage_video');
        
        $this->db->where('manage_video_id',$manage_video_id);
        $this->db->delete('tbl_manage_video_location');
        
        $section_video_exist = $this->db->select('*')
                ->from('tbl_section_video')
                ->where('manage_video_id', $manage_video_id)
                ->get()->result();
        if(isset($section_video_exist)){
            $this->db->where('manage_video_id',$manage_video_id);
            $this->db->delete('tbl_section_video');
        }
        
        $work_file = $this->get_admin_workfile_information_by_work_file_type_id($manage_video_id);
        if($work_file){
            $this->db->where('work_file_type_id', $manage_video_id);
            $this->db->delete('tbl_work_files');
        }
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 27-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Delete single resolution video location information
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $manage_video_location_id is used for get admin video manage_video_location_id information  
     * @Return              : Null     
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_single_resolution_video($manage_video_location_id){
        $this->db->where('manage_video_location_id',$manage_video_location_id);
        $this->db->delete('tbl_manage_video_location');
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 29-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Delete video workfile information
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $work_file_type_id is used for get admin workfile work_file_type_id information  
     * @Return              : Null     
     * @value               : Null
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function delete_admin_video_workfile($work_file_type_id){
        $this->db->where('work_file_type_id', $work_file_type_id);
        $this->db->delete('tbl_work_files');
        
        $manage_video['manage_video_work_file'] = 2;
        $this->db->where('manage_video_id', $work_file_type_id);
        $this->db->update('tbl_manage_video', $manage_video);
    }
    
    /**
     * @Author              : Md. Delwar Hossain    
     * @CreatedDate         : 29-07-17   
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : Search video all information
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $search_value is used for get search_value  
     *                          $manage_admin_video_status is used for get manage_admin_video_status  
     * @Return              : $data     
     * @value               : $data['manage_video'] is used for get all video info
     *                          $data[$data['manage_video'][$i]->manage_video_id] is used for get video location info
     *                          $data['work_files'][$data['manage_video'][$i]->manage_video_id] is used for get video workfile info
     *                          $data['count_all_video'] is used for count video info
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function search_admin_video_info($search_value, $manage_admin_video_status, $limit_offset = NULL){
        if($manage_admin_video_status == 0){
            $manage_video_status = array(1,2);
        }else{
            $manage_video_status = $manage_admin_video_status;
        }
        
        $data['manage_video'] = $this->db->select('*')
                ->from('tbl_manage_video')
                ->like('manage_video_title', $search_value, 'both')
                ->limit(10, $limit_offset)
                ->where_in('manage_video_status', $manage_video_status)
                ->get()->result();
        if(isset($data['manage_video'])){
            for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                $data[$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                        ->from('tbl_manage_video_location')
                        ->where('manage_video_id', $data['manage_video'][$i]->manage_video_id)
                        ->get()->result();
            }
        }
        if(isset($data['manage_video'])){
            for ($i = 0; $i < (count($data['manage_video'])); $i++) {
                $data['work_files'][$data['manage_video'][$i]->manage_video_id] = $this->db->select('*')
                        ->from('tbl_work_files')
                        ->where('work_file_type_id', $data['manage_video'][$i]->manage_video_id)
                        ->get()->row();
            }
        }
        
        $manage_all_video = $this->db->select('*')
                                        ->from('tbl_manage_video')
                                        ->like('manage_video_title', $search_value, 'both')
                                        ->where_in('manage_video_status', $manage_video_status)
                                        ->get()->result();
        $data['count_all_video']  = count($manage_all_video);
        return $data;
    }
    /**
     * @Author              : Kazol
     * @CreatedDate         : 22-08-2017 
     * @ModifiedDate        : Null
     * @ModifiedBy          : Null
     * @Route               : Null
     * @Description         : This function is used for getting video course url by manage video id for video course 
                              folder to edit the video of a section  
     * @view                : Null
     * @redirect            : Null
     * @deprecated          : No
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $manage_video_id
     * @Return              : $video_course_url->url     
     * @value               : 
     * @Status              : Available
     * @version             : v2.1       
    * */
    public function get_video_course_url_by_manage_video_id($manage_video_id){
        
        $section_id = $this->db->select('section_id')
                ->from('tbl_section_video')
                ->where('manage_video_id', $manage_video_id)
                ->get()->row();
        
        if(isset($section_id)){
            $video_course_id = $this->db->select('section_type_id')
                ->from('tbl_section')
                ->where('section_id', $section_id->section_id)
                ->get()->row();
            
            $video_course_id = $video_course_id->section_type_id;
            
            $url_id = $this->db->select('url_id')
                    ->from('tbl_video_course')
                    ->where('video_course_id', $video_course_id)
                    ->get()->row();
    
            $video_course_url = $this->db->select('url')
                    ->from('tbl_url')
                    ->where('url_id', $url_id->url_id)
                    ->get()->row();
            return $video_course_url->url;
        }
    }
}

