<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Manage_admin_video_course_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 20-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting all parent topic
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function select_all_parent_topic_if_child_exists() {
        $topic_id = $this->get_parent_topic_id_if_child();
        $this->db->select('*')
                ->from('tbl_topic')
                ->where_in('topic_id', explode(',', $topic_id))
                ->where_in('topic_status', Array(1, 5));
        return $this->db->get()->result();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 20-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting all parent topic if child exists
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :  $this->db->get()->row()->parent_topic_id;    
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function get_parent_topic_id_if_child() {
        $this->db->select('GROUP_CONCAT(DISTINCT(parent_topic_id))  AS parent_topic_id')
                ->from('tbl_topic')
                ->where("parent_topic_id != '0'")
                ->where_in('topic_status', Array(1, 5));
        return $this->db->get()->row()->parent_topic_id;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 20-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting all resource person
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :  $result;    
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function select_all_resource_person() {
        $result = $this->db->select('*')
                ->from('tbl_person AS p')
                ->join('tbl_resource_person AS rp', 'rp.person_id = p.person_id')
                ->where('resource_person_type', 1)
                ->where('person_status', 1)
                ->get()
                ->result();
        return $result;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 22-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting all child topic of a parent topic
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              :      
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function get_all_child_topic_by_parent_topic_id($parent_topic_id) {
        $this->db->select('*')
                ->from('tbl_topic')
                ->where('parent_topic_id', $parent_topic_id)
                ->where_in('topic_status', Array(1, 5));
        return $this->db->get()->result();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 22-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting the search language when video course add
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : $result     
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function search_admin_video_course_language_info($search_text) {
        $result = $this->db->select('*')
                        ->from('tbl_language')
                        ->order_by('language_name', 'ASC')
                        ->like('language_name', $search_text, 'after')
                        ->get()->result();

        return $result;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 23-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting all language for add video course search language
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : $result     
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function select_all_language() {
        $result = $this->db->select('*')
                ->from('tbl_language')
                ->get()
                ->result();
        return $result;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 23-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for saving video course url
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $url_name,$url_type
     * @Return              : $this->db->insert_id()     
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function save_video_course_url($url_name, $url_type) {
        $data['url'] = $url_name;
        $data['url_type'] = $url_type;
        $this->db->insert('tbl_url', $data);

        return $this->db->insert_id();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 23-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for saving video course information in the database
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $data
     * @Return              :    
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function add_admin_video_course_info($data) {
        $this->db->insert('tbl_video_course', $data);
        return $this->db->insert_id();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 24-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for saving video course other topic in the database
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $tdata
     * @Return              : $this->db->insert_id()  
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function save_other_topic_when_add_video_course($tdata) {
        $this->db->insert('tbl_topic', $tdata);
        return $this->db->insert_id();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 24-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for saving video course price information in the database
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $pdata
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function save_video_course_price_info($pdata) {
        $this->db->insert('tbl_price',$pdata);
    }

    public function update_video_course_price_info($pdata,$video_course_id) {
        $tt = $this->db->select('*')
                ->from('tbl_price')
                ->where('price_type_id',$video_course_id)
                ->get()
                ->row();
        if(isset($tt)){
            $this->db->where('price_type_id',$video_course_id)
                    ->update('tbl_price', $pdata);
        }else{
            $this->save_video_course_price_info($pdata);
        }
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 24-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for selecting all the data from video course table by 
     *                       joining tbl_person and tbl_topic
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function manage_admin_video_course_info() {
        $result = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_person AS p', 'vc.person_id = p.person_id')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->get()->result();
        return $result;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 24-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for delete admin video course information from database
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : 
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function delete_admin_video_course_info($video_course_id) {
        $this->db->where('video_course_id', $video_course_id)
                ->delete('tbl_video_course');
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 25-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for selecting video course information from database by joining table 
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function edit_admin_video_course_info($video_course_id) {
        $result = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_resource_person AS rp', 'vc.resource_person_id = rp.resource_person_id')
                        ->join('tbl_person AS p', 'rp.person_id = p.person_id')
                        ->join('tbl_language AS l', 'vc.language_id = l.language_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->where('vc.video_course_id', $video_course_id)
                        ->get()->row();
        return $result;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 25-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for update video course information by video course id 
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id,$data
     * @Return              : 
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function update_admin_video_course_info($video_course_id, $data) {
        $this->db->where('video_course_id', $video_course_id)
                ->update('tbl_video_course', $data);
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 26-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for search video course by video course title or creator or topic
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $search_text
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function search_admin_video_course_info($search_text, $admin_video_course_publication_status, $admin_video_course_payment_type, $limit_offset = NULL){
        if($admin_video_course_publication_status == 0){
            $video_course_publication_status = array(1,2,3,4,5,6);
        }else{
            $video_course_publication_status = $admin_video_course_publication_status;
        }
        
        if($admin_video_course_payment_type == 0){
            $video_course_payment_type = array(1,2);
        }else{
            $video_course_payment_type = $admin_video_course_payment_type;
        }
        
        $data['video_course'] = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_person AS p', 'vc.person_id = p.person_id')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->where_in('video_course_publication_status', $video_course_publication_status)
                        ->where_in('video_course_payment_type', $video_course_payment_type)
                        ->like('vc.video_course_title', $search_text)
                        ->limit(10, $limit_offset)
                        ->get()->result();
        
        $all_video_course = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_person AS p', 'vc.person_id = p.person_id')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->order_by('vc.video_course_title', 'ASC')
                        ->where_in('video_course_publication_status', $video_course_publication_status)
                        ->where_in('video_course_payment_type', $video_course_payment_type)
                        ->like('vc.video_course_title', $search_text)
                        ->get()->result();
        $data['count_all_video_course']  = count($all_video_course);
        return $data;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 26-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for selecting 10 video course depend on page number
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $limit_offset
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function manage_limit_admin_video_course_info($limit_offset,$sort_by = '') {
        //$this->cf->dd($sort_by);
        $video_course_id = $this->session->userdata("video_course_id");
        $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_person AS p', 'vc.person_id = p.person_id')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id');
                        if($video_course_id != ''){
                            $this->db->where('vc.video_course_id !=', $video_course_id);
                        }
                        if ($sort_by != '') {
                            $this->db->order_by('vc.video_course_title', $sort_by);
                        }
                        $this->db->order_by('vc.video_course_id', 'desc');
                        $this->db->limit(10, $limit_offset);
                        
        return $this->db->get()->result();
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 26-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for seleting single video course information by url id
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_url
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function view_single_video_course_info($video_course_url) {
        $result = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_resource_person AS rp', 'vc.resource_person_id = rp.resource_person_id')
                        ->join('tbl_person AS p', 'rp.person_id = p.person_id')
                        ->join('tbl_language AS l', 'vc.language_id = l.language_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->where('u.url', $video_course_url)
                        ->get()->row();
        return $result;
    }

    /*
     * @Author              : Kazol 
     * @CreatedDate         : 27-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for check video course url exist
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $url
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */

    public function check_url($url) {
        $result = $this->db->select('url')
                ->from('tbl_url')
                ->where('url', $url)
                ->get()
                ->row();
        return $result;
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 31-07-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for select video course price by video course id
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function select_video_course_price($video_course_id) {
        $result = $this->db->select('*')
                        ->from('tbl_price')
                        ->where('price_type_id', $video_course_id)
                        ->get()->row();
        return $result;
    }
    /*
     * @Author              : Kazol 
     * @CreatedDate         : 02-08-2017  
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for select for highlight add edit video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $result
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function highlight_add_edit_admin_video_course($video_course_id) {
        $result = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_person AS p', 'vc.person_id = p.person_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->where('video_course_id', $video_course_id)
                        ->get()->row();
        return $result;
    }
    
    public function change_video_course_status($video_management_id, $status){
        switch ($status) {
                case 'Draft':
                    $this->db->set('video_course_publication_status', 1);
                    break;
                case 'Published':
                    $this->db->set('video_course_publication_status', 2);
                    break;
                case 'Pending':
                    $this->db->set('video_course_publication_status', 3);
                    break;
                case 'Archived':
                    $this->db->set('video_course_publication_status', 4);
                    break;
                
            }
            $this->db->where('video_course_id', $video_management_id);
            $this->db->update('tbl_video_course');
    }
}
