<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Description of image_model => All Kinf Image Model
 *
 * @Author MD Jaherul Islam
 * @Created Date : 01-08-16
 */
class Image_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @Function            : upload_file 
     * @Description         : upload file in file path and return all file information
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-06-2016 12:36 PM 
     * @Parameter           : $upload_path (Uploaded file path), 
     *                        $allow_type (Allow file type), 
     *                        $max_size (Maximun file size), 
     *                        $file (file name)
     * @Return              : $file_uploaded_data[Array]        
     * @Status              : available      
     * */
    function upload_file($upload_path, $allow_type, $max_size, $file) {
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = $allow_type;
        $config['max_size'] = $max_size;
        $config['encrypt_name'] = TRUE;
        $this->load->library('upload', $config);

        $this->upload->do_upload($file);
        return $this->upload->data();
    }

    /**
     * @Function            : check_image_orientation 
     * @Description         : check imge orientation
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-06-2016 01:24 PM 
     * @Parameter           : $image_data (Uploaded image data), 
     *                        $image_path (Uploaded image path)
     * @Return              : $image_path (Uploaded image path)
     * @Status              : available      
     * */
    function check_image_orientation($image_data, $image_path) {
        $final_image_path = '';
        $orientation_array = Array(3, 6, 8);
        if (in_array($image_data['Orientation'], $orientation_array)) {
            switch ($image_data['Orientation']) {
                case 3: // 180 rotate left
                    $final_image_path = $this->rotate_image($image_path, 180);  // rotate image 180 degree if orientation is 3
                    break;

                case 6: // 90 rotate right
                    $final_image_path = $this->rotate_image($image_path, 90); // rotate image 90 degree if orientation is 3
                    break;

                case 8:    // 90 rotate left
                    $image_path1 = $this->rotate_image($image_path, 90); // rotate image 90 degree if orientation is 3
                    $final_image_path = $this->rotate_image($image_path1, 180);  // rotate image 180 degree if orientation is 3
                    break;
            }
        } else {
            $final_image_path = $image_path;
        }
        return $final_image_path;
    }

    /**
     * @Function            : create_thumbnail_image 
     * @Description         : create thumbnail image format
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 21-06-2016 09:58 AM   
     * @Parameter           : $upload_directory (Uploaded image Directory), 
     *                        $image_path (Uploaded image path)
     * @Return              : Null
     * @Status              : available      
     * */
    function create_thumbnail_image($upload_directory, $image_path) {
        $config['image_library'] = 'GD2';
        $config['new_image'] = $upload_directory;
        $config['source_image'] = $image_path;
        $config['maintain_ratio'] = TRUE;
        $config['width'] = '100';
        $config['height'] = '100';

        $this->image_lib->clear();
        $this->image_lib->initialize($config);
        $this->image_lib->resize();
    }

    /**
     * @Function            : rotate_image 
     * @Description         : rotate image 
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 16-06-2016 01:24 PM 
     * @Parameter           : $image_path (Uploaded image Directory), 
     *                        $degree (Uploaded image rotate degree)
     * @Return              : $image_path (Uploaded image path)  
     * @Status              : available      
     * */
    function rotate_image($image_path, $degree) {
        $config['image_library'] = 'imagemagick';
        $config['library_path'] = '/usr/bin/';
        $config['source_image'] = $image_path;
        $config['rotation_angle'] = $degree;

        $this->image_lib->initialize($config);
        $this->image_lib->rotate();
        return $image_path;
    }

    /**
     * @Function            : crop_image 
     * @Description         : crop image
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-06-2016 09:57 PM  
     * @Parameter           : $cropping_top (Image Croping in top position),
     *                        $cropping_left (Image Croping in left position), 
     *                        $cropping_height (Image Croping in height), 
     *                        $cropping_width (Image Croping in width), 
     *                        $image_path (Uploaded image Directory)
     * @Return              : $image_path (Uploaded image path)   
     * @Status              : available      
     * */
    function crop_image($cropping_top, $cropping_left, $cropping_height, $cropping_width, $image_path) {
        $image_config['image_library'] = 'imagemagick';
        $image_config['library_path'] = '/usr/bin/';
        $image_config['source_image'] = $image_path;
        $image_config['quality'] = "100%";
        $image_config['maintain_ratio'] = FALSE;
        $image_config['width'] = $cropping_width;
        $image_config['height'] = $cropping_height;
        $image_config['x_axis'] = $cropping_left;
        $image_config['y_axis'] = $cropping_top;

        $this->image_lib->clear();
        $this->image_lib->initialize($image_config);
        $this->image_lib->crop();
        return $image_path;
    }

}
