<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Group_notification_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }
    /**
     * @Function            : get_group_post_notification_message
     * @Used IN             : @function-'get_notification_message'      this[@Model]
     * @Description         : view group post notification message
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 29-09-2016 05:02 PM 
     * @Parameter           : $post_id[INTEGER]
     * @Return              : $notification_message
     * @Status              : available      
     * */
    function get_group_post_notification_message($post_id) {
        $post_info = $this->utility_model->get_single_table_information('*', 'tbl_post', 'post_id', $post_id);
        $type_message = $this->tt_notification->get_post_type_message($post_info->post_type);
        $all_group_name = $this->group_model->get_concat_multiple_group_name_by_post_id($post_id);
        $group_name = (strlen($all_group_name) > 50) ? mb_substr($all_group_name, 0, 50, 'utf-8') . '..' : $all_group_name;
        return ' have added ' . $type_message . ' in <span style="color: #4d4d4d !important; font-weight: bold !important;">' . $group_name . '</span>';
    }

    /**
     * @Function            : get_group_notification_message
     * @Used IN             : @function-'get_notification_message'      notification_model[@Model]
     * @Description         : get group notification message
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 01-10-2016 10:09 AM 
     * @Parameter           : $notification_type[INTEGER],$group_id[INTEGER]
     * @Return              : $notification_message
     * @Status              : available      
     * */
    function get_group_notification_message($notification_type, $group_id) {
        $group_info = $this->utility_model->get_single_table_information('group_name', 'tbl_group', 'group_id', $group_id);
        $type_message = ($notification_type == 4) ? 'sent a join request' : 'accepted your join request';
        return 'has ' . $type_message . ' for group <span style="color: #4d4d4d !important; font-weight: bold !important;">' . $group_info->group_name . '</span>';
    }

}
