<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description => View all public course action
 *
 * @author User
 */
class Course_model extends CI_Model {

    const tbl_name = 'tbl_course';
    const primary_key = 'course_id';

    public function __construct() {
        parent::__construct();
    }

    /*
      -----------@@@RIPON@ Start Course Common QUery Part(11-11-16)----------------------------------
     */

    /**
     * @Description         : get courses by topic ID
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 11:21 AM     
     * @Parameter           : $field_name=> return which field value
     *                        $topic_id => child topic ID [get couse by this topic ID]  
     * */
    function get_courses_by_topic_id($field_name, $topic_id, $course_id) {
        return $this->db->select($field_name)->from('tbl_course AS c')
                        ->join('tbl_url AS u', 'c.url_id = u.url_id')
                        ->where('c.topic_id', $topic_id)
                        ->where_not_in('c.course_id', $course_id)->get()->result();
    }

    /**
     * @Description         : get single course information by course url
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 11-11-2016 11:35 PM     
     * @Parameter           : $field_name=> return which field value
     *                        $url => Course URl
     * */
    function course_info_by_url($field_name, $url) {
        return $this->db->select($field_name)->from('tbl_course AS c')
                        ->join('tbl_url AS u', 'c.url_id = u.url_id')
                        ->where('u.url', $url)->get()->row();
    }

    /*
      -----------@@@RIPON@ End Course Common QUery Part(11-11-16)----------------------------------
     */



    /*
      -----------@@@RIPON@ Start Course Public View Part(17-08-16)----------------------------------
     */

    /**
     * @Function            : get_course_left_sidebar_data
     * @Used IN             : @function-'view_course'    course[@Controller]  
     * @Description         : View course side bar data for view public course
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 17-08-2016 10:45 AM    
     * @Parameter           : $data[ARRAY]
     * @Return              : Null   
     * @Status              : available      
     * */
    function get_course_left_sidebar_data($data) {
        $data['parent_topic'] = $this->topic_model->get_course_assign_parent_topic_info();
        foreach ($data['parent_topic'] as $topic_value) {
            $active_status = '1,5';
            $inactive_status = '2,3,4';
            $data['child_topic'][$topic_value->topic_id] = $this->topic_model->get_course_assign_child_topic_info_by_topic_id($topic_value->topic_id, $active_status, '0');
            $data['total_child_topic'][$topic_value->topic_id] = count($this->topic_model->get_course_assign_child_topic_info_by_topic_id($topic_value->topic_id, $active_status));
            $data['other_topic'][$topic_value->topic_id] = $this->topic_model->get_course_assign_child_topic_info_by_topic_id($topic_value->topic_id, $inactive_status);
        }
        $data['other_parent_topic'] = $this->topic_model->get_inactive_and_deleted_child_topic_id();
        return $data;
    }

    /**
     * @Function            : get_assign_course_child_topic
     * @Used IN             : @function-'view_course'    course[@Controller]  
     * @Description         : get assign course child topic by parent topic id
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 20-08-2016 11:43 AM    
     * @Parameter           : $data[ARRAY]
     * @Return              : Null   
     * @Status              : available      
     * */
    function get_assign_course_child_topic($data, $parent_topic_id, $active_status, $limit) {
        $data['child_topic'][$parent_topic_id] = $this->topic_model->get_course_assign_child_topic_info_by_topic_id($parent_topic_id, $active_status, $limit);
        $data['total_child_topic'][$parent_topic_id] = count($this->topic_model->get_course_assign_child_topic_info_by_topic_id($parent_topic_id, $active_status));
        return $data;
    }

    /**
     * @Function            : view_course_information
     * @Used IN             : @function-'view_course'    course[@Controller]  
     * @Description         : View course information
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 19-08-2016 04:29 PM    
     * @Parameter           : $data[ARRAY]
     * @Return              : $data[ARRAY]   
     * @Status              : available      
     * */
    function view_course_information($data) {
        $data['all_course'] = $this->get_all_courses($data);
        $data['total_course'] = $this->get_total_courses($data);
        foreach ($data['all_course'] as $course_value) {
            $data['course_creator_info'][$course_value->course_id] = $this->person_model->get_single_person_information_by_person_id($course_value->person_id);

            if ($course_value->course_type == 1) {
                $data['course_price_info'][$course_value->course_id] = $this->price_model->get_single_price_information(1, $course_value->course_id);
            }
        }
        return $data;
    }

    /**
     * @Function            : get_all_courses
     * @Used IN             : @function-'view_course'    course[@Controller]  
     * @Description         : View all course
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 17-08-2016 12:52 PM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     * */
    function get_all_courses($data) {
        $sql = "SELECT * FROM tbl_course AS c, tbl_url AS u
                WHERE c.course_status IN (1,4) AND c.url_id = u.url_id";

        if ($data['search_input'] != '') {
            $sql.=" AND c.course_name LIKE '%$data[search_input]%'";
        }

        if ($data['all_course_status'] != '1') {
            $sql.=($data['child_topic_id'] != '') ? " AND c.topic_id IN ($data[child_topic_id])" : '';
            $sql.=($data['course_upcomming'] != '') ? " AND c.upcoming_course = 1" : '';
            $sql.=($data['skill_level_id'] != '') ? " AND c.course_level IN ($data[skill_level_id])" : '';
            $sql.=($data['course_type'] != '') ? " AND c.course_type = 2" : '';
            $sql.=($data['course_priority'] == '1') ? " ORDER BY c.course_id DESC" : "";
            $sql.=($data['course_priority'] == '2') ? " ORDER BY c.course_view DESC" : "";
            $sql.=($data['course_rating'] == '1') ? " ORDER BY c.course_rating DESC" : "";
        } else {
            $sql.=" ORDER BY c.course_rating DESC";
        }

        $sql.=" LIMIT $data[limit],10";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_courses
     * @Used IN             : @function-'view_course'    course[@Controller]  
     * @Description         : View total courses with all requirments
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 24-08-2016 10:30 AM    
     * @Parameter           : $data[ARRAY]
     * @Return              : $total_course   
     * @Status              : available      
     * */
    function get_total_courses($data) {
        $sql = "SELECT count(*) AS total FROM tbl_course AS c WHERE c.course_status IN (1,4)";
        if ($data['search_input'] != '') {
            $sql.=" AND c.course_name LIKE '%$data[search_input]%'";
        }
        if ($data['all_course_status'] != '1') {
            $sql.=($data['child_topic_id'] != '') ? " AND c.topic_id IN ($data[child_topic_id])" : '';
            $sql.=($data['course_upcomming'] != '') ? " AND c.upcoming_course = 1" : '';
            $sql.=($data['skill_level_id'] != '') ? " AND c.course_level IN ($data[skill_level_id])" : '';
            $sql.=($data['course_type'] != '') ? " AND c.course_type = 2" : '';
        }
        return $this->db->query($sql)->row()->total;
    }

    /**
     * @Function            : get_child_topic_id
     * @Used IN             : @function-'view_all_courses'    course[@Controller]  
     * @Description         : concat child topic ID and other topic id
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 22-08-2016 11:29 AM    
     * @Parameter           : Null
     * @Return              : Null   
     * @Status              : available      
     * */
    function get_child_topic_id($child_topic_id_array, $other_topic_id_array, $other_parent_topic) {
        if ($other_topic_id_array) {
            $other_topic_id = $this->topic_model->get_course_assign_concat_child_topic_info_by_topic_id(implode(',', $other_topic_id_array), '2,3,4');
        } else {
            $other_topic_id = Array();
        }
        $child_topic_id = array_filter(array_merge($child_topic_id_array, $other_topic_id));
        if ($other_parent_topic == 1) {
            $deleted_child_topic_id = $this->topic_model->get_inactive_and_deleted_child_topic_id();
            $all_child_id = array_unique(array_filter(array_merge($deleted_child_topic_id, $child_topic_id)));
            return ($all_child_id) ? implode(',', $all_child_id) : '';
        } else {
            return ($child_topic_id) ? implode(',', $child_topic_id) : '';
        }
    }

    /**
     * @Function            : count_course_view
     * @Used IN             : @function-'view_single_course'    course[@Controller]  
     * @Description         : count course view
     * @Developed By        : Md Jaherul Islam  
     * @Start DateTime      : 27-08-2016 11:01 AM    
     * @Parameter           : $course_id[Integer]
     * @Return              : Null   
     * @Status              : available      
     * */
    function count_course_view($course_id) {
        $course_view = $this->utility_model->get_single_table_information('course_view', 'tbl_course', 'course_id', $course_id)->course_view;

        $data['course_view'] = ($course_view == '') ? 1 : ++$course_view;
        $this->utility_model->update_information_in_database('tbl_course', 'course_id', $course_id, $data);
    }

    /**
     * @Function            : check_course_video_course_authentication 
     * @Used IN             : @function-'course_public_view'     this[@controller],
     * @Description         : view public course and video course authentication
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 26-08-2016 06:06 PM
     * @Parameter           : $login_person_id=>[login person ID],$course_creator_id=>[course creator id], 
     *                        $status=>[Course,video course status]
     * @Return              : 1=>for Authentication user, 2=>for all login user, 
     *                        3=>id course inactive,archive,draft,unpublished and unautherize user    
     * @Status              : Available       
     * */
    function check_course_authentication_for_public_view($login_person_id, $course_creator_id, $resource_person_id, $status) {
        $login_person_info = $this->person_model->get_single_person_info_by_person_id($login_person_id);
        if (in_array($login_person_info->person_role, Array(1, 6, 9))) { // for admin users
            return 1;
        }
        if (in_array($login_person_info->person_role, Array(3, 4))) { // for front end users (Teacher/Organization)
            $resource_person_info = $this->resource_person_model->select_person_information_by_resource_person_id($resource_person_id);
            if (in_array($status, Array(1, 4))) {
                return ($course_creator_id == $login_person_id) ? 1 : (($resource_person_info->person_id == $login_person_id) ? 1 : 2);
            }
            if (in_array($status, Array(2, 3, 5, 6))) {
                return ($course_creator_id == $login_person_id) ? 1 : (($resource_person_info->person_id == $login_person_id) ? 1 : 3);
            }
        }
        if ($login_person_info->person_role == 5) { // for front end users (students)
            return (in_array($status, Array(1, 4))) ? 2 : 3;
        }
    }

    /*
      -----------@@@RIPON@ End Course Public View Part(17-08-16)----------------------------------
     */

    /**
     * @Function            : get_upcomming_course 
     * @Used IN             : @function-'user/right_content.php'
     * @Description         : get all upcomming course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-04-2016 03:10 PM  
     * @Parameter           : $limit[INTEGER]
     * @View                : None
     * @Redirect            : None
     * @Return              : al_upcomming course    
     * @Status              : Available        
     * */
    function get_upcomming_course($limit) {
        $course_with_date = $this->get_upcomming_course_with_date($limit);
        $course_without_date = '';

        if (count($course_with_date) < $limit) {
            $new_limit = $limit - count($course_with_date);
            $course_without_date = $this->get_upcomming_course_without_date($new_limit);
        }
        if ($course_without_date != '') {
            return array_merge($course_with_date, $course_without_date);
        } else {
            return $course_with_date;
        }
    }

    function get_upcomming_course_with_date($limit) {
        $sql = "SELECT *
                FROM 
                    tbl_course AS c,
                    tbl_url AS u
                WHERE 
                    c.upcoming_course = '1'
                AND c.url_id = u.url_id
                AND c.course_start_date != ''
                AND c.course_status IN (1,4)
                ORDER BY c.course_start_date ASC
                LIMIT $limit";
        return $this->db->query($sql)->result();
    }

    function get_upcomming_course_without_date($limit) {
        $sql = "SELECT *
                FROM 
                    tbl_course AS c,
                    tbl_url AS u
                WHERE 
                    c.upcoming_course = '1'
                AND c.url_id = u.url_id
                AND c.course_start_date IS NULL
                AND c.course_status IN (1,4)
                ORDER BY c.course_id DESC
                LIMIT $limit";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_upcomming_course 
     * @Used IN             : @function-'user/right_content.php'
     * @Description         : get total upcomming course
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 20-04-2016 03:45 PM  
     * @Parameter           : NULL
     * @View                : None
     * @Redirect            : None
     * @Return              : total_upcomming_course    
     * @Status              : Available        
     * */
    function get_total_upcomming_course() {
        $sql = "SELECT count(*) AS total
                FROM 
                    tbl_course AS c,
                    tbl_url AS u
                WHERE 
                    c.upcoming_course = '1'
                AND c.url_id = u.url_id
                AND c.course_status IN (1,4)";
        return $this->db->query($sql)->row();
    }

    /**
     * @Function            : get_single_public_course_by_menu_id 
     * @Used IN             : @function-'public_menu_view'  application[@controller] - [335]
     * @Description         : get public course b menu ID  
     * @Developed By        : MD Jaherul Islam
     * @Start DateTime      : 04-05-2016 11:46 AM
     * @Parameter           : $menu_id[INTEGER]
     * @Return              : course_info    
     * @Status              : Available       
     * */
    function get_single_public_course_by_menu_id($menu_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_course AS c,
                    tbl_url AS u
                WHERE 
                    c.url_id = u.url_id
                AND u.url_type = '5'
                AND c.menu_id = '$menu_id'
                AND c.course_status IN (1,4)";
        return $this->db->query($sql)->row();
    }

    //@Endripon




    /*
      -----------@@@RIPON@ Start public course search Part----------------------------------
     */

    function get_course_value_by_search($data, $search_value, $start_limit, $end_limit) {
        $searched_course = $this->get_searched_course_information($search_value, $start_limit, $end_limit);
        if ($searched_course) {
            $data['searched_course'] = $searched_course;
            $data['total_searched_course'] = $this->get_total_searched_course_information($search_value);
        }
        return $data;
    }

    /**
     * @Function            : get_searched_course_information 
     * @Used IN             : @function-'view_searched_value'  welcome[@controller],
     * @Description         : get course information by search 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 10:11 AM   
     * @Status              : available      
     * */
    function get_searched_course_information($search_value, $start_limit, $end_limit) {
        $sql = "SELECT *
                FROM 
                    tbl_course AS c,
                    tbl_url AS u
                WHERE
                    c.url_id = u.url_id
                AND u.url_type = '5'
                AND c.course_name LIKE '%$search_value%'
                AND c.course_status IN (1,4)
                ORDER BY c.course_name ASC
                LIMIT $start_limit,$end_limit";
        return $this->db->query($sql)->result();
    }

    /**
     * @Function            : get_total_searched_course_information 
     * @Used IN             : @function-'view_searched_value'  welcome[@controller],
     * @Description         : get total course information by search 
     * @Developed By        : Ripon Jaherul
     * @Start DateTime      : 27-03-2016 01:27 PM   
     * @Status              : available      
     * */
    function get_total_searched_course_information($search_value) {
        $sql = "SELECT count(*) AS total_course
                FROM 
                    tbl_course AS c,
                    tbl_url AS u
                WHERE
                    c.url_id = u.url_id
                AND u.url_type = '5'
                AND c.course_name LIKE '%$search_value%'
                AND c.course_status IN (1,4)";
        $result = $this->db->query($sql)->row();
        return $result->total_course;
    }

    /*
      -----------@@@RIPON@ End public course search Part----------------------------------
     */

    /**
     * @Description         : set course ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 12-12-2016 04:25 PM 
     * */
    private $course_id;

    function set_course_id($course_id) {
        $this->course_id = $course_id;
        return $this;
    }

    /**
     * @Description         : set topic ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 12-01-2016 10:47 AM 
     * */
    private $topic_id;

    function set_topic_id($topic_id) {
        $this->topic_id = $topic_id;
        return $this;
    }

    /**
     * @Description         : set person_id
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 10:41 AM 
     * */
    private $person_id;

    function set_person_id($person_id) {
        $this->person_id = $person_id;
        return $this;
    }

    /**
     * @Description         : set course url
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 02:34 PM 
     * */
    private $url;

    function set_url($url) {
        $this->url = $url;
        return $this;
    }

    /**
     * @Description         : set course field name
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 02:42 PM 
     * */
    private $field_name;

    function set_field_name($field_name) {
        $this->field_name = $field_name;
        return $this;
    }

    /**
     * @Description         : set course information by course ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 02:42 PM 
     * */
    function set_course_info_by_course_id() {
        $this->result = $this->db->select($this->field_name)->from(self::tbl_name)
                        ->where(self::primary_key, $this->course_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : set course information with url by course ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 08-12-2016 03:18 PM 
     * */
    function set_course_info_with_url_by_course_id() {
        $this->result = $this->db->select($this->field_name)->from('tbl_course AS c')
                        ->join('tbl_url AS u', 'c.url_id = u.url_id')
                        ->where(self::primary_key, $this->course_id)->get()->row();
        return $this;
    }

    /**
     * @Description         : set course information by course URl
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 02:34 PM 
     * */
    function set_info_by_url() {
        $this->result = $this->db->select($this->field_name)->from('tbl_course AS c')
                        ->join('tbl_url AS u', 'c.url_id = u.url_id')
                        ->where('u.url', $this->url)->get()->row();
        return $this;
    }

    /**
     * @Description         : set course_id for_payment
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 10:41 AM 
     * */
    private $result;

    function set_course_id_for_payment() {
        $this->result = $this->db->select('GROUP_CONCAT(DISTINCT(tbl_course.course_id)) AS id')
                        ->from(self::tbl_name)->join('tbl_payment', 'tbl_payment.payment_type_id=tbl_course.course_id')
                        ->where('tbl_payment.payment_type', 1)->where('tbl_course.person_id', $this->person_id)
                        ->where_in('tbl_payment.payment_status', [1, 2, 6, 9])->get()->row()->id;
        return $this;
    }
    
    function get_user_paid_all_course_id($person_id){
        $this->db->select('GROUP_CONCAT(DISTINCT(c.course_id)) AS id')
                ->from('tbl_course AS c')
                ->join('tbl_payment AS p', 'p.payment_type_id=c.course_id')
                ->where('p.payment_type', 1)
                ->where('c.person_id', $person_id)
                ->where_in('p.payment_status', [1, 2, 6, 9]);
        return $this->db->get()->row()->id;
    }

    /**
     * @Description         : set course information by topic ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 12-01-2017 10:46 AM 
     * */
    function set_course_info_by_topic_id() {
        $this->result = $this->db->select($this->field_name)
                        ->from(self::tbl_name)->join('tbl_url', 'tbl_url.url_id=tbl_course.url_id')
                        ->where('topic_id', $this->topic_id)
                        ->where_not_in('course_id', $this->course_id)
                        ->get()->result();
        return $this;
    }

    /**
     * @Description         : get course creator ID/ resource person ID for pay invoice
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 12-12-2016 04:28 PM 
     * */
    function get_person_id_for_course_view_invoice() {
        $person_id_array = [];
        $this->set_field_name('person_id,resource_person_id,course_resource_person_view_invoice')
                ->set_course_info_by_course_id();

        if ($this->result->course_resource_person_view_invoice == 1) {
            $person_id_array[] = $this->resource_person_model->set_resource_person_id($this->result->resource_person_id)
                            ->set_info_by_resource_person_id()->get_result()->person_id;
        }

        $person_id_array[] = $this->result->person_id;
        return array_unique($person_id_array);
    }

    /**
     * @Description         : get result
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 10-12-2016 10:41 AM 
     * */
    function get_result() {
        return $this->result;
    }

    /**
     * @Description         : view all course notification
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 31-12-2016 03:57 PM 
     * */
    function view_course_notification() {
        $data = [];
        $todays_date = date('Y/m/d', (time() - $this->session->time_offset));
        $data['todays_notification'] = $this->notification_model
                        ->set_notify_to($this->person_id)
                        ->set_notification_type(6)
                        ->set_notification_date_time($todays_date)
                        ->total_notification_by_date()->get_result();
        $data['read_notification'] = $this->notification_model
                        ->total_read_notification()->get_result();
        $data['unread_notification'] = $this->notification_model
                        ->total_unread_notification()->get_result();
        $this->result = $data;
        return $this;
    }
    
    
    /**
     * @Description         : Removes Student from batch When student deleted
     *                        from course                         
     * @Developed By        : Md Mashqur Ul Alam
     * @Start DateTime      : 25-02-17
     * @Parameter           : $student_id 
     * */
    function remove_batch_assign_student($student_id){
        $sql = "UPDATE tbl_course_batch
        SET student_id = TRIM(BOTH ',' FROM REPLACE(CONCAT(',', `student_id`), ',$student_id', ''))
        WHERE FIND_IN_SET('$student_id', `student_id`)";
        $this->db->query($sql);
    }

}
