<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Client_admin_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->model('url_model');
    }

    //put your code here
    public function select_teacher($organization_id, $limit = null, $limit_offset = 0) {        
        $this->db->select('*')
                ->from('tbl_organization_resource_person AS orp,tbl_resource_person AS rp,tbl_person AS p,tbl_url AS u')
                ->where('orp.organization_id', $organization_id)
                ->where('orp.resource_person_id = rp.resource_person_id')
                ->where('rp.person_id = p.person_id AND p.url_id = u.url_id');
        if($limit){
            $this->db->limit($limit, $limit_offset);
        }
        return $this->db->get()->result();
    }

    public function select_organization_resource_person_by_org_id($org_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p, "
                . "     tbl_resource_person as rp "
                . " WHERE "
                . "         p.person_id= rp.person_id "
                . "     AND p.person_status = 1 "
                . "     AND rp.organization_id = $org_id"
        ;
        $result = $this->db->query($sql)->result();

        return $result;
    }

    public function save_person_unique_url($url, $url_type, $url_status) {
        $url = preg_replace('/[^A-Za-z0-9 -]/', '', $url);
        $url = str_replace('.', '-', $url);
        $url = str_replace(' ', '-', $url);
        $url = $temp_url = strtolower($url);
        $i = 1;
        do {
            $sql = "SELECT * FROM tbl_url as u WHERE u.url = '$temp_url'";
            $result = $this->db->query($sql)->row();
            if ($result) {
                $temp_url = $url;
                $temp_url .=$i;
                $i++;
            }
        } while ($result);

        $url = $temp_url;
        $url_data['url'] = $url;
        $url_data['url_type'] = $url_type;
        $url_data['url_status'] = $url_status;
        $this->db->insert('tbl_url', $url_data);

        $profile_url = $url_data['url'];
        $this->load->library('cf');
        $this->cf->create_folder($profile_url);
        $data['url'] = $profile_url;
        $data['url_id'] = $this->db->insert_id();
        return $data;
    }

    /**
     * @Function            : save_person_information
     * @Used IN             : @function-'self'  
     * @Description         : Save organization teacher information
     * @                    : @Update1 - remove all free feature issue in sign in 
     * @Developed By        : Mahabub-A-Mawla
     * @Start DateTime      : Unknown
     * @Updated Date Time   : 01-03-2016 06:49 PM
     * @Updated By          : Ripon Jaherul      
     * @Status              : available      
     * */
    public function save_person_information($person_info) {
        $pdata = array();
        $pdata['person_email'] = $this->input->post('person_email', TRUE);
        $pdata['person_password'] = md5($this->input->post('person_password', TRUE));
        $pdata['person_first_name'] = $this->input->post('person_first_name', TRUE);
        $pdata['person_last_name'] = $this->input->post('person_last_name', TRUE);
        $country_code = $this->input->post('hidden_country_code', TRUE);
        $pdata['person_contact_number'] = $country_code . ' ' . $this->input->post('person_contact_number', TRUE);
        $pdata['person_country'] = $this->input->post('person_country', TRUE);
        $pdata['person_city'] = $this->input->post('person_city', TRUE);
        $pdata['person_zip'] = $this->input->post('person_zip', TRUE);
        $pdata['person_address'] = $this->input->post('person_address', TRUE);
        $pdata['person_role'] = 3;
        $pdata['person_gender'] = $this->input->post('person_gender', TRUE);
        $pdata['person_status'] = $this->input->post('person_status', TRUE);
        $pdata['person_join_tt'] = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));

        // Save URL information
        $url1 = $this->input->post('profile_url', TRUE);
        $udata = $this->url_model->create_teacher_url_for_organization($url1);
        $url = $udata['url'];
        $pdata['url_id'] = $udata['url_id'];
        /*
         * Start Image Upload
         */
        if ($_FILES['person_image']['name']) {
            $config['upload_path'] = 'content-library/' . $url . '/my-image/'; //'site/images/user/original/';
            $config['allowed_types'] = 'jpeg|jpg|gif|png|bmp';
            $config['max_size'] = '2097152';
            $error = '';
            $fdata = array();
            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('person_image')) {
                $error = $this->upload->display_errors();
            } else {
                $fdata = $this->upload->data();
                $pdata['person_image'] = 'my-image/' . $fdata['file_name'];

                // Start Create Thumbnail
                $config['image_library'] = 'gd2';
                $config['new_image'] = 'content-library/' . $url . '/my-image/'; //'site/images/user/thumbnail/';
                $config['source_image'] = $config['upload_path'] . $fdata['file_name'];
                $config['create_thumb'] = TRUE;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = '100';
                $config['height'] = '100';
                $this->load->library('image_lib', $config);

                $this->image_lib->resize();
                if (!$this->image_lib->resize()) {
                    $error = $this->image_lib->display_errors();
                } else {
                    $pdata['person_image_thumb'] = 'my-image/' . $fdata['raw_name'] . '_thumb' . $fdata['file_ext'];
                }
            }
        }
        // END Create Thumbnail
        /*
         * End Image Ipload
         */
        $this->db->insert('tbl_person', $pdata);
        $person_id = $this->db->insert_id();

        $status_data['person_id'] = $person_id;
        $status_data['person_email_view_status'] = 1;
        $status_data['person_contact_number_view_status'] = 1;
        $status_data['person_address_view_status'] = 1;
        $status_data['person_birthday_view_status'] = 1;
        $status_data['person_self_assessment_skills_view_status'] = 1;
        $this->db->insert('tbl_person_info_view_status', $status_data);

        $organization_info = $this->profile_model->select_organization_info($person_info->person_id);
        $r_data['person_id'] = $person_id;
        $r_data['resource_person_type'] = '3';
        $r_data['organization_id'] = $organization_info->organization_id;
        $this->db->insert('tbl_resource_person', $r_data);
    }

    public function update_organization_feature_info($feature_price_id, $payment_id_new, $organization_id) {
        $this->db->set('feature_price_id', $feature_price_id);
        $this->db->where('organization_id', $organization_id);
        $this->db->update('tbl_organization');
    }

    public function update_resource_person_feature_info($feature_price_id, $payment_id_new, $resource_person_id) {
        $this->db->set('feature_price_id', $feature_price_id);
        $this->db->set('feature_price_payment_id', "$payment_id_new");
        $this->db->where('resource_person_id', $resource_person_id);
        $this->db->update('tbl_resource_person');
    }

    public function save_teacher_education($person_id) {
        $data = array();
        $data['person_id'] = $person_id;
        $data['education_institute_id'] = $this->input->post('education_institution_id', TRUE);

        if ($data['education_institute_id'] == 'other') {
            $oei_data['education_institute_country'] = $this->input->post('education_institution_country', TRUE);
            $oei_data['education_institute_city'] = $this->input->post('education_institution_city', TRUE);
            $oei_data['education_institute_name'] = $this->input->post('other_institute', TRUE);
            $oei_data['education_institute_type'] = $this->input->post('attended_for', TRUE);
            $oei_data['education_institute_status'] = 0;
            $this->db->insert('tbl_education_institute', $oei_data);
            $data['education_institute_id'] = $this->db->insert_id();
        }

        $data['start_time_period'] = $this->input->post('start_time_period', TRUE);
        $data['end_time_period'] = $this->input->post('end_time_period', TRUE);
        $data['educational_description'] = $this->input->post('educational_description', TRUE);
        $data['attended_for'] = $this->input->post('attended_for', TRUE);
        $data['person_education_view_status'] = $this->input->post('person_education_view_status', TRUE);
        $data['person_education_status'] = 1;
        $this->db->insert('tbl_person_education_details', $data);
    }

    public function select_teacher_education_information($teacher_person_id) {
        
    }

    public function select_institute($country, $city, $attended_for) {
        $sql = "SELECT * FROM "
                . "     tbl_education_institute as ei "
                . "WHERE "
                . "         ei.education_institute_country = '$country' "
                . "     AND ei.education_institute_city = '$city' "
                . "     AND ei.education_institute_type = $attended_for ";

        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function update_teacher_education($education_detail_id) {
        $data = array();
        $data['person_id'] = $this->input->post('person_id', TRUE);
        $data['education_institute_id'] = $this->input->post('education_institution_id', TRUE);

        if ($data['education_institute_id'] == 'other') {
            $oei_data['education_institute_country'] = $this->input->post('education_institution_country', TRUE);
            $oei_data['education_institute_city'] = $this->input->post('education_institution_city', TRUE);
            $oei_data['education_institute_name'] = $this->input->post('other_institute', TRUE);
            $oei_data['education_institute_type'] = $this->input->post('attended_for', TRUE);
            $oei_data['education_institute_status'] = 0;
            $this->db->insert('tbl_education_institute', $oei_data);
            $data['education_institute_id'] = $this->db->insert_id();
        }

        $data['start_time_period'] = $this->input->post('start_time_period', TRUE);
        $data['end_time_period'] = $this->input->post('end_time_period', TRUE);
        $data['educational_description'] = $this->input->post('educational_description', TRUE);
        $data['attended_for'] = $this->input->post('attended_for', TRUE);
        $data['person_education_view_status'] = $this->input->post('person_education_view_status', TRUE);
        $data['person_education_status'] = $this->input->post('person_education_status', TRUE);
        $this->db->where('person_education_details_id', $education_detail_id);
        $this->db->update('tbl_person_education_details', $data);
    }

    public function save_teacher_work_experience($person_id) {
        $wdata = array();
        $wdata['person_id'] = $person_id;
        $wdata['company_name'] = $this->input->post('user_new_company_name', TRUE);
        $wdata['designation'] = $this->input->post('user_new_designation', TRUE);
        $wdata['company_address'] = $this->input->post('user_new_address', TRUE);
        $wdata['company_website_url'] = $this->input->post('company_website_url', TRUE);
        $wdata['job_start_date'] = $this->input->post('user_new_job_start_date', TRUE);
        $wdata['job_end_date'] = $this->input->post('user_new_job_end_date', TRUE);
        $wdata['work_currently_here'] = $this->input->post('work_current_here', TRUE);
        $wdata['job_responsibility_details'] = $this->input->post('user_new_responsibility', TRUE);
        $wdata['person_work_view_status'] = $this->input->post('person_work_view_status', TRUE);
        $wdata['work_details_status'] = 1;
        $this->db->insert('tbl_person_work_details', $wdata);
    }

    public function update_teacher_work_experience($person_id) {
        $wdata = array();
        $wdata['person_id'] = $person_id;
        $wdata['company_name'] = $this->input->post('company_name', TRUE);
        $wdata['designation'] = $this->input->post('designation', TRUE);
        $wdata['company_address'] = $this->input->post('company_address', TRUE);
        $wdata['company_website_url'] = $this->input->post('company_website_url', TRUE);
        $wdata['job_start_date'] = $this->input->post('job_start_date', TRUE);
        $wdata['job_end_date'] = $this->input->post('job_end_date', TRUE);
        $wdata['work_currently_here'] = $this->input->post('work_currently_here', TRUE);
        $wdata['job_responsibility_details'] = $this->input->post('job_responsibility_details', TRUE);
        $wdata['person_work_view_status'] = $this->input->post('person_work_view_status', TRUE);
        $wdata['work_details_status'] = $this->input->post('work_details_status', TRUE);
        $this->db->where('person_work_details_id', $work_detail_id);
        $this->db->update('tbl_person_work_details', $wdata);
    }

    public function select_user_information_by_id($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person as p,"
                . "     tbl_url as u"
                . " WHERE "
                . "         p.person_id = $person_id"
                . "     AND p.url_id = u.url_id";
        $result = $this->db->query($sql)->row();

        if (!$result) {
            $sql = "SELECT p.*, p.person_id, o.organization_id, o.payment_id, o.payment_details_information_id, o.organization_name, o.organization_code, o.number_of_student_person "
                    . " FROM tbl_person as p, tbl_organization as o "
                    . " WHERE p.person_id = $person_id AND p.person_id = o.person_id";
            $result = $this->db->query($sql)->row();
        }

        return $result;
    }

    public function select_org_all_resource_person_by_name($org_id) {
        $sql = "SELECT  count(*) as total, "
                . "     o.number_of_student_person "
                . " FROM "
                . "     tbl_resource_person as rp, "
                . "     tbl_organization as o "
                . " WHERE "
                . "         rp.organization_id = $org_id "
                . "     AND o.organization_id = $org_id "
        ;

        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function select_org_info_by_name($org_name) {
        $sql = "SELECT  * "
                . " FROM "
                . "     tbl_organization as o "
                . " WHERE "
                . "     o.organization_name LIKE '%" . $org_name . "%'"
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function update_user_information($person_id) {
        $sql = "SELECT  * "
                . " FROM "
                . "     tbl_person as p, tbl_url as u"
                . " WHERE "
                . "     person_id = '$person_id' "
                . "     AND p.url_id = u.url_id";
        $person_info = $this->db->query($sql)->row();

        $pdata = array();
        $pdata['person_email'] = $this->input->post('person_email', TRUE);
        $pdata['person_first_name'] = $this->input->post('person_first_name', TRUE);
        $pdata['person_last_name'] = $this->input->post('person_last_name', TRUE);
        $pdata['person_gender'] = $this->input->post('person_gender', TRUE);
        $password = $this->input->post('person_password', TRUE);
        if ($password != '') {
            $pdata['person_password'] = md5($password);
        }
        $country_code = $this->input->post('hidden_country_code', TRUE);
        $pdata['person_contact_number'] = $country_code . ' ' . $this->input->post('person_contact_number', TRUE);
        $pdata['person_country'] = $this->input->post('person_country', TRUE);
        $pdata['person_city'] = $this->input->post('person_city', TRUE);
        $pdata['person_zip'] = $this->input->post('person_zip', TRUE);
        $pdata['person_address'] = $this->input->post('person_address', TRUE);
        if ($this->input->post('person_status', TRUE)) {
            $pdata['person_status'] = $this->input->post('person_status', TRUE);
        }

//        $profile_url = $this->input->post('profile_url', TRUE);
//        if ($profile_url != $person_info->url) {
//            $udata = $this->url_model->update_teacher_url_for_organization($person_info->url_id, $profile_url, $person_info->url);
//            $profile_url = $udata['url'];
//            $pdata['url_id'] = $person_info->url_id;
//            $pdata['person_last_change_url_date'] = $udata['person_last_change_url_date'];
//        }
//
//        $previous_folder = 'content-library/' . $person_info->url;
//        if ($person_info->url != $profile_url) {
//            $new_folder = 'content-library/' . $profile_url;
//            rename("$previous_folder", "$new_folder");
//            $pdata['person_last_change_url_date'] = date('Y-m-d', time() - $this->session->userdata('time_offset'));
//        }
        /*
         * Image Upload
         */
        if ($_FILES['person_new_image']['name']) {
            $upload_path = 'content-library/' . $profile_url . '/my-image/';
            $allowed_types = 'gif|jpg|png';
            $image_data = $this->image_model->upload_file($upload_path, $allowed_types, '2048', 'person_new_image');
            $pdata['person_image'] = 'my-image/' . $image_data['file_name'];

            $image_path = $upload_path . $image_data['file_name'];
            $new_image_name = $image_data['raw_name'] . '_thumb' . $image_data['file_ext'];
            $image_thumb = $upload_path . $new_image_name;

            $this->image_model->create_thumbnail_image($image_thumb, $image_path);
            $pdata['person_image_thumb'] = 'my-image/' . $new_image_name;

            $person_image = 'content-library/' . $profile_url . '/' . $person_info->person_image;
            $person_image_thumb = 'content-library/' . $profile_url . '/' . $person_info->person_image_thumb;
            if (is_file($person_image)) {
                unlink("$person_image");
            }
            if (is_file($person_image_thumb)) {
                unlink("$person_image_thumb");
            }
        } else {
            $pdata['person_image'] = $person_info->person_image;
            $pdata['person_image_thumb'] = $person_info->person_image_thumb;
        }

        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person', $pdata);
    }

    public function save_person_unique_url_edit($url, $url_id, $url_type, $url_status) {
        $url = preg_replace('/[^A-Za-z0-9 -]/', '', $url);
        $url = str_replace('.', '-', $url);
        $url = str_replace(' ', '-', $url);
        $url = $temp_url = strtolower($url);
        $i = 1;
        do {
            $sql = "SELECT * FROM tbl_url as u WHERE u.url = '$temp_url'";
            $result = $this->db->query($sql)->row();
            if ($result) {
                $temp_url = $url;
                $temp_url .=$i;
                $i++;
            }
        } while ($result);

        $profile_url = $temp_url;

        $this->db->set('url', $profile_url);
        $this->db->where('url_id', $url_id);
        $this->db->update('tbl_url');

        $data['url'] = $profile_url;
        $data['url_id'] = $url_id;
        return $data;
    }


    public function check_url($code) {
        // 1 = quiz, 2 = group, 3 = course , 4 = course_category, 5 = menu, 6 = video_course_category 7 = Person
        $this->db->select('*');
        $this->db->from('tbl_url');
        $this->db->where('url', $code);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    public function check_user_email_by_person_id($user_email_address, $person_id) {
        $sql = "SELECT * FROM tbl_person WHERE person_email = '$user_email_address' AND person_id != '$person_id'";
        $result = $this->db->query($sql)->result();
        return $result;
    }

    public function select_resource_person_info($person_id) {
        $sql = "SELECT * "
                . " FROM "
                . "     tbl_person p, "
                . "     tbl_resource_person as rp,"
                . "     tbl_url as u "
                . " WHERE "
                . "         p.person_id = $person_id "
                . "     AND rp.person_id = p.person_id "
                . "     AND u.url_id = p.url_id"
        ;
        $result = $this->db->query($sql)->row();
        return $result;
    }

    public function make_account_active($person_id) {
        $this->db->set('person_status', '1');
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function make_account_inactive($person_id) {
        $this->db->set('person_status', '4');
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

    public function make_account_archive($person_id) {
        $this->db->set('person_status', '2');
        $this->db->where('person_id', $person_id);
        $this->db->update('tbl_person');
    }

}
