<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class All_video_course_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
    /*
     * @Author              : Delwar Sumon 
     * @CreatedDate         : Unknown
     * @ModifiedDate        : 28-08-2017
     * @ModifiedBy          : Kazol
     * @Route               : 
     * @Description         : This function is used for show all video course in the view and also pagination
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $limit_offset
     * @Return              : $data
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function all_video_course_info($limit_offset = NULL) {
        $data['video_course'] = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->where('vc.video_course_publication_status', 2)
                        ->order_by('vc.video_course_id', 'ASC')
                        ->limit(15, $limit_offset)
                        ->get()->result();
        $total_row = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->where('vc.video_course_publication_status', 2)
                        ->order_by('vc.video_course_id', 'DESC')
                        ->get()->result();
        //$this->cf->dd($total_row);
        $data['total_row'] = count($total_row);
        if(isset($total_row)){
            foreach($total_row as $v_video_course){
                $data['resource_person'][] = $v_video_course->resource_person_id;
            }
        }
        //$this->cf->dd($data['resource_person']);
        if(isset($data['video_course'])){
           $data = $this->all_video_course_person_price_info($data);
        }
        
        return $data;
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 28-08-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for search all video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $search_value = NULL , $limit_offset = NULL
     * @Return              : $data
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function search_all_video_course_info($search_value = NULL, $limit_offset = NULL){
        $data['video_course'] = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->where('vc.video_course_publication_status', 2)
                        ->order_by('vc.video_course_id', 'DESC')
                        ->like('vc.video_course_title', $search_value)
                        ->limit(15, $limit_offset)
                        ->get()->result();
        $total_row = $this->db->select('*')
                        ->from('tbl_video_course AS vc')
                        ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                        ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                        ->where('vc.video_course_publication_status', 2)
                        ->like('vc.video_course_title', $search_value)
                        ->order_by('vc.video_course_id', 'DESC')
                        ->get()->result();
        //$this->cf->dd($total_row);
        $data['total_row'] = count($total_row);
        if(isset($data['video_course'])){
           $data = $this->all_video_course_person_price_info($data);
        }
        
        return $data;
    }

    public function all_video_course_person_price_info($data) {
        foreach ($data['video_course'] as $video_course) {
                $data['video_course_person_info'][$video_course->video_course_id] = $this->get_video_course_single_person_information($video_course->person_id);
                if ($video_course->video_course_payment_type == 2) {
                    $data['video_course_price_info'][$video_course->video_course_id] = $this->get_video_course_single_price_information(2, $video_course->video_course_id);
                }
            }
        return $data;
    }
    
    public function get_video_course_single_person_information($person_id) {
        $this->db->select('p.person_first_name,p.person_last_name,p.person_role,u.*')
                ->from('tbl_person as p')
                ->join('tbl_url as u','p.url_id = u.url_id')
                ->where('p.person_id', $person_id);
        return $this->db->get()->row();
    }
    public function get_video_course_single_price_information($price_type, $price_type_id) {
        $this->db->select('*')
                ->from('tbl_price')
                ->where('price_type', $price_type)
                ->where('price_type_id', $price_type_id);
        return $this->db->get()->row();
    }
    
    public function get_child_topic_id($child_topic_id, $other_parent_topic) {
        if ($other_parent_topic == 1) {
            $topic_id = $this->video_course_assign_concat_topic_id_without_sub_topic();
            $all_child_id = array_unique(array_filter(array_merge(explode(',', $topic_id), $child_topic_id)));
            return ($all_child_id) ? $all_child_id : '';
        } else {
            return ($child_topic_id) ? $child_topic_id : '';
        }
    }
    
    function video_course_assign_concat_topic_id_without_sub_topic() {
        $this->db->select('GROUP_CONCAT(DISTINCT(t.topic_id)) AS topic_id')
                ->from('tbl_video_course AS vc')
                ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                ->where('vc.video_course_publication_status', 2)
                ->where('t.parent_topic_id', 0)
                ->where_in('t.topic_status', array(1,5));
        return $this->db->get()->row()->topic_id;
    }
    /*
     * @Author              : delwar Sumon
     * @CreatedDate         : unkhown
     * @ModifiedDate        : 30-08-2017
     * @ModifiedBy          : Kazol
     * @Route               : 
     * @Description         : This function is used for get the video course when we click in the checkbox in the left side menu
     * @view                : all_video_course/ajax_view/view_all_video_course
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $data, $limit_offset = NULL
     * @Return              : $data
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function all_video_course_info_by_topic_id($data, $limit_offset = NULL) {
        $this->db->select('*');
        $this->db->from('tbl_video_course AS vc');
        $this->db->join('tbl_topic AS t', 'vc.topic_id = t.topic_id');
        $this->db->join('tbl_url AS u', 'vc.url_id = u.url_id');
        $this->db->where('vc.video_course_publication_status', 2);
        
            if(!empty($data['course_type'])){
                $this->db->where('vc.video_course_payment_type', $data['course_type']);
            }
            if(!empty($data['skill_level_id'])){
                $this->db->where_in('vc.video_course_skill_level', $data['skill_level_id']);
            }
            if(!empty($data['child_topic_id'])){
                $this->db->where_in('t.topic_id', $data['child_topic_id']);
            }
            if(!empty($data['resource_person'])){
                $this->db->where_in('vc.resource_person_id', $data['resource_person']);
            }
            if(!empty($data['video_course_priority_level'])){
                if($data['video_course_priority_level'] == '1'){
                    $this->db->order_by('vc.video_course_id', 'DESC');
                }else{
                    $this->db->order_by('vc.video_course_view', 'DESC');
                }
            }
        
        $this->db->limit(15, $limit_offset);
        
        $data['video_course'] = $this->db->get()->result();
        $data['total_row'] = $this->total_video_course_by_selected_checkbox($data, $limit_offset = NULL);
        //$this->cf->dd($data);
        if(isset($data['video_course'])){
            $data = $this->all_video_course_person_price_info($data);
        }
        return $data;
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 28-08-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting total video course for pagination
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : total_video_course_by_selected_checkbox (this function is used in the avobe function)
     * @Parameter           : $data, $limit_offset = NULL
     * @Return              : count($this->db->get()->result())
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function total_video_course_by_selected_checkbox($data, $limit_offset = NULL){
        $this->db->select('*');
        $this->db->from('tbl_video_course AS vc');
        $this->db->join('tbl_topic AS t', 'vc.topic_id = t.topic_id');
        $this->db->join('tbl_url AS u', 'vc.url_id = u.url_id');
        $this->db->where('vc.video_course_publication_status', 2);
        if(!empty($data['course_type'])){
            $this->db->where('vc.video_course_payment_type', $data['course_type']);
        }
        if(!empty($data['skill_level_id'])){
            $this->db->where_in('vc.video_course_skill_level', $data['skill_level_id']);
        }
        if(!empty($data['child_topic_id'])){
            $this->db->where_in('t.topic_id', $data['child_topic_id']);
        }
        if(!empty($data['resource_person'])){
            $this->db->where_in('vc.resource_person_id', $data['resource_person']);
        }
        $this->db->order_by('video_course_id', 'DESC');
        return count($this->db->get()->result());
    }

        public function all_video_course_by_topic_info() {
        $data['parent_topic'] = $this->get_course_assign_parent_topic_info();
        foreach ($data['parent_topic'] as $topic_value) {
            $active_status = '1,5';
            $data['child_topic'][$topic_value->topic_id] = $this->get_video_course_assign_child_topic_info_by_topic_id($topic_value->topic_id, $active_status, 3);
            $data['total_child_topic'][$topic_value->topic_id] = count($this->get_video_course_assign_child_topic_info_by_topic_id($topic_value->topic_id, $active_status));
        }
        $data['other_topic'] = $this->get_without_sub_topic_info();
        //$this->cf->dd($data);
        return $data;
    }
    
    
    function get_course_assign_parent_topic_info() {
        $parent_topic_id = $this->video_course_assign_concat_parent_topic_id();
        if ($parent_topic_id != '') {
            return $this->select_active_topic_info_by_topic_id($parent_topic_id);
        } else {
            return Array();
        }
    }
    
    function video_course_assign_concat_parent_topic_id() {
        $this->db->select('GROUP_CONCAT(DISTINCT(t.parent_topic_id)) AS topic_id')
                ->from('tbl_video_course AS vc')
                ->join('tbl_topic AS t', 'vc.topic_id = t.topic_id')
                ->where('vc.video_course_publication_status', 2)
                ->where_in('t.topic_status', array(1,5));
        return $this->db->get()->row()->topic_id;
    }
    
    function select_active_topic_info_by_topic_id($topic_id) {
        $this->db->select('*')
                ->from('tbl_topic')
                ->where_in('topic_id', explode(',', $topic_id))
                ->where_in('topic_status', Array(1, 5));
        return $this->db->get()->result();
    }
    
    function get_video_course_assign_child_topic_info_by_topic_id($topic_id, $status, $limit = NULL) {
        $this->db->select('*')
                ->from('tbl_topic AS t')
                ->join('tbl_video_course AS vc', 't.topic_id = vc.topic_id')
                ->where('vc.video_course_publication_status', 2)
                ->where_in('t.parent_topic_id', $topic_id)
                ->where_in('t.topic_status', $status)
                ->group_by('t.topic_id')
                ->limit($limit);
        return $this->db->get()->result();
    }
    
    function get_without_sub_topic_info() {
        $this->db->select('*')
                ->from('tbl_topic AS t')
                ->join('tbl_video_course AS vc', 't.topic_id = vc.topic_id')
                ->join('tbl_url AS u', 'vc.url_id = u.url_id')
                ->where('vc.video_course_publication_status', 2)
                ->where('t.parent_topic_id', 0)
                ->where_in('t.topic_status', array(1,5));
        return $this->db->get()->result();
    }
    
    public function other_topic_video_course_info() {
        $data['video_course'] = $this->get_without_sub_topic_info();
        if(isset($data['video_course'])){
            $this->all_video_course_person_price_info($data);
        }
        return $data;
    }
    
    function get_all_video_course_value_by_search($data, $search_value, $start_limit, $end_limit) {
        $searched_video_course = $this->get_searched_all_video_course_information($search_value, $start_limit, $end_limit);
        if ($searched_video_course) {
            $data['searched_video_course'] = $searched_video_course;
            $data['total_searched_video_course'] = $this->get_total_searched_video_course_information($search_value);
        }
        return $data;
    }
    
    function get_searched_all_video_course_information($search_value, $start_limit, $end_limit) {
        $this->db->select('*')
                ->from('tbl_video_course as vc')
                ->join('tbl_url as u', 'vc.url_id = u.url_id')
                ->where('u.url_type', 8)
                ->where_in('vc.video_course_publication_status', array(1,2))
                ->like('vc.video_course_title', $search_value, 'both')
                ->order_by('vc.video_course_id', 'DESC')
                ->limit($end_limit, $start_limit);
        return $this->db->get()->result();
    }
    function get_total_searched_video_course_information($search_value) {
        $this->db->select('*')
                ->from('tbl_video_course as vc')
                ->join('tbl_url as u', 'vc.url_id = u.url_id')
                ->where('u.url_type', 8)
                ->where_in('vc.video_course_publication_status', array(1,2))
                ->like('vc.video_course_title', $search_value, 'both')
                ->order_by('vc.video_course_id', 'DESC');
        return $this->db->count_all_results();
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 30-08-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting video course by resource person in left checkbox menu
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $resource_person
     * @Return              : $resource_person_name
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function all_video_course_resource_person_by_resourcePerson_id($resource_person, $limit = NULL){
        $person_id = $this->db->select('person_id')
                ->from('tbl_resource_person')
                ->where_in('resource_person_id', $resource_person)
                ->get()
                ->result();
        if(isset($person_id)){
            foreach($person_id as $v_person_id){
                $all_person_id[] = $v_person_id->person_id;
            }
        }
        //$this->cf->dd($all_person_id);
        $resource_person_name = $this->db->select('*')
                ->from('tbl_person AS p')
                ->join('tbl_resource_person AS rp','rp.person_id = p.person_id')
                ->where_in('p.person_id', $all_person_id)
                ->limit($limit)
                ->get()
                ->result();
        //$this->cf->dd($resource_person_name);
        return $resource_person_name;
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 31-08-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : 
     * @Description         : This function is used for getting total number view of a video course and updated its value by 1
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $resource_person_name
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function get_video_course_total_view($video_course_id){
        $total_view = $this->db->select('video_course_view')
                ->from('tbl_video_course')
                ->where('video_course_id', $video_course_id)
                ->get()
                ->row();
        $data['video_course_view'] = ++$total_view->video_course_view;
        $this->db->where('video_course_id', $video_course_id)
                ->update('tbl_video_course', $data);
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 12-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : super-admin/video-course-detail
     * @Description         : This function is used for getting the details of a single video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $video_course_details
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function get_video_course_details($video_course_id){
        $check_free_video_course = $this->db->select('*')
                ->from('tbl_price')
                ->where('price_type_id', $video_course_id)
                ->get()
                ->row();
        if($check_free_video_course){
        $video_course_details = $this->db->select('*')
                ->from('tbl_video_course AS vc')
                ->join('tbl_price AS p','vc.video_course_id = p.price_type_id')
                ->where('vc.video_course_id', $video_course_id)
                ->get()
                ->row();
        }else{
            $video_course_details = $this->db->select('*')
                ->from('tbl_video_course')
                ->where('video_course_id', $video_course_id)
                ->get()
                ->row();
        }
        return $video_course_details;
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 12-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : super-admin/video-course-detail
     * @Description         : This function is used for getting the work file information of a single video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $all_video_course_work_files
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function get_video_course_work_files($video_course_id){
        $section_id = $this->db->select('section_id')
                ->from('tbl_section')
                ->where('section_type_id', $video_course_id)
                ->get()
                ->result();
        if(isset($section_id)){
            foreach($section_id as $v_section_id){
                $total_section_id[] = $v_section_id->section_id;
            }
        }
        //$this->cf->dd($total_section_id);
        if(isset($total_section_id)){
        $work_file_id = $this->db->select('manage_video_id')
                ->from('tbl_section_video')
                ->where_in('section_id', $total_section_id)
                ->get()
                ->result();
        }
       if(isset($work_file_id)){
            foreach($work_file_id as $v_work_file_id){
                $total_work_file_id[] = $v_work_file_id->manage_video_id;
            }
        }
        if(isset($total_work_file_id)){
        $all_video_course_work_files = $this->db->select('*')
                ->from('tbl_work_files')
                ->where_in('work_file_type_id', $total_work_file_id)
                ->get()
                ->result();
        }
        if(isset($all_video_course_work_files)){
            return $all_video_course_work_files;
        }
        
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 12-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : super-admin/video-course-detail
     * @Description         : This function is used for getting similar resource person video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $similar_video_course
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function get_similar_resource_person_video_course($video_course_id){
        $resource_person = $this->db->select('resource_person_id')
                ->from('tbl_video_course')
                ->where('video_course_id', $video_course_id)
                ->get()
                ->row();
        if(isset($resource_person)){
        $similar_video_course['resource_person'] = $this->db->select('*')
                ->from('tbl_resource_person AS rp')
                ->join('tbl_person AS p','p.person_id = rp.person_id')
                ->where('resource_person_id', $resource_person->resource_person_id)
                ->get()
                ->row();
        
        $similar_video_course['similar_video_course'] = $this->db->select('*')
                ->from('tbl_video_course')
                ->where('resource_person_id', $resource_person->resource_person_id)
                ->where('video_course_publication_status', 2)
                ->where('video_course_id !=', $video_course_id)
                ->get()
                ->result();
        //$this->cf->dd($similar_video_course);
        return $similar_video_course;
        }
    }
    /*
     * @Author              : Kazol
     * @CreatedDate         : 13-09-2017
     * @ModifiedDate        : 
     * @ModifiedBy          : 
     * @Route               : super-admin/video-course-detail
     * @Description         : This function is used for getting similar parent topic video course
     * @view                : 
     * @redirect            : 
     * @deprecated          : 
     * @exception           : 
     * @inheritDoc          : 
     * @Parameter           : $video_course_id
     * @Return              : $all_video_course_by_parent_topic
     * @value               : 
     * @Status              : active
     * @version             : v2.1        
     */
    public function get_similar_parent_topic_video_course($video_course_id){
        $topic_id = $this->db->select('topic_id')
                ->from('tbl_video_course')
                ->where('video_course_id', $video_course_id)
                ->get()
                ->row();
        $parent_topic_id = $this->db->select('parent_topic_id')
                ->from('tbl_topic')
                ->where('topic_id',$topic_id->topic_id)
                ->get()
                ->row();
        $all_topic_id = $this->db->select('topic_id')
                ->from('tbl_topic')
                ->where('parent_topic_id', $parent_topic_id->parent_topic_id)
                ->get()
                ->result();
        if(!empty($all_topic_id)){
            foreach($all_topic_id as $v_all_topic_id){
                $video_course_topic[] = $v_all_topic_id->topic_id;
            }
        }else{
            $video_course_topic[] = '';
        }
        if(isset($video_course_topic) || empty($video_course_topic)){
        $all_video_course_by_parent_topic = $this->db->select('*')
                ->from('tbl_video_course AS vc')
                ->join('tbl_topic AS t','t.topic_id = vc.topic_id')
                ->where_in('vc.topic_id', $video_course_topic)
                ->where('vc.video_course_publication_status', 2)
                ->where('vc.video_course_id !=', $video_course_id)
                ->get()
                ->result();
        //$this->cf->dd($all_video_course_by_parent_topic);
        return $all_video_course_by_parent_topic;
        }
    }
    
    public function get_video_course_creator_info($video_course_id){
        $video_course_creator = $this->db->select('p.person_first_name')
                ->from('tbl_person AS p')
                ->join('tbl_video_course AS vc','vc.person_id = p.person_id')
                ->where('vc.video_course_id', $video_course_id)
                ->get()
                ->row();
        return $video_course_creator;
    }
}
