<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Description of admin_payment_model
 *
 * @author Ripon
 */
class Admin_payment_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function update_bank_name() {
        $bank_data = Array();
        $bank_id = $this->input->post('edit_bank_id', TRUE);
        $bank_data['bank_name'] = $this->input->post('edit_bank_name', TRUE);
        $this->utility_model->update_information_in_database('tbl_bank', 'bank_id', $bank_id, $bank_data);
    }

    function select_all_bank_name($search_value, $sort, $limit, $bank_id = NULL) {
        $sql = "SELECT * 
                FROM 
                    tbl_bank AS b
                WHERE b.bank_name !=''";
        if ($bank_id != NULL) {
            $sql.=" AND b.bank_id != '$bank_id'";
        }
        if ($search_value != '') {
            $sql.=" AND b.bank_name LIKE '%$search_value%'";
        }
        if ($sort != '') {
            $sql.=" ORDER BY b.bank_name $sort";
        } else {
            $sql.=" ORDER BY b.bank_id ASC";
        }
        $sql.=" LIMIT $limit,10";
        return $this->db->query($sql)->result();
    }

    function total_bank_name() {
        $sql = "SELECT 
                    count(*) AS total 
                FROM tbl_bank";
        return $this->db->query($sql)->row();
    }

    function check_bank_name_existence($bank_name) {
        $sql = "SELECT * FROM tbl_bank AS b WHERE b.bank_name = '$bank_name'";
        return $this->db->query($sql)->row();
    }

    function get_bank_info_by_id($bank_id) {
        $sql = "SELECT * 
                FROM 
                    tbl_bank AS b
                WHERE 
                    b.bank_id = '$bank_id'";
        return $this->db->query($sql)->row();
    }

    function get_bank_info_for_edit($bank_id, $bank_name) {
        $sql = "SELECT * 
                FROM 
                    tbl_bank AS b
                WHERE b.bank_id != '$bank_id'
                AND b.bank_name = '$bank_name'";
        return $this->db->query($sql)->row();
    }

    /*
     * @Description         : get all bank name
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 19-11-2016 04:00 PM  
     */

    function get_all_bank() {
        return $this->db->select('*')->from('tbl_bank')->order_by('bank_name', 'ASC')->get()->result();
    }

    /*
     * @Description         : set payment method ID
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-01-2017 11:40 AM  
     */

    private $payment_method_id;

    function set_payment_method_id($payment_method_id) {
        $this->payment_method_id = $payment_method_id;
        return $this;
    }

    /*
     * @Description         : set payment method info
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-01-2017 11:41 AM  
     */

    function set_payment_method_info() {
        $bkash_payment_method_info = $this->utility_model
                ->set_single_row_info('*', 'tbl_person_bkash_payment_info', ['person_bkash_payment_info_id' => $this->payment_method_id])
                ->get_single_row_info();

        if (empty($bkash_payment_method_info)) {
            $check_payment_method_info = $this->utility_model
                    ->set_single_row_info('*', 'tbl_person_check_payment_info', ['person_check_payment_info_id' => $this->payment_method_id])
                    ->get_single_row_info();

            if (empty($check_payment_method_info)) {
                $paypal_payment_method_info = $this->utility_model
                        ->set_single_row_info('*', 'tbl_person_paypal_payment_info', ['person_paypal_payment_info_id' => $this->payment_method_id])
                        ->get_single_row_info();
                if(!empty($paypal_payment_method_info)){
                    $this->result = $paypal_payment_method_info;
                }
            } else {
                $this->result = $check_payment_method_info;
            }
        } else {
            $this->result = $bkash_payment_method_info;
        }
        return $this;
    }

    /*
     * @Description         : get result
     * @Developed By        : Md Jaherul Islam
     * @Start DateTime      : 21-01-2017 11:40 AM  
     */

    private $result;

    function get_result() {
        return $this->result;
    }

}
