<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Add_Teacher_Organization_Model extends CI_Model {

    function __construct() {
        parent::__construct();
        $this->load->library('image_lib'); //for resize image
    }

    /**
     * @Function            : save_person_information
     * @Used IN             : function[add_teacher_by_organization] controller[add_teacher_organization]      
     * @Description         : used for save org teacher info
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 08-06-2016
     * @Parameter           : $person_info
     * @Return              : none
     * @Status              : Available        
     * */
    function save_teacher_information_by_organization($person_info) {
        $pdata = array();
        $pdata['person_email'] = $this->input->post('person_email', TRUE);
        $pdata['person_password'] = md5($this->input->post('person_password', TRUE));
        $pdata['person_first_name'] = $this->input->post('person_first_name', TRUE);
        $pdata['person_last_name'] = $this->input->post('person_last_name', TRUE);
        $country_code = $this->input->post('hidden_country_code', TRUE);
        $pdata['person_contact_number'] = $country_code . ' ' . $this->input->post('person_contact_number', TRUE);
        $pdata['person_country'] = $this->input->post('person_country', TRUE);
        $pdata['person_city'] = $this->input->post('person_city', TRUE);
        $pdata['person_zip'] = $this->input->post('person_zip', TRUE);
        $pdata['person_address'] = $this->input->post('person_address', TRUE);
        $pdata['person_role'] = 3;                      //admin_user=1;account_officer=2;account_officer=2;teacher=3;organization=4;student=5;super_admin=6
        $pdata['person_gender'] = $this->input->post('person_gender', TRUE);
        $pdata['person_status'] = $this->input->post('person_status', TRUE);
        $pdata['person_join_tt'] = date('Y-m-d H:i:s', strtotime(gmdate('Y-m-d H:i:s')) - $this->session->userdata('time_offset'));

        $url1 = $this->input->post('profile_url', TRUE);
        $udata = $this->url_model->create_teacher_url_for_organization($url1);  //save url
        $url = $udata['url'];
        $pdata['url_id'] = $udata['url_id'];

        $upload = $this->image_upload($url); //used for image upload,here, $upload(=> array contain $upload['person_image'], $upload['person_image_thumb'] )
        $pdata['person_image'] = $upload['person_image'];
        $pdata['person_image_thumb'] = $upload['person_image_thumb'];

        $this->db->insert('tbl_person', $pdata);
        $person_id = $this->db->insert_id();
        $this->save_person_info_view_status($person_id);
        $this->save_resource_person_info($person_id);
    }

    /**
     * @Function            : image_upload
     * @Used IN             : function[save_teacher_information_by_organization] model[add_teacher_organization_model]     
     * @Description         : used to upload image
     * @Developed By        : Tania Akter
     * @Start Date          : 08-06-2016
     * @Parameter           : $url
     * @Return              : $upload(array=> contain person_image, person_thumbnail_image)
     * @Status              : Available        
     * */
    function image_upload($url) {
        if ($_FILES['person_image']['name']) {
            $upload_path = 'content-library/' . $url . '/my-image/';
            $allowed_types = 'gif|jpg|png|jpeg';
            $image_data = $this->image_model->upload_file($upload_path, $allowed_types, '2048', 'person_image');
            $pdata['person_image'] = 'my-image/' . $image_data['file_name'];

            $image_path = $upload_path . $image_data['file_name'];
            $new_image_name = $image_data['raw_name'] . '_thumb' . $image_data['file_ext'];
            $image_thumb = $upload_path . $new_image_name;

            $this->image_model->create_thumbnail_image($image_thumb, $image_path);
            $pdata['person_image_thumb'] = 'my-image/' . $new_image_name;
            return $pdata;
        }
    }

    /**
     * @Function            : save_person_info_view_status
     * @Used IN             : function[save_teacher_information_by_organization] model[add_teacher_organization_model]         
     * @Description         : used to save data in person_info_view_status tbl.
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 08-06-2016
     * @Parameter           : $person_id
     * @Return              : person_info_view_status_id
     * @Status              : Available        
     * */
    function save_person_info_view_status($person_id) {
        $status_data['person_id'] = $person_id;
        $status_data['person_email_view_status'] = 1;       //public=1;tt_user=2;link=3;me=5     
        $status_data['person_contact_number_view_status'] = 1;      //public=1;tt_user=2;link=3;me=5
        $status_data['person_address_view_status'] = 1;         //public=1;tt_user=2;link=3;me=5
        $status_data['person_birthday_view_status'] = 1;        //public=1;tt_user=2;link=3;me=5
        $status_data['person_self_assessment_skills_view_status'] = 1;      //public=1;tt_user=2;link=3;me=5
        $this->db->insert('tbl_person_info_view_status', $status_data);
    }

    /**
     * @Function            : save_resource_person_info
     * @Used IN             : function[save_teacher_information_by_organization] model[add_teacher_organization_model]        
     * @Description         : used to save resource person info
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Update By           : Tania Akter
     * @Update Date         : 08-06-2016
     * @Parameter           : $person_info, $person_id
     * @Return              : resource_person_id
     * @Status              : Available        
     * */
    function save_resource_person_info($person_id) {
        $resource_person_id = $this->resource_person_model->save_resource_person_information($person_id);
        $session_person_id = $this->session->userdata('person_id');
        $orgnization_info = $this->organization_model->select_single_organization_info_by_person_id($session_person_id);
        $this->organization_model->save_organization_resource_person($resource_person_id, $orgnization_info->organization_id);
    }

    /**
     * @Function            : check_user_email_info
     * @Used IN             : function[check_user_email] model[add_teacher_organization_model]        
     * @Description         : select person by email address
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : $user_email_address
     * @Return              : person_info
     * @Status              : Available        
     * */
    function check_user_email_info($user_email_address) {
        $this->db->select('*');
        $this->db->from('tbl_person');
        $this->db->where('person_email', $user_email_address);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

    /**
     * @Function            : check_url
     * @Used IN             : function[check_org_teacher_url_existance] controller[add_teacher_organization] 
     *                        function [profile_url_check] controller[add_teacher_organization]       
     * @Description         : used to check url 
     * @Developed By        : Unknown
     * @Start DateTime      : Unknown
     * @Parameter           : $code (url)
     * @Return              : url_info
     * @Status              : Available        
     * */
    function check_url($code) {
        $this->db->select('*');
        $this->db->from('tbl_url');
        $this->db->where('url', $code);
        $query_result = $this->db->get();
        $result = $query_result->row();
        return $result;
    }

}
