<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Tbl_coupon extends TT_migration {

    const table_name = 'tbl_coupon';

    public function up() {
        $this->field_name('coupon_id')->type('INT')->size(7)->auto_increment()->generate();
        $this->field_name('coupon_name')->type('VARCHAR')->size(100)->generate();
        //'feature=1;course=2;video_course=3',
        $this->field_name('coupon_type')->type('TINYINT')->size(1)->generate();
        // 'percentage=1;fixed=2',
        $this->field_name('coupon_price_type')->type('TINYINT')->size(1)->generate();
        // 'number=1;date=2',
        $this->field_name('coupon_expire_type')->type('TINYINT')->size(1)->generate();
        $this->field_name('coupon_can_use_number')->type('INT')->size(11)->set_null()->generate();
        $this->field_name('coupon_start_date')->type('DATE')->set_null()->generate();
        $this->field_name('coupon_finish_date')->type('DATE')->set_null()->generate();
        $this->field_name('coupon_code')->type('VARCHAR')->size(50)->set_null()->generate();
        $this->field_name('coupon_discount_amount')->type('DECIMAL')->size('10,2')->set_null()->generate();
        $this->field_name('coupon_status')->type('TINYINT')->size(1)->generate();
        $this->set_primary_key('coupon_id')->set_table_name(self::table_name)->create();
    }

    public function down() {
        
    }
}
